function success = wfu_infowrite_pfile(fname,pfile,Pvars)
% infoTextwrite is called by wfu_dicom_convert and writes a text file that
% corresponds with each analyze volume. 
%--------------------------------------------------------------------------
success = 0;      

%------ Open new file for writing -----------------------------------------
infoFID = fopen(fname,'wt');             % fid to output


%------ Write comments -----------------------------------------------------
fprintf(infoFID, '%% This .info file contains parameters from the following pfile: \n');
fprintf(infoFID, '%%     %s \n',pfile);
fprintf(infoFID, '%% Generated by wfu_infowrite_pfile.m on %s at %s \n', ...
    datestr(now,1),datestr(now,14));
fprintf(infoFID, '%% ----------------------------------------------------------------------\n\n');


%------ Write pfile parameters%------------------------------------
F = fieldnames(Pvars); 
V = struct2cell(Pvars); 
for i = 1:length(F)
    field = F{i};
    value = V{i};
    fprintf(infoFID, '%s\t', field);
    if isa(value,'char')
        if strcmp(field,'FileName')
            value = wfu_remove_bad_chars(value,'/','.','-','_');
        elseif strcmp(field,'ScanDate') || strcmp(field,'ScanTime')
            value = wfu_remove_bad_chars(value,'/',':');
        else
            value = wfu_remove_bad_chars(value); 
        end
        value = wfu_fill_blanks_with_underscores(value);
        fprintf(infoFID,'%s\n', value);
    elseif isnumeric(value)
        if strncmp(field,'PixelSize',9) || strncmp(field,'Horiz',5)
            fprintf(infoFID,'%.2f\n',value);
        else
            fprintf(infoFID,'%d\n', value);
        end
    else
        warning([], 'Class unknown for variable:\n%s\nTreating as string', field); 
        fprintf(infoFID,'%s\n', value);
    end
end
fprintf(infoFID, '\n%% ----------------------------------------------------------------------\n\n');



%------ Close file ---------------------------------------------------------
closetype = fclose(infoFID);
if closetype == 0 % 0=successful close
    success = 1;
end;
