function translation = wfu_translate(number,type)

if strcmp(type,'plane')
    if isa(number,'double')
        number = number(1);
    end
    if isequal(number,2), translation = 'ax'; 
    elseif isequal(number,4), translation = 'sag'; 
    elseif isequal(number,8), translation = 'cor';
    elseif isequal(number,16), translation = 'obl'; 
    else 
        translation = 'unknown_plane_type'; 
        warning(sprintf('Plane type number: %d is unknown',number));
    end
elseif strcmp(type,'position')
   position = { ...
         'supine', ...
         'prone', ...
         'left', ...
         'right' ...
     };
    if number<1 | number>4 
        translation = 'invalid_position_number'; 
        warning(sprintf('Patient position number: %d is invalid\nMust be 1-4',number));
    else
        translation = position{number};
    end
elseif strcmp(type,'entry')
    entry = { ...
     'head_first', ...
     'feet_first', ...
     'axial_entry', ...
     'side_entry', ...
     'vertical_entry', ...
     'reserved', ...
     'head_first_plus25degrees', ...
     'head_first_minus25degrees', ...
     'feet_first_plus25degrees', ...
     'feet_first_minus25degrees' ...
    };
    if number<1 | number>10
        translation = 'invalid_entry_number';
        warning(sprintf('Patient entry number: %d is invalid\nMust be 1-10',number));
    else
        translation = entry{number}; 
    end
elseif strcmp(type,'acquisition')
    acq = { ...
            'fmri', ...
            'dccsi', ...
            'dcpsf', ...
            'perfusion' ...
        }; 
    if number<1 | number>4
        translation = 'invalid_acquisition_type_number'; 
        warning(sprintf('Acquisition type number: %d is invalid\nMust be 1-4',number)); 
    else
        translation = acq{number}; 
    end
else
    translation = 'improper_translation_check_"wfu_translate.m"';
    warning(sprintf('Type: %s is not valid arg2 for wfu_translate',number));
end

