function wfu_list_files(fileNames, truncateFlag )

%
% PURPOSE:   A quick way to list a cell array of files in sequential order.
%
% CATEGORY: Utility
%
% INPUTS: 
%         fileNames - List of filenames or directories
%
%         truncateFlag - Truncate list of names if the name exceeds 80 characters. Truncation is 
%                        acheived by discarding the full directory name except for the parent.
%
% OUTPUTS: 
%
%    aFiles - A list of filenames that are automatically copied to the command workspace and
%             given the name specified by the second input argument.
%
% EXAMPLE:
%
%   >> char(a)
%      ??? Undefined function or variable 'a'.
% 
%   >> wfu_lsa
% 
%      Files:
% 
%         1) /ansir5/plaurien/attn/attn003_07_22_05/attn003.11_41_35.07_22_05.P35328_4D.img   Epiflex p-files found with type all
% 
%    >> char(a)
%
%       ans =
%           
%       /ansir5/plaurien/attn/attn003_07_22_05/attn003.11_41_35.07_22_05.P35328_4D.img
%
%



if nargin < 2 || isempty(truncateFlag) 
   truncateFlag = true;
end


%
%
%

nFiles = length(fileNames);

if nFiles == 0
   disp(sprintf('\n   No Files or Directories to list! \n'));
   return;
end

%
% Display files
%

startingDirectory = cd;
nStartingDirectory = length( startingDirectory);

nFiles = 0;
nDirs   = 0;

for ii=1:length(fileNames)

    if isdir(fileNames{ii})
        nDirs = nDirs + 1;
    else
        nFiles = nFiles+1;
    end

end

disp(' ');    

if nDirs == 0
    disp('Files ...');
elseif nFiles == 0
    disp('Directories ...');
else
    disp('Files and Directories ...');    
end

disp(' ');

    for ii=1:length(fileNames)
        tmp = char(fileNames{ii});

        if length(tmp) > 80 && (isdir(fileNames{ii}) == false) && (truncateFlag == true)           
            tmp = strcat('.', tmp(nStartingDirectory+1:end));
        end
        
        disp(sprintf('   %3d) %s', ii, tmp));
    end

    disp(' ');

%
% Display Directories
%

% if options.displayDirectories
% 
%     disp(' ');
%     disp('Directories:');
%     disp(' ');
%     
%     for i=1:length(dnames)
%         disp([ '   ' num2str(i) ') ' char(dnames{i}) ]);
%     end
% 
%     disp(' ');
% end