function vars = wfu_read_textfile(filename)

% Loads variables from a text file into variable structure
% FORMAT vars = wfu_read_info(filename)
%
% vars          - structure containing variables and values
%
% filename      - any tab-delimited text file (txt/info)
%                 If comments are used, they must by of the 
%                 matlab convention (%) 
%___________________________________________________________

vars = [];
[p,n,ext,v] = fileparts(filename);

%==== read file and create structure ====% 
[variable,value] = textread(filename,'%s %s', ...
    'headerlines',  0, ...
    'commentstyle', 'matlab' ...
    );
for i = 1:length(value)
    numValue = str2num(value{i});
        if ~isempty(numValue)
            value{i} = numValue;
        end
    vars = setfield(vars,char(variable{i}),value{i}); 
end

%==== give warning if file type is unknown ====%
if ~any(strcmp(ext,{'.txt','.info'}))
    warning(sprintf( ...
        'File type is not .info or .txt\nOutput may contain errors.'));
end
return