function wfu_startup(wfu_path, spmVersion)
%
%	MODIFIED VERSION FOR DISTRIBUTION WITH THE SPM5_PIPELINE
%
%
%
% PURPOSE: - To load the WFU into Matlab and setup the correct WFU
%
% INPUTS:
%
%    wfu_path - Absolute path of WFU directory. If undefined and on the 
%                   Unix platform environment variable WFU_PATH is used as default
%
%    spmVersion  - The version number of SPM to add to path. Currently 99 (default),
%                  2, and 5 are the only version numbers supported. 
%                  If undefined and on the Unix platform the environment variables
%                  WFU_SPM99, WFU_SPM99FDR, and WFU_SPM2 are used to modify
%                  the Matlab path.  If these enviroment variables are not
%                  set or the directory is invalid a warning will be
%                  produced.
%
% EXAMPLE:
%
%    > wfu_path;  % Loads in the default WFU and SPM paths defined from
%                     % the environment variables.
%
%    > wfu_path([],2);  % Loads in the default WFU path and SPM2.
%                           % SPM99 paths will be removed from Matlab path.
%
%    > wfu_path('/WFU2');  % Adds the new WFU in WFU2 to the path but does not 
%                              % remove old WFU directories. This is a
%                              % known bug.
%
%

%==========================================================================
% C H A N G E   L O G
%
% $Id: wfu_startup.m,v 1.1 2009/02/13 19:35:41 bwagner Exp $ 
%
% $Log: wfu_startup.m,v $
% Revision 1.1  2009/02/13 19:35:41  bwagner
% Adding WFU directory
%
% Revision 1.1  2009/01/08 15:06:27  bwagner
% Initial Version of WFU_SPM5_Pipeline for distribution
%
% Revision 1.31  2008/04/03 17:19:49  bwagner
% Added WFU_mosiac
%
% Revision 1.30  2007/10/10 18:27:47  kpearson
% add path for WFU_DICOMtk
%
% Revision 1.29  2007/08/31 20:45:39  kpearson
% add path of WFU/CBU slice_overlay
%
% Revision 1.28  2007/06/11 16:38:26  kpearson
% add WFU_SAM to wfu_startup
%
% Revision 1.27  2006/08/24 20:17:19  maldjian
% added WFU_batch to the startup
%
% Revision 1.26  2006/05/11 18:40:52  kpearson
% add WFU_grid path to wfu_startup
%
% Revision 1.25  2006/05/11 16:02:20  kpearson
% for wfu_startup, check in Bob's distribution
% change from MIMP genpath to MIMP
%
% Revision 1.24  2006/02/21 21:34:23  bkraft
% Added MIMP to Matlab path when WFU starts up.
%
% Revision 1.23  2005/12/13 15:17:26  kpearson
% add WFU_utilities path last so it will always be on top
%
% Revision 1.22  2005/10/07 16:17:12  maldjian
% compatibility between versions of spm for analyze images and .mat
%
% Revision 1.20  2005/08/12 15:42:24  kpearson
% remove wfu_ge_toolbox comment
%
% Revision 1.19  2005/08/11 22:19:00  kpearson
% comment out wfu_get_toolbox_startup
%
% Revision 1.18  2005/08/11 20:37:45  maldjian
% SGE Shell Scripts
%
% Revision 1.16  2005/05/03 15:41:10  abaer
% *** empty log message ***
%
% Revision 1.15  2005/04/06 13:31:20  bkraft
% Removed UNIX check for environment variables.  Removed genpath from function so CVS directories are no longer added.
%
% Revision 1.14  2005/03/09 14:06:06  abaer
% added path to WFU/anatomy toolbox for spm2
%
% Revision 1.13  2004/12/18 01:59:35  maldjian
% Added WFU_dicom folder
% programs for reslicing images using sn3d intermediate
%
% Revision 1.12  2004/12/16 18:06:39  bkraft
% Merged changes from branch bkraft_wfu_00_00
%
% Revision 1.11.2.2  2004/12/16 18:02:41  bkraft
% Added paths after setting the SPM path.
%
% Revision 1.11.2.1  2004/12/16 17:49:51  bkraft
% Added a function to call the SPM path.
%
% Revision 1.11  2004/12/16 14:39:52  bkraft
% Changed all references from BPM to WFU.
%
% Revision 1.10  2004/11/23 21:23:23  bkraft
% Changed the Log comment to prevent multiple keyword substitution by CVS.
%
% Revision 1.9  2004/11/19 14:23:38  abaer
% Added call to spmdefault if it exists on the path (i.e SPM is on path).
%
% Revision 1.8  2004/11/18 18:43:44  bkraft
% Added some checks for spmVersion number.  Version number now
% defaults to environment variable WFU_SPM_DEFAULT. If this
% variable is not defined then the version number 99 is used as the
% default.  Corrected CVS keyword expansion to include a $ at the
% end of $Id and $Log
%
%--------------------------------------------------------------------------

%
%  Startup file for WFU
%
% 

if ((nargin < 1) | isempty(wfu_path))
  wfu_path = getenv('WFU_PATH');
end

%
% Verify that wfu_path exist and that it is a valid WFU directory
%

if exist(wfu_path,'dir') ~= 7  % Check to see if wfu_path is a directory
  warning('Unknown WFU path. wfu_path is not a valid directory');
end

%
% Check SPM Version number
%


if(nargin < 2) | isempty(spmVersion) 
  spmVersion = str2num(getenv('WFU_SPM_DEFAULT'));
end


%
% Set SPM Path
%

% wfu_set_spm_path( spmVersion );

wfu_spm05_path = getenv('WFU_SPM5');
if exist(wfu_spm05_path,'dir') == 7
	addpath(wfu_spm05_path,'-end');
	run((fullfile(spm('dir'),'spm_defaults')));
else
	warning(sprintf('SPM5 directory (%s) does not exist.',wfu_spm05_path));
	warning('SPM defaults no loaded.');
end

%
% Load WFU Modules
%

% Add this directory first so you can use wfu_find_files for
% setting additional paths


% add this path last
% addpath(fullfile(wfu_path,'WFU_utilities'));

%% double commented items have been removed for spm5_pipeline 

%%addpath(fullfile(wfu_path,filesep,'CBU'));
%%addpath(fullfile(wfu_path,filesep,'MIMP'));
%%addpath(fullfile(wfu_path,filesep,'MIMP',filesep,'icons'));

%%addpath(fullfile(wfu_path,filesep,'WFU_DICOMtk'));
%%addpath(genpath(fullfile(wfu_path,'WFU_BPM')));

addpath(fullfile(wfu_path,'WFU_geToolbox'));
wfu_ge_toolbox_startup(fullfile(wfu_path,'WFU_geToolbox'));

addpath(fullfile(wfu_path,'WFU_PickAtlas'));

addpath(fullfile(wfu_path,'WFU_job'));

%%addpath(fullfile(wfu_path,'WFU_dicom'));
addpath(fullfile(wfu_path,'WFU_dicom5'));

%addpath(fullfile(wfu_path,'anatomy')); 

%%addpath(fullfile(wfu_path,'WFU_grid'));
%%addpath(fullfile(wfu_path,'WFU_test'));
%%addpath(fullfile(wfu_path,'WFU_SAM'));
%%addpath(fullfile(wfu_path,'WFU_VBM'));
%%addpath(fullfile(wfu_path,'WFU_compatibility'));
addpath(fullfile(wfu_path,'WFU_utilities'));
addpath(fullfile(wfu_path,'WFU_batch'));
%%addpath(fullfile(wfu_path,'WFU_mosaic'));
addpath(fullfile(wfu_path,'WFU_DTI'));


