/*
 *  GE Medical Systems
 *  Copyright (C) 1997 The General Electric Company
 *  
 *  io_signa_lx.c - This code reads in the raw data header if the data was 
 *                  collected and stored on a LX based system or on a genesis
 *                  system.
 *                  This code is necessary since the LX host does not care 
 *                  about byte-aligned data but the signa system does and the
 *                  fact that the raw data header size changed for LX.
 *  
 *  Language : ANSI C
 *  Author   : Bryan J Mock
 *  Date     : 10/27/97
 */
/* do not edit anything above this line */


/* Local header files */
#include "io_signa_lx.h"
#include <stdio.h>
extern int debug;

/**************************************************************************/
/*Read raw data header file into structure POOL_HEADER defined in rdbm.h*/
int readrawhead(char filename[], RDB_HEADER_REC *prdbhead,
		RDB_DATA_ACQ_TAB acq_tab, MR_EXAMDATATYPE *pexamhead,
		MR_SERIESDATATYPE *pserieshead, MR_MRIMAGEDATATYPE *pimagehead)
{
  FILE *fphead;
  char header[RDB_HEADER_SIZE_BYTES];
  
  if ((fphead = fopen(filename,"r"))!=NULL)
    {
      fseek(fphead, (long) 0, (int) 0);
      fread(header,sizeof(char),RDB_HEADER_SIZE_BYTES, fphead);

    if(debug)
      printf("Reading from header.\n");


      fclose(fphead);
    }
  else
    return(1);

  /* Parse rawheader struct - stash in separate structs */
  memcpy(prdbhead,header+RDB_HDR_OFF,RDB_HDR_SIZE);
  memcpy(acq_tab,header+RDB_DATAACQ_OFF,RDB_DATAACQ_SIZE);
 
#ifdef LX_SYSTEM

if(debug)
   printf("LX header.\n");

  /* BJM (10/23/97): added these memcpy's to replace calls to Carl Crawfords */
  /* byte alignment calls if compiling for lx platform.... */ 

  memcpy(pexamhead,header+RDB_EXAMDATATYPE_OFF,RDB_EXAMDATATYPE_SIZE);
  memcpy(pserieshead,header+RDB_SERIESDATATYPE_OFF,RDB_SERIESDATATYPE_SIZE);
  memcpy(pimagehead,header+RDB_MRIMAGEDATATYPE_OFF,RDB_MRIMAGEDATATYPE_SIZE);
#else

if(debug)
   printf("Signa System: C34 header conversion.\n");

  /* BJM (10/23/97): Byte Alignment NOT needed for raw */
  /* data collected on lx systems but is needed for */ 
  /* Signa systems with sun3 engines & sun4 hosts - These */
  /* routines were written by Carl Crawford for this purpose */ 
  printf("Exam offset = %d\n",RDB_EXAMDATATYPE_OFF);
  EXAM_34(header+RDB_EXAMDATATYPE_OFF,pexamhead,0);
  SERIES_34(header+RDB_SERIESDATATYPE_OFF,pserieshead,0);
  IMAGE_34(header+RDB_MRIMAGEDATATYPE_OFF,pimagehead,0); 
#endif  

  return(0);
}



int readrawhead_ls(char filename[], RDB_HEADER_REC *prdbhead,
		   RDB_DATA_ACQ_TAB acq_tab, MR_EXAMDATATYPE *pexamhead,
		   MR_SERIESDATATYPE *pserieshead, MR_MRIMAGEDATATYPE *pimagehead)
{
  FILE *fphead;
  char header[RDB_HEADER_SIZE_BYTES];
  
  if ((fphead = fopen(filename,"r"))!=NULL)
    {
      fseek(fphead, (long) 0, (int) 0);
      fread(header,sizeof(char),RDB_HEADER_SIZE_BYTES, fphead);

    if(debug)
      printf("Reading from header.\n");


      fclose(fphead);
    }
  else
    return(1);

  /* Parse rawheader struct - stash in separate structs */
  /*
  memcpy(prdbhead,header+RDB_HDR_OFF,RDB_HDR_SIZE);
  memcpy(acq_tab,header+RDB_DATAACQ_OFF,RDB_DATAACQ_SIZE);
  */ 

#ifdef LX_SYSTEM

if(debug)
   printf("LX header.\n");

  /* BJM (10/23/97): added these memcpy's to replace calls to Carl Crawfords */
  /* byte alignment calls if compiling for lx platform.... */ 

  memcpy(pexamhead,header+RDB_EXAMDATATYPE_OFF_LS,RDB_EXAMDATATYPE_SIZE);
  memcpy(pserieshead,header+RDB_SERIESDATATYPE_OFF_LS,RDB_SERIESDATATYPE_SIZE);
  memcpy(pimagehead,header+RDB_MRIMAGEDATATYPE_OFF_LS,RDB_MRIMAGEDATATYPE_SIZE);
#else

if(debug)
   printf("Signa System: C34 header conversion.\n");

  /* BJM (10/23/97): Byte Alignment NOT needed for raw */
  /* data collected on lx systems but is needed for */ 
  /* Signa systems with sun3 engines & sun4 hosts - These */
  /* routines were written by Carl Crawford for this purpose */ 
  printf("Exam offset = %d\n",RDB_EXAMDATATYPE_OFF);
  EXAM_34(header+RDB_EXAMDATATYPE_OFF,pexamhead,0);
  SERIES_34(header+RDB_SERIESDATATYPE_OFF,pserieshead,0);
  IMAGE_34(header+RDB_MRIMAGEDATATYPE_OFF,pimagehead,0); 
#endif  

  return(0);
}






