/*
 *  GE Medical Systems
 *  Copyright (C) 1997 The General Electric Company
 *  
 *  io_signa_lx.h - contains function prototypes and include files 
 *                  for LX & Signa version of readrawheader() function.
 *                  Structure definitions are typdefs so the interface doesn't
 *                  need to change for the function.
 *  
 *  Language : ANSI C
 *  Author   : Bryan J Mock
 *  Date     : 
 */
/* do not edit anything above this line */

#ifndef RECON_FLAG
#define RECON_FLAG
#endif /* RECON_FLAG */

/* Local header files */
#ifdef LX_SYSTEM

#include "imagedb.h"    /* no byte alignment needed */
#include "rdbm_lx2.h"

/* note: this typedef method is necessary since the structures */
/*       are typedefs themselves rather than having tagnames */
 typedef EXAMDATATYPE MR_EXAMDATATYPE;
 typedef SERIESDATATYPE MR_SERIESDATATYPE;
 typedef MRIMAGEDATATYPE MR_MRIMAGEDATATYPE;

#else

#include "idbm.h"      /* C34 byte alignment needed for sun3->sun4 */
#include "rdbm.h"
 
/* note: this typedef method is necessary since the structures */
/*       are typedefs themselves rather than having tagnames */
 typedef EXAM MR_EXAMDATATYPE;
 typedef SERIES MR_SERIESDATATYPE;
 typedef IMAGE MR_MRIMAGEDATATYPE;

#endif /* LX_SYSTEM */

/* Function protoypes.... */
int readrawhead(char *, RDB_HEADER_REC *, RDB_DATA_ACQ_TAB,
		MR_EXAMDATATYPE *, MR_SERIESDATATYPE *, MR_MRIMAGEDATATYPE *);
              
int readrawhead_ls(char *, RDB_HEADER_REC *, RDB_DATA_ACQ_TAB,
		   MR_EXAMDATATYPE *, MR_SERIESDATATYPE *, MR_MRIMAGEDATATYPE *);

/* prototype for c34 library if Signa system */

void EXAM_34(char *, MR_EXAMDATATYPE *, int);
void SERIES_34(char *,MR_SERIESDATATYPE *, int);
void IMAGE_34(char *, MR_MRIMAGEDATATYPE *, int);
void EXAM_43(char *, MR_EXAMDATATYPE *, int);
void SERIES_43(char *, MR_SERIESDATATYPE *, int);
void IMAGE_43(char *, MR_MRIMAGEDATATYPE *, int);

int writesigna(float *,int,int,char *,float, MR_EXAMDATATYPE,
               MR_SERIESDATATYPE, MR_MRIMAGEDATATYPE,float);
int readpool(char *,POOL_HEADER *);







