 /*  read_pfile_header.c */

static const char rcsid[] = "$Id: read_pfile_header.c,v 1.1 2009/02/26 16:49:23 bwagner Exp $";

#include <math.h>
#include <stdlib.h> 
#include <stdio.h>
#include <stdarg.h>

/* Num recipes header files */
#include "nrutil.h"
#include "nr.h"

/* epirecon header files */
#include "rcn.h"
#include "io_signa_lx.h"

#define SHIFTX 64
#ifndef M_PI
#define M_PI    3.14159265358979323846
#endif

#define MAXCHAR 256

int debug = 0;          /* Global debug flag                         */
int non_epi = 0;        /*   "    flag for conventional non-epi data */
FILE *fplog;            /*   "    file pointer for recon log         */


void get_paradigm(int ref, char *szRefName);

#define REL_PC 0

/* prototype for main () */
int main(int,char **);

/* main(): contols most aspects of the reconstruction of raw epi data.  */
/*         This function is basically a big loop that passes over the   */
/*         slices & nexs in a raw epi data file collected w/ NOPROC = 1 */
int main(int argc, char **argv)
{

  /* Raw data header structure definitions.  These */
  /* are typdefs in io_signa_lx.h.  They are needed to continue support */
  /* of byte-aligned recons on genesis while permitting compilation for */
  /* reconning data collected on LX systems (no byte alignment needed). */

  RDB_HEADER_REC rdbhead;
  RDB_DATA_ACQ_TAB acq_tab;
  MR_EXAMDATATYPE examhead;
  MR_SERIESDATATYPE serieshead;
  MR_MRIMAGEDATATYPE imagehead;

  /* Most of the following is read in from the header */
  
  int i,j;
  int xres, yres;        /* acq. resolution */
  int rcxres,rcyres;     /* reconstructed resolution (with fovar=1.0) */

  int rcxres_orig;       /* these is needed to support ramped sampling */
			 /* & zero-fill to a higher resolution */
  int rcyres_orig;    
  float thick;           /* slice thickness */
  float gap;             /* gap (mm) between slices */
  float TR;
  int TE;                /* echo & repetition time */
  int SKIP = -1;         /* images to skip (for saturation) when writing stimulate file */
			 /* - defaults to 4 images */
  int bpass = 1;         /* bandpass asymmetry flag (1 = on) */

  float FOVx, FOVy;
  int interm_xres;	 /* reconstructed x resolution (with fovar != 1.0) */
  int numreps, rep = 1;  /* total reps and rep number (nex in header) */
  int numslice, sl;      /* slice counter and number of slices */
  int frame;             /* size of each image points calc. from */
			 /* header info */

  int ssp_size;          /* Adding these together (+ header) should */
  int rhraw_size;        /* give expected file size in bytes        */

  int sdt_frame;         /* frame size for sdt file = rcxres*rcyres*ptsize */
  float **vrgf_coeff;    /* vrgf coeffient array */
  float *fbuf;           /* and read buffer */
  int NO_REF_flag = 0;   /* ref.dat flag */
  int VRGF_flag = 0;     /* vrgf.dat flag */
  int loffset;           /* offset in file to linear phase coeff. */
                    
  float aphase[2048];    /* band pass asymmetry variables - phase */
  float amag[2048];      /*  & mag */
  int nbpc;              /* num points */
  char *scanner;         /* UW only - determine if data collected @ */
                         /* hospital or Waisman so correct bandpass */
                         /* correction files are used */

  int *slice;            /* array for slice ordering due to acq. order */
  float hnw;             /* homodyne correction transition width in */
			 /* header */
  int homodyne_flag = 0; /* flag to do homodyne recon */
  int overscan = 0;      /* number of Ky lines collected past Ky = 0 */
  float bandw;           /* recevier bandwidth from header */
  int fast_rec = 0;      /* fast_reciever check */
  float *M;              /* Magnitude EPI Image */
  float *raw;            /* Raw K-Space Image for debugging */
  float *lp, *poff;      /* Phase correction vectors (linear and */
			 /* const) from ref.dat file */
  fcomplex *data;        /* complex raw data from Pxxx */
  float fw, fr;		  /* fermi width and radius from header */
  float fovar;		  /* Field of View Aspect Ratio from header */
  char pl;                /* orientation of slice */ 
  char plane[4];          /* if pl = L/R > axial or A/P > sag, */
			  /* S/I > coronal */
  short swapfp;           /* swapped freq/phase encode direction 1 = */
			  /* yes - determines if images are reoriented */
  int pt_size = 0;        /* For extended Dynamic Range data */
  int bviews = 0;         /* # of baseline views */
  int bl_flag = 0;        /* if baselines exist */

  int tot_reps = 0;       /* set total reps (per loc) by hand */
  short rot, tpose;

  /* variables for stimulate file format option */
  FILE *fpsdt;       /* pointer for stimulate file format */
  FILE *fphsdt;      /* pointer for stimulate header file */
  
  FILE *input_file, *output_file;
  int indextemp1, indextemp2;
  
  int SDT, BOTH;     /* int flags to write out SDT file or Both fni and */
		     /* SDT file types, default is fni only */
  
  /* values passed as command line arguments */
  float scale = 1.0;    /* fft scaling value (default is auto scale) */
  char FILT_FLAG[10];    /* filter flag - apply a spatial filter */

  /* file names arrays for Raw, EPI Image, and RAW k-space image */
  char rawfilename[80], magfilename[80], lrawfilename[80], sdtfilename[80];
  char EPI_NAME[80] = "";

  /* Felix add */
  int  epiflexType;

  char szEpiflexType[30];
  char szPlane[10];
  /* char *szRefName; */
  char szRefName[MAXCHAR];
  int nscantime,mins,secs;
  int option;
  char *szBaseFileName;
  char *szPfileFilename;
  
  /* BJM: read command line arguments */ 
  if (myreadcl(argc,argv,rawfilename,&option))
    {
     if(debug) {
	printf ("Sleeping 10 seconds to debug memory allocation...\n");
	sleep(10);
      }

     printf("Command Line Format and options for epirecon.....\n"
            "read_pfile_header -f <raw data filename> [Options]\n"
            "\tOptions: none: return all info\n"
	    "\t\t -o 1:return examno\n"
	    "\t\t    2:return type, ref function\n");
     exit(1);
    }

/* Set skip variable for stimulate file if not set on commandline */
  if(SKIP < 0) SKIP = 4;
  
/* BJM: reads raw header and allows acces to every item stored in header */
  if(readrawhead(rawfilename,&rdbhead,acq_tab,
	       &examhead,&serieshead,&imagehead))
    {
      printf("Error reading raw data header or couldn't find file named %s.\n",rawfilename);
      exit(1);
    }
  else {

    szBaseFileName=(char*)strrchr(rawfilename,'/');
      if (szBaseFileName==NULL)
	szPfileFilename=rawfilename;
      else
	szPfileFilename=szBaseFileName+1;

      /*    szRefName=(char *)malloc(100*sizeof(char)); */

    switch (option){
    case 0:
      printf("Pfile Name    = %s\n",    szPfileFilename);
      printf("PSD Name      = %s\n\n",  imagehead.psdname);

      printf("Exam Number   = %d\n",    examhead.ex_no);
      printf("Series Number = %d\n\n",  serieshead.se_no);

      printf("Series Description = %s \n", serieshead.se_desc);
      printf("Protocol           = %s \n\n", serieshead.prtcl);

      /* Plane  string
	 2      Axial
	 4      Sagittal
	 8      Coronal
	 16     Oblique
	 */
      switch ((int) imagehead.plane){
      case 2:
	  strcpy(szPlane,"Axial");
	  break;
      case 4:
	  strcpy(szPlane,"Sagittal");
	  break;
      case 8:
	  strcpy(szPlane,"Coronal");
	  break;
      case 16:
	  strcpy(szPlane,"Oblique");
	  break;
      }

      printf("Imaging Plane      = %s\n", szPlane);
      printf("Imaging Options    = %d\n\n", imagehead.iopt);


      printf("TE                 = %8.3f [ms]\n", (float) imagehead.te/1000.0);
      printf("TR                 = %8.3f [ms]\n", (float) imagehead.tr/1000.0);

      if( 1 ) {
        printf("TI                 = %8.3f [ms]\n", (float) imagehead.ti/1000.0);
      }

      printf("\n");
      printf("Resolution         = %3d x %3d\n", rdbhead.rdb_hdr_frame_size, 
                                                rdbhead.rdb_hdr_nframes);
      printf("Field of View      = %3.0f x %3.0f [mm]\n", imagehead.dfov, imagehead.dfov_rect);

      printf("Number of Slices   = %d\n", rdbhead.rdb_hdr_nslices);
      printf("Slice Thickness    = %2.1f [mm]\n", imagehead.slthick);


      if (strstr(imagehead.psdname,"epiflex")) 
      {

        printf("\n\n*** EPIFLEX v%d details ***\n\n",  (int) rdbhead.rdb_hdr_user18);
        
      /* type   string
	 1      fMRI experiment
	 2      Distortion Correction Map
	 3      PSF Map
         4
         5
         6
         7 
      */
        epiflexType = (int) rdbhead.rdb_hdr_user20;
        
	switch ( epiflexType ) {
	case 1:
	  strcpy(szEpiflexType,"fMRI experiment");
	  break;
	case 2:
	  strcpy(szEpiflexType,"Distortion Correction Map");
	  break;
	case 3:
	  strcpy(szEpiflexType,"PSF Map");
	  break;
	  /*
	case 4:
	  strcpy(szEpiflexType,"T1 Mappping");
	  break;
	case 5:
	  strcpy(szEpiflexType,"T2 Mapping");
	  break;
	case 6:
	  strcpy(szEpiflexType,"DC T2 Mapping");
	  break;
	case 7:
	  */
	case 4:
	  strcpy(szEpiflexType,"Perfusion");
	  break;
	}

	nscantime=(int)(imagehead.sctime/1000000);
	mins=nscantime/60;
	secs=nscantime%60;
	printf("\tScan Duration         = %d:%02d\n",mins,secs);
	printf("\tImaging Volumes       = %d\n\n", imagehead.fphase);

	printf("\tAcquisition Code      = %d\n", epiflexType);
	printf("\tAcquisition           = %s\n\n", szEpiflexType);

          printf("\tfMRI Paradigm Number  = %d   \n", (int) rdbhead.rdb_hdr_user21);

	if (rdbhead.rdb_hdr_user21){
	  get_paradigm( (int) rdbhead.rdb_hdr_user21,szRefName);
	  printf("\tfMRI Paradigm         = %s \n", szRefName);
	}
      }

      printf("\n\n");

      break;

    case 1:
      printf("%d",    examhead.ex_no);
      break;

    case 2:
      if (strstr(imagehead.psdname,"epiflex")) {

      /* type   string
	 1      fMRI experiment
	 2      Distortion Correction Map
	 3      PSF Map
      */

        epiflexType = (int) rdbhead.rdb_hdr_user20;
        
	switch ( epiflexType ) {
	case 1:
	  strcpy(szEpiflexType,"fMRI experiment");
	  break;
	case 2:
	  strcpy(szEpiflexType,"Distortion Correction Map");
	  break;
	case 3:
	  strcpy(szEpiflexType,"PSF Map");
	  break;
	  /*
	case 4:
	  strcpy(szEpiflexType,"T1 Mappping");
	  break;
	case 5:
	  strcpy(szEpiflexType,"T2 Mapping");
	  break;
	case 6:
	  strcpy(szEpiflexType,"DC T2 Mapping");
	  break;
	case 7:
	  */
	case 4:
	  strcpy(szEpiflexType,"Perfusion");
	  break;
	}

	printf("%s", szEpiflexType);

	if (rdbhead.rdb_hdr_user21){
	  get_paradigm( (int) rdbhead.rdb_hdr_user21,szRefName);
	  printf(",%s", szRefName);
	}

	printf("\n");
      }
      break;
    }
    }

}


/*************************************************************************/
/*Get raw data filename from command line */
int myreadcl(int numarg,char **pstring, char filename[], int *option)
{
  int fileflag = 1;
  
  if (numarg !=1)
    {
      pstring++;
      while (*pstring != NULL)
	{
	  if (strcmp("-f",*pstring)==0)
	    {
	      pstring++;
	      if(*pstring!=NULL)
		{
		  strcpy(filename,*pstring);
		  fileflag = 0;
		}
	      pstring++;
	    }
	  else if (strcmp("-help",*pstring)==0)
	    {
	      printf("Command Line Format and options[].....\n"
	             "read_pfile_header -f <raw data filename> [Options]\n"
		     "\tOptions: none: return all info\n"
		     "\t\t -o 1:return examno\n"
		     "\t\t    2:return type, ref function\n");

	      pstring++;
	      exit(0);
	    }
	  else if (strcmp("-o",*pstring)==0)
	    {
	      pstring++;
	      if(*pstring!=NULL)
		{
		  *option=atoi(*pstring);
		}
	      else *option=0;
	      pstring++;
	    }	  
         
          
           		
	  else pstring++;
	}
    }

  return(fileflag);
}

void get_paradigm( int ref, char *szRefName){

FILE *fp;
char tblname[256];
/* char line[100]; */
char line[MAXCHAR];
char str1[MAXCHAR];
char str2[MAXCHAR];
char *str3;
int i;
int j;
/*char path[60];*/
/*
char *pch;
char *pch1;
char *pch2;
char line1[100];
char result[100];
char *result;
char *pch3;*/

strcpy(szRefName, "Not found");
i=0;
/* fp=fopen("/export/home/sdc/mojoe/paradigm_lookup_table","r"); */
if (getenv("MOJOE_DIR") != NULL)
    sprintf(tblname, "%s/paradigm_lookup_table", getenv("MOJOE_DIR"));
else
    strcpy(tblname, "/export/home/sdc/mojoe/paradigm_lookup_table");

fp=fopen(tblname, "r");
if (fp==NULL) {
  printf ("Can not open lookup table");
  return;
}
/*
while(fgets(line,100,fp)!=NULL){
  if (line[0]!=';' & line[0] != '\n'){ 
    pch =(char*) strtok(line,"\t");
    sscanf(pch,"%d",&j);
    pch1= (char *)strtok(NULL,"\n");
    if (j==ref){
      pch=(char*)strrchr(pch1,'/')+1;
      strcpy(szRefName,pch);
      break;
    }
*/
while(fgets(line,MAXCHAR,fp)!=NULL)
  {
  if ((line[0]!=';') && (line[0] != '\n'))
    if (sscanf(line, "%s%s", str1, str2) == 2)
      if (sscanf(str1, "%d", &j) == 1)
	if (j == ref)
	  {
	    str3 = (char *) strrchr(str2, '/');
	    if ((str3 != NULL) && (strlen(str3) > 1))
		strcpy(szRefName, str3+1);
	    else
		strcpy(szRefName, str2);
	    break;
	  }
  }
fclose(fp);
 return;
}
