/*  read_pfile_header.c */
#include <stdio.h>
#include <stdlib.h>
#include "imagedb.h"
#define RECON_FLAG 1
#include "rdbm.h"


#define MAXCHAR 256

int debug = 0;          /* Global debug flag                         */
int non_epi = 0;        /*   "    flag for conventional non-epi data */
FILE *fplog;            /*   "    file pointer for recon log         */

RDB_HEADER_REC rdbhead;
EXAMDATATYPE examhead;
SERIESDATATYPE serieshead;
MRIMAGEDATATYPE imagehead;

void get_paradigm(int ref, char *szRefName);
int readrawhead(char *rawfilename);

#define REL_PC 0

/* prototype for main () */
int main(int,char **);

/* main(): contols most aspects of the reconstruction of raw epi data.  */
/*         This function is basically a big loop that passes over the   */
/*         slices & nexs in a raw epi data file collected w/ NOPROC = 1 */
int main(int argc, char **argv)
{

  int SKIP = -1;         /* images to skip (for saturation) when writing stimulate file */
  int i,j;
  int  epiflexType;

  char szEpiflexType[30];
  char szPlane[10];
  char szRefName[MAXCHAR];
  int nscantime,mins,secs;
  int option = 0;
  char rawfilename[MAXCHAR];
  char *szBaseFileName;
  char *szPfileFilename;
  
  /* BJM: read command line arguments */ 
  if (myreadcl(argc,argv,rawfilename,&option))
    {
     if(debug) {
	printf ("Sleeping 10 seconds to debug memory allocation...\n");
	sleep(10);
      }

     printf("Command Line Format and options for epirecon.....\n"
            "read_pfile_header -f <raw data filename> [Options]\n"
            "\tOptions: none: return all info\n"
	    "\t\t -o 1:return examno\n"
	    "\t\t    2:return type, ref function\n");
     exit(1);
    }

/* Set skip variable for stimulate file if not set on commandline */
  if(SKIP < 0) SKIP = 4;
  
/* BJM: reads raw header and allows acces to every item stored in header */
  if(readrawhead(rawfilename))
    {
      printf("Error reading raw data header or couldn't find file named %s.\n",rawfilename);
      exit(1);
    }
  else {

    szBaseFileName=(char*)strrchr(rawfilename,'/');
      if (szBaseFileName==NULL)
	szPfileFilename=rawfilename;
      else
	szPfileFilename=szBaseFileName+1;


    switch (option){
    case 0:

      printf("Pfile Name    = %s\n",    szPfileFilename);
      printf("PSD Name      = %s\n\n",  imagehead.psdname);

      printf("Exam Number   = %d\n",    examhead.ex_no);
      printf("Series Number = %d\n\n",  serieshead.se_no);

      printf("Series Description = %s \n", serieshead.se_desc);
      printf("Protocol           = %s \n\n", serieshead.prtcl);

      /* Plane  string
	 2      Axial
	 4      Sagittal
	 8      Coronal
	 16     Oblique
	 */
      switch ((int) imagehead.plane){
      case 2:
	  strcpy(szPlane,"Axial");
	  break;
      case 4:
	  strcpy(szPlane,"Sagittal");
	  break;
      case 8:
	  strcpy(szPlane,"Coronal");
	  break;
      case 16:
	  strcpy(szPlane,"Oblique");
	  break;
      }

      printf("Imaging Plane      = %s\n", szPlane);
      printf("Imaging Options    = %d\n\n", imagehead.iopt);


      printf("TE                 = %8.3f [ms]\n", (float) imagehead.te/1000.0);
      printf("TR                 = %8.3f [ms]\n", (float) imagehead.tr/1000.0);

      if( 1 ) {
        printf("TI                 = %8.3f [ms]\n", (float) imagehead.ti/1000.0);
      }

      printf("\n");
      printf("Resolution         = %3d x %3d\n", rdbhead.rdb_hdr_frame_size, 
                                                rdbhead.rdb_hdr_nframes);
      printf("Field of View      = %3.0f x %3.0f [mm]\n", imagehead.dfov, imagehead.dfov_rect);

      printf("Number of Slices   = %d\n", rdbhead.rdb_hdr_nslices);
      printf("Slice Thickness    = %2.1f [mm]\n", imagehead.slthick);


      if (strstr(imagehead.psdname,"epiflex")) 
      {

        printf("\n\n*** EPIFLEX v%d details ***\n\n",  (int) rdbhead.rdb_hdr_user18);
        
      /* type   string
	 1      fMRI experiment
	 2      Distortion Correction Map
	 3      PSF Map
         4
         5
         6
         7 
      */
        epiflexType = (int) rdbhead.rdb_hdr_user20;
        
	switch ( epiflexType ) {
	case 1:
	  strcpy(szEpiflexType,"fMRI experiment");
	  break;
	case 2:
	  strcpy(szEpiflexType,"Distortion Correction Map");
	  break;
	case 3:
	  strcpy(szEpiflexType,"PSF Map");
	  break;
	  /*
	case 4:
	  strcpy(szEpiflexType,"T1 Mappping");
	  break;
	case 5:
	  strcpy(szEpiflexType,"T2 Mapping");
	  break;
	case 6:
	  strcpy(szEpiflexType,"DC T2 Mapping");
	  break;
	case 7:
	  */
	case 4:
	  strcpy(szEpiflexType,"Perfusion");
	  break;
	}

	nscantime=(int)(imagehead.sctime/1000000);
	mins=nscantime/60;
	secs=nscantime%60;
	printf("\tScan Duration         = %d:%02d\n",mins,secs);
	printf("\tImaging Volumes       = %d\n\n", imagehead.fphase);

	printf("\tAcquisition Code      = %d\n", epiflexType);
	printf("\tAcquisition           = %s\n\n", szEpiflexType);

          printf("\tfMRI Paradigm Number  = %d   \n", (int) rdbhead.rdb_hdr_user21);

	if (rdbhead.rdb_hdr_user21){
	  get_paradigm( (int) rdbhead.rdb_hdr_user21,szRefName);
	  printf("\tfMRI Paradigm         = %s \n", szRefName);
	}
      }

      printf("\n\n");

      break;

    case 1:
      printf("%d",    examhead.ex_no);
      break;

    case 2:
      if (strstr(imagehead.psdname,"epiflex")) {

      /* type   string
	 1      fMRI experiment
	 2      Distortion Correction Map
	 3      PSF Map
      */

        epiflexType = (int) rdbhead.rdb_hdr_user20;
        
	switch ( epiflexType ) {
	case 1:
	  strcpy(szEpiflexType,"fMRI experiment");
	  break;
	case 2:
	  strcpy(szEpiflexType,"Distortion Correction Map");
	  break;
	case 3:
	  strcpy(szEpiflexType,"PSF Map");
	  break;
	  /*
	case 4:
	  strcpy(szEpiflexType,"T1 Mappping");
	  break;
	case 5:
	  strcpy(szEpiflexType,"T2 Mapping");
	  break;
	case 6:
	  strcpy(szEpiflexType,"DC T2 Mapping");
	  break;
	case 7:
	  */
	case 4:
	  strcpy(szEpiflexType,"Perfusion");
	  break;
	}

	printf("%s", szEpiflexType);

	if (rdbhead.rdb_hdr_user21){
	  get_paradigm( (int) rdbhead.rdb_hdr_user21,szRefName);
	  printf(",%s", szRefName);
	}

	printf("\n");
      }
      break;
    }
    }

}


/*************************************************************************/
/*Get raw data filename from command line */
int myreadcl(int numarg,char **pstring, char filename[], int *option)
{
  int fileflag = 1;
  
  if (numarg !=1)
    {
      pstring++;
      while (*pstring != NULL)
	{
	  if (strcmp("-f",*pstring)==0)
	    {
	      pstring++;
	      if(*pstring!=NULL)
		{
		  strcpy(filename,*pstring);
		  fileflag = 0;
		}
	      pstring++;
	    }
	  else if (strcmp("-help",*pstring)==0)
	    {
	      printf("Command Line Format and options[].....\n"
	             "read_pfile_header -f <raw data filename> [Options]\n"
		     "\tOptions: none: return all info\n"
		     "\t\t -o 1:return examno\n"
		     "\t\t    2:return type, ref function\n");

	      pstring++;
	      exit(0);
	    }
	  else if (strcmp("-o",*pstring)==0)
	    {
	      pstring++;
	      if(*pstring!=NULL)
		{
		  *option=atoi(*pstring);
		}
	      else *option=0;
	      pstring++;
	    }	  
         
          
           		
	  else pstring++;
	}
    }

  return(fileflag);
}

void get_paradigm( int ref, char *szRefName){

FILE *fp;
char line[MAXCHAR];
char str1[MAXCHAR];
char str2[MAXCHAR];
char tblname[256];
char *str3;
int i;
int j;

strcpy(szRefName, "Not found");
i=0;
/* fp=fopen("/export/home/sdc/mojoe/paradigm_lookup_table","r"); */
if (getenv("MOJOE_DIR") != NULL)
    sprintf(tblname, "%s/paradigm_lookup_table", getenv("MOJOE_DIR"));
else
    strcpy(tblname, "/export/home/sdc/mojoe/paradigm_lookup_table");

fp=fopen(tblname, "r");

if (fp==NULL) {
  printf ("Can not open lookup table");
  return;
}
while(fgets(line,MAXCHAR,fp)!=NULL)
  {
  if ((line[0]!=';') && (line[0] != '\n'))
    if (sscanf(line, "%s%s", str1, str2) == 2)
      if (sscanf(str1, "%d", &j) == 1)
	if (j == ref)
	  {
	    str3 = (char *) strrchr(str2, '/');
	    if ((str3 != NULL) && (strlen(str3) > 1))
		strcpy(szRefName, str3+1);
	    else
		strcpy(szRefName, str2);
	    break;
	  }
  }
fclose(fp);
 return;
}

int readrawhead(char *rawfilename)
{
FILE *f;
int failure;

f = fopen(rawfilename, "rb");
failure = 1;
if (f != NULL)
    {
    if (fread(&rdbhead, sizeof(rdbhead), 1, f) == 1)
        if (fseek(f, RDB_EXAMDATATYPE_OFF, SEEK_SET) == 0)
            if (fread(&examhead, sizeof(examhead), 1, f) == 1)
	        if (fread(&serieshead, sizeof(serieshead), 1, f) == 1)
		  if (fread(&imagehead, sizeof(imagehead), 1, f) == 1)
                        {
                        failure = 0;
                        };
   fclose(f);
   }
return(failure);
}
