#include <stdio.h>
#include "imagedb.h"
#define RECON_FLAG 1
#include "rdbm.h"

int main(int argc, char **argv)
{
  void byteflip(char *x, int n);

  FILE *f;
  int flip;
  EXAMDATATYPE examhdr;
  SERIESDATATYPE serieshdr;
  MRIMAGEDATATYPE imagehdr;
  RDB_HEADER_REC rdbhdr;
  register int i;


  if (argc != 3)
    {
      printf ("usage:\t readp pfilename flipbytes\n");
      exit(1);
    }

  if(sscanf(argv[2], "%d", &flip) != 1)
    exit(1);
  if ((flip < 0) || (flip > 1))
    exit(1);

  f = fopen(argv[1], "rb");
    
  if (f != NULL)
    {
	if (fread(&rdbhdr, sizeof(rdbhdr), 1, f) == 1)
	  {
	    if (flip)
	      {
		byteflip((char *) (&rdbhdr.rdb_hdr_frame_size), sizeof(rdbhdr.rdb_hdr_frame_size));
		byteflip((char *) (&rdbhdr.rdb_hdr_nframes), sizeof(rdbhdr.rdb_hdr_nframes));
		byteflip((char *) (&rdbhdr.rdb_hdr_nslices), sizeof(rdbhdr.rdb_hdr_nslices));
		byteflip((char *) (&rdbhdr.rdb_hdr_user18), sizeof(rdbhdr.rdb_hdr_user18));
		byteflip((char *) (&rdbhdr.rdb_hdr_user20), sizeof(rdbhdr.rdb_hdr_user20));
		byteflip((char *) (&rdbhdr.rdb_hdr_user21), sizeof(rdbhdr.rdb_hdr_user21));
	      }

	  printf("RDB xres       = %d\n", rdbhdr.rdb_hdr_frame_size);
	  printf("RDB yres       = %d\n", rdbhdr.rdb_hdr_nframes);
	  printf("RDB nslices    = %d\n", rdbhdr.rdb_hdr_nslices);
	  printf("RDB version    = %d\n", (int) rdbhdr.rdb_hdr_user18);
	  printf("RDB type       = %d\n", (int) rdbhdr.rdb_hdr_user20);	  
	  i = (int) rdbhdr.rdb_hdr_user20;
	  if (i == 1)
	    printf("RDB type name  = %s\n", "fMRI experiment");
	  else if (i == 2)
	    printf("RDB type name  = %s\n", "Distortion Correction Map");
	  else if (i == 3)
	    printf("RDB type name  = %s\n", "PSF Map");
	  else
	    printf("RDB type name   = %s\n", "UNKNOWN");
	  printf("RDB paradigm   = %d\n", (int) rdbhdr.rdb_hdr_user21);
	  }
//	else
//	  printf ("error reading rdb header\n");
      if (fseek(f, RDB_EXAMDATATYPE_OFF, SEEK_SET) == 0)
	{
        if (fread(&examhdr, sizeof(examhdr), 1, f) == 1)
	  {
	  if (flip)
	    {
	      byteflip((char *) (&examhdr.ex_no), sizeof(examhdr.ex_no));
	    }
	  printf("EXM suid       = %s\n", examhdr.ex_suid);
	  printf("EXM pat        = %s\n", examhdr.patname);
	  printf("EXM exam       = %d\n", examhdr.ex_no);
	  }
//        else
//	  printf ("error reading exam header\n");
	if (fread(&serieshdr, sizeof(serieshdr), 1, f) == 1)
	  {
	  if (flip)
	    {
	      byteflip((char *) (&serieshdr.se_exno), sizeof(serieshdr.se_exno));
	      byteflip((char *) (&serieshdr.se_no), sizeof(serieshdr.se_no));
	      byteflip((char *) (&serieshdr.position), sizeof(serieshdr.position));
	      byteflip((char *) (&serieshdr.lmhor), sizeof(serieshdr.lmhor));
	    }
	  printf("SER suid       = %s\n", serieshdr.se_suid);
	  printf("SER protocol   = %s\n", serieshdr.prtcl);
	  printf("SER desc       = %s\n", serieshdr.se_desc);
	  printf("SER exam       = %d\n", serieshdr.se_exno);
	  printf("SER series     = %d\n", serieshdr.se_no);
	  printf("SER position   = %d\n", serieshdr.position);
	  printf("SER h landmark = %.4f\n", serieshdr.lmhor);
	  }
//      else
//	  printf ("error reading exam header\n");
	if (fread(&imagehdr, sizeof(imagehdr), 1, f) == 1)
	  {
	    if (flip)
	      {
		byteflip((char *) (&imagehdr.plane), sizeof(imagehdr.plane));
		byteflip((char *) (&imagehdr.im_exno), sizeof(imagehdr.im_exno));
		byteflip((char *) (&imagehdr.iopt), sizeof(imagehdr.iopt));
		byteflip((char *) (&imagehdr.fphase), sizeof(imagehdr.fphase));
		byteflip((char *) (&imagehdr.dim_X), sizeof(imagehdr.dim_X));
		byteflip((char *) (&imagehdr.dim_Y), sizeof(imagehdr.dim_Y));
		byteflip((char *) (&imagehdr.te), sizeof(imagehdr.te));
		byteflip((char *) (&imagehdr.tr), sizeof(imagehdr.tr));
		byteflip((char *) (&imagehdr.ti), sizeof(imagehdr.ti));
		byteflip((char *) (&imagehdr.slthick), sizeof(imagehdr.slthick));
		byteflip((char *) (&imagehdr.dfov), sizeof(imagehdr.dfov));
		byteflip((char *) (&imagehdr.sctime), sizeof(imagehdr.sctime));
		byteflip((char *) (&imagehdr.scanspacing), sizeof(imagehdr.scanspacing));
	      }
	  printf("IMG psdname    = %s\n", imagehdr.psdname);
	  printf("IMG suid       = %s\n", imagehdr.im_suid);
	  printf("IMG plane      = %d\n", imagehdr.plane);

	  if (imagehdr.plane == 2)
	    printf("IMG plane name = %s\n", "Axial");
	  if (imagehdr.plane == 4)
	    printf("IMG plane name = %s\n", "Sagittal");
	  if (imagehdr.plane == 8)
	    printf("IMG plane name = %s\n", "Coronal");
	  if (imagehdr.plane == 16)
	    printf("IMG plane name = %s\n", "Oblique");

	  printf("IMG exam       = %d\n", imagehdr.im_exno);
	  printf("IMG options    = 0x%x\n", imagehdr.iopt);
	  printf("IMG f phase    = %d\n", imagehdr.fphase);
	  printf("IMG dim_x      = %.0f\n", imagehdr.dim_X);
	  printf("IMG dim_y      = %.0f\n", imagehdr.dim_Y);
	  printf("IMG te [ms]    = %.3f\n", imagehdr.te/1000.0);
	  printf("IMG tr [ms]    = %.3f\n", imagehdr.tr/1000.0);
	  printf("IMG ti [ms]    = %.3f\n", imagehdr.ti/1000.0);
	  printf("IMG slthick    = %.1f\n", imagehdr.slthick);
	  printf("IMG dfov       = %.0f\n", imagehdr.dfov);
	  printf("IMG sctime[sec]= %d\n", (int) (imagehdr.sctime)/1000000);
	  i = (imagehdr.sctime)/1000000;
	  printf("IMG sctime[m:s]= %d:%02d\n", i/60, i%60);
	  printf("IMG between    = %.4f\n", imagehdr.scanspacing);
	  }
//	else//	  printf ("error reading series header\n");
	 }
      fclose(f);
      }
  exit(0);
   }

void byteflip(char *x, int n)
{
  char xflip[8];
  if (n == 2)
    {
      xflip[0] = x[1];
      xflip[1] = x[0];

      x[0] = xflip[0];
      x[1] = xflip[1];
    }
  else if (n == 4)
    {
      xflip[0] = x[3];
      xflip[1] = x[2];
      xflip[2] = x[1];
      xflip[3] = x[0];

      x[0] = xflip[0];
      x[1] = xflip[1];
      x[2] = xflip[2];
      x[3] = xflip[3];
    }
  else if (n == 8)
    {
      xflip[0] = x[7];
      xflip[1] = x[6];
      xflip[2] = x[5];
      xflip[3] = x[4];
      xflip[4] = x[3];
      xflip[5] = x[2];
      xflip[6] = x[1];
      xflip[7] = x[0];

      x[0] = xflip[0];
      x[1] = xflip[1];
      x[2] = xflip[2];
      x[3] = xflip[3];
      x[4] = xflip[4];
      x[5] = xflip[5];
      x[6] = xflip[6];
      x[7] = xflip[7];
    }
}
