/*	infodcm.cc
 *
 *      Usage: infodcm dicom_file_name [display_file_name]
 *
 */
#include <stdio.h>
#include <unistd.h>

#include "dcmtk/dcmdata/dctk.h"
#define INCLUDE_CSTDLIB
#define INCLUDE_CSTRING
#include "dcmtk/ofstd/ofstdinc.h"

int main(int argc, char **argv)
{
DcmFileFormat dfile;
int i;
int j;
int plane;

#define NTAGS 16
Uint16 tag[NTAGS+NTAGS] =
	{
	0x0019, 0x109c,
	0x0020, 0x0010,
	0x0020, 0x0011,
	0x0008, 0x103e,
	0x0018, 0x1030,
	0x0027, 0x1035,
	0x0018, 0x0022,
	0x0018, 0x0081,
	0x0018, 0x0080,
	0x0018, 0x0082,
	0x0019, 0x101e,
	0x0018, 0x0094,
	0x0021, 0x104f,    
	0x0018, 0x0050,
	0x0025, 0x1010,
	0x0018, 0x1310
	};
char *tagName[] =
	{
	"PSD Name",
	"Exam Number",
	"Series Number",
	"Series Description",
	"Protocol",
	"Plane",
	"Scan Options",
	"TE",
	"TR",
	"TI",
	"Display Field of View",
	"% Phase Field of View",
	"Number of Slices",
	"Slice Thickness",
	"Landmark Counter",
	"Acquisition Matrix"
	};  

#define MAXSTRING 256
char headervar[MAXSTRING];

if ((argc < 2) || (argc > 3))
	{
	printf("Usage:\tinfodcm dicom_file_name [display_file_name]\n");
	return(EXIT_FAILURE);
	}

if (access(argv[1], R_OK) != 0)
 	{
	printf("Dicom file %s is not available\n", argv[1]);
	return(EXIT_FAILURE);
	}

printf("\n");

if (argc == 3)
	printf("%-21s = %s\n", "Image File Name", argv[2]);
else
	printf("%-21s = %s\n", "Image File Name", argv[1]);
  
DcmDataset * dataset = dfile.getDataset();
OFCondition cond = dfile.loadFile(argv[1]);

// ** uncomment these lines of code to return when library error on loadFile
//if(!cond.good())
//	{
//	printf("Error **%s** loading file **%s**\n", argv[1], cond.text());
//        return(EXIT_FAILURE);
//	}
// **


// ** uncomment this line of code to load all data into memory
//    dfile.loadAllDataIntoMemory();
// **

OFString value;
i = j = 0;
DcmTagKey key(tag[j], tag[j+1]);  // StudyID 

for (i = 0; i < NTAGS; i++)
	{
	if (i > 0)
		key.set(tag[j], tag[j+1]);
//	cond = dataset->findAndGetOFString(key, value);
	strcpy(headervar, "(undefined)");  // assume undefined
	cond = dataset->findAndGetOFStringArray(key, value, OFTrue);
	if (cond.good())
		{
		if (strlen(value.data()) < MAXSTRING)
			strcpy(headervar, value.data());
		if (!strcmp(tagName[i], "Plane"))
			{
			if (sscanf(value.data(), "%d", &plane) == 1)
				{
				switch(plane)
					{
					case 2: strcpy(headervar, "Axial"); break;
					case 4: strcpy(headervar, "Saggital"); break;
					case 8: strcpy(headervar, "Coronal"); break;
					case 16: strcpy(headervar, "Oblique"); break;
					}
				}
			}
		}
	printf("%-21s = %s\n", tagName[i], headervar);
	j += 2;
	}	

printf("\n");

return(EXIT_SUCCESS);
}
