/*	infodcm.cc
 *
 *      Usage: infodcm dicom_file_name option [prefix]
 *
 */
#include <stdio.h>
#include <unistd.h>

#include "dcmtk/dcmdata/dctk.h"
#define INCLUDE_CSTDLIB
#define INCLUDE_CSTRING
#include "dcmtk/ofstd/ofstdinc.h"

int main(int argc, char **argv)
{
DcmFileFormat dfile;
int i;
int j;
int plane;

int option;

#define NTAGS 4
Uint16 tag[NTAGS+NTAGS] =
	{
	0x0019, 0x109c,
	0x0020, 0x0011,
	0x0008, 0x103e,
	0x0018, 0x1030
	};
char *tagName[] =
	{
	"PSDName",
	"SeriesNumber",
	"SeriesDescription",
	"Protocol",
	};  

#define MAXSTRING 256
char headervar[MAXSTRING];

if ((argc < 3) || (argc > 4))
	{
	printf("Usage:\tinfodcm2 dicom_file_name option [prefix]\n");
	return(EXIT_FAILURE);
	}

if (access(argv[1], R_OK) != 0)
 	{
	printf("Dicom file %s is not available\n", argv[1]);
	return(EXIT_FAILURE);
	}
/* option 0 = print header and info, option 1 = print csv header, option 2 = print csv info */
sscanf(argv[2], "%d", &option);

DcmDataset * dataset = dfile.getDataset();
OFCondition cond = dfile.loadFile(argv[1]);

// ** uncomment these lines of code to return when library error on loadFile
//if(!cond.good())
//	{
//	printf("Error **%s** loading file **%s**\n", argv[1], cond.text());
//        return(EXIT_FAILURE);
//	}
// **


// ** uncomment this line of code to load all data into memory
//    dfile.loadAllDataIntoMemory();
// **

OFString value;
i = j = 0;
DcmTagKey key(tag[j], tag[j+1]);  // StudyID 

for (i = 0; i < NTAGS; i++)
	{
	if (i > 0)
		key.set(tag[j], tag[j+1]);
//	cond = dataset->findAndGetOFString(key, value);
	strcpy(headervar, "(undefined)");  // assume undefined
	cond = dataset->findAndGetOFStringArray(key, value, OFTrue);
	if (cond.good())
		{
		if (strlen(value.data()) < MAXSTRING)
			strcpy(headervar, value.data());
		if (!strcmp(tagName[i], "Plane"))
			{
			if (sscanf(value.data(), "%d", &plane) == 1)
				{
				switch(plane)
					{
					case 2: strcpy(headervar, "Axial"); break;
					case 4: strcpy(headervar, "Saggital"); break;
					case 8: strcpy(headervar, "Coronal"); break;
					case 16: strcpy(headervar, "Oblique"); break;
					}
				}
			}
		}
        if ((option > 0) && (i == 0) && (argc == 4))  /* prefix? */
	    printf("%s,", argv[3]);
        if ((option > 0) && (i > 0))
	    printf(",");
        if (option == 1)
	    printf("%s", tagName[i]);
        else if (option == 2)
	    printf("%s", headervar);
        else
	    printf("%-21s = %s\n", tagName[i], headervar);
	j += 2;
	}	

printf("\n");

return(EXIT_SUCCESS);
}
