#include "dcmtk/dcmdata/dctk.h"
#define INCLUDE_CSTDLIB
#define INCLUDE_CSTRING
#include "dcmtk/ofstd/ofstdinc.h"

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <dirent.h>

char IMAGEDIR[256];

#define TRUE 1
#define FALSE 0

#define MAXKEYLEN 129  // length of sort string
#define MAXKEYSORT 14 // 1st N characters to consider in the sort
#define MAXENAME 43   // max number of characters to use for patient name
#define MAXERROR 10   // # errors from DICOM header to be considered "error-free" 

typedef struct
	{
	int studydate;
	int studytime;
	long exam;
	long DICOMpatient;
	long DICOMexam;
	char ename[MAXENAME+1];
	} dbinfo;

dbinfo db;
int nerror;
int nlist;
char *dbTable = NULL;

int main(int argc, char **argv)
{
void getList(void);
int revsort_cmp (const void *c1, const void *c2);

register int i;
register int j;

if (argc < 2)
   exit(EXIT_FAILURE);

strcpy(IMAGEDIR, argv[1]);

nlist = 0;
getList();
if (nlist > 0)
    {
    qsort ((void *) dbTable, nlist, MAXKEYLEN, revsort_cmp);
    j = 0;
    for (i = 0; i < nlist; i++)
        {
	printf("%s\n", dbTable+j);
	j += MAXKEYLEN;
        }
    }

if (dbTable != NULL)
   free(dbTable);

if (nlist > 0)
  exit(EXIT_SUCCESS);

exit(EXIT_FAILURE);
}

void getList(void)
{
void getSeries(char *pename);

DIR *dir1;
DIR *dir2;
struct dirent *ent1;
struct dirent *ent2;
char pename[256];

if ((dir1 = opendir(IMAGEDIR)) != NULL)
	{
	while ((ent1 = readdir(dir1)) != NULL)
		{
		if (!strncmp(ent1->d_name, "p", 1))
			{
			sscanf(ent1->d_name+1, "%ld", &db.DICOMpatient);
			sprintf(pename, "%s/%s", IMAGEDIR, ent1->d_name);
			if ((dir2 = opendir(pename)) != NULL)
				{
				while ((ent2 = readdir(dir2)) != NULL)
					{
					if (!strncmp(ent2->d_name, "e", 1))
						{
						sscanf(ent2->d_name+1, "%ld", &db.DICOMexam);
						sprintf(pename, "%s/%s/%s", IMAGEDIR, ent1->d_name, ent2->d_name);
						getSeries(pename);
						}
					}
				closedir(dir2);
				}
			}
		}
	closedir(dir1);
	}
}

void getSeries(char *pename)
{
void getInternalInfo(char *fname);
void dbAppend(void);

DIR *dir3;
DIR *dir4;
struct dirent *ent3;
struct dirent *ent4;
int added;
int nseries;
int nimage;
char fname[256];

nseries = 0;
added = FALSE;
nimage = 0;
if ((dir3 = opendir(pename)) != NULL)
	{
	while ((ent3 = readdir(dir3)) != NULL)
		{
		if (!strncmp(ent3->d_name, "s", 1))
			{
			++nseries;
			if ((added == TRUE) && (nseries > 1))
			  break; // look through only 1 error-free series directory
			sprintf(fname, "%s/%s", pename, ent3->d_name);
			if ((dir4 = opendir(fname)) != NULL)
				{
				while ((ent4 = readdir(dir4)) != NULL)
					{
					if (!strncmp(ent4->d_name, ".", 1))
					  continue;
					if (!strncmp(ent4->d_name, "i", 1))
						{
						sprintf(fname, "%s/%s/%s", pename, 
							ent3->d_name, ent4->d_name);
						getInternalInfo(fname);
						if (nerror <= MAXERROR)
						  added = TRUE;
						++nimage;
						}
					if ((nimage >= 1) && (added == TRUE))
					  break;
					}
				if (added)
				  {
				    dbAppend();
				    nlist++;
				  }
				closedir(dir4);
				}
			}
		}
	closedir(dir3);
	}
}


void getInternalInfo(char *fname)
{
void charReset(char *str, char inchar, char outchar);
 int n;

#define CHECKCONDITION    \
    if(!cond.good())      \
      ++nerror;

nerror = 0;

long ltemp;
int itemp;

    DcmFileFormat dfile;
    OFCondition cond = dfile.loadFile(fname);
    CHECKCONDITION

//??    dfile.loadAllDataIntoMemory();
    DcmDataset * dataset = dfile.getDataset();
//?? need to release data set?

    // search for a particular key
    OFString value;

    DcmTagKey key(0x0020, 0x0010);  // StudyID
    cond = dataset->findAndGetOFString(key, value);
    CHECKCONDITION
    if (sscanf(value.data(), "%ld", &ltemp) == 1)
        db.exam = ltemp;

    key.set(0x0008, 0x0020);  // StudyDate
    cond = dataset->findAndGetOFString(key, value);
    CHECKCONDITION
    if (sscanf(value.data(), "%d", &itemp) == 1)
        db.studydate = itemp;

    key.set(0x0008, 0x0030);  // StudyTime
    cond = dataset->findAndGetOFString(key, value);
    CHECKCONDITION
    if (sscanf(value.data(), "%d", &itemp) == 1)
        db.studytime = itemp;

    key.set(0x0010, 0x0010);  // PatientsName
    cond = dataset->findAndGetOFString(key, value);
    CHECKCONDITION
    n = strlen(value.data());
    if (n <= 0)
	 strcpy(db.ename, " ");
    else if (n > MAXENAME)
        {
	strncpy(db.ename, value.data(), MAXENAME);
	db.ename[MAXENAME] = 0;
	}
    else
       strcpy(db.ename, value.data());

    charReset(db.ename, ' ', '_');
}

void charReset(char *str, char inchar, char outchar)
{
  int i;
  int j;

  j = strlen(str);
  for (i = 0; i < j; i++)
    if (str[i] == inchar)
      str[i] = outchar;
}


void dbAppend(void)
{
#define FORMAT "%08d%06d %10s %8s %05ld %-43.43s %-43.43s"
char DICOMdir[44];
char datestr[16];
char timestr[16];
char tempstr[16];

sprintf(DICOMdir, "p%ld/e%ld", db.DICOMpatient, db.DICOMexam);

sprintf(tempstr, "%08d", db.studydate);
datestr[0] = tempstr[4];
datestr[1] = tempstr[5];
datestr[2] = '/';
datestr[3] = tempstr[6];
datestr[4] = tempstr[7];
datestr[5] = '/';
datestr[6] = tempstr[0];
datestr[7] = tempstr[1];
datestr[8] = tempstr[2];
datestr[9] = tempstr[3];
datestr[10] = '\0';

sprintf(tempstr, "%06d", db.studytime);
timestr[0] = tempstr[0];
timestr[1] = tempstr[1];
timestr[2] = ':';
timestr[3] = tempstr[2];
timestr[4] = tempstr[3];
timestr[5] = ':';
timestr[6] = tempstr[4];
timestr[7] = tempstr[5];
timestr[8] = '\0';

if (dbTable == NULL)
    {
    dbTable = (char *) malloc(MAXKEYLEN);
    if (dbTable != NULL)
      sprintf(dbTable, FORMAT, db.studydate, db.studytime, datestr, timestr, db.exam, db.ename, DICOMdir);
    }
else
    {
    if (realloc(dbTable, MAXKEYLEN*(nlist+1)) != NULL) // total new size
      sprintf(dbTable+(nlist*MAXKEYLEN), FORMAT, db.studydate, db.studytime, datestr, timestr, db.exam, db.ename, DICOMdir);
    }
}

int  revsort_cmp (const void *c1, const void *c2)
{
return strncmp ((char *) c2, (char *) c1, MAXKEYSORT);
}
