#include "dcmtk/dcmdata/dctk.h"
#define INCLUDE_CSTDLIB
#define INCLUDE_CSTRING
#include "dcmtk/ofstd/ofstdinc.h"

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <dirent.h>

#define TRUE 1
#define FALSE 0

#define IMAGEDIR argv[1]
#define MAXKEYLEN 128  // length of sort string
#define MAXKEYSORT 58  // 1st N characters to consider in the sort
#define MAXSNAME 43    // max number of characters to use for patient name
#define MAXERROR 10    // # errors from DICOM header to be considered "error-free" 
#define MAXSERIES 1024

typedef struct
	{
	long DICOMseries;
        long exam;
	long series;
	long imagesinseries;
	char sname[MAXSNAME+1];
	} dbinfo;

dbinfo db;
int nerror;
int nlist;
char *dbTable = NULL;
char pedir[256];

int main(int argc, char ** argv)
{
void getSeries(char *pename);
int sort_cmp (const void *c1, const void *c2);
 char pename[256];
register int i;
register int j;

if (argc < 4)
   exit(EXIT_FAILURE);

 strcpy(pedir, argv[2]);

if (sscanf(argv[3], "%ld", &db.exam) != 1)
   exit(EXIT_FAILURE);

 sprintf(pename, "%s/%s", IMAGEDIR, pedir);

nlist = 0;
getSeries(pename);

if (nlist > 0)
    {
    qsort ((void *) dbTable, nlist, MAXKEYLEN, sort_cmp);
    j = 0;
    for (i = 0; i < nlist; i++)
        {
	printf("%s\n", dbTable+j);
	j += MAXKEYLEN;
        }
    }

//Causes seg fault
//if (dbTable != NULL)
//	delete(dbTable);

if (nlist > 0)
  exit(EXIT_SUCCESS);

exit(EXIT_FAILURE);
}

void getSeries(char *pename)
{
void getInternalSeriesInfo(char *fname);
void dbAppend(void);

DIR *dir3;
DIR *dir4;
struct dirent *ent3;
struct dirent *ent4;
int added;
int nseries;
int nimage;
char fname[256];

nseries = 0;
added = FALSE;
nimage = 0;
if ((dir3 = opendir(pename)) != NULL)
	{
	while ((ent3 = readdir(dir3)) != NULL)
		{
		if (!strncmp(ent3->d_name, "s", 1))
			{
			++nseries;
			if (nseries > MAXSERIES)
			  break; // look through only N series directories
			sscanf(ent3->d_name+1, "%ld", &db.DICOMseries);
			sprintf(fname, "%s/%s", pename, ent3->d_name);
			if ((dir4 = opendir(fname)) != NULL)
				{
 			        nimage = 0;
				while ((ent4 = readdir(dir4)) != NULL)
					{
					if (!strncmp(ent4->d_name, ".", 1))
					  continue;
					if (!strncmp(ent4->d_name, "i", 1))
						{
						  if (nimage == 0)
						    {
						      sprintf(fname, "%s/%s/%s", pename, 
							      ent3->d_name, ent4->d_name);
						      getInternalSeriesInfo(fname);
						      if (nerror <= MAXERROR)
							added = TRUE;
						    }
						++nimage;
						}
					}
				if (added)
				  {
				    db.imagesinseries = nimage;
				    dbAppend();
				    nlist++;
				  }
				closedir(dir4);
				}
			}
		}
	closedir(dir3);
	}
}

void getInternalSeriesInfo(char *fname)
{
void charReset(char *str, char inchar, char outchar);
 int n;

#define CHECKCONDITION    \
    if(!cond.good())      \
      ++nerror;

nerror = 0;

long ltemp;
     DcmFileFormat dfile;
    OFCondition cond = dfile.loadFile(fname);
    CHECKCONDITION

//??    dfile.loadAllDataIntoMemory();
    DcmDataset * dataset = dfile.getDataset();
//?? need to release data set?

    // search for a particular key
    OFString value;

    DcmTagKey key(0x0020, 0x0011);  // SeriesNumber
    cond = dataset->findAndGetOFString(key, value);
    CHECKCONDITION
    if (sscanf(value.data(), "%ld", &ltemp) == 1)
        db.series = ltemp;

    /*
    key.set(0x0025, 0x1007);  // ImagesInSeries
    cond = dataset->findAndGetOFString(key, value);
    CHECKCONDITION
    if (sscanf(value.data(), "%ld", &ltemp) == 1)
        db.imagesinseries = ltemp;
    */

    key.set(0x0008, 0x103e);  // SeriesDecsription
    cond = dataset->findAndGetOFString(key, value);
    CHECKCONDITION
    n = strlen(value.data());
    if (n <= 0)
	 strcpy(db.sname, " ");
    else if (n > MAXSNAME)
        {
	strncpy(db.sname, value.data(), MAXSNAME);
	db.sname[MAXSNAME] = 0;
	}
    else
       strcpy(db.sname, value.data());

    charReset(db.sname, ' ', '_');
}

void charReset(char *str, char inchar, char outchar)
{
#define MAXSERIESLEN 28
  int i;
  int j;

  j = strlen(str);
  for (i = 0; i < j; i++)
    {
    if (i <= MAXSERIESLEN)
      {
	if (str[i] == inchar)
	  str[i] = outchar;
      }
    else
      str[i] = ' ';
    }
}


void dbAppend(void)
{
  char format1[] = "%05ld";
  char format2[32] = " %04ld";
  char format3[] = "%-43.43s";
  char format4[] = "%4ld";
  char format5[] = "%-65.65s";

char format[128];
char DICOMdir[128];



 if (db.series < 10000)
   strcpy(format2, " %04ld");
 else if (db.series < 100000)
   strcpy(format2, "%05ld");

sprintf(format, "%s %s %s %s %s", format1, format2, format3, format4, format5);

sprintf(DICOMdir, "%s/s%ld", pedir, db.DICOMseries);

 if (dbTable == NULL)
    {
    dbTable = (char *) malloc(MAXKEYLEN);
    if (dbTable != NULL)
      sprintf(dbTable, format, db.exam, db.series, db.sname, db.imagesinseries, DICOMdir);
    }
else
    {
    if (realloc(dbTable, MAXKEYLEN*(nlist+1)) != NULL) // total new size
      sprintf(dbTable+(nlist*MAXKEYLEN), format, db.exam, db.series, db.sname, db.imagesinseries, DICOMdir);
    }
}

int  sort_cmp (const void *c1, const void *c2)
{
return strncmp ((char *) c1, (char *) c2, MAXKEYSORT);
}
