static const char rcsid[] = "$Id: bxh_convert_bxh.c,v 1.1 2009-01-15 20:55:18 gadde Exp $";

/*
 * bxh2bxh.cc --
 * 
 * Creates a BXH or XCEDE file based on given BXH or XCEDE file.
 */

#include "bxh_utils.h"
#include "bxh_datarec.h"

#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <time.h>
#include <math.h>

extern char * domutil_errorbuf;

BXHDocPtr
createDocFromBXH(const char *ifname, const char *ofname)
{
    BXHDocPtr docp = NULL;

    if ((docp = bxh_readFile(ifname)) == NULL) {
	fprintf(stderr, "Reading XML file failed.\n"); 
	goto FAIL;
    }

#ifdef HAVE_LIBXSLT
    if (!bxh_doXCEDE) {
	BXHElementPtr bxh = NULL;
	bxh = bxh_getRootElement(docp);
	if (bxh_setAttribute(bxh, "fromxcede", "no") != 0) {
	    fprintf(stderr, "Error setting 'fromxcede' attribute!\n");
	    goto FAIL;
	}
	bxh_element_unref(bxh);
    }
#endif

    goto EXIT;

FAIL:
    if (domutil_errorbuf[0]) {
	fprintf(stderr, "%s", domutil_errorbuf);
    }
    if (docp) {
	bxh_freeDocument(docp);
	docp = NULL;
    }


EXIT:
    return docp;
}

int
createBXHFromBXH(const char *ifname, const char *ofname)
{
    int result = 0;
    BXHDocPtr docp = NULL;
    struct stat statbuf;

    if (stat(ofname, &statbuf) == 0) {
	fprintf(stderr, "createBXHFromBXH: file exists ('%s')\n", ofname);
	goto FAIL;
    }

    if ((docp = createDocFromBXH(ifname, ofname)) == NULL)
	goto FAIL;
    if (bxh_writeFile(docp, ofname) != 0)
	goto FAIL;

    goto EXIT;

FAIL:
    result = -1;

EXIT:
    if (docp) {
	bxh_freeDocument(docp);
	docp = NULL;
    }

    return result;
}

BXHDocPtr
bxh_bxh2doc(const char * filename)
{
    return createDocFromBXH(filename, "dummy.bxh");
}

/*
 * $Log: In-line log eliminated on transition to SVN; use svn log instead. $
 * Revision 1.1  2007/02/23 23:24:40  gadde
 * Add {bxh|xcede}2{bxh|xcede}
 *
 */
