/* $Id: bxh_eventlib.h,v 1.2 2005-04-01 22:27:02 gadde Exp $ */

/* bxh_eventlib.h --
 *
 *  Generically useful event parsing functions.
 *
 * Author: Syam Gadde (gadde@biac.duke.edu), Feb. 2005.
 */

#include <string>
#include <map>
#include <vector>
#include <functional>
#include <libxml/tree.h>

/* <onset, duration> --> node */
typedef std::pair<double, double> se_key_t;
typedef xmlNodePtr se_data_t;
typedef std::pair<se_key_t, se_data_t> se_val_t;
struct se_less : public std::binary_function<se_key_t, se_key_t, bool> { 
    bool operator()(se_key_t x, se_key_t y) const {
	return
	    (x.first < y.first) ||
	    (x.first == y.first && x.second < y.second);
    }
};
typedef struct qent_s {
    qent_s() : qind(-1), qnodes() { /* null */ }
    int qind;
    std::vector<xmlNodePtr> qnodes;
} qent_t;
typedef std::vector<qent_t> qvec;

xmlDocPtr merge_event_lists(std::vector<xmlDocPtr> & docs, const char * alleventsxpath, FILE * logfp);
int sort_event_list(xmlDocPtr doc, const char * alleventsxpath, FILE * logfp);
int canonicalize_event_list(xmlDocPtr doc, const char * alleventsxpath, FILE * logfp);
int match_events(xmlDocPtr doc, int numqueries, char ** queries, char ** querylabels, std::map<double, qvec > & eventlist, FILE * logfp);
int filter_events(xmlDocPtr doc, int numqueries, char ** queryfilters, char ** querylabels, std::map<double, qvec > & eventlist, FILE * logfp);
int exclude_epochs(xmlDocPtr doc, int numqueries, char ** queryepochexcludes, char ** querylabels, double epochdurbefore, double epochdurafter, std::map<double, qvec > & eventlist, FILE * logfp);
char * query2xpath(const char * queryin);
char * expand_xpath_event(const char * queryin);
