/* $Id: bxh_groupdocs.h,v 1.4 2004-06-10 19:56:24 gadde Exp $ */

/* bxh_groupdocs.h --
 *
 * BXH group documentation for doxygen
 *
 */

/** \defgroup bxh_util BXH file access interface
 *  These utilities are a further abstraction of the DOM interface
 *  which allows us to replace the underlying DOM implementation
 *  with another one if we find it necessary.
 */

/** \defgroup bxh_datarec BXH raw datarec functions
 *  \ingroup bxh_util
 *  These functions and data structures help convert to/from
 *  the BXH/DOM/XML representation of a datarec element to/from
 *  an internal C data structure of type bxhrawdatarec.
 */

/** \defgroup bxh_util_document BXH document functions
 *  \ingroup bxh_util
 *  Document-level functions, like create/read/write.
 */

/** \defgroup bxh_util_section BXH section functions
 *  \ingroup bxh_util
 *  Functions to get references to the major sections of a BXH file,
 *  like \<datarec\>, \<history\>, etc.
 */

/** \defgroup bxh_util_elementval BXH element value extraction functions
 *  \ingroup bxh_util
 *  Get the values stored in particular elements.
 */

/** \defgroup bxh_util_element BXH element functions
 *  \ingroup bxh_util
 *  Manipulate/access elements in a BXH file.
 */

/** \defgroup bxh_util_attribute BXH attribute functions
 *  \ingroup bxh_util
 *  Manipulate/access attributes in a BXH file.
 */

/** \defgroup bxh_util_comment BXH comment functions
 *  \ingroup bxh_util
 *  Manipulate/access comments in a BXH file.
 */

/** \defgroup bxh_util_misc BXH miscellaneous functions
 *  \ingroup bxh_util
 *  Other useful functions for BXH files.
 */


/** \defgroup bxh_convert BXH file conversion
 *  These functions are used to help convert some file formats
 *  to a BXH document.
 */

/*
 * $Log: In-line log eliminated on transition to SVN; use svn log instead. $
 * Revision 1.3  2003/07/28 20:56:54  gadde
 * Slight integration of libxml2/Xerces branches
 *
 * Revision 1.2  2003/02/13 17:53:10  gadde
 * Updated documentation.
 *
 */
