/* $Id: bxh_niftilib.h,v 1.1 2007-12-10 17:50:32 gadde Exp $ */

/* bxh_niftilib.h --
 *
 * Functions and structures for writing analyze and NIfTI-1 headers
 * from BXH/XCEDE structs.
 *
 * Author: Syam Gadde (gadde@biac.duke.edu)
 */

#ifndef __BXH_NIFTILIB_H
#define __BXH_NIFTILIB_H

#include "bxh_utils.h"

#ifdef __cplusplus
extern "C" {
#endif

struct bxh2analyze_opts {
    int dontWriteBxh;
    int dontWriteMat;
    int dontWriteImg;
    int dontWriteHdr;
    int splitBxh;
    int dontSplitVols;
    int niftihdr;
    int nii;
    int niigz;
    int spmhdr;
    int analyzehdr;
    int analyzetypes;
    int preferanalyzetypes;
    int nosform;
    char * spatialunits;
    char * temporalunits;
    int zeroorigin;
    int version;
    int overwrite;
    int xcede;
    int xcede2;
    int bxh;
};

int writeBXHAndNIIGZ(const char *outbase, struct bxhdataread * bdr, void * inputdata, int xcede);
int convertBXHToAnalyze(const char *ifname, const char *ofname, struct bxhdataread * bdr, void * inputdata, struct bxh2analyze_opts * opts);

#ifdef __cplusplus
}
#endif

#endif
