/* $Id: bxh_signa.h,v 1.9 2005-07-07 15:09:21 gadde Exp $ */

/* bxh_signa.h --
 *
 * Extract SIGNA data into BXH files using these functions.
 *
 * Author: Syam Gadde (gadde@biac.duke.edu), Nov. 2002.
 */


#include <bxh_utils.h>

#ifdef __cplusplus
extern "C" {
#endif

/** \defgroup bxh_SIGNA SIGNA to BXH conversion functions
 *  \ingroup bxh_convert */
/*@{*/
int bxh_SIGNA_readPFileFromFile(BXHDocPtr docp, const char *filename, unsigned int numslices, unsigned int numtimepoints, const char * opt_dimorder, int datamsbfirst, float forceversion);
int bxh_SIGNA_readPFileFromHeaders(BXHDocPtr docp, const void * examdata, const void * seriesdata, const void * mrimagedata, unsigned int numslices, unsigned int numtimepoints, const char * opt_dimorder, int datamsbfirst, int hdrbigend, float hdrver);
int bxh_SIGNA_readIMGFromFile(BXHDocPtr docp, const char *filename, unsigned int numslices, unsigned int numtimepoints, const char * opt_dimorder);
int bxh_SIGNA_readIMGFromHeaders(BXHDocPtr docp, const void * examdata, const void * seriesdata, const void * mrimagedata, unsigned int numslices, unsigned int numtimepoints, const char * opt_dimorder, int hdrbigend);
int bxh_SIGNA_readXIMGFromFile(BXHDocPtr docp, const char *filename, unsigned int numslices, unsigned int numtimepoints, const char * opt_dimorder);
int bxh_SIGNA_readXIMGFromHeaders(BXHDocPtr docp, const void * examdata, const void * seriesdata, const void * mrimagedata, unsigned int numslices, unsigned int numtimepoints, const char * opt_dimorder, int hdrbigend);
int bxh_SIGNA_addHeaders(BXHDocPtr docp, unsigned int maxalignsize, const void * examdata, const void * seriesdata, const void * mrimagedata, unsigned int numslices, unsigned int numtimepoints, const char * opt_dimorder, int datamsbfirst, int hdrbigend, float hdrver);
/*@}*/

#ifdef __cplusplus
}
#endif
