/* $Id: bxh_types.h,v 1.18 2008-02-12 19:53:59 gadde Exp $ */

/* bxh_types.h --
 *
 * BXH type declarations.
 *
 * Author: Syam Gadde (gadde@biac.duke.edu), Nov. 2002.
 */

#ifndef __BXH_TYPES_H
#define __BXH_TYPES_H

#include <stdlib.h>
#include <stdio.h>
#include <sys/types.h>
#include <zlib.h>

/*\@{*/
/** A pointer to a BXH document */
typedef void * BXHDocPtr;
/** A pointer to a BXH element */
typedef void * BXHElementPtr;
/** A pointer to a BXH attribute */
typedef void * BXHAttributePtr;
/** A pointer to a BXH comment */
typedef void * BXHCommentPtr;
/** A pointer to a BXH node */
typedef void * BXHNodePtr;
/*\@}*/

/** \addtogroup bxh_datarec */
/*\@{*/

/** This structure encapsulates a \<datapoints\> element (with optional
 *  label.
 */
struct bxhdatapoints {
    char *	label;
    size_t	numvalues;	/**< should generally match dimension size, but may be larger depending on whether it is a split dimension and the value of outputselect */
    char **	values;
};
typedef struct bxhdatapoints bxhdatapoints;

/** This structure encapsulates the information in a BXH \c \<dimension\>
 *  element.  Members with default values can be left as 0 or NULL.
 */
struct bxhdimension {
    char *	type;	/**< "x", "y", "t", etc. */
    char *	units;	/**< "mm", "ms", etc. */
    size_t	size;	/**< how many elements along this dimension */
    int *	outputselect; /**< if supported, output only these elements from the dimension, indexed by 0 */
    size_t	numoutputselect; /**< number of elements in outputselect */
    double	origin;	/**< location of first element */
    double	gap;	/**< size of unsampled space between two datapoints */
    double	spacing;	/**< distance between consecutive datapoints */
    double *	direction;	/**< RAS coordinates of vector parallel to this dimension; if non-NULL, must be of length 3 */
    char *	measurementframeversion;	/**< just a label to help distinguish changes in measurement frame implementations */
    double *	measurementframe;	/**< 3x3 frame that transforms from coordinate system used in fields to RAS, if not already in RAS */
    int	numdpstructs;	/* number of bxhdatapoints structures in dpstructs */
    bxhdatapoints *	dpstructs;	/**< values of each element along this dimension, if not calculatable using origin and spacing */
};
typedef struct bxhdimension bxhdimension;

/** This structure describes a file fragment.  A file fragment
 *  is a contiguous section of a file that is referred to by
 *  a BXH file.
 */
struct bxhfrag {
    char *	filename;	/**< File in which to find this fragment */
    off_t	fileoffset;	/**< Offset within file at which fragment starts */
    off_t	fragsize;	/**< Size of the fragment */
};
typedef struct bxhfrag bxhfrag;
typedef bxhfrag *bxhfragp;

/** This structure describes the common fields of a BXH \c \<datarec\> element
 *  that describe the location, type, and extent of the actual data.
 */
struct bxhrawdatarec {
    int		numdims;	/**< how many dimensions */
    bxhdimension * dimensions;	/**< the dimensions */
    char *	elemtype;	/**< "uint16", "int32", "float64", etc. */
    int         msbfirstfrags;	/**< byte-order of data.  1==msbfirst, 0=lsbfirst */
    int		numfrags;	/**< number of file fragments */
    bxhfragp *	frags;		/**< the fragments */
    int		elemsize;	/**< size of each element in bytes */
    off_t	datasize;	/**< total data size */
    char *	bxhpath;	/**< path to xml file (for resolving relative frag filenames) */
    char *	compression;	/**< in non-NULL, frags are compressed using this type of compression (only valid value: "gzip" or "gzipfrag") */
    char **	comments;	/**< if non-NULL, a NULL-terminated array of strings that should be added as comments at the top of a datarec */
    void *	lastfp;		/**< used internally */
    int		lastfpisgz;	/**< used internally */
    char *	lastfilename;	/**< used internally */
    void *	readobj;	/**< used internally */
};
typedef struct bxhrawdatarec bxhrawdatarec;

/*\@}*/

#endif /* #ifndef __BXH_TYPES_H */

/*
 * $Log: In-line log eliminated on transition to SVN; use svn log instead. $
 * Revision 1.17  2007/02/01 15:39:22  gadde
 * Add compression field
 *
 * Revision 1.16  2006/05/25 18:23:49  gadde
 * Add support for reading gzipped files.
 *
 * Revision 1.15  2006/04/07 19:08:04  gadde
 * Add implicit BIAC tensors and measurementframe
 *
 * Revision 1.14  2004/03/19 15:13:32  gadde
 * Major changes in datarec support, include a new 'prepare' stage
 * that initiates filtering, permutation.
 * bxh_datarec_readData has been changed to bxh_datarec_readRawData
 * to reflect this.
 * Added some fMRI QA measures.
 *
 * Revision 1.13  2003/10/21 19:31:32  gadde
 * Change from splitignorestart to more generic outputselect.
 *
 * Revision 1.12  2003/10/14 16:47:49  gadde
 * Hack to get rid of extra slices in Siemens Mosaic (maybe it can be applied generally to other formats with split dimensions)
 *
 * Revision 1.11  2003/07/28 20:56:55  gadde
 * Slight integration of libxml2/Xerces branches
 *
 * Revision 1.10  2003/07/08 17:06:46  gadde
 * Move gdome include to bxh_types.h
 *
 * Revision 1.9  2003/06/18 16:14:15  gadde
 * win32 fixes
 *
 * Revision 1.8  2003/06/06 19:43:16  gadde
 * Add missing include files.
 *
 * Revision 1.7  2003/05/16 19:58:06  gadde
 * Require basepath for datarec.
 *
 * Revision 1.6  2003/03/24 16:44:32  gadde
 * Add support for vector datapoints
 *
 * Revision 1.5  2003/02/13 17:53:18  gadde
 * Update documentation.
 *
 * Revision 1.4  2003/02/12 19:30:14  gadde
 * Updated doxygen documentation.
 *
 */
