<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet
  xmlns="http://nbirn.net/Resources/Users/Applications/xcede/"
  xmlns:xcede="http://nbirn.net/Resources/Users/Applications/xcede/"
  xmlns:bxh="http://www.biac.duke.edu/bxh"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  exclude-result-prefixes="bxh"
  version="1.0">

  <xsl:output
    method="xml"
    indent="yes"
    omit-xml-declaration="no"
    />

  <xsl:template match="/">
    <serieslevel
      xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
      <xsl:for-each select="/bxh:bxh/bxh:subject">
        <xsl:call-template name="convertsubject"/>
      </xsl:for-each>
      <xsl:for-each select="/bxh:bxh/bxh:acquisitiondata">
        <xsl:call-template name="convertacquisitiondata"/>
      </xsl:for-each>
      <xsl:for-each select="/bxh:bxh/bxh:datarec[@type='image']">
        <xsl:call-template name="convertdatarec"/>
      </xsl:for-each>
      <xsl:for-each select="/bxh:bxh/bxh:history">
        <xsl:call-template name="converthistory"/>
      </xsl:for-each>
    </serieslevel>
  </xsl:template>

  <xsl:template name="convertNSattributes">
    <xsl:choose>
      <xsl:when test="namespace-uri()='http://www.biac.duke.edu/bxh'">
        <xsl:attribute name="{local-name()}" namespace="http://nbirn.net/Resources/Users/Applications/xcede/">
	  <xsl:apply-templates/>
        </xsl:attribute>
      </xsl:when>
      <xsl:otherwise>
        <xsl:copy>
          <xsl:apply-templates/>
        </xsl:copy>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template name="convertNSaux">
    <!-- NOTE: won't do attributes -->
    <xsl:choose>
      <!-- element -->
      <xsl:when test="self::*">
        <xsl:call-template name="convertNS"/>
      </xsl:when>
      <!-- everything else -->
      <xsl:otherwise>
        <xsl:copy/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template name="convertNS">
    <xsl:choose>
      <xsl:when test="namespace-uri()='http://www.biac.duke.edu/bxh'">
        <xsl:element name="{local-name()}" namespace="http://nbirn.net/Resources/Users/Applications/xcede/">
          <xsl:for-each select="@*">
            <xsl:call-template name="convertNSattributes"/>
          </xsl:for-each>
          <xsl:for-each select="*|text()">
            <xsl:call-template name="convertNSaux"/>
          </xsl:for-each>
        </xsl:element>
      </xsl:when>
      <xsl:otherwise>
        <xsl:copy>
          <xsl:for-each select="@*">
            <xsl:call-template name="convertNSattributes"/>
          </xsl:for-each>
          <xsl:for-each select="*|text()">
            <xsl:call-template name="convertNSaux"/>
          </xsl:for-each>
        </xsl:copy>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>


  <xsl:template name="replaceNSaux">
    <!-- NOTE: won't do attributes -->
    <xsl:choose>
      <!-- element -->
      <xsl:when test="self::*">
        <xsl:call-template name="replaceNS"/>
      </xsl:when>
      <!-- everything else -->
      <xsl:otherwise>
        <xsl:copy/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template name="replaceNS">
    <xsl:element name="{local-name()}" namespace="http://nbirn.net/Resources/Users/Applications/xcede/">
      <xsl:for-each select="@*">
        <xsl:call-template name="convertNSattributes"/>
      </xsl:for-each>
      <xsl:for-each select="*|text()">
        <xsl:call-template name="replaceNSaux"/>
      </xsl:for-each>
    </xsl:element>
  </xsl:template>

  <!--
      /serieslevel/subjectConst
      /serieslevel/subjectVar
    -->
  <xsl:template name="convertsubject">
    <subject>
      <name><xsl:value-of select="bxh:name"/></name>
      <sex>
        <xsl:choose>
          <xsl:when test="bxh:sex = 'M'">male</xsl:when>
          <xsl:when test="bxh:sex = 'F'">female</xsl:when>
          <xsl:otherwise>other</xsl:otherwise>
        </xsl:choose>
      </sex>
    </subject>
    <visit>
      <subjectVar>
        <age>
          <xsl:attribute name="agetype">postnatal</xsl:attribute>
          <xsl:attribute name="units">years</xsl:attribute>
          <xsl:value-of select="bxh:age"/>
        </age>
      </subjectVar>
    </visit>
  </xsl:template>

  <!--
      /serieslevel/scanner
      /serieslevel/expProtocol
      /serieslevel/acqProtocol
    -->
  <xsl:template name="convertacquisitiondata">
    <scanner>
      <model><xsl:value-of select="bxh:scanner"/></model>
    </scanner>
    <expProtocol>
      <xsl:if test="bxh:description">
        <name><xsl:value-of select="bxh:description"/></name>
      </xsl:if>
    </expProtocol>
    <acqProtocol>
      <name>
        <xsl:if test="bxh:psdname">
          <xsl:value-of select="bxh:psdname"/>
        </xsl:if>
        <xsl:if test="bxh:psdinternalname">
          <xsl:text> (</xsl:text>
          <xsl:value-of select="bxh:psdinternalname"/>
          <xsl:text>)</xsl:text>
        </xsl:if>
      </name>
      <xsl:for-each select="bxh:acqParam">
        <xsl:element name="acqParam">
          <xsl:for-each select="@*|node()">
            <xsl:copy-of select=".">
            </xsl:copy-of>
          </xsl:for-each>
        </xsl:element>
      </xsl:for-each>

      <xsl:if test="bxh:examnumber">
        <xsl:element name="acqParam">
          <xsl:attribute name="name">examnumber</xsl:attribute>
          <xsl:attribute name="type">integer</xsl:attribute>
          <xsl:value-of select="bxh:examnumber"/>
        </xsl:element>
      </xsl:if>

      <xsl:if test="bxh:studyid">
        <xsl:element name="acqParam">
          <xsl:attribute name="name">studyid</xsl:attribute>
          <xsl:attribute name="type">varchar</xsl:attribute>
          <xsl:value-of select="bxh:studyid"/>
        </xsl:element>
      </xsl:if>

      <xsl:if test="bxh:seriesnumber">
        <xsl:element name="acqParam">
          <xsl:attribute name="name">seriesnumber</xsl:attribute>
          <xsl:attribute name="type">integer</xsl:attribute>
          <xsl:value-of select="bxh:seriesnumber"/>
        </xsl:element>
      </xsl:if>

      <xsl:if test="bxh:runnumber">
        <xsl:element name="acqParam">
          <xsl:attribute name="name">runnumber</xsl:attribute>
          <xsl:attribute name="type">integer</xsl:attribute>
          <xsl:value-of select="bxh:runnumber"/>
        </xsl:element>
      </xsl:if>

      <xsl:if test="bxh:scanningsequence">
        <xsl:element name="acqParam">
          <xsl:attribute name="name">scanningsequence</xsl:attribute>
          <xsl:attribute name="type">varchar</xsl:attribute>
          <xsl:value-of select="bxh:scanningsequence"/>
        </xsl:element>
      </xsl:if>

      <xsl:if test="bxh:sequencevariant">
        <xsl:element name="acqParam">
          <xsl:attribute name="name">sequencevariant</xsl:attribute>
          <xsl:attribute name="type">varchar</xsl:attribute>
          <xsl:value-of select="bxh:sequencevariant"/>
        </xsl:element>
      </xsl:if>

      <xsl:if test="bxh:magneticfield">
        <xsl:element name="acqParam">
          <xsl:attribute name="name">magneticfield</xsl:attribute>
          <xsl:attribute name="type">float</xsl:attribute>
          <xsl:value-of select="bxh:magneticfield"/>
        </xsl:element>
      </xsl:if>

      <xsl:if test="bxh:description">
        <xsl:element name="acqParam">
          <xsl:attribute name="name">description</xsl:attribute>
          <xsl:attribute name="type">varchar</xsl:attribute>
          <xsl:value-of select="bxh:description"/>
        </xsl:element>
      </xsl:if>

      <xsl:if test="bxh:scandate">
        <xsl:element name="acqParam">
          <xsl:attribute name="name">scandate</xsl:attribute>
          <xsl:attribute name="type">varchar</xsl:attribute>
          <xsl:value-of select="bxh:scandate"/>
        </xsl:element>
      </xsl:if>

      <xsl:if test="bxh:scantime">
        <xsl:element name="acqParam">
          <xsl:attribute name="name">scantime</xsl:attribute>
          <xsl:attribute name="type">varchar</xsl:attribute>
          <xsl:value-of select="bxh:scantime"/>
        </xsl:element>
      </xsl:if>

      <xsl:if test="bxh:tr">
        <xsl:element name="acqParam">
          <xsl:attribute name="name">tr</xsl:attribute>
          <xsl:attribute name="type">float</xsl:attribute>
          <xsl:value-of select="bxh:tr"/>
        </xsl:element>
      </xsl:if>

      <xsl:if test="bxh:te">
        <xsl:element name="acqParam">
          <xsl:attribute name="name">te</xsl:attribute>
          <xsl:attribute name="type">float</xsl:attribute>
          <xsl:value-of select="bxh:te"/>
        </xsl:element>
      </xsl:if>

      <xsl:if test="bxh:operator">
        <xsl:element name="acqParam">
          <xsl:attribute name="name">operator</xsl:attribute>
          <xsl:attribute name="type">varchar</xsl:attribute>
          <xsl:value-of select="bxh:operator"/>
        </xsl:element>
      </xsl:if>

      <xsl:if test="bxh:flipangle">
        <xsl:element name="acqParam">
          <xsl:attribute name="name">flipangle</xsl:attribute>
          <xsl:attribute name="type">float</xsl:attribute>
          <xsl:value-of select="bxh:flipangle"/>
        </xsl:element>
      </xsl:if>

      <xsl:if test="bxh:prescribedslicespacing">
        <xsl:element name="acqParam">
          <xsl:attribute name="name">prescribedslicespacing</xsl:attribute>
          <xsl:attribute name="type">float</xsl:attribute>
          <xsl:value-of select="bxh:prescribedslicespacing"/>
        </xsl:element>
      </xsl:if>

      <xsl:if test="bxh:frequencydirection">
        <xsl:element name="acqParam">
          <xsl:attribute name="name">frequencydirection</xsl:attribute>
          <xsl:attribute name="type">integer</xsl:attribute>
          <xsl:value-of select="bxh:frequencydirection"/>
        </xsl:element>
      </xsl:if>

      <xsl:if test="bxh:acquisitionmatrix">
        <xsl:element name="acqParam">
          <xsl:attribute name="name">acquisitionmatrix</xsl:attribute>
          <xsl:attribute name="type">varchar</xsl:attribute>
          <xsl:value-of select="bxh:acquisitionmatrix"/>
        </xsl:element>
      </xsl:if>

      <xsl:if test="bxh:bandwidth">
        <xsl:element name="acqParam">
          <xsl:attribute name="name">bandwidth</xsl:attribute>
          <xsl:attribute name="type">float</xsl:attribute>
          <xsl:value-of select="bxh:bandwidth"/>
        </xsl:element>
      </xsl:if>

      <xsl:if test="bxh:receivecoilname">
        <xsl:element name="acqParam">
          <xsl:attribute name="name">receivecoilname</xsl:attribute>
          <xsl:attribute name="type">varchar</xsl:attribute>
          <xsl:value-of select="bxh:receivecoilname"/>
        </xsl:element>
      </xsl:if>

      <xsl:if test="bxh:transmitcoilname">
        <xsl:element name="acqParam">
          <xsl:attribute name="name">transmitcoilname</xsl:attribute>
          <xsl:attribute name="type">varchar</xsl:attribute>
          <xsl:value-of select="bxh:transmitcoilname"/>
        </xsl:element>
      </xsl:if>

      <xsl:if test="bxh:institution">
        <xsl:element name="acqParam">
          <xsl:attribute name="name">institution</xsl:attribute>
          <xsl:attribute name="type">varchar</xsl:attribute>
          <xsl:value-of select="bxh:institution"/>
        </xsl:element>
      </xsl:if>

      <xsl:if test="bxh:examdescription">
        <xsl:element name="acqParam">
          <xsl:attribute name="name">examdescription</xsl:attribute>
          <xsl:attribute name="type">varchar</xsl:attribute>
          <xsl:value-of select="bxh:examdescription"/>
        </xsl:element>
      </xsl:if>

      <xsl:if test="bxh:scanner">
        <xsl:element name="acqParam">
          <xsl:attribute name="name">scanner</xsl:attribute>
          <xsl:attribute name="type">varchar</xsl:attribute>
          <xsl:value-of select="bxh:scanner"/>
        </xsl:element>
      </xsl:if>

      <xsl:if test="bxh:scannermanufacturer">
        <xsl:element name="acqParam">
          <xsl:attribute name="name">scannermanufacturer</xsl:attribute>
          <xsl:attribute name="type">varchar</xsl:attribute>
          <xsl:value-of select="bxh:scannermanufacturer"/>
        </xsl:element>
      </xsl:if>

      <xsl:if test="bxh:scannermodelname">
        <xsl:element name="acqParam">
          <xsl:attribute name="name">scannermodelname</xsl:attribute>
          <xsl:attribute name="type">varchar</xsl:attribute>
          <xsl:value-of select="bxh:scannermodelname"/>
        </xsl:element>
      </xsl:if>

      <xsl:if test="bxh:fieldofview">
        <xsl:element name="acqParam">
          <xsl:attribute name="name">fieldofview</xsl:attribute>
          <xsl:attribute name="type">varchar</xsl:attribute>
          <xsl:value-of select="bxh:fieldofview"/>
        </xsl:element>
      </xsl:if>

      <xsl:if test="bxh:ti">
        <xsl:element name="acqParam">
          <xsl:attribute name="name">ti</xsl:attribute>
          <xsl:attribute name="type">varchar</xsl:attribute>
          <xsl:value-of select="bxh:ti"/>
        </xsl:element>
      </xsl:if>

      <xsl:if test="bxh:psdname">
        <xsl:element name="acqParam">
          <xsl:attribute name="name">psdname</xsl:attribute>
          <xsl:attribute name="type">varchar</xsl:attribute>
          <xsl:value-of select="bxh:psdname"/>
        </xsl:element>
      </xsl:if>

      <xsl:if test="bxh:psdinternalname">
        <xsl:element name="acqParam">
          <xsl:attribute name="name">psdinternalname</xsl:attribute>
          <xsl:attribute name="type">varchar</xsl:attribute>
          <xsl:value-of select="bxh:psdinternalname"/>
        </xsl:element>
      </xsl:if>

      <xsl:if test="bxh:psddate">
        <xsl:element name="acqParam">
          <xsl:attribute name="name">psddate</xsl:attribute>
          <xsl:attribute name="type">varchar</xsl:attribute>
          <xsl:value-of select="bxh:psddate"/>
        </xsl:element>
      </xsl:if>

      <xsl:if test="bxh:psdtime">
        <xsl:element name="acqParam">
          <xsl:attribute name="name">psdtime</xsl:attribute>
          <xsl:attribute name="type">varchar</xsl:attribute>
          <xsl:value-of select="bxh:psdtime"/>
        </xsl:element>
      </xsl:if>

      <xsl:if test="bxh:protocolname">
        <xsl:element name="acqParam">
          <xsl:attribute name="name">protocolname</xsl:attribute>
          <xsl:attribute name="type">varchar</xsl:attribute>
          <xsl:value-of select="bxh:protocolname"/>
        </xsl:element>
      </xsl:if>

      <xsl:for-each select="bxh:*">
        <xsl:if test="local-name() != 'acqParam' and local-name() != 'examnumber' and local-name() != 'studyid' and local-name() != 'seriesnumber' and local-name() != 'runnumber' and local-name() != 'scanningsequence' and local-name() != 'sequencevariant' and local-name() != 'magneticfield' and local-name() != 'description' and local-name() != 'scandate' and local-name() != 'scantime' and local-name() != 'tr' and local-name() != 'te' and local-name() != 'operator' and local-name() != 'flipangle' and local-name() != 'prescribedslicespacing' and local-name() != 'frequencydirection' and local-name() != 'acquisitionmatrix' and local-name() != 'bandwidth' and local-name() != 'receivecoilname' and local-name() != 'transmitcoilname' and local-name() != 'institution' and local-name() != 'examdescription' and local-name() != 'scanner' and local-name() != 'scannermanufacturer' and local-name() != 'scannermodelname' and local-name() != 'fieldofview' and local-name() != 'ti' and local-name() != 'psdname' and local-name() != 'psdinternalname' and local-name() != 'psddate' and local-name() != 'psdtime' and local-name() != 'protocolname'">
          <xsl:element name="acqParam">
            <xsl:attribute name="name"><xsl:value-of select="local-name()" /></xsl:attribute>
            <xsl:attribute name="type">varchar</xsl:attribute>
            <xsl:value-of select="string(.)"/>
          </xsl:element>
        </xsl:if>
      </xsl:for-each>

    </acqProtocol>
  </xsl:template>

  <xsl:template name="copywithsiblingsuptomember">
    <xsl:param name="memberset" />
    <xsl:variable name="previoussiblings" select="preceding-sibling::node()" />
    <xsl:variable name="curpos" select="count($previoussiblings)" />
    <xsl:variable name="previousmember" select="$previoussiblings[.=$memberset][last()]" />
    <xsl:variable name="previouspos">
      <xsl:choose>
        <xsl:when test="$previousmember">
          <xsl:value-of select="count($previousmember/preceding-sibling::node())" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="-1" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:for-each select="$previoussiblings">
      <xsl:variable name="sibpos" select="count(preceding-sibling::node())" />
      <xsl:if test="$sibpos > $previouspos">
	<xsl:call-template name="convertNS" />
      </xsl:if>
    </xsl:for-each>
    <xsl:call-template name="convertNS" />
  </xsl:template>

  <!--
      /serieslevel/datarec
    -->
  <xsl:template name="convertdatarec">
    <xsl:variable name="childlist" select="*[1]|*[1]/following-sibling::node()"/>
    <xsl:variable name="olddimensions" select="bxh:dimension"/>
    <xsl:variable name="oldrasorigin" select="bxh:rasorigin"/>
    <xsl:variable name="specialnodes" select="$oldrasorigin"/>
    <xsl:variable name="numspecialnodes" select="count($specialnodes)"/>
    <xsl:variable name="newrasorigin">
      <!-- get any text/comment nodes preceding the first child element -->
      <xsl:for-each select="*[1]/preceding-sibling::node()">
	<xsl:copy/>
      </xsl:for-each>
      <xsl:choose>
	<xsl:when test="$oldrasorigin">
          <xsl:element name="rasorigin">
            <xsl:value-of select="$oldrasorigin"/>
          </xsl:element>
        </xsl:when>
        <xsl:otherwise>
          <!-- The following code converts/permutes the RAS origin, which
               is distributed among the X,Y,Z axes (in BXH files without
               the rasorigin field) to a single RAS origin field outside
               the dimension elements in the XCEDE XML file.
               The code below is a testament to how complicated the
               original design was to work with
               (putting each coordinate of the RAS origin in the X, Y, or Z
               dimension with which its axis was most aligned).
               The new way should be much simpler.
            -->
          <xsl:choose>
            <xsl:when test="bxh:dimension/bxh:origin and bxh:dimension/bxh:direction">
              <xsl:variable name="dirx" select="normalize-space(string(bxh:dimension[@type='x']/bxh:direction))"/>
              <xsl:variable name="diry" select="normalize-space(string(bxh:dimension[@type='y']/bxh:direction))"/>
              <xsl:variable name="dirz" select="normalize-space(string(bxh:dimension[@type='z' or @type='z-split2']/bxh:direction))"/>
              <xsl:variable name="origx" select="normalize-space(string(bxh:dimension[@type='x']/bxh:origin))"/>
              <xsl:variable name="origy" select="normalize-space(string(bxh:dimension[@type='y']/bxh:origin))"/>
              <xsl:variable name="origz" select="normalize-space(string(bxh:dimension[@type='z' or @type='z-split2']/bxh:origin))"/>
              <xsl:variable name="xR" select="number(substring-before($dirx, ' '))"/>
              <xsl:variable name="yR" select="number(substring-before($diry, ' '))"/>
              <xsl:variable name="zR" select="number(substring-before($dirz, ' '))"/>
              <xsl:variable name="xA" select="number(substring-before(substring-after($dirx,' '), ' '))"/>
              <xsl:variable name="yA" select="number(substring-before(substring-after($diry,' '), ' '))"/>
              <xsl:variable name="zA" select="number(substring-before(substring-after($dirz,' '), ' '))"/>
              <xsl:variable name="xS" select="number(substring-after(normalize-space(substring-after($dirx,' ')),' '))"/>
              <xsl:variable name="yS" select="number(substring-after(normalize-space(substring-after($diry,' ')),' '))"/>
              <xsl:variable name="zS" select="number(substring-after(normalize-space(substring-after($dirz,' ')),' '))"/>
              <xsl:variable name="absxR" select="substring('-1', 2-($xR&lt;0))*$xR"/>
              <xsl:variable name="absyR" select="substring('-1', 2-($yR&lt;0))*$yR"/>
              <xsl:variable name="abszR" select="substring('-1', 2-($zR&lt;0))*$zR"/>
              <xsl:variable name="absxA" select="substring('-1', 2-($xA&lt;0))*$xA"/>
              <xsl:variable name="absyA" select="substring('-1', 2-($yA&lt;0))*$yA"/>
              <xsl:variable name="abszA" select="substring('-1', 2-($zA&lt;0))*$zA"/>
              <xsl:variable name="absxS" select="substring('-1', 2-($xS&lt;0))*$xS"/>
              <xsl:variable name="absyS" select="substring('-1', 2-($yS&lt;0))*$yS"/>
              <xsl:variable name="abszS" select="substring('-1', 2-($zS&lt;0))*$zS"/>
              <rasorigin>
                <xsl:choose>
                  <xsl:when test="$absxR > $absyR and $absxR > $abszR">
                    <xsl:value-of select="$origx"/>
                  </xsl:when>
                  <xsl:when test="$absyR > $absxR and $absyR > $abszR">
                    <xsl:value-of select="$origy"/>
                  </xsl:when>
                  <xsl:when test="$abszR > $absxR and $abszR > $absyR">
                    <xsl:value-of select="$origz"/>
                  </xsl:when>
                </xsl:choose>
                <xsl:text> </xsl:text>
                <xsl:choose>
                  <xsl:when test="$absxA > $absyA and $absxA > $abszA">
                    <xsl:value-of select="$origx"/>
                  </xsl:when>
                  <xsl:when test="$absyA > $absxA and $absyA > $abszA">
                    <xsl:value-of select="$origy"/>
                  </xsl:when>
                  <xsl:when test="$abszA > $absxA and $abszA > $absyA">
                    <xsl:value-of select="$origz"/>
                  </xsl:when>
                </xsl:choose>
                <xsl:text> </xsl:text>
                <xsl:choose>
                  <xsl:when test="$absxS > $absyS and $absxS > $abszS">
                    <xsl:value-of select="$origx"/>
                  </xsl:when>
                  <xsl:when test="$absyS > $absxS and $absyS > $abszS">
                    <xsl:value-of select="$origy"/>
                  </xsl:when>
                  <xsl:when test="$abszS > $absxS and $abszS > $absyS">
                    <xsl:value-of select="$origz"/>
                  </xsl:when>
                </xsl:choose>
                <xsl:text> </xsl:text>
              </rasorigin>
            </xsl:when>
            <xsl:otherwise>
              <rasorigin>0 0 0</rasorigin>
            </xsl:otherwise>
	  </xsl:choose>
	</xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <datarec>
      <xsl:for-each select="@*">
        <xsl:call-template name="convertNSattributes"/>
      </xsl:for-each>
      <xsl:copy-of select="$newrasorigin"/>
      <xsl:for-each select="$childlist[count(.|$specialnodes) != $numspecialnodes]">
        <xsl:choose>
          <xsl:when test=".=$olddimensions">
	    <dimension>
	      <xsl:variable name="orderedelems" select="bxh:size|bxh:origin|bxh:spacing|bxh:gap|bxh:datapoints|bxh:direction|bxh:units" />
	      <xsl:for-each select="@*">
		<xsl:call-template name="convertNSattributes"/>
	      </xsl:for-each>
	      <xsl:for-each select="bxh:size">
		<xsl:call-template name="copywithsiblingsuptomember">
		  <xsl:with-param name="memberset" select="$orderedelems"/>
		</xsl:call-template>
	      </xsl:for-each>
	      <xsl:for-each select="bxh:origin">
		<xsl:call-template name="copywithsiblingsuptomember">
		  <xsl:with-param name="memberset" select="$orderedelems"/>
		</xsl:call-template>
	      </xsl:for-each>
	      <xsl:for-each select="bxh:spacing">
		<xsl:call-template name="copywithsiblingsuptomember">
		  <xsl:with-param name="memberset" select="$orderedelems"/>
		</xsl:call-template>
	      </xsl:for-each>
	      <xsl:for-each select="bxh:gap">
		<xsl:call-template name="copywithsiblingsuptomember">
		  <xsl:with-param name="memberset" select="$orderedelems"/>
		</xsl:call-template>
	      </xsl:for-each>
	      <xsl:for-each select="bxh:datapoints">
		<xsl:call-template name="copywithsiblingsuptomember">
		  <xsl:with-param name="memberset" select="$orderedelems"/>
		</xsl:call-template>
	      </xsl:for-each>
	      <xsl:for-each select="bxh:direction">
		<xsl:call-template name="copywithsiblingsuptomember">
		  <xsl:with-param name="memberset" select="$orderedelems"/>
		</xsl:call-template>
	      </xsl:for-each>
	      <xsl:for-each select="bxh:units">
		<xsl:call-template name="copywithsiblingsuptomember">
		  <xsl:with-param name="memberset" select="$orderedelems"/>
		</xsl:call-template>
	      </xsl:for-each>
              <xsl:for-each select="$orderedelems[last()]/following-sibling::node()">
		<!-- any node after the last ordered elem -->
                <xsl:call-template name="convertNS" />
	      </xsl:for-each>
	    </dimension>
          </xsl:when>
          <xsl:when test="self::*">
	    <xsl:call-template name="convertNS"/>
	  </xsl:when>
	  <xsl:otherwise>
	    <!-- text nodes, comments, etc. -->
	    <xsl:copy>
	      <xsl:apply-templates/>
	    </xsl:copy>
	  </xsl:otherwise>
        </xsl:choose>
      </xsl:for-each>
    </datarec>
  </xsl:template>

  <xsl:template name="converthistory">
    <provenance>
      <xsl:for-each select="bxh:entry">
        <xsl:choose>
          <xsl:when test="bxh:description/bxh:processStep">
            <xsl:for-each select="bxh:description/bxh:processStep">
              <processStep>
                <programName><xsl:value-of select="bxh:programName"/></programName>
                <programArgument><xsl:value-of select="bxh:programArgument"/></programArgument>
                <version><xsl:value-of select="bxh:version"/></version>
                <timeStamp><xsl:value-of select="bxh:timeStamp"/></timeStamp>
                <cvs><xsl:value-of select="bxh:cvs"/></cvs>
                <user><xsl:value-of select="bxh:user"/></user>
                <machine><xsl:value-of select="bxh:machine"/></machine>
                <platform><xsl:value-of select="bxh:platform"/></platform>
                <platformVersion><xsl:value-of select="bxh:platormVersion"/></platformVersion>
              </processStep>
            </xsl:for-each>
          </xsl:when>
          <xsl:otherwise>
            <processStep>
              <xsl:variable name="description" select="string(bxh:description)"/>
              <xsl:variable name="machine" select="substring-after(substring-before($description, ' by '), 'Generated on ')"/>
              <xsl:variable name="programName" select="substring-after(substring-before($description, ' from'), 'by ')"/>
              <xsl:variable name="version" select="substring-after($description, '-VERSIONSTR-')"/>
              <xsl:variable name="timeStamp" select="string(bxh:date)"/>
              <xsl:variable name="cvs" select="$version"/>
              <xsl:variable name="inputFile" select="substring-before(substring-after($description, ' from '), '.')"/>
              <programName><xsl:value-of select="$programName"/></programName>
              <programArgument><xsl:value-of select="$inputFile"/></programArgument>
              <version><xsl:value-of select="$version"/></version>
              <timeStamp><xsl:value-of select="$timeStamp"/></timeStamp>
              <cvs><xsl:value-of select="$cvs"/></cvs>
              <user></user>
              <machine><xsl:value-of select="$machine"/></machine>
              <platform></platform>
              <platformVersion></platformVersion>
            </processStep>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:for-each>
    </provenance>
  </xsl:template>

  <xsl:template match="@*|node()">
    <xsl:copy>
      <xsl:apply-templates select="@*|node()"/>
    </xsl:copy>
  </xsl:template>

</xsl:stylesheet>

<!--
  $Log: In-line log eliminated on transition to SVN; use svn log instead. $
  Revision 1.12  2008/01/22 17:59:50  gadde
  Add protocolname.

  Revision 1.11  2007/08/02 17:51:45  gadde
  Add several missing fields to the acqparam translation.

  Revision 1.10  2007/02/27 18:04:30  gadde
  Add more acquisition data parameters.

  Revision 1.9  2007/02/21 21:49:15  gadde
  Make sure all acquisitiondata and acqParam elements are translated BXH->XCEDE and vice-versa

  Revision 1.8  2007/02/01 15:39:21  gadde
  Add compression field

  Revision 1.7  2006/04/03 17:29:09  gadde
  Fix filerecordsize translation.

  Revision 1.6  2006/02/09 21:40:22  gadde
  Use bxh rasorigin field if it exists.

  Revision 1.5  2006/01/03 17:14:54  gadde
  Add CVS Log.

  -->
