#!/usr/bin/perl -w

use strict;

if (scalar(@ARGV) != 3) {
  print STDERR "Usage: $0 XSL-file C-string-name outputfile\n";
  exit -1;
}

undef $/;

my $outputfile = pop @ARGV;
my $varname = pop @ARGV;
my $doc = <>;

my $size = length($doc) + 1;

my $fragsize = 512;
my @frags = ();
while (length($doc) > 0) {
  push @frags, substr($doc, 0, $fragsize);
  substr($doc, 0, $fragsize) = "";
}

for my $frag (@frags) {
$frag =~ s/\\/\\\\/g;
$frag =~ s/"/\\"/g;
$frag =~ s/'/\\'/g;
$frag =~ s/\n/\\n/g;
}

if ($outputfile eq '-') {
  open(FH, ">&STDOUT") || die "Can't dup STDOUT: $!\n";
} else {
  open(FH, '>', $outputfile) || die "Error opening file $outputfile for writing: $!\n";
}
print FH "char $varname\[$size] = \"", join("\"\n \"", @frags), "\";\n";
close FH;
