static const char rcsid[] = "$Id: bxh_absorb_iowasignafive.c,v 1.1 2009-01-15 20:56:16 gadde Exp $";

/*
 * signafive2bxh.cc --
 * 
 * Creates a BXH file based on given Signa 5 files.
 */

#include "bxh_convert.h"
#include "bxh_signamaps.h"
#include "bxh_utils.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#ifndef WIN32
#include <dirent.h>
#endif

#include "opts.h"

static int
addopts_iowasignafive2bxh_common(opt_data * optsin[], int numoptsin)
{
    const int numopts = 1;
    opt_data opts[1] = {
	{ 0x0, OPT_VAL_NONE, NULL, 0, "",
	  " imagedir is a directory containing I.* images" }
    };
    *optsin = (opt_data *)realloc(*optsin, sizeof(opt_data)*(numoptsin+numopts));
    memcpy(&(*optsin)[numoptsin], &opts[0], sizeof(opt_data)*numopts);
    return numopts;
}

int
addopts_bxhabsorb_iowasignafive2bxh(opt_data * optsin[], int numoptsin)
{
    const int numopts = 5;
    opt_data opts[5] = {
	{ 0x0, OPT_VAL_NONE, NULL, 0, "", "" },
	{ 0x0, OPT_VAL_NONE, NULL, 0, "",
	  "IOWA SIGNA 5.X USAGE " },
	{ 0x0, OPT_VAL_NONE, NULL, 0, "",
	  "  bxhabsorb --fromtype iowa-signa5 imagedir output.bxh" },
	{ 0x0, OPT_VAL_NONE, NULL, 0, "",
	  "  bxhabsorb --fromtype iowa-signafive imagedir output.bxh" },
	{ 0x0, OPT_VAL_NONE, NULL, 0, "",
	  "  NOTE: the bxhabsorb option --inputsfromfile is not available "
	  "for the iowa-signa5 format" }
    };
    *optsin = (opt_data *)realloc(*optsin, sizeof(opt_data)*(numoptsin+numopts));
    memcpy(&(*optsin)[numoptsin], &opts[0], sizeof(opt_data)*numopts);
    return numopts + addopts_iowasignafive2bxh_common(optsin, numoptsin + numopts);
}

int
addopts_iowasignafive2bxh(opt_data * optsin[], int numoptsin)
{
    const int numopts = 2;
    opt_data opts[2] = {
	{ 0x0, OPT_VAL_NONE, NULL, 0, "",
	  "Usage:\n"
	  "  iowa-signafive2bxh imagedir output.bxh\n\n"
	  "This program creates an XML wrapper for "
	  "Univ. of Iowa-style GE Signa5 images." },
	{ 0x0, OPT_VAL_NONE, NULL, 0, "", "" }
    };
    *optsin = (opt_data *)realloc(*optsin, sizeof(opt_data)*(numoptsin+numopts));
    memcpy(&(*optsin)[numoptsin], &opts[0], sizeof(opt_data)*numopts);
    return numopts + addopts_iowasignafive2bxh_common(optsin, numoptsin + numopts);
}

int
main_iowasignafive2bxh(int argc, char *argv[])
{
    int result = 0;
    BXHDocPtr docp = NULL;

    if (argc != 3) {
	fprintf(stderr, "Usage: %s imagedir outfile\n", argv[0]);
	return -1;
    }

    if ((docp = createDocFromIowaSigna5(argv[1], argv[2])) == NULL)
	goto FAIL;

    if (bxh_addAutoHistoryEntry(docp, argv[0], &((const char **)argv)[1], argc - 2) != 0)
	goto FAIL;
    
    if (bxh_writeFile(docp, argv[2]) != 0)
	goto FAIL;

  FAIL:
    result = -1;

  EXIT:
    if (docp) {
	bxh_freeDocument(docp);
	docp = NULL;
    }
}


/*
 * $Log: In-line log eliminated on transition to SVN; use svn log instead. $
 * Revision 1.12  2005/11/10 21:11:08  gadde
 * Use file name rather than user39 to sort files.
 *
 * Revision 1.11  2005/09/19 16:31:58  gadde
 * Documentation and help message updates.
 *
 * Revision 1.10  2005/07/07 15:09:22  gadde
 * Updates for ver11 pfiles.
 *
 * Revision 1.9  2005/03/28 17:45:22  gadde
 * Version bump
 *
 * Revision 1.8  2004/03/19 15:13:32  gadde
 * Major changes in datarec support, include a new 'prepare' stage
 * that initiates filtering, permutation.
 * bxh_datarec_readData has been changed to bxh_datarec_readRawData
 * to reflect this.
 * Added some fMRI QA measures.
 *
 * Revision 1.7  2004/03/12 16:29:04  gadde
 * Minor updates
 *
 * Revision 1.6  2004/02/26 22:32:28  gadde
 * Windows fix?
 *
 * Revision 1.5  2004/02/26 22:25:40  gadde
 * Windows fix.
 *
 * Revision 1.4  2004/02/20 18:42:48  gadde
 * Add version option and rearrange documentation
 *
 * Revision 1.3  2004/01/08 21:50:14  gadde
 * Fix comment.
 *
 * Revision 1.2  2004/01/08 17:47:18  gadde
 * Update docs
 *
 * Revision 1.1  2004/01/08 16:33:27  gadde
 * Add iowa GE support and other minor fixes
 *
 */
