static const char rcsid[] = "$Id: bxh_absorb_minc.c,v 1.1 2009-01-15 20:56:16 gadde Exp $";

/*
 * minc2bxh.cc --
 * 
 * Creates a BXH file based on given MINC file.
 * Requires MINC and netCDF libraries.
 */

#include "bxh_convert.h"
#include "bxh_datarec.h"
#include "bxh_utils.h"
#include "opts.h"

#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <time.h>
#include <math.h>

extern size_t opt_hintsize[4];
extern double opt_hintorigin[4];
extern double opt_hintspacing[4];
extern double opt_hintgap[4];
extern char * opt_forceorient;

extern int ncopts;

int
addopts_minc2bxh_common(opt_data * optsin[], int numoptsin)
{
    /* no extra options */
    return 0;
}

int
addopts_bxhabsorb_minc2bxh(opt_data * optsin[], int numoptsin)
{
    const int numopts = 3;
    opt_data opts[3] = {
	{ 0x0, OPT_VAL_NONE, NULL, 0, "", "" },
	{ 0x0, OPT_VAL_NONE, NULL, 0, "",
	  "MINC USAGE " },
	{ 0x0, OPT_VAL_NONE, NULL, 0, "",
	  "  bxhabsorb --fromtype minc [opts] [mincfiles...] output.bxh" }
    };
    *optsin = (opt_data *)realloc(*optsin, sizeof(opt_data)*(numoptsin+numopts));
    memcpy(&(*optsin)[numoptsin], &opts[0], sizeof(opt_data)*numopts);
    return numopts + addopts_minc2bxh_common(optsin, numoptsin + numopts);
}

int
addopts_minc2bxh(opt_data * optsin[], int numoptsin)
{
    const int numopts = 2;
    opt_data opts[2] = {
	{ 0x0, OPT_VAL_NONE, NULL, 0, "",
	  "Usage:\n"
	  "  minc2bxh [opts] [mincfiles...] output.bxh\n\n"
	  "This program creates an XML wrapper for MINC images." },
	{ 0x0, OPT_VAL_NONE, NULL, 0, "", "" }
    };
    *optsin = (opt_data *)realloc(*optsin, sizeof(opt_data)*(numoptsin+numopts));
    memcpy(&(*optsin)[numoptsin], &opts[0], sizeof(opt_data)*numopts);
    return numopts + addopts_minc2bxh_common(optsin, numoptsin + numopts);
}

int
main_minc2bxh(int argc, char *argv[])
{
    int result = 0;
    BXHDocPtr docp = NULL;

    if (argc != 3) {
	fprintf(stderr, "Usage: %s infile outfile\n", argv[0]);
	return -1;
    }

    if ((docp = createDocFromMINC((const char *)argv[1], (const char *)argv[2], opt_hintsize, opt_hintorigin, opt_hintspacing, opt_hintgap, opt_forceorient)) == NULL)
	goto FAIL;

    if (bxh_addAutoHistoryEntry(docp, argv[0], &((const char **)argv)[1], argc - 2) != 0)
	goto FAIL;
    
    if (bxh_writeFile(docp, argv[2]) != 0)
	goto FAIL;

  FAIL:
    result = -1;

  EXIT:
    if (docp) {
	bxh_freeDocument(docp);
	docp = NULL;
    }
}


/*
 * $Log: In-line log eliminated on transition to SVN; use svn log instead. $
 * Revision 1.14  2006/04/07 14:47:38  gadde
 * Fix memory bug.
 *
 * Revision 1.13  2006/03/23 17:39:15  gadde
 * Solaris fixes.
 *
 * Revision 1.12  2005/09/19 16:31:58  gadde
 * Documentation and help message updates.
 *
 * Revision 1.11  2005/09/14 15:19:17  gadde
 * Some -Wall fixes.
 *
 * Revision 1.10  2005/03/08 18:09:58  gadde
 * Add support for dimension size/spacing/gap/orientation hints
 *
 * Revision 1.9  2004/06/15 19:34:16  gadde
 * Make sure spacing is not negative.
 *
 * Revision 1.8  2004/06/15 16:16:11  gadde
 * Several -Wall fixes and addition of bxh_datarec_addfrag()
 *
 * Revision 1.7  2004/02/24 18:01:07  gadde
 * Move history generation to bxh_utils.cpp, and add option to create BIRN files
 *
 * Revision 1.6  2004/02/20 18:42:48  gadde
 * Add version option and rearrange documentation
 *
 * Revision 1.5  2003/08/19 19:35:41  gadde
 * New options scheme, so that options are available using whichever form of bxhabsorb you use.
 *
 * Revision 1.4  2003/07/21 16:46:49  gadde
 * Code-prettiness updates, for the most part, to further protect BXH
 * library users from particulars of DOM implementation (esp. C vs. C++).
 *
 * Revision 1.3  2003/06/18 16:08:37  gadde
 * fopen in binary mode
 *
 * Revision 1.2  2003/05/10 18:22:12  gadde
 * Add Log.
 *
 */
