static const char rcsid[] = "$Id: bxh_absorb_pfile.c,v 1.1 2009-01-15 20:56:16 gadde Exp $";

/*
 * pfile2bxh.cc --
 * 
 * Creates a BXH file based on given Signa p-file.
 */

#include "bxh_convert.h"
#include "bxh_signa.h"
#include "bxh_signamaps.h"
#include "bxh_utils.h"
#include "opts.h"

#include <ctype.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <time.h>

extern size_t opt_hintsize[4];
extern double opt_hintorigin[4];
extern double opt_hintspacing[4];
extern double opt_hintgap[4];
extern char * opt_forceorient;

static struct signamaps * signamap3list[3] = { &signamaps3align0, &signamaps3align2, NULL };
static struct signamaps * signamap11list[3] = { &signamaps11align0, &signamaps11align2, NULL };

static float opt_forceversion = -1;
static int opt_msbfirst = 0;
static const char * opt_dimorder = NULL;
static int opt_usemrorigin = 0;
static int opt_useslicetableorigin = 0;
static char * opt_elemtype = "int16";

static int
addopts_pfile2bxh_common(opt_data * optsin[], int numoptsin)
{
    const int numopts = 6;
    opt_data opts[6] = {
	{ OPT_FLAGS_FULL, OPT_VAL_FLOAT, &opt_forceversion, 1, "forceversion",
	  "Force version of P-file to be interpreted as this number." },
	{ OPT_FLAGS_FULL, OPT_VAL_BOOL, &opt_msbfirst, 1, "msbfirst",
	  "Indicates that data is big-endian (default: little-endian)." },
	{ OPT_FLAGS_FULL, OPT_VAL_STR, &opt_dimorder, 1, "dimorder",
	  "Comma-separated names of dimensions from fastest-moving to "
	  "slowest-moving (default: x,y,z,t)." },
	{ OPT_FLAGS_FULL, OPT_VAL_STR, &opt_elemtype, 1, "elemtype",
	  "Provide element type of image data (one of int8, uint8, "
	  "int16 [default], uint16, int32, uint32, float32, or float64)." },
	{ OPT_FLAGS_FULL, OPT_VAL_BOOL, &opt_usemrorigin, 1, "usemrorigin",
	  "This option extracts the origin from the tlhc_[RAS] fields in the "
	  "MR structure.  This is the default." },
	{ OPT_FLAGS_FULL, OPT_VAL_BOOL, &opt_useslicetableorigin, 1, "useslicetableorigin",
	  "The origin coordinates are extracted from the slice table "
	  "at the end of the P-file header." }
    };
    *optsin = (opt_data *)realloc(*optsin, sizeof(opt_data)*(numoptsin+numopts));
    memcpy(&(*optsin)[numoptsin], &opts[0], sizeof(opt_data)*numopts);
    return numopts;
}

int
addopts_bxhabsorb_pfile2bxh(opt_data * optsin[], int numoptsin)
{
    const int numopts = 4;
    opt_data opts[4] = {
	{ 0x0, OPT_VAL_NONE, NULL, 0, "", "" },
	{ 0x0, OPT_VAL_NONE, NULL, 0, "",
	  "PFILE USAGE " },
	{ 0x0, OPT_VAL_NONE, NULL, 0, "",
	  "  bxhabsorb --fromtype pfile [opts] [pfilehdr imagedata1...] output.bxh" },
	{ 0x0, OPT_VAL_NONE, NULL, 0, "",
	  "PFILE OPTIONS " }
    };
    *optsin = (opt_data *)realloc(*optsin, sizeof(opt_data)*(numoptsin+numopts));
    memcpy(&(*optsin)[numoptsin], &opts[0], sizeof(opt_data)*numopts);
    return numopts + addopts_pfile2bxh_common(optsin, numoptsin + numopts);
}

int
addopts_pfile2bxh(opt_data * optsin[], int numoptsin)
{
    const int numopts = 2;
    opt_data opts[2] = {
	{ 0x0, OPT_VAL_NONE, NULL, 0, "",
	  "Usage:\n"
	  "  pfile2bxh [opts] [pfilehdr imagedata1...] output.bxh\n\n"
	  "This program creates an XML wrapper for "
	  "GE P-files (and associated reconstructed image data)." },
	{ 0x0, OPT_VAL_NONE, NULL, 0, "", "" }
    };
    *optsin = (opt_data *)realloc(*optsin, sizeof(opt_data)*(numoptsin+numopts));
    memcpy(&(*optsin)[numoptsin], &opts[0], sizeof(opt_data)*numopts);
    return numopts + addopts_pfile2bxh_common(optsin, numoptsin + numopts);
}

int
main_pfile2bxh(int argc, char *argv[])
{ 
    int result = 0;
    BXHDocPtr docp = NULL;

    if (argc < 3) {
	fprintf(stderr, "Not enough arguments! use\n %s --help\n", argv[0]);
	return -1;
    }
    
    if (strcmp(opt_elemtype, "int8") != 0 &&
	strcmp(opt_elemtype, "uint8") != 0 &&
	strcmp(opt_elemtype, "int16") != 0 &&
	strcmp(opt_elemtype, "uint16") != 0 &&
	strcmp(opt_elemtype, "int32") != 0 &&
	strcmp(opt_elemtype, "uint32") != 0 &&
	strcmp(opt_elemtype, "float32") != 0 &&
	strcmp(opt_elemtype, "float64") != 0) {
	fprintf(stderr, "Unrecognized elemtype '%s': must be one of int8, uint8, int16, uint16, int32, uint32, float32, or float64\n", opt_elemtype);
	return -1;
    }

    if (opt_useslicetableorigin && opt_usemrorigin) {
	fprintf(stderr, "Both --usemrorigin and --useslicetableorigin can not be specified!\n");
	return -1;
    }
    opt_usemrorigin = 1;
    if (opt_useslicetableorigin) {
	opt_usemrorigin = 0;
    }

    if ((docp = createDocFromPFile(argv[1], &((const char **)argv)[2], argc - 3, argv[argc-1], &opt_hintsize[0], &opt_hintorigin[0], &opt_hintspacing[0], &opt_hintgap[0], opt_forceorient, opt_forceversion, opt_msbfirst, opt_dimorder, opt_elemtype, opt_usemrorigin)) == NULL)
	goto FAIL;

    if (bxh_addAutoHistoryEntry(docp, argv[0], &((const char **)argv)[1], argc - 2) != 0)
	goto FAIL;
    
    if (bxh_writeFile(docp, argv[argc-1]) != 0)
	goto FAIL;
    goto EXIT;

  FAIL:
    result = -1;

  EXIT:
    if (docp) {
	bxh_freeDocument(docp);
	docp = NULL;
    }
    return result;
}

/*
 * $Log: In-line log eliminated on transition to SVN; use svn log instead. $
 * Revision 1.84  2008/04/04 14:08:26  gadde
 * Use nframes for number of timepoints if no sequence-specific hints.
 *
 * Revision 1.83  2008/01/28 17:01:40  gadde
 * Fix memory leak.
 *
 * Revision 1.82  2008/01/22 18:02:02  gadde
 * Update struct sizes for < 7.0 versions of Pfile (but don't know
 * how the structs themselves changed).
 *
 * Revision 1.81  2007/11/08 16:11:20  gadde
 * Add sensespiral CVs.
 *
 * Revision 1.80  2007/09/17 18:58:23  gadde
 * Add "transpose" code.
 *
 * Revision 1.79  2007/01/16 19:34:42  gadde
 * Memory fixes.
 *
 * Revision 1.78  2006/11/15 22:09:51  gadde
 * Put in some code to deal with strange coordinates in slice table
 * on 4T epiduke data.
 *
 * Revision 1.77  2006/11/01 19:44:04  gadde
 * Add --usemrorigin option.
 *
 * Revision 1.76  2006/08/14 17:28:58  gadde
 * 64-bit fix (time_t is not 32-bit on 64-bit machines)
 *
 * Revision 1.75  2006/07/31 17:56:14  gadde
 * Fix X/Y spacing for epiduke.
 *
 * Revision 1.74  2006/07/28 14:08:51  gadde
 * Add more spepi-like sequences.
 *
 * Revision 1.73  2006/07/11 14:08:55  gadde
 * Fix to use correct user CVs for EPIDUKE.
 *
 * Revision 1.72  2006/06/06 18:56:23  gadde
 * Comment out diagnostic message.
 *
 * Revision 1.71  2006/03/24 14:55:37  gadde
 * Use the rotate field in the per-slice table.
 *
 * Revision 1.70  2006/02/08 19:05:56  gadde
 * Go back to using tlhc etc. for BIAC data until we can interpret 'rotate' field
 *
 * Revision 1.69  2005/12/06 19:12:02  gadde
 * Add some more sequence names.
 *
 * Revision 1.68  2005/09/19 16:31:59  gadde
 * Documentation and help message updates.
 *
 * Revision 1.67  2005/09/14 14:49:32  gadde
 * Type conversion updates to fix win32 warnings
 *
 * Revision 1.66  2005/08/03 16:27:52  gadde
 * Surround some BIAC-specific stuff with if (psdspec != PSDSPEC_NONE)
 * so it can be used outside BIAC too.
 *
 * Revision 1.65  2005/07/12 21:18:10  gadde
 * Update slice structure for ver11 pfiles.
 *
 * Revision 1.64  2005/07/12 18:37:08  gadde
 * Add "spepi" to recognized PSDs.
 *
 * Revision 1.63  2005/07/07 19:26:21  gadde
 * Remove t dimension if there is only one timepoint.
 *
 * Revision 1.62  2005/07/07 15:05:03  gadde
 * Updates for ver11 pfiles.
 *
 * Revision 1.61  2005/05/10 19:49:11  gadde
 * Add slice order info from user CVs.
 *
 * Revision 1.60  2005/03/08 18:09:58  gadde
 * Add support for dimension size/spacing/gap/orientation hints
 *
 * Revision 1.59  2005/02/02 17:34:05  gadde
 * Make section size calculation a little more clear.
 *
 * Revision 1.58  2005/02/01 21:45:27  gadde
 * Add support for little-endian (i.e. vers>9.0) image headers.
 *
 * Revision 1.57  2005/01/11 21:29:35  gadde
 * Add --forceversion option.
 *
 * Revision 1.56  2004/11/02 18:24:35  gadde
 * Get location/orientation info from per-slice table rather than
 * from MR corner fields (MR_tlhc_R, MR_tlhc_A, ...) which are not
 * necessarily reliable.
 *
 * Revision 1.55  2004/07/07 17:00:49  gadde
 * Memory fixes.
 *
 * Revision 1.54  2004/06/18 15:21:51  gadde
 * Standardize frag creation (redux)
 *
 * Revision 1.53  2004/06/15 16:16:11  gadde
 * Several -Wall fixes and addition of bxh_datarec_addfrag()
 *
 * Revision 1.52  2004/05/20 18:03:49  gadde
 * Don't fail on unrecognized PSD.
 *
 * Revision 1.51  2004/05/20 17:21:38  gadde
 * Fix BIAC #ifdefs.
 *
 * Revision 1.50  2004/05/20 14:44:47  gadde
 * BIAC: Don't fail on unrecognized PSDs.
 *
 * Revision 1.49  2004/04/29 20:40:11  gadde
 * Add some more pulse sequences.
 *
 * Revision 1.48  2004/02/24 18:01:07  gadde
 * Move history generation to bxh_utils.cpp, and add option to create BIRN files
 *
 * Revision 1.47  2004/02/20 18:42:48  gadde
 * Add version option and rearrange documentation
 *
 * Revision 1.46  2004/02/12 22:01:05  gadde
 * Use number of files as number of timepoints in non-BIAC case.
 *
 * Revision 1.45  2004/01/02 18:41:43  gadde
 * -Wall fixes
 *
 * Revision 1.44  2003/11/14 19:03:51  gadde
 * Add internal PSD name and PSD compile date/time.
 *
 * Revision 1.43  2003/10/22 16:08:48  gadde
 * Fix some compiler warnings
 *
 * Revision 1.42  2003/09/26 16:26:27  gadde
 *  * Don't accumulate slice spacings, just use total volume spacing and
 *  * divide.
 *
 * Revision 1.41  2003/09/26 15:06:39  gadde
 * Use calculated slice spacing.
 *
 * Revision 1.40  2003/09/08 16:40:41  gadde
 * Fix x/y typo.
 *
 * Revision 1.39  2003/08/19 19:35:41  gadde
 * New options scheme, so that options are available using whichever form of bxhabsorb you use.
 *
 * Revision 1.38  2003/08/19 14:35:04  gadde
 * Use the correct "dif" flag (user16, not user19).
 *
 * Revision 1.37  2003/08/05 15:53:39  gadde
 * Use display field of view to calculate spacing if we haven't gotten it
 * by other means.
 *
 * Revision 1.36  2003/07/31 21:12:50  gadde
 * Check for newer version of Pfile header.
 *
 * Revision 1.35  2003/07/31 15:18:46  gadde
 * #ifdef out BIAC-specific things
 *
 * Revision 1.34  2003/07/25 20:43:53  gadde
 * Windows fixes for the C++ conversion of some files.
 * Also reordered some headers so "interface" is not
 * defined before including gdome headers.
 *
 * Revision 1.33  2003/07/21 16:46:49  gadde
 * Code-prettiness updates, for the most part, to further protect BXH
 * library users from particulars of DOM implementation (esp. C vs. C++).
 *
 * Revision 1.32  2003/06/18 16:11:49  gadde
 * win32 fixes
 *
 * Revision 1.31  2003/06/18 16:07:14  gadde
 * fopen in binary mode
 *
 * Revision 1.30  2003/05/16 19:57:09  gadde
 * Require a basepath for datarec.
 *
 * Revision 1.29  2003/05/10 18:20:37  gadde
 * Don't null-terminate frags.
 *
 * Revision 1.28  2003/04/28 19:47:14  gadde
 * Move to catch-all BXH encapsulation program bxhabsorb -- dicom2bxh, pfile2bxh,
 * etc. will all be symbolic links to bxhabsorb.
 *
 * Revision 1.27  2003/04/11 16:17:44  gadde
 * Change default dimorder to x,y,z,t
 *
 * Revision 1.26  2003/04/11 15:17:28  gadde
 * Move some PSD-specific stuff into pfile2bxh, like acquisitionmatrix
 * and frequencydirection for spirals.
 *
 * Revision 1.25  2003/04/03 16:47:43  gadde
 * Add some more psds.
 *
 * Revision 1.24  2003/04/02 20:22:58  gadde
 * Get rid of warning.
 *
 * Revision 1.23  2003/03/24 16:49:24  gadde
 * Add support for ximg format
 *
 * Revision 1.22  2003/02/13 16:58:29  gadde
 * Multi-line literal snuck in -- purged.
 *
 * Revision 1.21  2003/01/17 16:16:17  gadde
 * Add version string to history
 *
 * Revision 1.20  2003/01/16 22:06:58  gadde
 * Fixed phraseology.
 *
 * Revision 1.19  2003/01/16 21:13:38  gadde
 * Add field of view from psd
 *
 * Revision 1.18  2003/01/16 20:55:43  gadde
 * Add psd-specific info
 *
 * Revision 1.17  2002/12/03 20:41:05  gadde
 * Big update --
 *  add new datarec module, convert more programs from domutil_ to bxh_,
 *  add new bxh_getElement* functions, and domutil_prettify.
 *
 * Revision 1.16  2002/11/25 16:21:31  gadde
 * Mega-update to merge in new library functions.
 *
 * Revision 1.15  2002/11/15 21:16:51  gadde
 * More uncommitted namespace changes
 *
 * Revision 1.14  2002/11/15 20:52:33  gadde
 * Now BXH files have the correct namespace declarations (at the expense
 * of some fragile code in dom_utils.c that breaks the GDOME abstraction
 * layer).
 *
 * Revision 1.13  2002/10/25 20:31:01  gadde
 * Added infrastructure to support different PSDs.  Nothing useful happens yet.
 *
 * Revision 1.12  2002/09/18 21:47:32  gadde
 * Added nshots, nechoes, bandwidth.
 * R,A,S dimensions calculated differently.
 *
 * Revision 1.11  2002/09/13 19:52:43  gadde
 * Fixed tr, te, ti units (us -> ms)
 * Added units for 't' dimension, and spacing for 'z' dimension.
 *
 * Revision 1.10  2002/09/10 04:44:53  gadde
 * Comment positioning.
 *
 * Revision 1.9  2002/09/10 04:27:34  gadde
 * /mriheader -> /bxh
 *
 * Revision 1.8  2002/09/09 19:49:37  gadde
 * Fixed integer division of MagneticFieldStrength -- oops.
 * Also, /mriheader -> /bxh
 *
 * Revision 1.7  2002/09/09 17:05:29  gadde
 * Now outputs orientation vectors (dimension/direction).
 *
 * Revision 1.6  2002/08/30 14:32:13  gadde
 * Now a C file.
 *
 * Revision 1.5  2002/08/21 19:45:18  gadde
 * mxh -> bxh
 *
 * Revision 1.4  2002/08/20 21:03:35  gadde
 * scantime was mislabeled as scandate.
 *
 * Revision 1.3  2002/08/20 20:08:54  gadde
 * Added const to rcsid to avoid compiler warning.
 *
 * Revision 1.2  2002/08/20 15:32:33  gadde
 * Everything moved from libxml to libgdome (DOM).  All utility functions
 * prefixed with domutil_.  XPath support still shaky in gdome, but dom_utils.c
 * accounts for this, and extra code can be removed when gdome fully supports
 * the DOM level 3 XPath specification.
 *
 */
