/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.tbi.dictionary.validation;

import gov.nih.tbi.dictionary.validation.ConditionalValidator;
import gov.nih.tbi.dictionary.validation.TypeValidator;
import gov.nih.tbi.dictionary.validation.ValidationConstants;
import gov.nih.tbi.dictionary.validation.ValidationUtil;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AstTree {
    private HashSet<String> columnRefs;
    private HashSet<String> rowRefs;
    private Node root;

    public AstTree(String shortName, Vector<String> tokens) throws ParseException {
        this.columnRefs = new HashSet();
        this.rowRefs = new HashSet();
        for (int i = 0; i < tokens.size(); ++i) {
            String s = tokens.get(i);
            if (ValidationUtil.isColRef(s)) {
                if (s.contains(".")) {
                    String[] splits = s.split("\\.");
                    if (splits.length != 2) {
                        throw new ParseException("Column references should be of the format $short_name.element_name or $element_name", i);
                    }
                    this.columnRefs.add(s.substring(1).toLowerCase());
                    continue;
                }
                s = (shortName + "." + s.substring(1)).toLowerCase();
                this.columnRefs.add(s);
                tokens.set(i, "$" + s);
                continue;
            }
            if (!ValidationUtil.isRowRef(s)) continue;
            if (s.contains(".")) {
                throw new ParseException("Row references should be of the format #element_name", i);
            }
            s = (shortName + "." + s.substring(1)).toLowerCase();
            this.rowRefs.add(s);
            tokens.set(i, "#" + s);
        }
        this.root = this.buildTree(tokens);
    }

    private AstTree(Node root) {
        this.root = root;
    }

    public HashSet<String> getColumnRefs() {
        return this.columnRefs;
    }

    public boolean isRootNull() {
        return this.root == null;
    }

    public void setConstraintTypes(ConditionalValidator validator) throws RuntimeException {
        if (this.root != null) {
            this.root.setType(validator);
        }
    }

    public boolean evaluate(ConditionalValidator validator) throws RuntimeException {
        if (this.root != null) {
            return this.root.eval(validator);
        }
        return true;
    }

    public AstTree rowValuesSubsitution(HashMap<String, String> rowValues) throws RuntimeException {
        if (this.root != null) {
            return new AstTree(this.root.valSub(rowValues));
        }
        return null;
    }

    private Node buildTree(Vector<String> tokens) throws ParseException {
        return this.buildTree(tokens, false, 0);
    }

    private Node buildTree(Vector<String> tokens, boolean negate, int loc) throws ParseException {
        if (tokens.isEmpty()) {
            return null;
        }
        Vector<String> left = new Vector<String>();
        int parenCounter = 0;
        if (tokens.get(0).equalsIgnoreCase(ValidationConstants.CONSTRAINT_NEGATION)) {
            if (!tokens.get(1).equalsIgnoreCase("(")) {
                throw new ParseException("You can only negate constraints, '(' expected and missing", loc);
            }
            negate = true;
            tokens.remove(0);
            ++loc;
        }
        if (tokens.get(0).equalsIgnoreCase("(")) {
            for (int i = 0; i < tokens.size(); ++i) {
                left.addElement(tokens.get(i));
                if (tokens.get(i).equalsIgnoreCase("(")) {
                    ++parenCounter;
                } else if (tokens.get(i).equalsIgnoreCase(")")) {
                    --parenCounter;
                }
                if (parenCounter < 0) {
                    throw new ParseException("Unmatched closing perenthesis found", loc + i);
                }
                if (parenCounter != 0) continue;
                left.remove(0);
                left.remove(left.size() - 1);
                if (++i == tokens.size()) {
                    return this.buildTree(left, negate, loc + 1);
                }
                if (tokens.elementAt(i).equalsIgnoreCase(ValidationConstants.CONSTRAINT_AND) || tokens.elementAt(i).equalsIgnoreCase(ValidationConstants.CONSTRAINT_OR)) {
                    LogicalOp node = new LogicalOp(tokens.elementAt(i), false, loc + i);
                    node.left = this.buildTree(left, negate, loc + 1);
                    node.right = this.buildTree(this.getRight(tokens, ++i), false, loc + i);
                    return node;
                }
                throw new ParseException("Constrains must be separated by logical operators - && ||", loc + i);
            }
            throw new ParseException("Unmatched opening perenthesis found", loc);
        }
        for (int i = 0; i < tokens.size(); ++i) {
            if (tokens.get(i).equalsIgnoreCase("(") || tokens.get(i).equalsIgnoreCase(")") || tokens.elementAt(i).equalsIgnoreCase(ValidationConstants.CONSTRAINT_NEGATION)) {
                throw new ParseException(tokens.get(i) + " is only valid around a constraint expression", loc + i);
            }
            if (tokens.elementAt(i).equalsIgnoreCase(ValidationConstants.CONSTRAINT_AND) || tokens.elementAt(i).equalsIgnoreCase(ValidationConstants.CONSTRAINT_OR)) {
                LogicalOp node = new LogicalOp(tokens.elementAt(i), negate, loc + i);
                node.left = this.buildTree(left, false, loc);
                node.right = this.buildTree(this.getRight(tokens, ++i), false, loc + i);
                return node;
            }
            left.addElement(tokens.get(i));
        }
        if (!ValidationUtil.isRowRef(tokens.get(0))) {
            throw new ParseException("Contraints must begin with a row reference - #element_name", loc);
        }
        String columnRef = tokens.remove(0);
        ++loc;
        if (!ValidationUtil.isOperator(tokens.get(0))) {
            throw new ParseException("Contraints missing operator - <, >, =, !=, <=, >=, ~, !~", loc);
        }
        String operator = tokens.remove(0);
        ++loc;
        if (tokens.isEmpty()) {
            throw new ParseException("Constraint missing value", loc);
        }
        boolean isRangeOp = ValidationUtil.isRangeOperator(operator);
        if (!isRangeOp && tokens.size() > 1) {
            throw new ParseException("Multiple values are only valid for range operators - ~, !~", loc);
        }
        Vector<String> values = new Vector<String>();
        for (int i = 0; i < tokens.size(); ++i) {
            String token = tokens.get(i);
            if (ValidationUtil.isColRef(token) && !isRangeOp) {
                throw new ParseException("Column references, $element_name, are only valid values for range operators - ~, !~", loc + i);
            }
            if (token.endsWith("+") && !isRangeOp) {
                throw new ParseException("Value ranges can only be specified for contstraints with range operators - ~, !~", loc + token.indexOf("::"));
            }
            if (token.contains("::")) {
                if (!isRangeOp) {
                    throw new ParseException("Value ranges can only be specified for contstraints with range operators - ~, !~", loc + token.indexOf("::"));
                }
                String[] minMax = token.split("::");
                if (minMax.length != 2) {
                    throw new ParseException("Incorrect value range syntax", loc);
                }
            }
            if (token.equalsIgnoreCase(";")) continue;
            values.add(tokens.get(i));
        }
        return new Constraint(operator, columnRef, values, negate, loc);
    }

    private Vector<String> getRight(Vector<String> tokens, int start) {
        Vector<String> right = new Vector<String>();
        for (int i = start; i < tokens.size(); ++i) {
            right.addElement(tokens.get(i));
        }
        return right;
    }

    public void printTree() {
        ArrayList<Node> next = new ArrayList<Node>();
        next.add(this.root);
        this.printTree(next);
    }

    private void printTree(ArrayList<Node> level) {
        String row = "";
        ArrayList<Node> next = new ArrayList<Node>();
        for (Node n : level) {
            if (n == null) continue;
            row = row + n.printNode() + "\t";
            if (!(n instanceof LogicalOp)) continue;
            LogicalOp op = (LogicalOp)n;
            next.add(op.left);
            next.add(op.right);
        }
        System.out.println(row);
        if (!next.isEmpty()) {
            this.printTree(next);
        }
    }

    public String toString() {
        return String.format("%s", this.root);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Constraint
    extends Node {
        int loc;
        String rowRef;
        Vector<String> caseValues;
        String type;

        protected Constraint(String operator, String rowRef, Vector<String> caseValues, boolean negate, int loc) {
            this.loc = loc;
            this.operator = operator;
            this.rowRef = rowRef;
            this.caseValues = caseValues;
            this.negate = negate;
        }

        @Override
        void setType(ConditionalValidator validator) throws RuntimeException {
            try {
                this.type = validator.getConstraintType(this.rowRef);
            }
            catch (RuntimeException e) {
                throw new RuntimeException("type could not be determined for " + this.rowRef + " because " + e.getMessage());
            }
        }

        @Override
        boolean eval(ConditionalValidator validator) throws RuntimeException {
            if (this.negate && !(validator instanceof TypeValidator)) {
                return !validator.validateConstraint(this.operator, this.rowRef, this.caseValues, this.type, null);
            }
            return validator.validateConstraint(this.operator, this.rowRef, this.caseValues, this.type, null);
        }

        @Override
        Node valSub(HashMap<String, String> rowValues) throws RuntimeException {
            Vector<String> caseSub = new Vector<String>();
            String element = this.rowRef.split("\\.")[1];
            if (!rowValues.containsKey(element) || rowValues.get(element).isEmpty()) {
                throw new RuntimeException("value subsitution could not occur because " + element + " - No such data element found.");
            }
            String refSub = rowValues.get(element);
            for (String value : this.caseValues) {
                if (ValidationUtil.isRowRef(value)) {
                    element = value.split("\\.")[1];
                    if (rowValues.containsKey(element) && !rowValues.get(element).isEmpty()) {
                        caseSub.add(rowValues.get(element));
                        continue;
                    }
                    throw new RuntimeException("Value subsitution could not occur because " + element + " - No such data element found.");
                }
                caseSub.add(value);
            }
            Constraint node = new Constraint(this.operator, refSub, caseSub, this.negate, this.loc);
            node.type = this.type;
            return node;
        }

        @Override
        public String printNode() {
            return this.toString();
        }

        public String toString() {
            return this.rowRef + " " + this.operator + " " + this.caseValues.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LogicalOp
    extends Node {
        int loc;
        Node left;
        Node right;

        protected LogicalOp(String operator, boolean negate, int loc) {
            this.loc = loc;
            this.operator = operator;
            this.negate = negate;
        }

        @Override
        void setType(ConditionalValidator validator) throws RuntimeException {
            this.left.setType(validator);
            this.right.setType(validator);
        }

        @Override
        boolean eval(ConditionalValidator validator) throws RuntimeException {
            if (validator instanceof TypeValidator) {
                return this.left.eval(validator) && this.right.eval(validator);
            }
            if (this.operator.equalsIgnoreCase(ValidationConstants.CONSTRAINT_AND)) {
                if (this.negate) {
                    return !this.left.eval(validator) || !this.right.eval(validator);
                }
                return this.left.eval(validator) && this.right.eval(validator);
            }
            if (this.operator.equalsIgnoreCase(ValidationConstants.CONSTRAINT_OR)) {
                if (this.negate) {
                    return !this.left.eval(validator) && !this.right.eval(validator);
                }
                return this.left.eval(validator) || this.right.eval(validator);
            }
            return false;
        }

        @Override
        Node valSub(HashMap<String, String> rowValues) throws RuntimeException {
            LogicalOp node = new LogicalOp(this.operator, this.negate, this.loc);
            node.left = this.left.valSub(rowValues);
            node.right = this.right.valSub(rowValues);
            return node;
        }

        @Override
        public String printNode() {
            String output = "";
            if (this.negate) {
                output = "(!)";
            }
            output = output + this.operator;
            return output;
        }

        public String toString() {
            String output = "";
            if (this.negate) {
                output = output + "!(";
            }
            output = output + this.right.toString();
            output = output + " " + this.operator + " ";
            output = output + this.left.toString();
            if (this.negate) {
                output = output + ")";
            }
            return output;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class Node {
        String operator;
        boolean negate;

        private Node() {
        }

        abstract void setType(ConditionalValidator var1) throws RuntimeException;

        abstract boolean eval(ConditionalValidator var1) throws RuntimeException;

        abstract Node valSub(HashMap<String, String> var1);

        public abstract String printNode();
    }
}

