/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.tbi.dictionary.validation;

import gov.nih.tbi.dictionary.model.AbstractDataElement;
import gov.nih.tbi.dictionary.model.hibernate.DataStructure;
import gov.nih.tbi.dictionary.model.hibernate.MapElement;
import gov.nih.tbi.dictionary.model.hibernate.RepeatableGroup;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DictionaryAccessor {
    private static Logger logger = Logger.getLogger(DictionaryAccessor.class);
    protected List<DataStructure> dictionary;

    public DictionaryAccessor() {
    }

    public DictionaryAccessor(List<DataStructure> dictionary) {
        this.dictionary = dictionary;
    }

    public void setDictionary(List<DataStructure> list) {
        this.dictionary = list;
    }

    public void addWorkingStructure(DataStructure struct) {
        if (this.dictionary == null) {
            this.dictionary = new ArrayList<DataStructure>();
        }
        this.dictionary.add(struct);
    }

    public static DataStructure getDataStructureByName(List<DataStructure> dictionary, String concatName) {
        try {
            String shortName = concatName.substring(0, concatName.length() - 2);
            Integer version = Integer.valueOf(concatName.substring(concatName.length() - 2));
            for (DataStructure ads : dictionary) {
                if (!ads.getShortName().equalsIgnoreCase(shortName) || !ads.getVersion().equals(version)) continue;
                return ads;
            }
        }
        catch (NumberFormatException e) {
            logger.debug((Object)"Tried to get a data structure by compostie shortname that has no version.  Likely this is because it is not actually a short name.");
        }
        catch (StringIndexOutOfBoundsException ex) {
            logger.debug((Object)"Tried to get a data structure by compostie shortname that is not long enough to have a version.  Likely this is because it is not actually a short name.");
        }
        return null;
    }

    public static AbstractDataElement getDataElementByName(DataStructure ds, String elementName, String repeatableGroup) {
        if (repeatableGroup == null || "".equals(repeatableGroup.trim())) {
            repeatableGroup = "main";
        }
        for (RepeatableGroup rg : ds.getRepeatableGroups()) {
            if (!rg.getName().equalsIgnoreCase(repeatableGroup)) continue;
            for (MapElement me : rg.getMapElements()) {
                if (!me.getName().equalsIgnoreCase(elementName)) continue;
                return me;
            }
        }
        return null;
    }

    protected AbstractDataElement getElement(String shortname, String element) throws RuntimeException {
        if (this.dictionary == null) {
            throw new RuntimeException("dictionary has not be initialized");
        }
        DataStructure struct = DictionaryAccessor.getDataStructureByName(this.dictionary, shortname.toLowerCase());
        if (struct == null) {
            throw new RuntimeException(shortname + " - No such structure exists");
        }
        AbstractDataElement el = DictionaryAccessor.getDataElementByName(struct, element.toLowerCase(), null);
        if (el == null) {
            throw new RuntimeException(element + " - No such element exists in " + shortname);
        }
        return el;
    }
}

