/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.tbi.dictionary.validation;

import gov.nih.tbi.dictionary.model.AbstractDataElement;
import gov.nih.tbi.dictionary.validation.AstTree;
import gov.nih.tbi.dictionary.validation.RangeValidator;
import gov.nih.tbi.dictionary.validation.TypeValidator;
import gov.nih.tbi.dictionary.validation.ValidationUtil;
import gov.nih.tbi.dictionary.ws.DictionaryProvider;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Vector;

public class ElementInputsChecker {
    private DictionaryProvider ddtClient;
    private RangeValidator ranger;
    private TypeValidator typer;
    private String username;

    public ElementInputsChecker(String username, DictionaryProvider provider) {
        this.ddtClient = provider;
        this.ranger = new RangeValidator();
        this.typer = new TypeValidator();
        this.username = username;
    }

    public boolean elementRangeCheck(String range, String type, AbstractDataElement iElement) throws ParseException {
        return this.rangeCheck(range, type, null, null, iElement);
    }

    public boolean rangeCheck(String range, String type, String shortName, AbstractDataElement iElement) throws ParseException {
        return this.rangeCheck(range, type, null, shortName, iElement);
    }

    public boolean rangeCheck(String range, String type, String format, String shortName, AbstractDataElement iElement) throws ParseException {
        return this.subRangeCheck(range, null, type, format, shortName, iElement);
    }

    public boolean subRangeCheck(String range, String parentRange, String type, String shortName, AbstractDataElement iElement) throws ParseException {
        return this.subRangeCheck(range, parentRange, type, null, shortName, iElement);
    }

    public boolean subRangeCheck(String range, String parentRange, String type, String format, String shortName, AbstractDataElement iElement) throws ParseException {
        Vector<String> rangeVec = ValidationUtil.tokenizeRange(range);
        Vector<String> parentVec = ValidationUtil.tokenizeRange(parentRange);
        HashSet<String> columnRefs = new HashSet<String>();
        ArrayList<String> structs = new ArrayList<String>();
        if (shortName != null) {
            structs.add(shortName);
        }
        for (int i = 0; i < rangeVec.size(); ++i) {
            String value = rangeVec.get(i);
            if (ValidationUtil.isColRef(value)) {
                if (shortName != null) {
                    if (value.contains(".")) {
                        String[] splits = value.split("\\.");
                        if (splits.length != 2) {
                            throw new ParseException("Column references should be of the format $short_name.element_name or $element_name", i);
                        }
                        structs.add(splits[0].substring(1));
                    } else {
                        value = "$" + shortName + "." + value.substring(1);
                    }
                    columnRefs.add(value);
                    continue;
                }
                throw new ParseException("Column references are invalid in element value ranges", i);
            }
            if (ValidationUtil.isRowRef(value)) {
                if (shortName != null) {
                    if (value.contains(".")) {
                        throw new ParseException("Row references should be of the format #element_name", i);
                    }
                    columnRefs.add("#" + shortName + "." + value.substring(1));
                    continue;
                }
                throw new ParseException("Row references are invalid in element value ranges", i);
            }
            if (value.contains("::") && this.typer.typeIsNumeric(type)) {
                String[] minMax = value.split("::");
                if (minMax.length != 2) {
                    throw new ParseException("Incorrect value range syntax", i);
                }
                for (String s : minMax) {
                    if (!this.typer.isType(s = s.trim(), type, format)) {
                        return false;
                    }
                    if (parentVec.isEmpty() || this.ranger.inRange(s, iElement)) continue;
                    return false;
                }
                continue;
            }
            if (value.endsWith("+") && this.typer.typeIsNumeric(type)) {
                value = value.substring(0, value.length() - 2).trim();
            }
            if (!this.typer.isType(value, type, format)) {
                return false;
            }
            if (parentVec.isEmpty() || this.ranger.inRange(value, iElement)) continue;
            return false;
        }
        String[] shortnames = new String[structs.size()];
        this.typer.setDictionary(DictionaryProvider.getDataDictionary(this.ddtClient, structs.toArray(shortnames)));
        for (String ref : columnRefs) {
            if (this.typer.refIsType(ref, type)) continue;
            return false;
        }
        return true;
    }

    public boolean constraintCheck(String constraint, String shortName) throws ParseException, RuntimeException {
        AstTree tree = new AstTree(shortName, ValidationUtil.tokenizeConstraint(constraint));
        ArrayList<String> structs = new ArrayList<String>();
        structs.add(shortName);
        for (String ref : tree.getColumnRefs()) {
            String[] split = ref.split("\\.");
            structs.add(split[0]);
        }
        String[] shortnames = new String[structs.size()];
        this.typer.setDictionary(DictionaryProvider.getDataDictionary(this.ddtClient, structs.toArray(shortnames)));
        tree.setConstraintTypes(this.typer);
        tree.evaluate(this.typer);
        return true;
    }

    public boolean stringSizeCheck(String range, String size) {
        int length = Integer.parseInt(size);
        Vector<String> rangeVec = ValidationUtil.tokenizeRange(range);
        for (String s : rangeVec) {
            if (s.length() <= length) continue;
            return false;
        }
        return true;
    }
}

