/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.tbi.dictionary.validation;

import gov.nih.tbi.commons.model.DataType;
import gov.nih.tbi.dictionary.model.AbstractDataElement;
import gov.nih.tbi.dictionary.model.hibernate.DataStructure;
import gov.nih.tbi.dictionary.validation.CellValidator;
import gov.nih.tbi.dictionary.validation.ConditionalValidator;
import gov.nih.tbi.dictionary.validation.ValidationUtil;
import java.util.Date;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeValidator
extends CellValidator
implements ConditionalValidator {
    public TypeValidator() {
    }

    public TypeValidator(List<DataStructure> dictionary) {
        super(dictionary);
    }

    @Override
    public boolean validate(AbstractDataElement iElement, String data) {
        String type = iElement.getType().name();
        String format = iElement.getFormat();
        return this.isType(data, type, format);
    }

    @Override
    public String getConstraintType(String rowRef) throws RuntimeException {
        String[] split = rowRef.substring(1).split("\\.");
        AbstractDataElement current = this.getElement(split[0], split[1]);
        return current.getType().getValue();
    }

    @Override
    public boolean validateConstraint(String operator, String rowRef, Vector<String> valueRange, String type, AbstractDataElement iElement) throws RuntimeException {
        if (ValidationUtil.isRangeOperator(operator)) {
            for (String value : valueRange) {
                if (ValidationUtil.isColRef(value) || ValidationUtil.isRowRef(value)) {
                    if (!this.refIsType(value, type)) {
                        throw new RuntimeException(value + "'s type does not match " + rowRef + "'s type, " + type);
                    }
                    return true;
                }
                if (value.contains("::")) {
                    String[] minMax;
                    if (!this.typeIsNumeric(type)) {
                        throw new RuntimeException(value + " - Ranges are only valid for numeric types");
                    }
                    for (String s : minMax = value.split("::")) {
                        if (this.isType(s.trim(), type)) continue;
                        throw new RuntimeException(s + " type does not match " + rowRef + "'s type, " + type);
                    }
                    continue;
                }
                if (value.endsWith("+")) {
                    if (!this.typeIsNumeric(type)) {
                        throw new RuntimeException(value + " - Ranges are only valid for numeric types");
                    }
                    String s = value.substring(0, value.length() - 1);
                    if (this.isType(s, type)) continue;
                    throw new RuntimeException(s + " type does not match " + rowRef + "'s type, " + type);
                }
                if (this.isType(value, type)) continue;
                throw new RuntimeException(value + " type does not match " + rowRef + "'s type, " + type);
            }
        } else {
            if (ValidationUtil.isNumberOperator(operator) && !this.typeIsNumeric(type)) {
                throw new RuntimeException(operator + " - Numeric operators are not valid for type, " + type);
            }
            String value = valueRange.get(0);
            if (ValidationUtil.isRowRef(value)) {
                if (!this.refIsType(value, type)) {
                    throw new RuntimeException(value + "'s type does not match " + rowRef + "'s type, " + type);
                }
                return true;
            }
            if (!this.isType(value, type)) {
                throw new RuntimeException(value + " type does not match " + rowRef + "'s type, " + type);
            }
        }
        return true;
    }

    public boolean refIsType(String ref, String type) throws RuntimeException {
        String[] split = ref.substring(1).split("\\.");
        AbstractDataElement current = this.getElement(split[0], split[1]);
        String curType = current.getType().getValue();
        return type.equals(curType);
    }

    public boolean isType(String value, String type) {
        return this.isType(value, type, null);
    }

    public boolean isType(String value, String type, String format) {
        boolean result;
        if (type == null || value == null) {
            return false;
        }
        value = value.trim();
        DataType elementType = DataType.valueOf((String)type);
        if (DataType.ALPHANUMERIC.equals((Object)elementType)) {
            if (format == null || format.equals("")) {
                return true;
            }
            result = value.matches(format);
        } else if (DataType.NUMERIC.equals((Object)elementType)) {
            result = this.isFloat(value, format);
        } else if (DataType.DATE.equals((Object)elementType)) {
            result = this.isDate(value, format);
        } else if (DataType.GUID.equals((Object)elementType)) {
            result = this.isGuid(value, format);
        } else {
            return false;
        }
        return result;
    }

    private boolean isDate(String s, String format) {
        Date date = ValidationUtil.parseDate(s, format);
        return date != null;
    }

    private boolean isGuid(String s, String format) {
        return true;
    }

    private boolean isFloat(String s, String format) {
        try {
            String[] dataArr;
            for (String val : dataArr = s.split(";")) {
                Float.parseFloat(val);
                if (format == null || format.equals("") || val.matches(format)) continue;
                return false;
            }
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private boolean isFile(String s, String format) {
        if (format == null || format.equals("")) {
            return s.matches("(/.*)*(\\.)(\\w)*");
        }
        return s.matches(format);
    }

    public boolean typeIsNumeric(String type) {
        return type.equalsIgnoreCase("Integer") || type.equalsIgnoreCase("Float") || type.equalsIgnoreCase("Date");
    }
}

