/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.tbi.dictionary.validation;

import gov.nih.tbi.dictionary.validation.ValidationConstants;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationUtil {
    public static boolean isRowRef(String token) {
        return token.startsWith("#");
    }

    public static boolean isColRef(String token) {
        return token.startsWith("$");
    }

    public static boolean isOperator(String token) {
        boolean isOperator = false;
        for (int i = 0; i < ValidationConstants.CONSTRAINT_OPERATORS.length; ++i) {
            String operator = ValidationConstants.CONSTRAINT_OPERATORS[i];
            if (!token.equalsIgnoreCase(operator)) continue;
            isOperator = true;
            break;
        }
        return isOperator;
    }

    public static boolean isNumberOperator(String token) {
        boolean isOperator = false;
        for (int i = 0; i < ValidationConstants.CONSTRAINT_NUMBER_OPERATORS.length; ++i) {
            String operator = ValidationConstants.CONSTRAINT_NUMBER_OPERATORS[i];
            if (!token.equalsIgnoreCase(operator)) continue;
            isOperator = true;
            break;
        }
        return isOperator;
    }

    public static boolean isRangeOperator(String token) {
        boolean isOperator = false;
        for (int i = 0; i < ValidationConstants.CONSTRAINT_RANGE_OPERATORS.length; ++i) {
            String operator = ValidationConstants.CONSTRAINT_RANGE_OPERATORS[i];
            if (!token.equalsIgnoreCase(operator)) continue;
            isOperator = true;
            break;
        }
        return isOperator;
    }

    public static Vector<String> tokenizeRange(String range) {
        Vector<String> tokenList = new Vector<String>();
        if (range != null && !range.isEmpty()) {
            for (String s : range.split(";")) {
                tokenList.add(s.trim());
            }
        }
        return tokenList;
    }

    public static Vector<String> tokenizeConstraint(String constraint) {
        boolean operator = false;
        Vector<String> tokenList = new Vector<String>();
        if (constraint != null) {
            int pos = 0;
            while (pos < constraint.length()) {
                StringBuffer sb;
                String s;
                char c = ValidationUtil.readChar(constraint, pos);
                if (c == ' ') {
                    ++pos;
                    continue;
                }
                if (c == ';') {
                    s = String.valueOf(c);
                    ++pos;
                    operator = true;
                    tokenList.add(s);
                    continue;
                }
                if (c == '(' || c == ')' || c == '=' || c == '~') {
                    s = String.valueOf(c);
                    ++pos;
                    operator = true;
                    tokenList.add(s);
                    continue;
                }
                if (c == '<' || c == '>') {
                    sb = new StringBuffer();
                    s = String.valueOf(c);
                    sb.append(s);
                    if (++pos < constraint.length() && (c = ValidationUtil.readChar(constraint, pos)) == '=') {
                        s = String.valueOf(c);
                        sb.append(s);
                        ++pos;
                    }
                    operator = true;
                    tokenList.add(sb.toString());
                    continue;
                }
                if (c == '!') {
                    sb = new StringBuffer();
                    s = String.valueOf(c);
                    sb.append(s);
                    if (++pos < constraint.length() && ((c = ValidationUtil.readChar(constraint, pos)) == '=' || c == '~')) {
                        s = String.valueOf(c);
                        sb.append(s);
                        ++pos;
                    }
                    operator = true;
                    tokenList.add(sb.toString());
                    continue;
                }
                sb = new StringBuffer();
                try {
                    int c2 = ValidationUtil.readChar(constraint, pos + 1);
                    if (c == '|' && c2 == 124 || c == '&' && c2 == 38) {
                        s = String.valueOf(c) + String.valueOf((char)c2);
                        sb.append(s);
                        pos += 2;
                        operator = true;
                        tokenList.add(sb.toString());
                        continue;
                    }
                    boolean escaped = false;
                    while (pos < constraint.length() && (!ValidationUtil.isTokenStart(c, (char)c2) || escaped)) {
                        if (c == '\\' && !escaped) {
                            escaped = true;
                        } else {
                            escaped = false;
                            s = String.valueOf(c);
                            sb.append(s);
                        }
                        ++pos;
                        try {
                            if (pos >= constraint.length()) continue;
                            c = ValidationUtil.readChar(constraint, pos);
                            c2 = ValidationUtil.readChar(constraint, pos + 1);
                        }
                        catch (IndexOutOfBoundsException e) {
                            c2 = 32;
                        }
                    }
                }
                catch (IndexOutOfBoundsException e) {
                    s = String.valueOf(c);
                    sb.append(s);
                    ++pos;
                }
                String token = sb.toString().trim();
                if (!operator && !tokenList.isEmpty()) {
                    String last = tokenList.lastElement();
                    last = last.concat(" ");
                    token = last + token;
                    tokenList.remove(tokenList.size() - 1);
                }
                operator = false;
                tokenList.add(token);
            }
        }
        return tokenList;
    }

    private static boolean isTokenStart(char c, char c2) {
        return c == '<' || c == '>' || c == '=' || c == '!' || c == ' ' || c == '(' || c == ')' || c == '~' || c == ';' || c == '|' && c2 == '|' || c == '&' && c2 == '&';
    }

    private static char readChar(String exp, int pos) {
        char c = exp.charAt(pos);
        return c;
    }

    public static boolean not(boolean eval) {
        return !eval;
    }

    public static boolean equals(String refData, String value, String type) {
        if (type.equalsIgnoreCase("Integer")) {
            int j;
            int i = Integer.parseInt(refData);
            return i == (j = Integer.parseInt(value));
        }
        if (type.equalsIgnoreCase("Float")) {
            float j;
            float i = Float.parseFloat(refData);
            return i == (j = Float.parseFloat(value));
        }
        if (type.equalsIgnoreCase("Date")) {
            Date i = ValidationUtil.parseDate(refData, null);
            Date j = ValidationUtil.parseDate(value, null);
            return i.equals(j);
        }
        return value.equalsIgnoreCase(refData);
    }

    public static boolean greater(String refData, String value, String type) {
        if (type.equalsIgnoreCase("Integer")) {
            int j;
            int i = Integer.parseInt(refData);
            return i > (j = Integer.parseInt(value));
        }
        if (type.equalsIgnoreCase("Float")) {
            float j;
            float i = Float.parseFloat(refData);
            return i > (j = Float.parseFloat(value));
        }
        if (type.equalsIgnoreCase("Date")) {
            Date i = ValidationUtil.parseDate(refData, null);
            Date j = ValidationUtil.parseDate(value, null);
            return i.after(j);
        }
        throw new UnsupportedOperationException("Greater then operation is only supported for numeric types.");
    }

    public static boolean less(String refData, String value, String type) {
        if (type.equalsIgnoreCase("Integer")) {
            int j;
            int i = Integer.parseInt(refData);
            return i < (j = Integer.parseInt(value));
        }
        if (type.equalsIgnoreCase("Float")) {
            float j;
            float i = Float.parseFloat(refData);
            return i < (j = Float.parseFloat(value));
        }
        if (type.equalsIgnoreCase("Date")) {
            Date i = ValidationUtil.parseDate(refData, null);
            Date j = ValidationUtil.parseDate(value, null);
            return i.before(j);
        }
        throw new UnsupportedOperationException("Less then operation is only supported for numeric types.");
    }

    public static Date parseDate(String date, String format) {
        if (format == null) {
            format = "dd-MMM-yyyy";
        }
        if (format.contains(";")) {
            String[] formats;
            for (String f : formats = format.split(";")) {
                try {
                    SimpleDateFormat dateForm = new SimpleDateFormat(f.trim());
                    Date d = dateForm.parse(date);
                    if (d == null) continue;
                    return d;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        } else {
            try {
                SimpleDateFormat dateForm = new SimpleDateFormat(format);
                return dateForm.parse(date);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }
}

