/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.tbi.dictionary.ws;

import gov.nih.tbi.account.ws.AuthenticationProvider;
import gov.nih.tbi.dictionary.model.AbstractDataStructure;
import gov.nih.tbi.dictionary.model.hibernate.BasicDataStructure;
import gov.nih.tbi.dictionary.model.hibernate.DataStructure;
import gov.nih.tbi.dictionary.ws.DictionaryWebService;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import javax.xml.ws.WebEndpoint;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DictionaryProvider
extends AuthenticationProvider {
    private static Logger logger = Logger.getLogger(DictionaryProvider.class);
    private static final String namespaceURI = "http://cxf.ws.dictionary.tbi.nih.gov/";
    private static final String serviceName = "DictionaryWebServiceImplService";
    private static final String portName = "DictionaryWebServiceImplPort";
    private static final String wsdlExtension = "/tbi-portal/ws/dictionaryWebService?wsdl";
    private static URL WSDL_LOCATION;
    private Service service;
    private DictionaryWebService dictionaryWebService;

    public DictionaryProvider(String serverLocation, String userName, String password) throws MalformedURLException {
        super(serverLocation, userName, password);
        WSDL_LOCATION = new URL(DictionaryProvider.class.getResource("."), serverLocation + wsdlExtension);
        this.service = Service.create((URL)WSDL_LOCATION, (QName)new QName(namespaceURI, serviceName));
        this.dictionaryWebService = this.getDataDictionaryService();
    }

    public DictionaryProvider(String serverLocation) throws MalformedURLException {
        this(serverLocation, "anonymous", "");
    }

    @WebEndpoint(name="dictionaryWebService")
    private DictionaryWebService getDataDictionaryService() {
        return (DictionaryWebService)this.service.getPort(new QName(namespaceURI, portName), DictionaryWebService.class);
    }

    public List<BasicDataStructure> getDataStructures() {
        return this.dictionaryWebService.getDataStructures(this.getUserLogin());
    }

    public List<DataStructure> getDataDictionary(List<? extends AbstractDataStructure> dataStructureList) {
        return this.dictionaryWebService.getDataDictionary(this.getUserLogin(), dataStructureList);
    }

    public static List<DataStructure> getDataDictionary(DictionaryProvider connection, String[] structureNames) {
        ArrayList<BasicDataStructure> dataStructureRequestList = new ArrayList<BasicDataStructure>();
        for (String name : structureNames) {
            BasicDataStructure bds = new BasicDataStructure();
            name = name.toLowerCase();
            try {
                bds.setShortName(name.substring(0, name.length() - 2));
                bds.setVersion(Integer.valueOf(name.substring(name.length() - 2)));
                dataStructureRequestList.add(bds);
            }
            catch (NumberFormatException ex) {
                logger.debug((Object)"Tried to get a data structure by compostie shortname that has no version.  Likely this is because it is not actually a short name.");
            }
            catch (StringIndexOutOfBoundsException ex) {
                logger.debug((Object)"Tried to get a data structure by compostie shortname that is not long enough to have a version.  Likely this is because it is not actually a short name.");
            }
        }
        return connection.getDataDictionary(dataStructureRequestList);
    }
}

