/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.loaders.objectfile;

import com.sun.j3d.loaders.IncorrectFormatException;
import com.sun.j3d.loaders.Loader;
import com.sun.j3d.loaders.ParsingErrorException;
import com.sun.j3d.loaders.Scene;
import com.sun.j3d.loaders.SceneBase;
import com.sun.j3d.loaders.objectfile.ObjectFileMaterials;
import com.sun.j3d.loaders.objectfile.ObjectFileParser;
import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.NormalGenerator;
import com.sun.j3d.utils.geometry.Stripifier;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Geometry;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.vecmath.Point3f;
import javax.vecmath.TexCoord2f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public class ObjectFile
implements Loader {
    private static final int DEBUG = 1;
    public static final int RESIZE = 64;
    public static final int TRIANGULATE = 128;
    public static final int REVERSE = 256;
    public static final int STRIPIFY = 512;
    private static final char BACKSLASH = '\\';
    private int flags;
    private String basePath = null;
    private URL baseUrl = null;
    private boolean fromUrl = false;
    private float radians;
    private ArrayList coordList;
    private ArrayList texList;
    private ArrayList normList;
    private ArrayList coordIdxList;
    private ArrayList texIdxList;
    private ArrayList normIdxList;
    private ArrayList stripCounts;
    private HashMap groups;
    private String curGroup;
    private HashMap sGroups;
    private String curSgroup;
    private HashMap groupMaterials;
    private HashMap triGroups;
    private ArrayList curTriGroup;
    private HashMap triSgroups;
    private ArrayList curTriSgroup;
    private Point3f[] coordArray = null;
    private Vector3f[] normArray = null;
    private TexCoord2f[] texArray = null;
    private long time;
    private ObjectFileMaterials materials = null;

    void readVertex(ObjectFileParser objectFileParser) throws ParsingErrorException {
        Point3f point3f = new Point3f();
        objectFileParser.getNumber();
        point3f.x = (float)objectFileParser.nval;
        objectFileParser.getNumber();
        point3f.y = (float)objectFileParser.nval;
        objectFileParser.getNumber();
        point3f.z = (float)objectFileParser.nval;
        objectFileParser.skipToNextLine();
        this.coordList.add(point3f);
    }

    void readNormal(ObjectFileParser objectFileParser) throws ParsingErrorException {
        Vector3f vector3f = new Vector3f();
        objectFileParser.getNumber();
        vector3f.x = (float)objectFileParser.nval;
        objectFileParser.getNumber();
        vector3f.y = (float)objectFileParser.nval;
        objectFileParser.getNumber();
        vector3f.z = (float)objectFileParser.nval;
        objectFileParser.skipToNextLine();
        this.normList.add(vector3f);
    }

    void readTexture(ObjectFileParser objectFileParser) throws ParsingErrorException {
        TexCoord2f texCoord2f = new TexCoord2f();
        objectFileParser.getNumber();
        texCoord2f.x = (float)objectFileParser.nval;
        objectFileParser.getNumber();
        texCoord2f.y = (float)objectFileParser.nval;
        objectFileParser.skipToNextLine();
        this.texList.add(texCoord2f);
    }

    void readFace(ObjectFileParser objectFileParser) throws ParsingErrorException {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        objectFileParser.getToken();
        while (objectFileParser.ttype != 10) {
            objectFileParser.pushBack();
            objectFileParser.getNumber();
            int n4 = (int)objectFileParser.nval - 1;
            if (n4 < 0) {
                n4 += this.coordList.size() + 1;
            }
            this.coordIdxList.add(new Integer(n4));
            objectFileParser.getToken();
            if (objectFileParser.ttype == 47) {
                objectFileParser.getToken();
                if (objectFileParser.ttype == -3) {
                    objectFileParser.pushBack();
                    objectFileParser.getNumber();
                    n = (int)objectFileParser.nval - 1;
                    if (n < 0) {
                        n += this.texList.size() + 1;
                    }
                    this.texIdxList.add(new Integer(n));
                    objectFileParser.getToken();
                }
                if (objectFileParser.ttype == 47) {
                    objectFileParser.getNumber();
                    n2 = (int)objectFileParser.nval - 1;
                    if (n2 < 0) {
                        n2 += this.normList.size() + 1;
                    }
                    this.normIdxList.add(new Integer(n2));
                    objectFileParser.getToken();
                }
            }
            ++n3;
        }
        Integer n5 = new Integer(this.stripCounts.size());
        this.stripCounts.add(new Integer(n3));
        this.groups.put(n5, this.curGroup);
        if (this.curSgroup != null) {
            this.sGroups.put(n5, this.curSgroup);
        }
        objectFileParser.skipToNextLine();
    }

    void readPartName(ObjectFileParser objectFileParser) {
        objectFileParser.getToken();
        String string = (String)this.groupMaterials.get(this.curGroup);
        this.curGroup = objectFileParser.ttype != -3 ? "default" : objectFileParser.sval;
        if (this.groupMaterials.get(this.curGroup) == null) {
            this.groupMaterials.put(this.curGroup, string);
        }
        objectFileParser.skipToNextLine();
    }

    void readMaterialName(ObjectFileParser objectFileParser) throws ParsingErrorException {
        objectFileParser.getToken();
        if (objectFileParser.ttype == -3) {
            this.groupMaterials.put(this.curGroup, new String(objectFileParser.sval));
        }
        objectFileParser.skipToNextLine();
    }

    void loadMaterialFile(ObjectFileParser objectFileParser) throws ParsingErrorException {
        String string = null;
        objectFileParser.lowerCaseMode(false);
        do {
            objectFileParser.getToken();
            if (objectFileParser.ttype != -3) continue;
            string = objectFileParser.sval;
        } while (objectFileParser.ttype != 10);
        this.materials.readMaterialFile(this.fromUrl, this.fromUrl ? this.baseUrl.toString() : this.basePath, string);
        objectFileParser.lowerCaseMode(true);
        objectFileParser.skipToNextLine();
    }

    void readSmoothingGroup(ObjectFileParser objectFileParser) throws ParsingErrorException {
        objectFileParser.getToken();
        if (objectFileParser.ttype != -3) {
            objectFileParser.skipToNextLine();
            return;
        }
        this.curSgroup = objectFileParser.sval.equals("off") ? "0" : objectFileParser.sval;
        objectFileParser.skipToNextLine();
    }

    void readFile(ObjectFileParser objectFileParser) throws ParsingErrorException {
        objectFileParser.getToken();
        while (objectFileParser.ttype != -1) {
            if (objectFileParser.ttype == -3) {
                if (objectFileParser.sval.equals("v")) {
                    this.readVertex(objectFileParser);
                } else if (objectFileParser.sval.equals("vn")) {
                    this.readNormal(objectFileParser);
                } else if (objectFileParser.sval.equals("vt")) {
                    this.readTexture(objectFileParser);
                } else if (objectFileParser.sval.equals("f")) {
                    this.readFace(objectFileParser);
                } else if (objectFileParser.sval.equals("fo")) {
                    this.readFace(objectFileParser);
                } else if (objectFileParser.sval.equals("g")) {
                    this.readPartName(objectFileParser);
                } else if (objectFileParser.sval.equals("s")) {
                    this.readSmoothingGroup(objectFileParser);
                } else if (objectFileParser.sval.equals("p")) {
                    objectFileParser.skipToNextLine();
                } else if (objectFileParser.sval.equals("l")) {
                    objectFileParser.skipToNextLine();
                } else if (objectFileParser.sval.equals("mtllib")) {
                    this.loadMaterialFile(objectFileParser);
                } else if (objectFileParser.sval.equals("usemtl")) {
                    this.readMaterialName(objectFileParser);
                } else if (objectFileParser.sval.equals("maplib")) {
                    objectFileParser.skipToNextLine();
                } else if (objectFileParser.sval.equals("usemap")) {
                    objectFileParser.skipToNextLine();
                } else {
                    throw new ParsingErrorException("Unrecognized token, line " + objectFileParser.lineno());
                }
            }
            objectFileParser.skipToNextLine();
            objectFileParser.getToken();
        }
    }

    public ObjectFile(int n, float f) {
        this.setFlags(n);
        this.radians = f;
    }

    public ObjectFile(int n) {
        this(n, -1.0f);
    }

    public ObjectFile() {
        this(0, -1.0f);
    }

    private void setBasePathFromFilename(String string) {
        if (string.lastIndexOf(File.separator) == -1) {
            this.setBasePath("." + File.separator);
        } else {
            this.setBasePath(string.substring(0, string.lastIndexOf(File.separator)));
        }
    }

    public Scene load(String string) throws FileNotFoundException, IncorrectFormatException, ParsingErrorException {
        this.setBasePathFromFilename(string);
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        return this.load(bufferedReader);
    }

    private void setBaseUrlFromUrl(URL uRL) throws FileNotFoundException {
        String string = uRL.toString();
        String string2 = string.lastIndexOf(47) == -1 ? uRL.getProtocol() + ":" : string.substring(0, string.lastIndexOf(47) + 1);
        try {
            this.baseUrl = new URL(string2);
        }
        catch (MalformedURLException malformedURLException) {
            throw new FileNotFoundException(malformedURLException.getMessage());
        }
    }

    public Scene load(URL uRL) throws FileNotFoundException, IncorrectFormatException, ParsingErrorException {
        BufferedReader bufferedReader;
        if (this.baseUrl == null) {
            this.setBaseUrlFromUrl(uRL);
        }
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
        }
        catch (IOException iOException) {
            throw new FileNotFoundException(iOException.getMessage());
        }
        this.fromUrl = true;
        return this.load(bufferedReader);
    }

    private Point3f[] getLimits() {
        Point3f point3f = new Point3f();
        Point3f[] point3fArray = new Point3f[]{new Point3f(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE), new Point3f(Float.MIN_VALUE, Float.MIN_VALUE, Float.MIN_VALUE)};
        int n = 0;
        while (n < this.coordList.size()) {
            point3f = (Point3f)this.coordList.get(n);
            if (point3f.x < point3fArray[0].x) {
                point3fArray[0].x = point3f.x;
            }
            if (point3f.x > point3fArray[1].x) {
                point3fArray[1].x = point3f.x;
            }
            if (point3f.y < point3fArray[0].y) {
                point3fArray[0].y = point3f.y;
            }
            if (point3f.y > point3fArray[1].y) {
                point3fArray[1].y = point3f.y;
            }
            if (point3f.z < point3fArray[0].z) {
                point3fArray[0].z = point3f.z;
            }
            if (point3f.z > point3fArray[1].z) {
                point3fArray[1].z = point3f.z;
            }
            ++n;
        }
        return point3fArray;
    }

    private void resize() {
        Point3f point3f = new Point3f();
        Point3f[] point3fArray = this.getLimits();
        Vector3f vector3f = new Vector3f(-0.5f * (point3fArray[0].x + point3fArray[1].x), -0.5f * (point3fArray[0].y + point3fArray[1].y), -0.5f * (point3fArray[0].z + point3fArray[1].z));
        float f = point3fArray[1].x - point3fArray[0].x;
        if (f < point3fArray[1].y - point3fArray[0].y) {
            f = point3fArray[1].y - point3fArray[0].y;
        }
        if (f < point3fArray[1].z - point3fArray[0].z) {
            f = point3fArray[1].z - point3fArray[0].z;
        }
        f /= 2.0f;
        int n = 0;
        while (n < this.coordList.size()) {
            point3f = (Point3f)this.coordList.get(n);
            point3f.add((Tuple3f)point3f, (Tuple3f)vector3f);
            point3f.x /= f;
            point3f.y /= f;
            point3f.z /= f;
            ++n;
        }
    }

    private int[] objectToIntArray(ArrayList arrayList) {
        int[] nArray = new int[arrayList.size()];
        int n = 0;
        while (n < arrayList.size()) {
            nArray[n] = (Integer)arrayList.get(n);
            ++n;
        }
        return nArray;
    }

    private Point3f[] objectToPoint3Array(ArrayList arrayList) {
        Point3f[] point3fArray = new Point3f[arrayList.size()];
        int n = 0;
        while (n < arrayList.size()) {
            point3fArray[n] = (Point3f)arrayList.get(n);
            ++n;
        }
        return point3fArray;
    }

    private TexCoord2f[] objectToTexCoord2Array(ArrayList arrayList) {
        TexCoord2f[] texCoord2fArray = new TexCoord2f[arrayList.size()];
        int n = 0;
        while (n < arrayList.size()) {
            texCoord2fArray[n] = (TexCoord2f)arrayList.get(n);
            ++n;
        }
        return texCoord2fArray;
    }

    private Vector3f[] objectToVectorArray(ArrayList arrayList) {
        Vector3f[] vector3fArray = new Vector3f[arrayList.size()];
        int n = 0;
        while (n < arrayList.size()) {
            vector3fArray[n] = (Vector3f)arrayList.get(n);
            ++n;
        }
        return vector3fArray;
    }

    private int[] groupIndices(ArrayList arrayList, ArrayList arrayList2) {
        int[] nArray = new int[arrayList2.size() * 3];
        int n = 0;
        while (n < arrayList2.size()) {
            int n2 = (Integer)arrayList2.get(n);
            nArray[n * 3 + 0] = (Integer)arrayList.get(n2 + 0);
            nArray[n * 3 + 1] = (Integer)arrayList.get(n2 + 1);
            nArray[n * 3 + 2] = (Integer)arrayList.get(n2 + 2);
            ++n;
        }
        return nArray;
    }

    private void smoothingGroupNormals() {
        NormalGenerator normalGenerator = new NormalGenerator(this.radians == -1.0f ? Math.PI : (double)this.radians);
        NormalGenerator normalGenerator2 = new NormalGenerator(0.0);
        this.normList.clear();
        this.normIdxList = null;
        int[] nArray = new int[this.coordIdxList.size()];
        Iterator iterator = this.triSgroups.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            ArrayList arrayList = (ArrayList)this.triSgroups.get(string);
            if (arrayList.size() <= 0) continue;
            GeometryInfo geometryInfo = new GeometryInfo(1);
            geometryInfo.setCoordinateIndices(this.groupIndices(this.coordIdxList, arrayList));
            geometryInfo.setCoordinates(this.coordArray);
            if (string.equals("0")) {
                normalGenerator2.generateNormals(geometryInfo);
            } else {
                normalGenerator.generateNormals(geometryInfo);
            }
            Vector3f[] vector3fArray = geometryInfo.getNormals();
            int[] nArray2 = geometryInfo.getNormalIndices();
            int n = 0;
            int n2 = 0;
            while (n2 < arrayList.size()) {
                int n3 = (Integer)arrayList.get(n2);
                int n4 = 0;
                while (n4 < 3) {
                    nArray[n3 + n4] = this.normList.size();
                    this.normList.add(vector3fArray[nArray2[n++]]);
                    ++n4;
                }
                ++n2;
            }
        }
        this.normIdxList = new ArrayList(this.coordIdxList.size());
        int n = 0;
        while (n < this.coordIdxList.size()) {
            this.normIdxList.add(new Integer(nArray[n]));
            ++n;
        }
        this.normArray = this.objectToVectorArray(this.normList);
    }

    private void convertToTriangles() {
        Object object;
        int n;
        boolean bl = (this.flags & 0x80) != 0;
        boolean bl2 = !this.texList.isEmpty() && !this.texIdxList.isEmpty() && this.texIdxList.size() == this.coordIdxList.size();
        boolean bl3 = !this.normList.isEmpty() && !this.normIdxList.isEmpty() && this.normIdxList.size() == this.coordIdxList.size();
        int n2 = this.stripCounts.size();
        boolean bl4 = this.curSgroup != null;
        this.triGroups = new HashMap(50);
        if (bl4) {
            this.triSgroups = new HashMap(50);
        }
        ArrayList arrayList = null;
        ArrayList arrayList2 = null;
        ArrayList arrayList3 = null;
        if (bl) {
            GeometryInfo geometryInfo = new GeometryInfo(5);
            geometryInfo.setStripCounts(this.objectToIntArray(this.stripCounts));
            geometryInfo.setCoordinates(this.coordArray);
            geometryInfo.setCoordinateIndices(this.objectToIntArray(this.coordIdxList));
            if (bl2) {
                geometryInfo.setTextureCoordinateParams(1, 2);
                geometryInfo.setTextureCoordinates(0, this.texArray);
                geometryInfo.setTextureCoordinateIndices(0, this.objectToIntArray(this.texIdxList));
            }
            if (bl3) {
                geometryInfo.setNormals(this.normArray);
                geometryInfo.setNormalIndices(this.objectToIntArray(this.normIdxList));
            }
            geometryInfo.convertToIndexedTriangles();
            int[] nArray = geometryInfo.getCoordinateIndices();
            n = 0;
            int n3 = 0;
            while (n3 < n2) {
                n += (Integer)this.stripCounts.get(n3) - 2;
                ++n3;
            }
            if (nArray.length != n * 3) {
                bl = false;
            } else {
                int[] nArray2 = geometryInfo.getTextureCoordinateIndices();
                object = geometryInfo.getNormalIndices();
                this.coordIdxList.clear();
                this.texIdxList.clear();
                this.normIdxList.clear();
                int n4 = 0;
                while (n4 < nArray.length) {
                    this.coordIdxList.add(new Integer(nArray[n4]));
                    if (bl2) {
                        this.texIdxList.add(new Integer(nArray2[n4]));
                    }
                    if (bl3) {
                        this.normIdxList.add(new Integer(object[n4]));
                    }
                    ++n4;
                }
            }
        }
        if (!bl) {
            arrayList = new ArrayList();
            if (bl2) {
                arrayList2 = new ArrayList();
            }
            if (bl3) {
                arrayList3 = new ArrayList();
            }
        }
        int n5 = 0;
        int n6 = 0;
        while (n6 < n2) {
            int n7;
            n = (Integer)this.stripCounts.get(n6);
            Integer n8 = new Integer(n6);
            this.curGroup = (String)this.groups.get(n8);
            this.curTriGroup = (ArrayList)this.triGroups.get(this.curGroup);
            if (this.curTriGroup == null) {
                this.curTriGroup = new ArrayList();
                this.triGroups.put(this.curGroup, this.curTriGroup);
            }
            if (bl4) {
                this.curSgroup = (String)this.sGroups.get(n8);
                if (this.curSgroup == null) {
                    this.curSgroup = "0";
                }
                this.curTriSgroup = (ArrayList)this.triSgroups.get(this.curSgroup);
                if (this.curTriSgroup == null) {
                    this.curTriSgroup = new ArrayList();
                    this.triSgroups.put(this.curSgroup, this.curTriSgroup);
                }
            }
            if (bl) {
                n7 = 0;
                while (n7 < n - 2) {
                    object = new Integer(n5);
                    this.curTriGroup.add(object);
                    if (bl4) {
                        this.curTriSgroup.add(object);
                    }
                    n5 += 3;
                    ++n7;
                }
            } else {
                n7 = 0;
                while (n7 < n - 2) {
                    object = new Integer(arrayList.size());
                    this.curTriGroup.add(object);
                    if (bl4) {
                        this.curTriSgroup.add(object);
                    }
                    arrayList.add(this.coordIdxList.get(n5));
                    arrayList.add(this.coordIdxList.get(n5 + n7 + 1));
                    arrayList.add(this.coordIdxList.get(n5 + n7 + 2));
                    if (bl2) {
                        arrayList2.add(this.texIdxList.get(n5));
                        arrayList2.add(this.texIdxList.get(n5 + n7 + 1));
                        arrayList2.add(this.texIdxList.get(n5 + n7 + 2));
                    }
                    if (bl3) {
                        arrayList3.add(this.normIdxList.get(n5));
                        arrayList3.add(this.normIdxList.get(n5 + n7 + 1));
                        arrayList3.add(this.normIdxList.get(n5 + n7 + 2));
                    }
                    ++n7;
                }
                n5 += n;
            }
            ++n6;
        }
        this.stripCounts = null;
        this.groups = null;
        this.sGroups = null;
        if (!bl) {
            this.coordIdxList = arrayList;
            this.texIdxList = arrayList2;
            this.normIdxList = arrayList3;
        }
    }

    private SceneBase makeScene() {
        SceneBase sceneBase = new SceneBase();
        BranchGroup branchGroup = new BranchGroup();
        sceneBase.setSceneGroup(branchGroup);
        boolean bl = this.normList.isEmpty() || this.normIdxList.isEmpty() || this.normIdxList.size() != this.coordIdxList.size();
        boolean bl2 = !this.texList.isEmpty() && !this.texIdxList.isEmpty() && this.texIdxList.size() == this.coordIdxList.size();
        this.coordArray = this.objectToPoint3Array(this.coordList);
        if (!bl) {
            this.normArray = this.objectToVectorArray(this.normList);
        }
        if (bl2) {
            this.texArray = this.objectToTexCoord2Array(this.texList);
        }
        this.convertToTriangles();
        if (bl && this.curSgroup != null) {
            this.smoothingGroupNormals();
            bl = false;
        }
        NormalGenerator normalGenerator = null;
        if (bl) {
            normalGenerator = new NormalGenerator(this.radians);
        }
        Stripifier stripifier = null;
        if ((this.flags & 0x200) != 0) {
            stripifier = new Stripifier();
        }
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        Iterator iterator = this.triGroups.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            ArrayList arrayList = (ArrayList)this.triGroups.get(string);
            if (arrayList.size() <= 0) continue;
            GeometryInfo geometryInfo = new GeometryInfo(1);
            geometryInfo.setCoordinateIndices(this.groupIndices(this.coordIdxList, arrayList));
            geometryInfo.setCoordinates(this.coordArray);
            if (bl2) {
                geometryInfo.setTextureCoordinateParams(1, 2);
                geometryInfo.setTextureCoordinates(0, this.texArray);
                geometryInfo.setTextureCoordinateIndices(0, this.groupIndices(this.texIdxList, arrayList));
            }
            if (bl) {
                if ((this.flags & 0x100) != 0) {
                    geometryInfo.reverse();
                }
                normalGenerator.generateNormals(geometryInfo);
            } else {
                geometryInfo.setNormalIndices(this.groupIndices(this.normIdxList, arrayList));
                geometryInfo.setNormals(this.normArray);
                if ((this.flags & 0x100) != 0) {
                    geometryInfo.reverse();
                }
            }
            if ((this.flags & 0x200) != 0) {
                stripifier.stripify(geometryInfo);
            }
            Shape3D shape3D = new Shape3D();
            shape3D.setGeometry((Geometry)geometryInfo.getGeometryArray(true, true, false));
            String string2 = (String)this.groupMaterials.get(string);
            this.materials.assignMaterial(string2, shape3D);
            branchGroup.addChild((Node)shape3D);
            sceneBase.addNamedObject(string, shape3D);
        }
        return sceneBase;
    }

    public Scene load(Reader reader) throws FileNotFoundException, IncorrectFormatException, ParsingErrorException {
        ObjectFileParser objectFileParser = new ObjectFileParser(reader);
        this.coordList = new ArrayList();
        this.texList = new ArrayList();
        this.normList = new ArrayList();
        this.coordIdxList = new ArrayList();
        this.texIdxList = new ArrayList();
        this.normIdxList = new ArrayList();
        this.groups = new HashMap(50);
        this.curGroup = "default";
        this.sGroups = new HashMap(50);
        this.curSgroup = null;
        this.stripCounts = new ArrayList();
        this.groupMaterials = new HashMap(50);
        this.groupMaterials.put(this.curGroup, "default");
        this.materials = new ObjectFileMaterials();
        this.time = 0L;
        this.readFile(objectFileParser);
        if ((this.flags & 0x40) != 0) {
            this.resize();
        }
        return this.makeScene();
    }

    public void setBaseUrl(URL uRL) {
        this.baseUrl = uRL;
    }

    public URL getBaseUrl() {
        return this.baseUrl;
    }

    public void setBasePath(String string) {
        this.basePath = string;
        if (this.basePath == null || this.basePath == "") {
            this.basePath = "." + File.separator;
        }
        this.basePath = this.basePath.replace('/', File.separatorChar);
        this.basePath = this.basePath.replace('\\', File.separatorChar);
        if (!this.basePath.endsWith(File.separator)) {
            this.basePath = this.basePath + File.separator;
        }
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setFlags(int n) {
        this.flags = n;
    }

    public int getFlags() {
        return this.flags;
    }
}

