/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.loaders.objectfile;

import com.sun.j3d.loaders.ParsingErrorException;
import com.sun.j3d.loaders.objectfile.DefaultMaterials;
import com.sun.j3d.loaders.objectfile.ObjectFileParser;
import com.sun.j3d.loaders.objectfile.RgbFile;
import com.sun.j3d.utils.image.TextureLoader;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import javax.media.j3d.Appearance;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.Material;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TexCoordGeneration;
import javax.media.j3d.Texture;
import javax.media.j3d.Texture2D;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Color3f;

class ObjectFileMaterials
implements ImageObserver {
    private static final int DEBUG = 0;
    private String curName = null;
    private ObjectFileMaterial cur = null;
    private HashMap materials;
    private String basePath;
    private boolean fromUrl;

    void assignMaterial(String string, Shape3D shape3D) {
        ObjectFileMaterial objectFileMaterial = null;
        Material material = new Material();
        objectFileMaterial = (ObjectFileMaterial)this.materials.get(string);
        Appearance appearance = new Appearance();
        if (objectFileMaterial != null) {
            if (objectFileMaterial.Ka != null) {
                material.setAmbientColor(objectFileMaterial.Ka);
            }
            if (objectFileMaterial.Kd != null) {
                material.setDiffuseColor(objectFileMaterial.Kd);
            }
            if (objectFileMaterial.Ks != null && objectFileMaterial.illum != 1) {
                material.setSpecularColor(objectFileMaterial.Ks);
            } else if (objectFileMaterial.illum == 1) {
                material.setSpecularColor(0.0f, 0.0f, 0.0f);
            }
            if (objectFileMaterial.illum >= 1) {
                material.setLightingEnable(true);
            } else if (objectFileMaterial.illum == 0) {
                material.setLightingEnable(false);
            }
            if (objectFileMaterial.Ns != -1.0f) {
                material.setShininess(objectFileMaterial.Ns);
            }
            if (objectFileMaterial.t != null) {
                appearance.setTexture((Texture)objectFileMaterial.t);
                if ((((GeometryArray)shape3D.getGeometry()).getVertexFormat() & 0x20) == 0) {
                    TexCoordGeneration texCoordGeneration = new TexCoordGeneration();
                    appearance.setTexCoordGeneration(texCoordGeneration);
                }
            }
            if (objectFileMaterial.transparent) {
                appearance.setTransparencyAttributes(new TransparencyAttributes(1, 0.0f));
            }
        }
        appearance.setMaterial(material);
        shape3D.setAppearance(appearance);
    }

    private void readName(ObjectFileParser objectFileParser) throws ParsingErrorException {
        objectFileParser.getToken();
        if (objectFileParser.ttype == -3) {
            if (this.curName != null) {
                this.materials.put(this.curName, this.cur);
            }
            this.curName = new String(objectFileParser.sval);
            this.cur = new ObjectFileMaterial();
        }
        objectFileParser.skipToNextLine();
    }

    private void readAmbient(ObjectFileParser objectFileParser) throws ParsingErrorException {
        Color3f color3f = new Color3f();
        objectFileParser.getNumber();
        color3f.x = (float)objectFileParser.nval;
        objectFileParser.getNumber();
        color3f.y = (float)objectFileParser.nval;
        objectFileParser.getNumber();
        color3f.z = (float)objectFileParser.nval;
        this.cur.Ka = color3f;
        objectFileParser.skipToNextLine();
    }

    private void readDiffuse(ObjectFileParser objectFileParser) throws ParsingErrorException {
        Color3f color3f = new Color3f();
        objectFileParser.getNumber();
        color3f.x = (float)objectFileParser.nval;
        objectFileParser.getNumber();
        color3f.y = (float)objectFileParser.nval;
        objectFileParser.getNumber();
        color3f.z = (float)objectFileParser.nval;
        this.cur.Kd = color3f;
        objectFileParser.skipToNextLine();
    }

    private void readSpecular(ObjectFileParser objectFileParser) throws ParsingErrorException {
        Color3f color3f = new Color3f();
        objectFileParser.getNumber();
        color3f.x = (float)objectFileParser.nval;
        objectFileParser.getNumber();
        color3f.y = (float)objectFileParser.nval;
        objectFileParser.getNumber();
        color3f.z = (float)objectFileParser.nval;
        this.cur.Ks = color3f;
        objectFileParser.skipToNextLine();
    }

    private void readIllum(ObjectFileParser objectFileParser) throws ParsingErrorException {
        objectFileParser.getNumber();
        this.cur.illum = (int)objectFileParser.nval;
        objectFileParser.skipToNextLine();
    }

    private void readShininess(ObjectFileParser objectFileParser) throws ParsingErrorException {
        objectFileParser.getNumber();
        this.cur.Ns = (float)objectFileParser.nval;
        if (this.cur.Ns < 1.0f) {
            this.cur.Ns = 1.0f;
        } else if (this.cur.Ns > 128.0f) {
            this.cur.Ns = 128.0f;
        }
        objectFileParser.skipToNextLine();
    }

    public void readMapKd(ObjectFileParser objectFileParser) {
        objectFileParser.lowerCaseMode(false);
        String string = null;
        do {
            objectFileParser.getToken();
            if (objectFileParser.ttype != -3) continue;
            string = objectFileParser.sval;
        } while (objectFileParser.ttype != 10);
        objectFileParser.lowerCaseMode(true);
        if (string != null && string.lastIndexOf(46) != -1) {
            try {
                RgbFile rgbFile;
                String string2 = string.substring(string.lastIndexOf(46) + 1).toLowerCase();
                TextureLoader textureLoader = null;
                if (string2.equals("int") || string2.equals("inta") || string2.equals("rgb") || string2.equals("rgba") || string2.equals("bw") || string2.equals("sgi")) {
                    boolean bl;
                    rgbFile = this.fromUrl ? new RgbFile(new URL(this.basePath + string).openStream()) : new RgbFile(new FileInputStream(this.basePath + string));
                    BufferedImage bufferedImage = rgbFile.getImage();
                    boolean bl2 = string2.equals("int") || string2.equals("inta");
                    this.cur.transparent = bl = string2.equals("inta") || string2.equals("rgba");
                    String string3 = null;
                    string3 = bl2 && bl ? "LUM8_ALPHA8" : (bl2 ? "LUMINANCE" : (bl ? "RGBA" : "RGB"));
                    textureLoader = new TextureLoader(bufferedImage, string3, 1);
                } else {
                    textureLoader = this.fromUrl ? new TextureLoader(new URL(this.basePath + string), "RGB", 1, null) : new TextureLoader(this.basePath + string, "RGB", 1, null);
                }
                rgbFile = (Texture2D)textureLoader.getTexture();
                if (rgbFile != null) {
                    this.cur.t = rgbFile;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        objectFileParser.skipToNextLine();
    }

    private void readFile(ObjectFileParser objectFileParser) throws ParsingErrorException {
        objectFileParser.getToken();
        while (objectFileParser.ttype != -1) {
            if (objectFileParser.ttype == -3) {
                if (objectFileParser.sval.equals("newmtl")) {
                    this.readName(objectFileParser);
                } else if (objectFileParser.sval.equals("ka")) {
                    this.readAmbient(objectFileParser);
                } else if (objectFileParser.sval.equals("kd")) {
                    this.readDiffuse(objectFileParser);
                } else if (objectFileParser.sval.equals("ks")) {
                    this.readSpecular(objectFileParser);
                } else if (objectFileParser.sval.equals("illum")) {
                    this.readIllum(objectFileParser);
                } else if (objectFileParser.sval.equals("d")) {
                    objectFileParser.skipToNextLine();
                } else if (objectFileParser.sval.equals("ns")) {
                    this.readShininess(objectFileParser);
                } else if (objectFileParser.sval.equals("tf")) {
                    objectFileParser.skipToNextLine();
                } else if (objectFileParser.sval.equals("sharpness")) {
                    objectFileParser.skipToNextLine();
                } else if (objectFileParser.sval.equals("map_kd")) {
                    this.readMapKd(objectFileParser);
                } else if (objectFileParser.sval.equals("map_ka")) {
                    objectFileParser.skipToNextLine();
                } else if (objectFileParser.sval.equals("map_ks")) {
                    objectFileParser.skipToNextLine();
                } else if (objectFileParser.sval.equals("map_ns")) {
                    objectFileParser.skipToNextLine();
                } else if (objectFileParser.sval.equals("bump")) {
                    objectFileParser.skipToNextLine();
                }
            }
            objectFileParser.skipToNextLine();
            objectFileParser.getToken();
        }
        if (this.curName != null) {
            this.materials.put(this.curName, this.cur);
        }
    }

    void readMaterialFile(boolean bl, String string, String string2) throws ParsingErrorException {
        Reader reader;
        this.basePath = string;
        this.fromUrl = bl;
        try {
            reader = bl ? new InputStreamReader(new BufferedInputStream(new URL(string + string2).openStream())) : new BufferedReader(new FileReader(string + string2));
        }
        catch (IOException iOException) {
            return;
        }
        ObjectFileParser objectFileParser = new ObjectFileParser(reader);
        this.readFile(objectFileParser);
    }

    ObjectFileMaterials() throws ParsingErrorException {
        StringReader stringReader = new StringReader(new DefaultMaterials().materials);
        ObjectFileParser objectFileParser = new ObjectFileParser(stringReader);
        this.materials = new HashMap(50);
        this.readFile(objectFileParser);
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        return (n & 0xA0) == 0;
    }

    private class ObjectFileMaterial {
        public Color3f Ka;
        public Color3f Kd;
        public Color3f Ks;
        public int illum;
        public float Ns;
        public Texture2D t;
        public boolean transparent;

        private ObjectFileMaterial() {
        }

        public void ObjectFileMaterial() {
            this.Ka = null;
            this.Kd = null;
            this.Ks = null;
            this.illum = -1;
            this.Ns = -1.0f;
            this.t = null;
        }
    }
}

