/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d;

import com.sun.j3d.utils.scenegraph.io.retained.Controller;
import com.sun.j3d.utils.scenegraph.io.retained.SymbolTableData;
import com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d.LODState;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.media.j3d.DistanceLOD;
import javax.media.j3d.SceneGraphObject;
import javax.vecmath.Point3f;

public class DistanceLODState
extends LODState {
    private int numDistances;

    public DistanceLODState(SymbolTableData symbolTableData, Controller controller) {
        super(symbolTableData, controller);
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        super.writeObject(dataOutput);
        int n = 0;
        while (n < this.numDistances) {
            dataOutput.writeDouble(((DistanceLOD)this.node).getDistance(n));
            ++n;
        }
        Point3f point3f = new Point3f();
        ((DistanceLOD)this.node).getPosition(point3f);
        this.control.writePoint3f(dataOutput, point3f);
    }

    public void readObject(DataInput dataInput) throws IOException {
        super.readObject(dataInput);
        int n = 0;
        while (n < this.numDistances) {
            ((DistanceLOD)this.node).setDistance(n, dataInput.readDouble());
            ++n;
        }
        ((DistanceLOD)this.node).setPosition(this.control.readPoint3f(dataInput));
    }

    public void writeConstructorParams(DataOutput dataOutput) throws IOException {
        super.writeConstructorParams(dataOutput);
        this.numDistances = ((DistanceLOD)this.node).numDistances();
        dataOutput.writeInt(this.numDistances);
    }

    public void readConstructorParams(DataInput dataInput) throws IOException {
        super.readConstructorParams(dataInput);
        this.numDistances = dataInput.readInt();
    }

    public SceneGraphObject createNode(Class clazz) {
        float[] fArray = new float[this.numDistances];
        return this.createNode(clazz, new Class[]{fArray.getClass()}, new Object[]{fArray});
    }

    protected SceneGraphObject createNode() {
        return new DistanceLOD(new float[this.numDistances]);
    }
}

