/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.universe;

import com.sun.j3d.utils.universe.ConfigCommand;
import com.sun.j3d.utils.universe.ConfigContainer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

class ConfigObject {
    String baseName = null;
    String instanceName = null;
    Object targetObject = null;
    String targetClassName = null;
    Class targetClass = null;
    List properties = new ArrayList();
    ConfigContainer configContainer = null;
    ConfigCommand creatingCommand = null;
    boolean isAlias = false;
    ConfigObject original = null;
    List aliases = new ArrayList();

    ConfigObject() {
    }

    protected void initialize(ConfigCommand configCommand) {
        if (configCommand.argc != 3) {
            this.syntaxError("Wrong number of arguments to " + configCommand.commandName);
        }
        if (!this.isName(configCommand.argv[1])) {
            this.syntaxError("The first argument to " + configCommand.commandName + " must be the instance name");
        }
        if (!this.isName(configCommand.argv[2])) {
            this.syntaxError("The second argument to " + configCommand.commandName + " must be the class name");
        }
        this.targetClassName = (String)configCommand.argv[2];
    }

    protected void setProperty(ConfigCommand configCommand) {
        if (configCommand.argc < 4) {
            this.syntaxError("Wrong number of arguments to " + configCommand.commandName);
        }
        if (!this.isName(configCommand.argv[1])) {
            this.syntaxError("The first argument to " + configCommand.commandName + " must be the instance name");
        }
        if (!this.isName(configCommand.argv[2])) {
            this.syntaxError("The second argument to " + configCommand.commandName + " must be the property name");
        }
        this.properties.add(configCommand);
    }

    protected Object createTargetObject() {
        if (this.targetClassName == null) {
            return null;
        }
        this.targetClass = this.getClassForName(this.creatingCommand, this.targetClassName);
        this.targetObject = this.getNewInstance(this.creatingCommand, this.targetClass);
        return this.targetObject;
    }

    protected Class getClassForName(ConfigCommand configCommand, String string) {
        try {
            return Class.forName(string, true, ClassLoader.getSystemClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException(ConfigObject.errorMessage(configCommand, "Class \"" + string + "\" not found"));
        }
    }

    protected Object getNewInstance(ConfigCommand configCommand, Class clazz) {
        try {
            return clazz.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException(ConfigObject.errorMessage(configCommand, "Illegal access to object class"));
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalArgumentException(ConfigObject.errorMessage(configCommand, "Instantiation error for object class"));
        }
    }

    protected void processProperties() {
        this.evaluateProperties(this.targetClass, this.targetObject, this.properties);
        this.properties.clear();
    }

    protected void evaluateProperties(Class clazz, Object object, List list) {
        Object[] objectArray = new Object[1];
        Class[] classArray = new Class[]{objectArray.getClass()};
        int n = 0;
        while (n < list.size()) {
            Object object2;
            ConfigCommand configCommand = (ConfigCommand)list.get(n);
            String string = (String)configCommand.argv[2];
            Object[] objectArray2 = new Object[configCommand.argc - 3];
            int n2 = 0;
            while (n2 < objectArray2.length) {
                objectArray2[n2] = configCommand.argv[n2 + 3];
                if (objectArray2[n2] instanceof ConfigCommand) {
                    object2 = (ConfigCommand)objectArray2[n2];
                    objectArray2[n2] = this.configContainer.evaluateBuiltIn((ConfigCommand)object2);
                }
                ++n2;
            }
            objectArray[0] = objectArray2;
            try {
                object2 = clazz.getMethod(string, classArray);
                ((Method)object2).invoke(object, objectArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new IllegalArgumentException(ConfigObject.errorMessage(configCommand, "Unknown property \"" + string + "\""));
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalArgumentException(ConfigObject.errorMessage(configCommand, "Illegal access to \"" + string + "\""));
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new IllegalArgumentException(ConfigObject.errorMessage(configCommand, invocationTargetException.getTargetException().getMessage()));
            }
            ++n;
        }
    }

    protected void syntaxError(String string) {
        throw new IllegalArgumentException(string);
    }

    static String errorMessage(ConfigCommand configCommand, String string) {
        return "\n" + string + "\nat line " + configCommand.lineNumber + " in " + configCommand.fileName + "\n" + configCommand + "\n";
    }

    protected boolean isName(Object object) {
        return object instanceof String;
    }
}

