/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.universe;

import com.sun.j3d.audioengines.headspace.HeadspaceMixer;
import com.sun.j3d.utils.universe.ConfigScreen;
import com.sun.j3d.utils.universe.ConfigView;
import com.sun.j3d.utils.universe.ConfiguredUniverse;
import com.sun.j3d.utils.universe.SimpleUniverse;
import com.sun.j3d.utils.universe.ViewerAvatar;
import com.sun.j3d.utils.universe.ViewingPlatform;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GraphicsConfigTemplate;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.HashMap;
import javax.media.j3d.AudioDevice;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.PhysicalBody;
import javax.media.j3d.PhysicalEnvironment;
import javax.media.j3d.Screen3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.View;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JWindow;

public class Viewer {
    private static final boolean debug = false;
    private static PhysicalBody physicalBody = null;
    private static PhysicalEnvironment physicalEnvironment = null;
    private View view;
    private ViewerAvatar avatar;
    private Canvas3D[] canvases;
    private JFrame[] j3dJFrames;
    private JPanel[] j3dJPanels;
    private Window[] j3dWindows;
    private ViewingPlatform viewingPlatform;
    static HashMap viewerMap = new HashMap(5);
    private float dvrFactor;
    private boolean doDvr;
    private boolean doDvrResizeCompensation;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Viewer getViewer(View view) {
        Viewer viewer = null;
        HashMap hashMap = viewerMap;
        synchronized (hashMap) {
            viewer = (Viewer)viewerMap.get(view);
        }
        return viewer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Viewer removeViewerMapEntry(View view) {
        Viewer viewer = null;
        HashMap hashMap = viewerMap;
        synchronized (hashMap) {
            viewer = (Viewer)viewerMap.remove(view);
        }
        return viewer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearViewerMap() {
        HashMap hashMap = viewerMap;
        synchronized (hashMap) {
            viewerMap.clear();
        }
    }

    public boolean isDvrEnabled() {
        return this.doDvr;
    }

    public void setDvrEnable(boolean bl) {
        this.doDvr = bl;
        this.view.repaint();
    }

    public float getDvrFactor() {
        return this.dvrFactor;
    }

    public void setDvrFactor(float f) {
        this.dvrFactor = f;
        this.view.repaint();
    }

    public void setDvrResizeCompensationEnable(boolean bl) {
        this.doDvrResizeCompensation = bl;
        this.view.repaint();
    }

    public boolean getDvrResizeCompensationEnable() {
        return this.doDvrResizeCompensation;
    }

    public Viewer() {
        this(null, null, null, true);
    }

    public Viewer(Canvas3D canvas3D) {
        Canvas3D[] canvas3DArray;
        if (canvas3D == null) {
            canvas3DArray = null;
        } else {
            Canvas3D[] canvas3DArray2 = new Canvas3D[1];
            canvas3DArray = canvas3DArray2;
            canvas3DArray2[0] = canvas3D;
        }
        this(canvas3DArray, null, null, true);
    }

    public Viewer(Canvas3D[] canvas3DArray) {
        this(canvas3DArray, null, null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Viewer(Canvas3D[] canvas3DArray, PhysicalBody physicalBody, PhysicalEnvironment physicalEnvironment, boolean bl) {
        this.view = null;
        this.avatar = null;
        this.canvases = null;
        this.j3dJFrames = null;
        this.j3dJPanels = null;
        this.j3dWindows = null;
        this.viewingPlatform = null;
        this.dvrFactor = 1.0f;
        this.doDvr = false;
        this.doDvrResizeCompensation = true;
        Viewer.physicalBody = physicalBody == null ? new PhysicalBody() : physicalBody;
        Viewer.physicalEnvironment = physicalEnvironment == null ? new PhysicalEnvironment() : physicalEnvironment;
        if (canvas3DArray == null) {
            GraphicsConfiguration graphicsConfiguration = ConfiguredUniverse.getPreferredConfiguration();
            this.canvases = new Canvas3D[1];
            this.canvases[0] = new Canvas3D(graphicsConfiguration);
            try {
                this.canvases[0].setFocusable(true);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            this.createFramesAndPanels(bl);
        } else {
            this.canvases = new Canvas3D[canvas3DArray.length];
            int n = 0;
            while (n < canvas3DArray.length) {
                this.canvases[n] = canvas3DArray[n];
                try {
                    this.canvases[n].setFocusable(true);
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
                ++n;
            }
        }
        this.view = new View();
        HashMap hashMap = viewerMap;
        synchronized (hashMap) {
            viewerMap.put(this.view, this);
        }
        int n = 0;
        while (n < this.canvases.length) {
            this.view.addCanvas3D(this.canvases[n]);
            ++n;
        }
        this.view.setPhysicalBody(Viewer.physicalBody);
        this.view.setPhysicalEnvironment(Viewer.physicalEnvironment);
    }

    public Viewer(URL uRL) {
        this(null, uRL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Viewer(Canvas3D canvas3D, URL uRL) {
        Object object;
        this.view = null;
        this.avatar = null;
        this.canvases = null;
        this.j3dJFrames = null;
        this.j3dJPanels = null;
        this.j3dWindows = null;
        this.viewingPlatform = null;
        this.dvrFactor = 1.0f;
        this.doDvr = false;
        this.doDvrResizeCompensation = true;
        if (physicalBody == null) {
            physicalBody = new PhysicalBody();
        }
        if (physicalEnvironment == null) {
            physicalEnvironment = new PhysicalEnvironment();
        }
        if (canvas3D == null) {
            object = SimpleUniverse.getPreferredConfiguration();
            this.canvases = new Canvas3D[1];
            this.canvases[0] = new Canvas3D((GraphicsConfiguration)object);
            this.createFramesAndPanels(true);
        } else {
            this.canvases = new Canvas3D[1];
            this.canvases[0] = canvas3D;
        }
        try {
            this.canvases[0].setFocusable(true);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        this.view = new View();
        object = viewerMap;
        synchronized (object) {
            viewerMap.put(this.view, this);
        }
        this.view.addCanvas3D(this.canvases[0]);
        this.view.setPhysicalBody(physicalBody);
        this.view.setPhysicalEnvironment(physicalEnvironment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Viewer(ConfigScreen[] configScreenArray, ConfigView configView, boolean bl) {
        this.view = null;
        this.avatar = null;
        this.canvases = null;
        this.j3dJFrames = null;
        this.j3dJPanels = null;
        this.j3dWindows = null;
        this.viewingPlatform = null;
        this.dvrFactor = 1.0f;
        this.doDvr = false;
        this.doDvrResizeCompensation = true;
        this.view = configView.j3dView;
        HashMap hashMap = viewerMap;
        synchronized (hashMap) {
            viewerMap.put(this.view, this);
        }
        physicalBody = configView.physicalBody;
        physicalEnvironment = configView.physicalEnvironment;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        if (graphicsDeviceArray == null) {
            throw new RuntimeException("\nNo screen devices available in local environment");
        }
        this.canvases = new Canvas3D[configScreenArray.length];
        this.j3dJFrames = new JFrame[configScreenArray.length];
        this.j3dJPanels = new JPanel[configScreenArray.length];
        this.j3dWindows = new Window[configScreenArray.length];
        GraphicsConfigTemplate3D graphicsConfigTemplate3D = new GraphicsConfigTemplate3D();
        if (configView.stereoEnable) {
            graphicsConfigTemplate3D.setStereo(2);
        }
        if (configView.antialiasingEnable) {
            graphicsConfigTemplate3D.setSceneAntialiasing(2);
        }
        int n = 0;
        while (n < configScreenArray.length) {
            Container container;
            if (configScreenArray[n].frameBufferNumber >= graphicsDeviceArray.length) {
                throw new ArrayIndexOutOfBoundsException(ConfigScreen.errorMessage(configScreenArray[n].creatingCommand, "Screen " + configScreenArray[n].frameBufferNumber + " is invalid; " + (graphicsDeviceArray.length - 1) + " is the maximum local index."));
            }
            GraphicsConfiguration graphicsConfiguration = graphicsDeviceArray[configScreenArray[n].frameBufferNumber].getBestConfiguration((GraphicsConfigTemplate)graphicsConfigTemplate3D);
            if (graphicsConfiguration == null) {
                throw new RuntimeException("\nNo GraphicsConfiguration on screen " + configScreenArray[n].frameBufferNumber + " conforms to template");
            }
            Rectangle rectangle = graphicsConfiguration.getBounds();
            configScreenArray[n].j3dJFrame = this.j3dJFrames[n] = new JFrame(configScreenArray[n].instanceName, graphicsConfiguration);
            if (configScreenArray[n].noBorderFullScreen) {
                try {
                    this.j3dJFrames[n].setUndecorated(true);
                    configScreenArray[n].j3dWindow = this.j3dWindows[n] = this.j3dJFrames[n];
                    container = this.j3dJFrames[n].getContentPane();
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    JWindow jWindow = new JWindow(this.j3dJFrames[n], graphicsConfiguration);
                    configScreenArray[n].j3dWindow = this.j3dWindows[n] = jWindow;
                    container = jWindow.getContentPane();
                }
                container.setLayout(new BorderLayout());
                this.j3dWindows[n].setSize(rectangle.width, rectangle.height);
                this.j3dWindows[n].setLocation(rectangle.x, rectangle.y);
            } else {
                configScreenArray[n].j3dWindow = this.j3dWindows[n] = this.j3dJFrames[n];
                container = this.j3dJFrames[n].getContentPane();
                container.setLayout(new BorderLayout());
                if (configScreenArray[n].fullScreen) {
                    this.j3dWindows[n].setSize(rectangle.width, rectangle.height);
                    this.j3dWindows[n].setLocation(rectangle.x, rectangle.y);
                } else {
                    this.j3dWindows[n].setSize(configScreenArray[n].windowWidthInPixels, configScreenArray[n].windowHeightInPixels);
                    this.j3dWindows[n].setLocation(rectangle.x + configScreenArray[n].windowX, rectangle.y + configScreenArray[n].windowY);
                }
            }
            configScreenArray[n].j3dCanvas = this.canvases[n] = new Canvas3D(graphicsConfiguration);
            this.canvases[n].setStereoEnable(configView.stereoEnable);
            this.canvases[n].setMonoscopicViewPolicy(configScreenArray[n].monoscopicViewPolicy);
            Screen3D screen3D = this.canvases[n].getScreen3D();
            if (configScreenArray[n].physicalScreenWidth != 0.0) {
                screen3D.setPhysicalScreenWidth(configScreenArray[n].physicalScreenWidth);
            }
            if (configScreenArray[n].physicalScreenHeight != 0.0) {
                screen3D.setPhysicalScreenHeight(configScreenArray[n].physicalScreenHeight);
            }
            if (configScreenArray[n].trackerBaseToImagePlate != null) {
                screen3D.setTrackerBaseToImagePlate(new Transform3D(configScreenArray[n].trackerBaseToImagePlate));
            }
            if (configScreenArray[n].headTrackerToLeftImagePlate != null) {
                screen3D.setHeadTrackerToLeftImagePlate(new Transform3D(configScreenArray[n].headTrackerToLeftImagePlate));
            }
            if (configScreenArray[n].headTrackerToRightImagePlate != null) {
                screen3D.setHeadTrackerToRightImagePlate(new Transform3D(configScreenArray[n].headTrackerToRightImagePlate));
            }
            configScreenArray[n].j3dJPanel = this.j3dJPanels[n] = new JPanel();
            this.j3dJPanels[n].setLayout(new BorderLayout());
            this.j3dJPanels[n].add("Center", (Component)this.canvases[n]);
            container.add("Center", this.j3dJPanels[n]);
            this.view.addCanvas3D(this.canvases[n]);
            this.addWindowCloseListener(this.j3dWindows[n]);
            try {
                this.canvases[n].setFocusable(true);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            ++n;
        }
        if (bl) {
            this.setVisible(true);
        }
    }

    private void createFramesAndPanels(boolean bl) {
        this.j3dJFrames = new JFrame[this.canvases.length];
        this.j3dJPanels = new JPanel[this.canvases.length];
        this.j3dWindows = new Window[this.canvases.length];
        int n = 0;
        while (n < this.canvases.length) {
            this.j3dJFrames[n] = new JFrame();
            this.j3dWindows[n] = this.j3dJFrames[n];
            this.j3dJFrames[n].getContentPane().setLayout(new BorderLayout());
            this.j3dJFrames[n].setSize(256, 256);
            this.j3dJPanels[n] = new JPanel();
            this.j3dJPanels[n].setLayout(new BorderLayout());
            this.j3dJPanels[n].add("Center", (Component)this.canvases[n]);
            this.j3dJFrames[n].getContentPane().add("Center", this.j3dJPanels[n]);
            if (bl) {
                this.j3dJFrames[n].setVisible(true);
            }
            this.addWindowCloseListener(this.j3dJFrames[n]);
            ++n;
        }
    }

    public void setVisible(boolean bl) {
        int n = 0;
        while (n < this.j3dWindows.length) {
            this.j3dWindows[n].setVisible(bl);
            ++n;
        }
    }

    public View getView() {
        return this.view;
    }

    public void setViewingPlatform(ViewingPlatform viewingPlatform) {
        if (this.viewingPlatform != null) {
            this.viewingPlatform.removeViewer(this);
        }
        this.viewingPlatform = viewingPlatform;
        if (viewingPlatform != null) {
            this.view.attachViewPlatform(viewingPlatform.getViewPlatform());
            viewingPlatform.addViewer(this);
            if (this.avatar != null) {
                this.viewingPlatform.setAvatar(this, this.avatar);
            }
        } else {
            this.view.attachViewPlatform(null);
        }
    }

    public ViewingPlatform getViewingPlatform() {
        return this.viewingPlatform;
    }

    public void setAvatar(ViewerAvatar viewerAvatar) {
        if (this.avatar == viewerAvatar) {
            return;
        }
        this.avatar = viewerAvatar;
        if (this.viewingPlatform != null) {
            this.viewingPlatform.setAvatar(this, this.avatar);
        }
    }

    public ViewerAvatar getAvatar() {
        return this.avatar;
    }

    public PhysicalBody getPhysicalBody() {
        return physicalBody;
    }

    public PhysicalEnvironment getPhysicalEnvironment() {
        return physicalEnvironment;
    }

    public Canvas3D getCanvas3D() {
        return this.canvases[0];
    }

    public Canvas3D getCanvas3D(int n) {
        if (n > this.canvases.length) {
            return null;
        }
        return this.canvases[n];
    }

    public Canvas3D[] getCanvas3Ds() {
        Canvas3D[] canvas3DArray = new Canvas3D[this.canvases.length];
        int n = 0;
        while (n < this.canvases.length) {
            canvas3DArray[n] = this.canvases[n];
            ++n;
        }
        return canvas3DArray;
    }

    public Canvas3D getCanvases() {
        return this.getCanvas3D();
    }

    public Frame getFrame() {
        throw new UnsupportedOperationException("\nAWT Frame components are not created by the Viewer class");
    }

    public JFrame getJFrame(int n) {
        if (this.j3dJFrames == null || n > this.j3dJFrames.length) {
            return null;
        }
        return this.j3dJFrames[n];
    }

    public JFrame[] getJFrames() {
        if (this.j3dJFrames == null) {
            return null;
        }
        JFrame[] jFrameArray = new JFrame[this.j3dJFrames.length];
        int n = 0;
        while (n < this.j3dJFrames.length) {
            jFrameArray[n] = this.j3dJFrames[n];
            ++n;
        }
        return jFrameArray;
    }

    public Panel getPanel() {
        throw new UnsupportedOperationException("\nAWT Panel components are not created by the Viewer class");
    }

    public JPanel getJPanel(int n) {
        if (this.j3dJPanels == null || n > this.j3dJPanels.length) {
            return null;
        }
        return this.j3dJPanels[n];
    }

    public JPanel[] getJPanels() {
        if (this.j3dJPanels == null) {
            return null;
        }
        JPanel[] jPanelArray = new JPanel[this.j3dJPanels.length];
        int n = 0;
        while (n < this.j3dJPanels.length) {
            jPanelArray[n] = this.j3dJPanels[n];
            ++n;
        }
        return jPanelArray;
    }

    public AudioDevice createAudioDevice() {
        if (physicalEnvironment != null) {
            HeadspaceMixer headspaceMixer = new HeadspaceMixer(physicalEnvironment);
            headspaceMixer.initialize();
            return headspaceMixer;
        }
        return null;
    }

    public SimpleUniverse getUniverse() {
        return this.getViewingPlatform().getUniverse();
    }

    void addWindowCloseListener(Window window) {
        SecurityManager securityManager = System.getSecurityManager();
        boolean bl = true;
        if (securityManager != null) {
            try {
                securityManager.checkExit(0);
            }
            catch (SecurityException securityException) {
                bl = false;
            }
        }
        final boolean bl2 = bl;
        window.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Window window = windowEvent.getWindow();
                window.hide();
                try {
                    window.dispose();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                if (bl2) {
                    System.exit(0);
                }
            }
        });
    }
}

