/*
 * Decompiled with CFR 0.152.
 */
package ij.measure;

public class SplineFitter {
    private double[] y2;

    public SplineFitter(int[] x, int[] y, int n) {
        this.initSpline(x, y, n);
    }

    public SplineFitter(float[] x, float[] y, int n) {
        this.initSpline(x, y, n);
    }

    void initSpline(int[] x, int[] y, int n) {
        this.y2 = new double[n];
        double[] u = new double[n];
        for (int i = 1; i < n - 1; ++i) {
            double sig = ((double)x[i] - (double)x[i - 1]) / ((double)x[i + 1] - (double)x[i - 1]);
            double p = sig * this.y2[i - 1] + 2.0;
            this.y2[i] = (sig - 1.0) / p;
            u[i] = ((double)y[i + 1] - (double)y[i]) / (double)(x[i + 1] - x[i]) - ((double)y[i] - (double)y[i - 1]) / (double)(x[i] - x[i - 1]);
            u[i] = (6.0 * u[i] / (double)(x[i + 1] - x[i - 1]) - sig * u[i - 1]) / p;
        }
        double un = 0.0;
        double qn = 0.0;
        this.y2[n - 1] = (un - qn * u[n - 2]) / (qn * this.y2[n - 2] + 1.0);
        for (int k = n - 2; k >= 0; --k) {
            this.y2[k] = this.y2[k] * this.y2[k + 1] + u[k];
        }
    }

    void initSpline(float[] x, float[] y, int n) {
        this.y2 = new double[n];
        double[] u = new double[n];
        for (int i = 1; i < n - 1; ++i) {
            double sig = ((double)x[i] - (double)x[i - 1]) / ((double)x[i + 1] - (double)x[i - 1]);
            double p = sig * this.y2[i - 1] + 2.0;
            this.y2[i] = (sig - 1.0) / p;
            u[i] = ((double)y[i + 1] - (double)y[i]) / (double)(x[i + 1] - x[i]) - ((double)y[i] - (double)y[i - 1]) / (double)(x[i] - x[i - 1]);
            u[i] = (6.0 * u[i] / (double)(x[i + 1] - x[i - 1]) - sig * u[i - 1]) / p;
        }
        double un = 0.0;
        double qn = 0.0;
        this.y2[n - 1] = (un - qn * u[n - 2]) / (qn * this.y2[n - 2] + 1.0);
        for (int k = n - 2; k >= 0; --k) {
            this.y2[k] = this.y2[k] * this.y2[k + 1] + u[k];
        }
    }

    public double evalSpline(int[] x, int[] y, int n, double xp) {
        int klo = 0;
        int khi = n - 1;
        while (khi - klo > 1) {
            int k = khi + klo >> 1;
            if ((double)x[k] > xp) {
                khi = k;
                continue;
            }
            klo = k;
        }
        double h = x[khi] - x[klo];
        if (h == 0.0) {
            return 0.0;
        }
        double a = ((double)x[khi] - xp) / h;
        double b = (xp - (double)x[klo]) / h;
        if (this.y2 == null) {
            return 0.0;
        }
        return a * (double)y[klo] + b * (double)y[khi] + ((a * a * a - a) * this.y2[klo] + (b * b * b - b) * this.y2[khi]) * (h * h) / 6.0;
    }

    public double evalSpline(float[] x, float[] y, int n, double xp) {
        int klo = 0;
        int khi = n - 1;
        while (khi - klo > 1) {
            int k = khi + klo >> 1;
            if ((double)x[k] > xp) {
                khi = k;
                continue;
            }
            klo = k;
        }
        double h = x[khi] - x[klo];
        if (h == 0.0) {
            return 0.0;
        }
        double a = ((double)x[khi] - xp) / h;
        double b = (xp - (double)x[klo]) / h;
        if (this.y2 == null) {
            return 0.0;
        }
        return a * (double)y[klo] + b * (double)y[khi] + ((a * a * a - a) * this.y2[klo] + (b * b * b - b) * this.y2[khi]) * (h * h) / 6.0;
    }
}

