/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import java.util.ArrayList;

public class Skeletonize3D
implements PlugInFilter {
    private ImagePlus imRef;
    private int width = 0;
    private int height = 0;
    private int depth = 0;
    private ImageStack inputImage = null;

    public int setup(String arg, ImagePlus imp) {
        this.imRef = imp;
        return 1 + (imp != null & imp.getStackSize() > 1 ? 128 : 0);
    }

    public void run(ImageProcessor ip) {
        this.width = this.imRef.getWidth();
        this.height = this.imRef.getHeight();
        this.depth = this.imRef.getStackSize();
        this.inputImage = this.imRef.getStack();
        this.prepareData(this.inputImage);
        this.computeThinImage(this.inputImage);
        for (int i = 1; i <= this.inputImage.getSize(); ++i) {
            this.inputImage.getProcessor(i).multiply(255.0);
        }
        this.imRef.updateAndDraw();
    }

    private void prepareData(ImageStack outputImage) {
        IJ.showStatus("Prepare Data: Copy input to output ...");
        for (int z = 0; z < this.depth; ++z) {
            for (int x = 0; x < this.width; ++x) {
                for (int y = 0; y < this.height; ++y) {
                    if (((byte[])this.inputImage.getPixels(z + 1))[x + y * this.width] == 0) continue;
                    ((byte[])outputImage.getPixels((int)(z + 1)))[x + y * this.width] = 1;
                }
            }
        }
        IJ.showStatus("Prepare Data End.");
    }

    void computeThinImage(ImageStack outputImage) {
        IJ.showStatus("Computing thin image ...");
        ArrayList<int[]> simpleBorderPoints = new ArrayList<int[]>();
        int[] eulerLUT = new int[256];
        this.fillEulerLUT(eulerLUT);
        int iter = 1;
        int unchangedBorders = 0;
        while (unchangedBorders < 6) {
            unchangedBorders = 0;
            for (int currentBorder = 1; currentBorder <= 6; ++currentBorder) {
                IJ.showStatus("Thinning iteration " + iter + " (" + currentBorder + "/6 borders) ...");
                for (int z = 0; z < this.depth; ++z) {
                    for (int y = 0; y < this.height; ++y) {
                        for (int x = 0; x < this.width; ++x) {
                            if (this.getPixel(outputImage, x, y, z) != 1) continue;
                            boolean isBorderPoint = false;
                            if (currentBorder == 1 && this.N(outputImage, x, y, z) <= 0) {
                                isBorderPoint = true;
                            }
                            if (currentBorder == 2 && this.S(outputImage, x, y, z) <= 0) {
                                isBorderPoint = true;
                            }
                            if (currentBorder == 3 && this.E(outputImage, x, y, z) <= 0) {
                                isBorderPoint = true;
                            }
                            if (currentBorder == 4 && this.W(outputImage, x, y, z) <= 0) {
                                isBorderPoint = true;
                            }
                            if (currentBorder == 5 && this.U(outputImage, x, y, z) <= 0) {
                                isBorderPoint = true;
                            }
                            if (currentBorder == 6 && this.B(outputImage, x, y, z) <= 0) {
                                isBorderPoint = true;
                            }
                            if (!isBorderPoint) continue;
                            int numberOfNeighbors = -1;
                            byte[] neighbor = this.getNeighborhood(outputImage, x, y, z);
                            for (int i = 0; i < 27; ++i) {
                                if (neighbor[i] != 1) continue;
                                ++numberOfNeighbors;
                            }
                            if (numberOfNeighbors == 1 || !this.isEulerInvariant(this.getNeighborhood(outputImage, x, y, z), eulerLUT) || !this.isSimplePoint(this.getNeighborhood(outputImage, x, y, z))) continue;
                            int[] index = new int[]{x, y, z};
                            simpleBorderPoints.add(index);
                        }
                    }
                    IJ.showProgress(z, this.depth);
                }
                boolean noChange = true;
                int[] index = null;
                for (int i = 0; i < simpleBorderPoints.size(); ++i) {
                    index = (int[])simpleBorderPoints.get(i);
                    this.setPixel(outputImage, index[0], index[1], index[2], (byte)0);
                    if (!this.isSimplePoint(this.getNeighborhood(outputImage, index[0], index[1], index[2]))) {
                        this.setPixel(outputImage, index[0], index[1], index[2], (byte)1);
                        continue;
                    }
                    noChange = false;
                }
                if (noChange) {
                    ++unchangedBorders;
                }
                simpleBorderPoints.clear();
            }
            ++iter;
        }
    }

    private byte[] getNeighborhood(ImageStack image, int x, int y, int z) {
        byte[] neighborhood = new byte[]{this.getPixel(image, x - 1, y - 1, z - 1), this.getPixel(image, x, y - 1, z - 1), this.getPixel(image, x + 1, y - 1, z - 1), this.getPixel(image, x - 1, y, z - 1), this.getPixel(image, x, y, z - 1), this.getPixel(image, x + 1, y, z - 1), this.getPixel(image, x - 1, y + 1, z - 1), this.getPixel(image, x, y + 1, z - 1), this.getPixel(image, x + 1, y + 1, z - 1), this.getPixel(image, x - 1, y - 1, z), this.getPixel(image, x, y - 1, z), this.getPixel(image, x + 1, y - 1, z), this.getPixel(image, x - 1, y, z), this.getPixel(image, x, y, z), this.getPixel(image, x + 1, y, z), this.getPixel(image, x - 1, y + 1, z), this.getPixel(image, x, y + 1, z), this.getPixel(image, x + 1, y + 1, z), this.getPixel(image, x - 1, y - 1, z + 1), this.getPixel(image, x, y - 1, z + 1), this.getPixel(image, x + 1, y - 1, z + 1), this.getPixel(image, x - 1, y, z + 1), this.getPixel(image, x, y, z + 1), this.getPixel(image, x + 1, y, z + 1), this.getPixel(image, x - 1, y + 1, z + 1), this.getPixel(image, x, y + 1, z + 1), this.getPixel(image, x + 1, y + 1, z + 1)};
        return neighborhood;
    }

    private byte getPixel(ImageStack image, int x, int y, int z) {
        if (x >= 0 && x < this.width && y >= 0 && y < this.height && z >= 0 && z < this.depth) {
            return ((byte[])image.getPixels(z + 1))[x + y * this.width];
        }
        return 0;
    }

    private void setPixel(ImageStack image, int x, int y, int z, byte value) {
        if (x >= 0 && x < this.width && y >= 0 && y < this.height && z >= 0 && z < this.depth) {
            ((byte[])image.getPixels((int)(z + 1)))[x + y * this.width] = value;
        }
    }

    private byte N(ImageStack image, int x, int y, int z) {
        return this.getPixel(image, x, y - 1, z);
    }

    private byte S(ImageStack image, int x, int y, int z) {
        return this.getPixel(image, x, y + 1, z);
    }

    private byte E(ImageStack image, int x, int y, int z) {
        return this.getPixel(image, x + 1, y, z);
    }

    private byte W(ImageStack image, int x, int y, int z) {
        return this.getPixel(image, x - 1, y, z);
    }

    private byte U(ImageStack image, int x, int y, int z) {
        return this.getPixel(image, x, y, z + 1);
    }

    private byte B(ImageStack image, int x, int y, int z) {
        return this.getPixel(image, x, y, z - 1);
    }

    private void fillEulerLUT(int[] LUT2) {
        LUT2[1] = 1;
        LUT2[3] = -1;
        LUT2[5] = -1;
        LUT2[7] = 1;
        LUT2[9] = -3;
        LUT2[11] = -1;
        LUT2[13] = -1;
        LUT2[15] = 1;
        LUT2[17] = -1;
        LUT2[19] = 1;
        LUT2[21] = 1;
        LUT2[23] = -1;
        LUT2[25] = 3;
        LUT2[27] = 1;
        LUT2[29] = 1;
        LUT2[31] = -1;
        LUT2[33] = -3;
        LUT2[35] = -1;
        LUT2[37] = 3;
        LUT2[39] = 1;
        LUT2[41] = 1;
        LUT2[43] = -1;
        LUT2[45] = 3;
        LUT2[47] = 1;
        LUT2[49] = -1;
        LUT2[51] = 1;
        LUT2[53] = 1;
        LUT2[55] = -1;
        LUT2[57] = 3;
        LUT2[59] = 1;
        LUT2[61] = 1;
        LUT2[63] = -1;
        LUT2[65] = -3;
        LUT2[67] = 3;
        LUT2[69] = -1;
        LUT2[71] = 1;
        LUT2[73] = 1;
        LUT2[75] = 3;
        LUT2[77] = -1;
        LUT2[79] = 1;
        LUT2[81] = -1;
        LUT2[83] = 1;
        LUT2[85] = 1;
        LUT2[87] = -1;
        LUT2[89] = 3;
        LUT2[91] = 1;
        LUT2[93] = 1;
        LUT2[95] = -1;
        LUT2[97] = 1;
        LUT2[99] = 3;
        LUT2[101] = 3;
        LUT2[103] = 1;
        LUT2[105] = 5;
        LUT2[107] = 3;
        LUT2[109] = 3;
        LUT2[111] = 1;
        LUT2[113] = -1;
        LUT2[115] = 1;
        LUT2[117] = 1;
        LUT2[119] = -1;
        LUT2[121] = 3;
        LUT2[123] = 1;
        LUT2[125] = 1;
        LUT2[127] = -1;
        LUT2[129] = -7;
        LUT2[131] = -1;
        LUT2[133] = -1;
        LUT2[135] = 1;
        LUT2[137] = -3;
        LUT2[139] = -1;
        LUT2[141] = -1;
        LUT2[143] = 1;
        LUT2[145] = -1;
        LUT2[147] = 1;
        LUT2[149] = 1;
        LUT2[151] = -1;
        LUT2[153] = 3;
        LUT2[155] = 1;
        LUT2[157] = 1;
        LUT2[159] = -1;
        LUT2[161] = -3;
        LUT2[163] = -1;
        LUT2[165] = 3;
        LUT2[167] = 1;
        LUT2[169] = 1;
        LUT2[171] = -1;
        LUT2[173] = 3;
        LUT2[175] = 1;
        LUT2[177] = -1;
        LUT2[179] = 1;
        LUT2[181] = 1;
        LUT2[183] = -1;
        LUT2[185] = 3;
        LUT2[187] = 1;
        LUT2[189] = 1;
        LUT2[191] = -1;
        LUT2[193] = -3;
        LUT2[195] = 3;
        LUT2[197] = -1;
        LUT2[199] = 1;
        LUT2[201] = 1;
        LUT2[203] = 3;
        LUT2[205] = -1;
        LUT2[207] = 1;
        LUT2[209] = -1;
        LUT2[211] = 1;
        LUT2[213] = 1;
        LUT2[215] = -1;
        LUT2[217] = 3;
        LUT2[219] = 1;
        LUT2[221] = 1;
        LUT2[223] = -1;
        LUT2[225] = 1;
        LUT2[227] = 3;
        LUT2[229] = 3;
        LUT2[231] = 1;
        LUT2[233] = 5;
        LUT2[235] = 3;
        LUT2[237] = 3;
        LUT2[239] = 1;
        LUT2[241] = -1;
        LUT2[243] = 1;
        LUT2[245] = 1;
        LUT2[247] = -1;
        LUT2[249] = 3;
        LUT2[251] = 1;
        LUT2[253] = 1;
        LUT2[255] = -1;
    }

    boolean isEulerInvariant(byte[] neighbors, int[] LUT2) {
        int eulerChar = 0;
        int n = 1;
        if (neighbors[24] == 1) {
            n = (char)(n | 0x80);
        }
        if (neighbors[25] == 1) {
            n = (char)(n | 0x40);
        }
        if (neighbors[15] == 1) {
            n = (char)(n | 0x20);
        }
        if (neighbors[16] == 1) {
            n = (char)(n | 0x10);
        }
        if (neighbors[21] == 1) {
            n = (char)(n | 8);
        }
        if (neighbors[22] == 1) {
            n = (char)(n | 4);
        }
        if (neighbors[12] == 1) {
            n = (char)(n | 2);
        }
        eulerChar += LUT2[n];
        n = 1;
        if (neighbors[26] == 1) {
            n = (char)(n | 0x80);
        }
        if (neighbors[23] == 1) {
            n = (char)(n | 0x40);
        }
        if (neighbors[17] == 1) {
            n = (char)(n | 0x20);
        }
        if (neighbors[14] == 1) {
            n = (char)(n | 0x10);
        }
        if (neighbors[25] == 1) {
            n = (char)(n | 8);
        }
        if (neighbors[22] == 1) {
            n = (char)(n | 4);
        }
        if (neighbors[16] == 1) {
            n = (char)(n | 2);
        }
        eulerChar += LUT2[n];
        n = 1;
        if (neighbors[18] == 1) {
            n = (char)(n | 0x80);
        }
        if (neighbors[21] == 1) {
            n = (char)(n | 0x40);
        }
        if (neighbors[9] == 1) {
            n = (char)(n | 0x20);
        }
        if (neighbors[12] == 1) {
            n = (char)(n | 0x10);
        }
        if (neighbors[19] == 1) {
            n = (char)(n | 8);
        }
        if (neighbors[22] == 1) {
            n = (char)(n | 4);
        }
        if (neighbors[10] == 1) {
            n = (char)(n | 2);
        }
        eulerChar += LUT2[n];
        n = 1;
        if (neighbors[20] == 1) {
            n = (char)(n | 0x80);
        }
        if (neighbors[23] == 1) {
            n = (char)(n | 0x40);
        }
        if (neighbors[19] == 1) {
            n = (char)(n | 0x20);
        }
        if (neighbors[22] == 1) {
            n = (char)(n | 0x10);
        }
        if (neighbors[11] == 1) {
            n = (char)(n | 8);
        }
        if (neighbors[14] == 1) {
            n = (char)(n | 4);
        }
        if (neighbors[10] == 1) {
            n = (char)(n | 2);
        }
        eulerChar += LUT2[n];
        n = 1;
        if (neighbors[6] == 1) {
            n = (char)(n | 0x80);
        }
        if (neighbors[15] == 1) {
            n = (char)(n | 0x40);
        }
        if (neighbors[7] == 1) {
            n = (char)(n | 0x20);
        }
        if (neighbors[16] == 1) {
            n = (char)(n | 0x10);
        }
        if (neighbors[3] == 1) {
            n = (char)(n | 8);
        }
        if (neighbors[12] == 1) {
            n = (char)(n | 4);
        }
        if (neighbors[4] == 1) {
            n = (char)(n | 2);
        }
        eulerChar += LUT2[n];
        n = 1;
        if (neighbors[8] == 1) {
            n = (char)(n | 0x80);
        }
        if (neighbors[7] == 1) {
            n = (char)(n | 0x40);
        }
        if (neighbors[17] == 1) {
            n = (char)(n | 0x20);
        }
        if (neighbors[16] == 1) {
            n = (char)(n | 0x10);
        }
        if (neighbors[5] == 1) {
            n = (char)(n | 8);
        }
        if (neighbors[4] == 1) {
            n = (char)(n | 4);
        }
        if (neighbors[14] == 1) {
            n = (char)(n | 2);
        }
        eulerChar += LUT2[n];
        n = 1;
        if (neighbors[0] == 1) {
            n = (char)(n | 0x80);
        }
        if (neighbors[9] == 1) {
            n = (char)(n | 0x40);
        }
        if (neighbors[3] == 1) {
            n = (char)(n | 0x20);
        }
        if (neighbors[12] == 1) {
            n = (char)(n | 0x10);
        }
        if (neighbors[1] == 1) {
            n = (char)(n | 8);
        }
        if (neighbors[10] == 1) {
            n = (char)(n | 4);
        }
        if (neighbors[4] == 1) {
            n = (char)(n | 2);
        }
        eulerChar += LUT2[n];
        n = 1;
        if (neighbors[2] == 1) {
            n = (char)(n | 0x80);
        }
        if (neighbors[1] == 1) {
            n = (char)(n | 0x40);
        }
        if (neighbors[11] == 1) {
            n = (char)(n | 0x20);
        }
        if (neighbors[10] == 1) {
            n = (char)(n | 0x10);
        }
        if (neighbors[5] == 1) {
            n = (char)(n | 8);
        }
        if (neighbors[4] == 1) {
            n = (char)(n | 4);
        }
        if (neighbors[14] == 1) {
            n = (char)(n | 2);
        }
        return (eulerChar += LUT2[n]) == 0;
    }

    private boolean isSimplePoint(byte[] neighbors) {
        int[] cube = new int[26];
        int i = 0;
        for (i = 0; i < 13; ++i) {
            cube[i] = neighbors[i];
        }
        for (i = 14; i < 27; ++i) {
            cube[i - 1] = neighbors[i];
        }
        int label = 2;
        for (i = 0; i < 26; ++i) {
            if (cube[i] != 1) continue;
            switch (i) {
                case 0: 
                case 1: 
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 12: {
                    this.octreeLabeling(1, label, cube);
                    break;
                }
                case 2: 
                case 5: 
                case 11: 
                case 13: {
                    this.octreeLabeling(2, label, cube);
                    break;
                }
                case 6: 
                case 7: 
                case 14: 
                case 15: {
                    this.octreeLabeling(3, label, cube);
                    break;
                }
                case 8: 
                case 16: {
                    this.octreeLabeling(4, label, cube);
                    break;
                }
                case 17: 
                case 18: 
                case 20: 
                case 21: {
                    this.octreeLabeling(5, label, cube);
                    break;
                }
                case 19: 
                case 22: {
                    this.octreeLabeling(6, label, cube);
                    break;
                }
                case 23: 
                case 24: {
                    this.octreeLabeling(7, label, cube);
                    break;
                }
                case 25: {
                    this.octreeLabeling(8, label, cube);
                }
            }
            if (++label - 2 < 2) continue;
            return false;
        }
        return true;
    }

    private void octreeLabeling(int octant, int label, int[] cube) {
        if (octant == 1) {
            if (cube[0] == 1) {
                cube[0] = label;
            }
            if (cube[1] == 1) {
                cube[1] = label;
                this.octreeLabeling(2, label, cube);
            }
            if (cube[3] == 1) {
                cube[3] = label;
                this.octreeLabeling(3, label, cube);
            }
            if (cube[4] == 1) {
                cube[4] = label;
                this.octreeLabeling(2, label, cube);
                this.octreeLabeling(3, label, cube);
                this.octreeLabeling(4, label, cube);
            }
            if (cube[9] == 1) {
                cube[9] = label;
                this.octreeLabeling(5, label, cube);
            }
            if (cube[10] == 1) {
                cube[10] = label;
                this.octreeLabeling(2, label, cube);
                this.octreeLabeling(5, label, cube);
                this.octreeLabeling(6, label, cube);
            }
            if (cube[12] == 1) {
                cube[12] = label;
                this.octreeLabeling(3, label, cube);
                this.octreeLabeling(5, label, cube);
                this.octreeLabeling(7, label, cube);
            }
        }
        if (octant == 2) {
            if (cube[1] == 1) {
                cube[1] = label;
                this.octreeLabeling(1, label, cube);
            }
            if (cube[4] == 1) {
                cube[4] = label;
                this.octreeLabeling(1, label, cube);
                this.octreeLabeling(3, label, cube);
                this.octreeLabeling(4, label, cube);
            }
            if (cube[10] == 1) {
                cube[10] = label;
                this.octreeLabeling(1, label, cube);
                this.octreeLabeling(5, label, cube);
                this.octreeLabeling(6, label, cube);
            }
            if (cube[2] == 1) {
                cube[2] = label;
            }
            if (cube[5] == 1) {
                cube[5] = label;
                this.octreeLabeling(4, label, cube);
            }
            if (cube[11] == 1) {
                cube[11] = label;
                this.octreeLabeling(6, label, cube);
            }
            if (cube[13] == 1) {
                cube[13] = label;
                this.octreeLabeling(4, label, cube);
                this.octreeLabeling(6, label, cube);
                this.octreeLabeling(8, label, cube);
            }
        }
        if (octant == 3) {
            if (cube[3] == 1) {
                cube[3] = label;
                this.octreeLabeling(1, label, cube);
            }
            if (cube[4] == 1) {
                cube[4] = label;
                this.octreeLabeling(1, label, cube);
                this.octreeLabeling(2, label, cube);
                this.octreeLabeling(4, label, cube);
            }
            if (cube[12] == 1) {
                cube[12] = label;
                this.octreeLabeling(1, label, cube);
                this.octreeLabeling(5, label, cube);
                this.octreeLabeling(7, label, cube);
            }
            if (cube[6] == 1) {
                cube[6] = label;
            }
            if (cube[7] == 1) {
                cube[7] = label;
                this.octreeLabeling(4, label, cube);
            }
            if (cube[14] == 1) {
                cube[14] = label;
                this.octreeLabeling(7, label, cube);
            }
            if (cube[15] == 1) {
                cube[15] = label;
                this.octreeLabeling(4, label, cube);
                this.octreeLabeling(7, label, cube);
                this.octreeLabeling(8, label, cube);
            }
        }
        if (octant == 4) {
            if (cube[4] == 1) {
                cube[4] = label;
                this.octreeLabeling(1, label, cube);
                this.octreeLabeling(2, label, cube);
                this.octreeLabeling(3, label, cube);
            }
            if (cube[5] == 1) {
                cube[5] = label;
                this.octreeLabeling(2, label, cube);
            }
            if (cube[13] == 1) {
                cube[13] = label;
                this.octreeLabeling(2, label, cube);
                this.octreeLabeling(6, label, cube);
                this.octreeLabeling(8, label, cube);
            }
            if (cube[7] == 1) {
                cube[7] = label;
                this.octreeLabeling(3, label, cube);
            }
            if (cube[15] == 1) {
                cube[15] = label;
                this.octreeLabeling(3, label, cube);
                this.octreeLabeling(7, label, cube);
                this.octreeLabeling(8, label, cube);
            }
            if (cube[8] == 1) {
                cube[8] = label;
            }
            if (cube[16] == 1) {
                cube[16] = label;
                this.octreeLabeling(8, label, cube);
            }
        }
        if (octant == 5) {
            if (cube[9] == 1) {
                cube[9] = label;
                this.octreeLabeling(1, label, cube);
            }
            if (cube[10] == 1) {
                cube[10] = label;
                this.octreeLabeling(1, label, cube);
                this.octreeLabeling(2, label, cube);
                this.octreeLabeling(6, label, cube);
            }
            if (cube[12] == 1) {
                cube[12] = label;
                this.octreeLabeling(1, label, cube);
                this.octreeLabeling(3, label, cube);
                this.octreeLabeling(7, label, cube);
            }
            if (cube[17] == 1) {
                cube[17] = label;
            }
            if (cube[18] == 1) {
                cube[18] = label;
                this.octreeLabeling(6, label, cube);
            }
            if (cube[20] == 1) {
                cube[20] = label;
                this.octreeLabeling(7, label, cube);
            }
            if (cube[21] == 1) {
                cube[21] = label;
                this.octreeLabeling(6, label, cube);
                this.octreeLabeling(7, label, cube);
                this.octreeLabeling(8, label, cube);
            }
        }
        if (octant == 6) {
            if (cube[10] == 1) {
                cube[10] = label;
                this.octreeLabeling(1, label, cube);
                this.octreeLabeling(2, label, cube);
                this.octreeLabeling(5, label, cube);
            }
            if (cube[11] == 1) {
                cube[11] = label;
                this.octreeLabeling(2, label, cube);
            }
            if (cube[13] == 1) {
                cube[13] = label;
                this.octreeLabeling(2, label, cube);
                this.octreeLabeling(4, label, cube);
                this.octreeLabeling(8, label, cube);
            }
            if (cube[18] == 1) {
                cube[18] = label;
                this.octreeLabeling(5, label, cube);
            }
            if (cube[21] == 1) {
                cube[21] = label;
                this.octreeLabeling(5, label, cube);
                this.octreeLabeling(7, label, cube);
                this.octreeLabeling(8, label, cube);
            }
            if (cube[19] == 1) {
                cube[19] = label;
            }
            if (cube[22] == 1) {
                cube[22] = label;
                this.octreeLabeling(8, label, cube);
            }
        }
        if (octant == 7) {
            if (cube[12] == 1) {
                cube[12] = label;
                this.octreeLabeling(1, label, cube);
                this.octreeLabeling(3, label, cube);
                this.octreeLabeling(5, label, cube);
            }
            if (cube[14] == 1) {
                cube[14] = label;
                this.octreeLabeling(3, label, cube);
            }
            if (cube[15] == 1) {
                cube[15] = label;
                this.octreeLabeling(3, label, cube);
                this.octreeLabeling(4, label, cube);
                this.octreeLabeling(8, label, cube);
            }
            if (cube[20] == 1) {
                cube[20] = label;
                this.octreeLabeling(5, label, cube);
            }
            if (cube[21] == 1) {
                cube[21] = label;
                this.octreeLabeling(5, label, cube);
                this.octreeLabeling(6, label, cube);
                this.octreeLabeling(8, label, cube);
            }
            if (cube[23] == 1) {
                cube[23] = label;
            }
            if (cube[24] == 1) {
                cube[24] = label;
                this.octreeLabeling(8, label, cube);
            }
        }
        if (octant == 8) {
            if (cube[13] == 1) {
                cube[13] = label;
                this.octreeLabeling(2, label, cube);
                this.octreeLabeling(4, label, cube);
                this.octreeLabeling(6, label, cube);
            }
            if (cube[15] == 1) {
                cube[15] = label;
                this.octreeLabeling(3, label, cube);
                this.octreeLabeling(4, label, cube);
                this.octreeLabeling(7, label, cube);
            }
            if (cube[16] == 1) {
                cube[16] = label;
                this.octreeLabeling(4, label, cube);
            }
            if (cube[21] == 1) {
                cube[21] = label;
                this.octreeLabeling(5, label, cube);
                this.octreeLabeling(6, label, cube);
                this.octreeLabeling(7, label, cube);
            }
            if (cube[22] == 1) {
                cube[22] = label;
                this.octreeLabeling(6, label, cube);
            }
            if (cube[24] == 1) {
                cube[24] = label;
                this.octreeLabeling(7, label, cube);
            }
            if (cube[25] == 1) {
                cube[25] = label;
            }
        }
    }

    void showAbout() {
        IJ.showMessage("About Skeletonize3D...", "This plug-in filter produces 3D thinning (skeletonization) of binary 3D images.\n");
    }
}

