/*
 * Decompiled with CFR 0.152.
 */
package ij.text;

import ij.IJ;
import ij.ImageJ;
import ij.Menus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GUI;
import ij.gui.YesNoCancelDialog;
import ij.io.OpenDialog;
import ij.macro.Interpreter;
import ij.plugin.filter.Analyzer;
import ij.text.TextPanel;
import java.awt.CheckboxMenuItem;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;

public class TextWindow
extends Frame
implements ActionListener,
FocusListener,
ItemListener {
    public static final String LOC_KEY = "results.loc";
    public static final String WIDTH_KEY = "results.width";
    public static final String HEIGHT_KEY = "results.height";
    public static final String LOG_LOC_KEY = "log.loc";
    public static final String DEBUG_LOC_KEY = "debug.loc";
    static final String FONT_SIZE = "tw.font.size";
    static final String FONT_ANTI = "tw.font.anti";
    TextPanel textPanel;
    CheckboxMenuItem antialiased;
    int[] sizes = new int[]{9, 10, 11, 12, 13, 14, 16, 18, 20, 24, 36, 48, 60, 72};
    int fontSize = (int)Prefs.get("tw.font.size", 5.0);
    MenuBar mb;

    public TextWindow(String title, String data, int width, int height) {
        this(title, "", data, width, height);
    }

    public TextWindow(String title, String headings, String data, int width, int height) {
        super(title);
        this.enableEvents(64L);
        if (IJ.isLinux()) {
            this.setBackground(ImageJ.backgroundColor);
        }
        this.textPanel = new TextPanel(title);
        this.textPanel.setTitle(title);
        this.add("Center", this.textPanel);
        this.textPanel.setColumnHeadings(headings);
        if (data != null && !data.equals("")) {
            this.textPanel.append(data);
        }
        this.addKeyListener(this.textPanel);
        ImageJ ij = IJ.getInstance();
        if (ij != null) {
            this.textPanel.addKeyListener(ij);
            Image img = ij.getIconImage();
            if (img != null) {
                try {
                    this.setIconImage(img);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        this.addFocusListener(this);
        this.addMenuBar();
        this.setFont();
        WindowManager.addWindow(this);
        Point loc = null;
        int w = 0;
        int h = 0;
        if (title.equals("Results")) {
            loc = Prefs.getLocation(LOC_KEY);
            w = (int)Prefs.get(WIDTH_KEY, 0.0);
            h = (int)Prefs.get(HEIGHT_KEY, 0.0);
        } else if (title.equals("Log")) {
            loc = Prefs.getLocation(LOG_LOC_KEY);
            w = width;
            h = height;
        } else if (title.equals("Debug")) {
            loc = Prefs.getLocation(DEBUG_LOC_KEY);
            w = width;
            h = height;
        }
        if (loc != null && w > 0 && h > 0) {
            this.setSize(w, h);
            this.setLocation(loc);
        } else {
            this.setSize(width, height);
            GUI.center(this);
        }
        this.show();
    }

    public TextWindow(String path, int width, int height) {
        super("");
        this.enableEvents(64L);
        this.textPanel = new TextPanel();
        this.textPanel.addKeyListener(IJ.getInstance());
        this.add("Center", this.textPanel);
        if (this.openFile(path)) {
            WindowManager.addWindow(this);
            this.setSize(width, height);
            this.show();
        } else {
            this.dispose();
        }
    }

    void addMenuBar() {
        this.mb = new MenuBar();
        if (Menus.getFontSize() != 0) {
            this.mb.setFont(Menus.getFont());
        }
        Menu m = new Menu("File");
        m.add(new MenuItem("Save As...", new MenuShortcut(83)));
        if (this.getTitle().equals("Results")) {
            m.add(new MenuItem("Rename..."));
            m.add(new MenuItem("Duplicate..."));
        }
        m.addActionListener(this);
        this.mb.add(m);
        m = new Menu("Edit");
        m.add(new MenuItem("Cut", new MenuShortcut(88)));
        m.add(new MenuItem("Copy", new MenuShortcut(67)));
        m.add(new MenuItem("Clear"));
        m.add(new MenuItem("Select All", new MenuShortcut(65)));
        m.addActionListener(this);
        this.mb.add(m);
        m = new Menu("Font");
        m.add(new MenuItem("Make Text Smaller"));
        m.add(new MenuItem("Make Text Larger"));
        m.addSeparator();
        this.antialiased = new CheckboxMenuItem("Antialiased", Prefs.get(FONT_ANTI, IJ.isMacOSX()));
        this.antialiased.addItemListener(this);
        m.add(this.antialiased);
        m.add(new MenuItem("Save Settings"));
        m.addActionListener(this);
        this.mb.add(m);
        if (this.getTitle().equals("Results")) {
            m = new Menu("Results");
            m.add(new MenuItem("Clear Results"));
            m.add(new MenuItem("Summarize"));
            m.add(new MenuItem("Distribution..."));
            m.add(new MenuItem("Set Measurements..."));
            m.add(new MenuItem("Options..."));
            m.addActionListener(this);
            this.mb.add(m);
        }
        this.setMenuBar(this.mb);
    }

    public void append(String text) {
        this.textPanel.append(text);
    }

    void setFont() {
        this.textPanel.setFont(new Font("SanSerif", 0, this.sizes[this.fontSize]), this.antialiased.getState());
    }

    boolean openFile(String path) {
        OpenDialog od = new OpenDialog("Open Text File...", path);
        String directory = od.getDirectory();
        String name = od.getFileName();
        if (name == null) {
            return false;
        }
        path = directory + name;
        IJ.showStatus("Opening: " + path);
        try {
            BufferedReader r = new BufferedReader(new FileReader(directory + name));
            this.load(r);
            r.close();
        }
        catch (Exception e) {
            IJ.error(e.getMessage());
            return true;
        }
        this.textPanel.setTitle(name);
        this.setTitle(name);
        IJ.showStatus("");
        return true;
    }

    public TextPanel getTextPanel() {
        return this.textPanel;
    }

    public void load(BufferedReader in) throws IOException {
        String s;
        boolean count = false;
        while ((s = in.readLine()) != null) {
            this.textPanel.appendLine(s);
        }
    }

    public void actionPerformed(ActionEvent evt) {
        String cmd = evt.getActionCommand();
        if (cmd.equals("Make Text Larger")) {
            this.changeFontSize(true);
        } else if (cmd.equals("Make Text Smaller")) {
            this.changeFontSize(false);
        } else if (cmd.equals("Save Settings")) {
            this.saveSettings();
        } else {
            this.textPanel.doCommand(cmd);
        }
    }

    public void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        int id = e.getID();
        if (id == 201) {
            this.close();
        } else if (id == 205) {
            WindowManager.setWindow(this);
        }
    }

    public void itemStateChanged(ItemEvent e) {
        this.setFont();
    }

    public void close() {
        this.close(true);
    }

    public void close(boolean showDialog) {
        if (this.getTitle().equals("Results")) {
            if (showDialog && !Analyzer.resetCounter()) {
                return;
            }
            IJ.setTextPanel(null);
            Prefs.saveLocation(LOC_KEY, this.getLocation());
            Dimension d = this.getSize();
            Prefs.set(WIDTH_KEY, d.width);
            Prefs.set(HEIGHT_KEY, d.height);
        } else if (this.getTitle().equals("Log")) {
            Prefs.saveLocation(LOG_LOC_KEY, this.getLocation());
            IJ.debugMode = false;
            IJ.log("\\Closed");
            IJ.notifyEventListeners(3);
        } else if (this.getTitle().equals("Debug")) {
            Prefs.saveLocation(DEBUG_LOC_KEY, this.getLocation());
        } else if (this.textPanel != null && this.textPanel.rt != null && !this.saveContents()) {
            return;
        }
        this.dispose();
        WindowManager.removeWindow(this);
        this.textPanel.flush();
    }

    public void rename(String title) {
        this.textPanel.rename(title);
    }

    boolean saveContents() {
        int lineCount = this.textPanel.getLineCount();
        if (!this.textPanel.unsavedLines) {
            lineCount = 0;
        }
        ImageJ ij = IJ.getInstance();
        boolean macro = IJ.macroRunning() || Interpreter.isBatchMode();
        boolean isResults = this.getTitle().contains("Results");
        if (lineCount > 0 && !macro && ij != null && !ij.quitting() && isResults) {
            YesNoCancelDialog d = new YesNoCancelDialog((Frame)this, this.getTitle(), "Save " + lineCount + " measurements?");
            if (d.cancelPressed()) {
                return false;
            }
            if (d.yesPressed() && !this.textPanel.saveAs("")) {
                return false;
            }
        }
        this.textPanel.rt.reset();
        return true;
    }

    void changeFontSize(boolean larger) {
        int in = this.fontSize++;
        if (larger) {
            if (this.fontSize == this.sizes.length) {
                this.fontSize = this.sizes.length - 1;
            }
        } else {
            --this.fontSize;
            if (this.fontSize < 0) {
                this.fontSize = 0;
            }
        }
        IJ.showStatus(this.sizes[this.fontSize] + " point");
        this.setFont();
    }

    void saveSettings() {
        Prefs.set(FONT_SIZE, this.fontSize);
        Prefs.set(FONT_ANTI, this.antialiased.getState());
        IJ.showStatus("Font settings saved (size=" + this.sizes[this.fontSize] + ", antialiased=" + this.antialiased.getState() + ")");
    }

    public void focusGained(FocusEvent e) {
        WindowManager.setWindow(this);
    }

    public void focusLost(FocusEvent e) {
    }
}

