/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.ellipticFunctions;

import de.jtem.mfc.field.Complex;

public class Elliptic {
    static final double EPS = 1.0E-12;
    static final Complex ZERO = new Complex(0.0);

    Elliptic() {
    }

    static void thetaConstants(Complex tau, double eps, Complex[] c) {
        if (c.length != 4) {
            throw new IllegalArgumentException("there are four constants");
        }
        for (int i = 0; i < 4; ++i) {
            if (c[i] != null) continue;
            c[i] = new Complex();
        }
        c[1].assign(0.0);
        Elliptic.theta4(ZERO, tau, eps, c[0]);
        Elliptic.theta2(ZERO, tau, eps, c[2]);
        Elliptic.theta3(ZERO, tau, eps, c[3]);
    }

    public static void thetaConstants(Complex tau, Complex[] c) {
        if (c.length != 4) {
            throw new IllegalArgumentException("there are four constants");
        }
        for (int i = 0; i < 4; ++i) {
            if (c[i] != null) continue;
            c[i] = new Complex();
        }
        c[1].assign(0.0);
        Elliptic.theta4(ZERO, tau, 1.0E-12, c[0]);
        Elliptic.theta2(ZERO, tau, 1.0E-12, c[2]);
        Elliptic.theta3(ZERO, tau, 1.0E-12, c[3]);
    }

    static Complex[] thetaConstants(Complex tau, double eps) {
        Complex[] c = new Complex[4];
        Elliptic.thetaConstants(tau, eps, c);
        return c;
    }

    public static Complex[] thetaConstants(Complex tau) {
        Complex[] c = new Complex[4];
        Elliptic.thetaConstants(tau, 1.0E-12, c);
        return c;
    }

    static int transformIntoFundamental(Complex w, Complex tau, Complex z) {
        double Y = w.im / tau.im / Math.PI;
        double X = w.re / Math.PI - Y * tau.re;
        int m = (int)Math.floor(X + 0.5);
        int n = (int)Math.floor(Y + 0.5);
        Elliptic.transform(w, tau, -m, -n, z);
        return n;
    }

    static void transform(Complex z, Complex tau, int m, int n, Complex w) {
        w.re = z.re + ((double)m + (double)n * tau.re) * Math.PI;
        w.im = z.im + (double)n * tau.im * Math.PI;
    }

    static void transform(Complex z, Complex tau, double x, double y, Complex w) {
        w.re = z.re + (x + y * tau.re) * Math.PI;
        w.im = z.im + y * tau.im * Math.PI;
    }

    static int lengthOfSeries(Complex z, Complex tau, double eps) {
        double delta = -Math.PI * tau.im;
        double y = Math.abs(z.im);
        return (int)Math.floor(1.0 - (y + Math.sqrt(Math.log(eps) * delta + y * y)) / delta);
    }

    static void logOfPeriodicityFactor(Complex z, Complex tau, int n, Complex logOfC) {
        logOfC.assign((double)(-n) * ((double)n * Math.PI * tau.re + 2.0 * z.re), (double)(-n) * ((double)n * Math.PI * tau.im + 2.0 * z.im));
        logOfC.assignTimesI();
    }

    static void logOfShiftFactor(Complex z, Complex tau, Complex logOfD) {
        logOfD.assign(0.7853981633974483 * tau.re + z.re, 0.7853981633974483 * tau.im + z.im);
        logOfD.assignTimesI();
    }

    static Complex logOfShiftFactor(Complex z, Complex tau) {
        Complex logOfD = new Complex();
        Elliptic.logOfShiftFactor(z, tau, logOfD);
        return logOfD;
    }

    public static Complex theta(Complex z, Complex tau) {
        return Elliptic.theta4(z, tau);
    }

    public static void theta(Complex w, Complex tau, Complex z, Complex logOfC, Complex thetaOfZ) {
        Elliptic.theta4(w, tau, 1.0E-12, z, logOfC, thetaOfZ);
    }

    public static Complex theta0(Complex z, Complex tau) {
        return Elliptic.theta4(z, tau);
    }

    public static void theta0(Complex w, Complex tau, Complex z, Complex logOfC, Complex thetaOfZ) {
        Elliptic.theta4(w, tau, 1.0E-12, z, logOfC, thetaOfZ);
    }

    static void logOfPeriodicityFactorForTheta1(Complex z, Complex tau, int m, int n, Complex logOfC) {
        Elliptic.logOfPeriodicityFactor(z, tau, n, logOfC);
        logOfC.im += (double)((m + n) % 2) * Math.PI;
    }

    static void periodicityFactorForTheta1(Complex z, Complex tau, int m, int n, Complex result) {
        Elliptic.logOfPeriodicityFactorForTheta1(z, tau, m, n, result);
        result.assignExp();
    }

    static Complex periodicityFactorForTheta1(Complex z, Complex tau, int m, int n) {
        Complex result = new Complex();
        Elliptic.periodicityFactorForTheta1(z, tau, m, n, result);
        return result;
    }

    static Complex theta1(Complex z, Complex tau, double eps) {
        Complex result = new Complex();
        Elliptic.theta1(z, tau, eps, result);
        return result;
    }

    public static Complex theta1(Complex z, Complex tau) {
        Complex result = new Complex();
        Elliptic.theta1(z, tau, 1.0E-12, result);
        return result;
    }

    static void theta1(Complex z, Complex tau, Complex theta1OfZ) {
        Elliptic.theta1(z, tau, 1.0E-12, theta1OfZ);
    }

    public static void theta1(Complex w, Complex tau, Complex z, Complex logOfC, Complex thetaOfZ) {
        Elliptic.theta1(w, tau, 1.0E-12, z, logOfC, thetaOfZ);
    }

    static void theta1(Complex z, Complex tau, double eps, Complex thetaOfZ) {
        Complex logOfC = new Complex();
        Elliptic.theta1(z, tau, eps, new Complex(), logOfC, thetaOfZ);
        logOfC.assignExp();
        thetaOfZ.assignTimes(logOfC);
    }

    static void theta1(Complex w, Complex tau, double eps, Complex z, Complex logOfC, Complex thetaOfZ) {
        Elliptic.transform(w, tau, 0.0, 0.5, z);
        Elliptic.theta4(z, tau, eps, z, logOfC, thetaOfZ);
        Complex logOfD = Elliptic.logOfShiftFactor(w, tau);
        logOfD.im -= 1.5707963267948966;
        logOfC.assignPlus(logOfD);
    }

    static void logOfPeriodicityFactorForTheta2(Complex z, Complex tau, int m, int n, Complex logOfC) {
        Elliptic.logOfPeriodicityFactor(z, tau, n, logOfC);
        logOfC.im += (double)(m % 2) * Math.PI;
    }

    static void periodicityFactorForTheta2(Complex z, Complex tau, int m, int n, Complex result) {
        Elliptic.logOfPeriodicityFactorForTheta2(z, tau, m, n, result);
        result.assignExp();
    }

    static Complex periodicityFactorForTheta2(Complex z, Complex tau, int m, int n) {
        Complex result = new Complex();
        Elliptic.periodicityFactorForTheta2(z, tau, m, n, result);
        return result;
    }

    static Complex theta2(Complex z, Complex tau, double eps) {
        Complex result = new Complex();
        Elliptic.theta2(z, tau, eps, result);
        return result;
    }

    public static Complex theta2(Complex z, Complex tau) {
        Complex result = new Complex();
        Elliptic.theta2(z, tau, 1.0E-12, result);
        return result;
    }

    static void theta2(Complex z, Complex tau, Complex theta2OfZ) {
        Elliptic.theta2(z, tau, 1.0E-12, theta2OfZ);
    }

    public static void theta2(Complex w, Complex tau, Complex z, Complex logOfC, Complex thetaOfZ) {
        Elliptic.theta2(w, tau, 1.0E-12, z, logOfC, thetaOfZ);
    }

    static void theta2(Complex z, Complex tau, double eps, Complex thetaOfZ) {
        Complex logOfC = new Complex();
        Elliptic.theta2(z, tau, eps, new Complex(), logOfC, thetaOfZ);
        logOfC.assignExp();
        thetaOfZ.assignTimes(logOfC);
    }

    static void theta2(Complex w, Complex tau, double eps, Complex z, Complex logOfC, Complex thetaOfZ) {
        Elliptic.transform(w, tau, 0.5, 0.5, z);
        Elliptic.theta4(z, tau, eps, z, logOfC, thetaOfZ);
        Complex logOfD = Elliptic.logOfShiftFactor(w, tau);
        logOfC.assignPlus(logOfD);
    }

    static void logOfPeriodicityFactorForTheta3(Complex z, Complex tau, int n, Complex logOfC) {
        Elliptic.logOfPeriodicityFactor(z, tau, n, logOfC);
    }

    static void periodicityFactorForTheta3(Complex z, Complex tau, int n, Complex result) {
        Elliptic.logOfPeriodicityFactorForTheta3(z, tau, n, result);
        result.assignExp();
    }

    static Complex periodicityFactorForTheta3(Complex z, Complex tau, int n) {
        Complex result = new Complex();
        Elliptic.periodicityFactorForTheta3(z, tau, n, result);
        return result;
    }

    static Complex theta3(Complex z, Complex tau, double eps) {
        Complex result = new Complex();
        Elliptic.theta3(z, tau, eps, result);
        return result;
    }

    public static Complex theta3(Complex z, Complex tau) {
        Complex result = new Complex();
        Elliptic.theta3(z, tau, 1.0E-12, result);
        return result;
    }

    static void theta3(Complex z, Complex tau, Complex theta3OfZ) {
        Elliptic.theta3(z, tau, 1.0E-12, theta3OfZ);
    }

    static void theta3(Complex z, Complex tau, double eps, Complex theta3OfZ) {
        Complex logOfC = new Complex();
        Elliptic.theta3(z, tau, eps, new Complex(), logOfC, theta3OfZ);
        logOfC.assignExp();
        theta3OfZ.assignTimes(logOfC);
    }

    public static void theta3(Complex w, Complex tau, Complex z, Complex logOfC, Complex thetaOfZ) {
        Elliptic.theta3(w, tau, 1.0E-12, z, logOfC, thetaOfZ);
    }

    static void theta3(Complex w, Complex tau, double eps, Complex z, Complex logOfC, Complex thetaOfZ) {
        Elliptic.transform(w, tau, 0.5, 0.0, z);
        Elliptic.theta4(z, tau, eps, z, logOfC, thetaOfZ);
    }

    static void logOfPeriodicityFactorForTheta4(Complex z, Complex tau, int n, Complex logOfC) {
        Elliptic.logOfPeriodicityFactor(z, tau, n, logOfC);
        logOfC.im += (double)(n % 2) * Math.PI;
    }

    static void periodicityFactorForTheta4(Complex z, Complex tau, int n, Complex result) {
        Elliptic.logOfPeriodicityFactorForTheta4(z, tau, n, result);
        result.assignExp();
    }

    static Complex periodicityFactorForTheta4(Complex z, Complex tau, int n) {
        Complex result = new Complex();
        Elliptic.periodicityFactorForTheta4(z, tau, n, result);
        return result;
    }

    static Complex theta4(Complex z, Complex tau, double eps) {
        Complex result = new Complex();
        Elliptic.theta4(z, tau, eps, result);
        return result;
    }

    static void theta4(Complex z, Complex tau, Complex theta4OfZ) {
        Elliptic.theta4(z, tau, 1.0E-12, theta4OfZ);
    }

    static void theta4(Complex z, Complex tau, double eps, Complex theta4OfZ) {
        Complex logOfC = new Complex();
        Elliptic.theta4(z, tau, eps, new Complex(), logOfC, theta4OfZ);
        logOfC.assignExp();
        theta4OfZ.assignTimes(logOfC);
    }

    public static Complex theta4(Complex z, Complex tau) {
        Complex result = new Complex();
        Elliptic.theta4(z, tau, 1.0E-12, result);
        return result;
    }

    public static void theta4(Complex w, Complex tau, Complex z, Complex logOfC, Complex thetaOfZ) {
        Elliptic.theta4(w, tau, 1.0E-12, z, logOfC, thetaOfZ);
    }

    static void theta4(Complex w, Complex tau, double eps, Complex z, Complex logOfC, Complex thetaOfZ) {
        int n = Elliptic.transformIntoFundamental(w, tau, z);
        Elliptic.logOfPeriodicityFactorForTheta4(z, tau, n, logOfC);
        Elliptic.theta4PlainSeries(z, tau, eps, thetaOfZ);
    }

    static void theta4PlainSeries(Complex z, Complex tau, double eps, Complex result) {
        if (!(tau.im > 0.0)) {
            throw new IllegalArgumentException("imagiary part of tau must be positive");
        }
        Complex tauIPi = tau.times(new Complex(0.0, Math.PI));
        Complex tauIPiNSqr = new Complex();
        Complex iz = z.timesI();
        Complex iZ2N = new Complex();
        Complex term = new Complex();
        Complex term1 = new Complex();
        Complex term2 = new Complex();
        int N = Elliptic.lengthOfSeries(z, tau, eps);
        double sign = -1.0;
        result.assign(1.0);
        int n = 1;
        while (n <= N) {
            iZ2N.assignTimes(iz, (double)(2 * n));
            tauIPiNSqr.assignTimes(tauIPi, (double)(n * n));
            term1.assignPlus(tauIPiNSqr, iZ2N);
            term1.assignExp();
            term2.assignMinus(tauIPiNSqr, iZ2N);
            term2.assignExp();
            term.assignPlus(term1, term2);
            term.assignTimes(sign);
            result.assignPlus(term);
            ++n;
            sign *= -1.0;
        }
    }
}

