/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.mfc.field;

import de.jtem.mfc.field.ComplexValue;
import de.jtem.mfc.field.Field;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.ListIterator;

public class Complex
extends ComplexValue
implements Field.Complex,
Serializable,
Cloneable {
    private static final long serialVersionUID = -8901026171267724320L;
    public static final Complex ZERO = new Complex(0.0, 0.0);
    public static final Complex ONE = new Complex(1.0, 0.0);
    public static final Complex I = new Complex(0.0, 1.0);
    public static final Complex NEG_ONE = new Complex(-1.0, 0.0);
    public static final Complex NEG_I = new Complex(0.0, -1.0);
    public double re;
    public double im;

    public Complex() {
        this.re = 0.0;
        this.im = 0.0;
    }

    public Complex(double aReal) {
        this.re = aReal;
        this.im = 0.0;
    }

    public Complex(Complex u) {
        this.re = u.re;
        this.im = u.im;
    }

    public Complex(Field.Complex u) {
        this.re = u.getRe();
        this.im = u.getIm();
    }

    public Complex(double aReal, double aImag) {
        this.re = aReal;
        this.im = aImag;
    }

    @Override
    public final double getRe() {
        return this.re;
    }

    @Override
    public final double getIm() {
        return this.im;
    }

    public final void setRe(double r) {
        this.re = r;
    }

    public final void setIm(double i) {
        this.im = i;
    }

    public final void assign(double aReal, double aImag) {
        this.re = aReal;
        this.im = aImag;
    }

    public final void assign(Complex v) {
        this.re = v.re;
        this.im = v.im;
    }

    public final void assign(Field.Complex v) {
        this.re = v.getRe();
        this.im = v.getIm();
    }

    public final void assign(double re) {
        this.re = re;
        this.im = 0.0;
    }

    public final Complex copy() {
        return new Complex(this.re, this.im);
    }

    public final Object clone() {
        return this.copy();
    }

    public final boolean isInfinite() {
        return Double.isInfinite(this.re) || Double.isInfinite(this.im);
    }

    public final boolean isNaN() {
        return Double.isNaN(this.re) || Double.isNaN(this.im);
    }

    public boolean isZero() {
        return this.equals(0.0, 0.0);
    }

    public final Complex plus(Field.Complex v) {
        return new Complex(this.re + v.getRe(), this.im + v.getIm());
    }

    public final Complex plus(double r) {
        return new Complex(this.re + r, this.im);
    }

    public final void assignPlus(double x, double y) {
        this.re += x;
        this.im += y;
    }

    public final void assignPlus(Complex v) {
        this.re += v.re;
        this.im += v.im;
    }

    public final void assignPlus(Field.Complex v) {
        this.re += v.getRe();
        this.im += v.getIm();
    }

    public final void assignPlus(Complex u, double r) {
        this.re = u.re + r;
        this.im = u.im;
    }

    public final void assignPlus(Field.Complex u, double r) {
        this.re = u.getRe() + r;
        this.im = u.getIm();
    }

    public final void assignPlus(double r) {
        this.re += r;
    }

    public final void assignPlus(Complex u, Complex v) {
        this.re = u.re + v.re;
        this.im = u.im + v.im;
    }

    public final void assignPlus(Field.Complex u, Field.Complex v) {
        this.re = u.getRe() + v.getRe();
        this.im = u.getIm() + v.getIm();
    }

    public final Complex minus(Field.Complex v) {
        return new Complex(this.re - v.getRe(), this.im - v.getIm());
    }

    public final Complex minus(double r) {
        return new Complex(this.re - r, this.im);
    }

    public final void assignMinus(double x, double y) {
        this.re -= x;
        this.im -= y;
    }

    public final void assignMinus(Complex v) {
        this.re -= v.re;
        this.im -= v.im;
    }

    public final void assignMinus(Field.Complex v) {
        this.re -= v.getRe();
        this.im -= v.getIm();
    }

    public final void assignMinus(double r) {
        this.re -= r;
    }

    public final void assignMinus(Complex u, Complex v) {
        this.re = u.re - v.re;
        this.im = u.im - v.im;
    }

    public final void assignMinus(Field.Complex u, Field.Complex v) {
        this.re = u.getRe() - v.getRe();
        this.im = u.getIm() - v.getIm();
    }

    public final void assignMinus(Complex u, double r) {
        this.re = u.re - r;
        this.im = u.im;
    }

    public final void assignMinus(Field.Complex u, double r) {
        this.re = u.getRe() - r;
        this.im = u.getIm();
    }

    public final void assignMinus(double r, Complex u) {
        this.re = r - u.re;
        this.im = -u.im;
    }

    public final void assignMinus(double r, Field.Complex u) {
        this.re = r - u.getRe();
        this.im = -u.getIm();
    }

    public final Complex times(Field.Complex v) {
        return new Complex(this.re * v.getRe() - this.im * v.getIm(), this.re * v.getIm() + this.im * v.getRe());
    }

    public final Complex times(double r) {
        return new Complex(this.re * r, this.im * r);
    }

    public final void assignTimes(double x, double y) {
        double rr = this.re * x - this.im * y;
        double ii = this.re * y + this.im * x;
        this.re = rr;
        this.im = ii;
    }

    public final void assignTimes(Complex v) {
        double rr = this.re * v.re - this.im * v.im;
        double ii = this.re * v.im + this.im * v.re;
        this.re = rr;
        this.im = ii;
    }

    public final void assignTimes(Field.Complex v) {
        double rr = this.re * v.getRe() - this.im * v.getIm();
        double ii = this.re * v.getIm() + this.im * v.getRe();
        this.re = rr;
        this.im = ii;
    }

    public final void assignTimes(double r) {
        this.re *= r;
        this.im *= r;
    }

    public final void assignTimes(double x, double y, double u, double v) {
        this.re = x * u - y * v;
        this.im = x * v + y * u;
    }

    public final void assignTimes(Complex u, Complex v) {
        double rr = u.re * v.re - u.im * v.im;
        double ii = u.re * v.im + u.im * v.re;
        this.re = rr;
        this.im = ii;
    }

    public final void assignTimes(Field.Complex u, Field.Complex v) {
        this.assignTimes(u.getRe(), u.getIm(), v.getRe(), v.getIm());
    }

    public final void assignTimes(Complex u, double r) {
        this.re = u.re * r;
        this.im = u.im * r;
    }

    public final void assignTimes(Field.Complex u, double r) {
        this.re = u.getRe() * r;
        this.im = u.getIm() * r;
    }

    public final Complex timesI() {
        return new Complex(-this.im, this.re);
    }

    public final void assignTimesI() {
        double rr = this.re;
        this.re = -this.im;
        this.im = rr;
    }

    public final void assignTimesI(Complex v) {
        double rr = v.re;
        this.re = -v.im;
        this.im = rr;
    }

    public final void assignTimesI(Field.Complex v) {
        double rr = v.getRe();
        this.re = -v.getIm();
        this.im = rr;
    }

    public final Complex divideI() {
        return new Complex(this.im, -this.re);
    }

    public final void assignDivideI() {
        double rr = this.re;
        this.re = this.im;
        this.im = -rr;
    }

    public final void assignDivideI(Complex v) {
        double rr = v.re;
        this.re = v.im;
        this.im = -rr;
    }

    public final void assignDivideI(Field.Complex v) {
        double rr = v.getRe();
        this.re = v.getIm();
        this.im = -rr;
    }

    public final Complex divide(Field.Complex v) {
        double vIm;
        double vRe = v.getRe();
        double nn = vRe * vRe + (vIm = v.getIm()) * vIm;
        if (nn == 0.0) {
            return new Complex(this.re / nn, this.im / nn);
        }
        return new Complex((this.re * vRe + this.im * vIm) / nn, (this.im * vRe - this.re * vIm) / nn);
    }

    public final Complex divide(double r) {
        return new Complex(this.re / r, this.im / r);
    }

    public final void assignDivide(double x, double y) {
        double nn = x * x + y * y;
        if (nn == 0.0) {
            this.re /= nn;
            this.im /= nn;
        } else {
            double rr = this.re;
            double ii = this.im;
            this.re = (rr * x + ii * y) / nn;
            this.im = (ii * x - rr * y) / nn;
        }
    }

    public final void assignDivide(Complex v) {
        this.assignDivide(v.re, v.im);
    }

    public final void assignDivide(Field.Complex v) {
        this.assignDivide(v.getRe(), v.getIm());
    }

    public final void assignDivide(double r) {
        this.re /= r;
        this.im /= r;
    }

    public final void assignDivide(double x, double y, double u, double v) {
        double nn = u * u + v * v;
        if (nn == 0.0) {
            this.re /= nn;
            this.im /= nn;
        } else {
            double rr = (x * u + y * v) / nn;
            double ii = (y * u - x * v) / nn;
            this.re = rr;
            this.im = ii;
        }
    }

    public final void assignDivide(Complex u, Complex v) {
        double nn = v.re * v.re + v.im * v.im;
        if (nn == 0.0) {
            this.re /= nn;
            this.im /= nn;
        } else {
            double rr = (u.re * v.re + u.im * v.im) / nn;
            double ii = (u.im * v.re - u.re * v.im) / nn;
            this.re = rr;
            this.im = ii;
        }
    }

    public final void assignDivide(Field.Complex u, Field.Complex v) {
        this.assignDivide(u.getRe(), u.getIm(), v.getRe(), v.getIm());
    }

    public final void assignDivide(Complex u, double r) {
        this.re = u.re / r;
        this.im = u.im / r;
    }

    public final void assignDivide(Field.Complex u, double r) {
        this.re = u.getRe() / r;
        this.im = u.getIm() / r;
    }

    public final void assignDivide(double r, Complex z) {
        double nn = Complex.absSqr(z);
        if (nn == 0.0) {
            this.re = r / nn;
            this.im = 0.0;
        } else {
            this.re = r * z.re / nn;
            this.im = -r * z.im / nn;
        }
    }

    public final void assignDivide(double r, Field.Complex z) {
        double v;
        double u = z.getRe();
        double nn = u * u + (v = z.getIm()) * v;
        if (nn == 0.0) {
            this.re = r / nn;
            this.im = 0.0;
        } else {
            this.re = r * u / nn;
            this.im = -r * v / nn;
        }
    }

    public final Complex invert() {
        double nn = this.re * this.re + this.im * this.im;
        if (nn == 0.0) {
            return new Complex(Double.POSITIVE_INFINITY, 0.0);
        }
        return new Complex(this.re / nn, -this.im / nn);
    }

    public static final Complex invert(Field.Complex u) {
        double uIm;
        double uRe = u.getRe();
        double nn = uRe * uRe + (uIm = u.getIm()) * uIm;
        if (nn == 0.0) {
            return new Complex(Double.POSITIVE_INFINITY, 0.0);
        }
        return new Complex(uRe / nn, -uIm / nn);
    }

    public final void assignInvert() {
        double nn = this.re * this.re + this.im * this.im;
        if (nn == 0.0) {
            this.re = Double.POSITIVE_INFINITY;
            this.im = 0.0;
            return;
        }
        this.re /= nn;
        this.im /= -nn;
    }

    public final void assignInvert(Complex u) {
        double nn = u.re * u.re + u.im * u.im;
        if (nn == 0.0) {
            this.re = Double.POSITIVE_INFINITY;
            this.im = 0.0;
        } else {
            this.re = u.re / nn;
            this.im = -u.im / nn;
        }
    }

    public final void assignInvert(Field.Complex u) {
        double uIm;
        double uRe = u.getRe();
        double nn = uRe * uRe + (uIm = u.getIm()) * uIm;
        if (nn == 0.0) {
            this.re = Double.POSITIVE_INFINITY;
            this.im = 0.0;
        } else {
            this.re = uRe / nn;
            this.im = -uIm / nn;
        }
    }

    public static final Complex conjugate(Field.Complex u) {
        return new Complex(u.getRe(), -u.getIm());
    }

    public final Complex conjugate() {
        return new Complex(this.re, -this.im);
    }

    public final void assignConjugate() {
        this.im = -this.im;
    }

    public final void assignConjugate(Complex u) {
        this.re = u.re;
        this.im = -u.im;
    }

    public final void assignConjugate(Field.Complex u) {
        this.re = u.getRe();
        this.im = -u.getIm();
    }

    public static final Complex neg(Field.Complex u) {
        return new Complex(-u.getRe(), -u.getIm());
    }

    public final Complex neg() {
        return new Complex(-this.re, -this.im);
    }

    public final void assignNeg() {
        this.re = -this.re;
        this.im = -this.im;
    }

    public final void assignNeg(Complex u) {
        this.re = -u.re;
        this.im = -u.im;
    }

    public final void assignNeg(Field.Complex u) {
        this.re = -u.getRe();
        this.im = -u.getIm();
    }

    public static final Complex sqr(Field.Complex u) {
        double uRe = u.getRe();
        double uIm = u.getIm();
        Complex w = new Complex();
        w.re = uRe * uRe - uIm * uIm;
        w.im = 2.0 * uRe * uIm;
        return w;
    }

    public final Complex sqr() {
        return Complex.sqr(this);
    }

    public final void assignSqr() {
        double rr = this.re;
        double ii = this.im;
        this.re = rr * rr - ii * ii;
        this.im = 2.0 * rr * ii;
    }

    public final void assignSqr(Complex u) {
        if (this == u) {
            this.assignSqr();
        } else {
            this.re = u.re * u.re - u.im * u.im;
            this.im = 2.0 * u.re * u.im;
        }
    }

    public final void assignSqr(Field.Complex u) {
        if (this == u) {
            this.assignSqr();
        } else {
            double uRe = u.getRe();
            double uIm = u.getIm();
            this.re = uRe * uRe - uIm * uIm;
            this.im = 2.0 * uRe * uIm;
        }
    }

    public static final Complex cube(Field.Complex u) {
        Complex w = new Complex();
        double uRe = u.getRe();
        double uIm = u.getIm();
        w.re = uRe * (uRe * uRe - 3.0 * uIm * uIm);
        w.im = uIm * (3.0 * uRe * uRe - uIm * uIm);
        return w;
    }

    public final Complex cube() {
        return Complex.cube(this);
    }

    public final void assignCube() {
        double rr = this.re;
        double ii = this.im;
        this.re = rr * (rr * rr - 3.0 * ii * ii);
        this.im = ii * (3.0 * rr * rr - ii * ii);
    }

    public final void assignCube(Complex u) {
        if (this == u) {
            this.assignCube();
        } else {
            this.re = u.re * (u.re * u.re - 3.0 * u.im * u.im);
            this.im = u.im * (3.0 * u.re * u.re - u.im * u.im);
        }
    }

    public final void assignCube(Field.Complex u) {
        if (this == u) {
            this.assignCube();
        } else {
            double uRe = u.getRe();
            double uIm = u.getIm();
            this.re = uRe * (uRe * uRe - 3.0 * uIm * uIm);
            this.im = uIm * (3.0 * uRe * uRe - uIm * uIm);
        }
    }

    public static final double re(Complex u) {
        return u.re;
    }

    public static final double im(Complex u) {
        return u.im;
    }

    public static final Complex exp(Field.Complex u) {
        Complex w = new Complex();
        double r = Math.exp(u.getRe());
        w.re = r * Math.cos(u.getIm());
        w.im = r * Math.sin(u.getIm());
        return w;
    }

    public final Complex exp() {
        return Complex.exp(this);
    }

    public final void assignExp() {
        double r = Math.exp(this.re);
        this.re = r * Math.cos(this.im);
        this.im = r * Math.sin(this.im);
    }

    public final void assignExp(double x, double y) {
        double r = Math.exp(x);
        this.re = r * Math.cos(y);
        this.im = r * Math.sin(y);
    }

    public final void assignExp(Complex u) {
        double r = Math.exp(u.re);
        this.re = r * Math.cos(u.im);
        this.im = r * Math.sin(u.im);
    }

    public final void assignExp(Field.Complex u) {
        double r = Math.exp(u.getRe());
        this.re = r * Math.cos(u.getIm());
        this.im = r * Math.sin(u.getIm());
    }

    public static final Complex log(Field.Complex u) {
        Complex v = new Complex(u);
        v.assignLog();
        return v;
    }

    public final Complex log() {
        return Complex.log(this);
    }

    public final void assignLog() {
        this.assignLog(this);
    }

    public final void assignLog(Complex u) {
        double r = u.abs();
        if (r == 0.0) {
            this.re = Double.NEGATIVE_INFINITY;
            this.im = 0.0;
        } else {
            double arg = u.arg();
            this.re = Math.log(r);
            this.im = arg;
        }
    }

    public final void assignLog(Field.Complex u) {
        double uIm;
        double uRe = u.getRe();
        double r = Complex.abs(uRe, uIm = u.getIm());
        if (r == 0.0) {
            this.re = Double.NEGATIVE_INFINITY;
            this.im = 0.0;
        } else {
            double arg = Complex.arg(uRe, uIm);
            this.re = Math.log(r);
            this.im = arg;
        }
    }

    public static final Complex sqrt(Field.Complex u) {
        double uRe = u.getRe();
        double uIm = u.getIm();
        double rr = Math.sqrt(Complex.abs(uRe, uIm));
        double ii = Complex.arg(uRe, uIm) / 2.0;
        return new Complex(rr * Math.cos(ii), rr * Math.sin(ii));
    }

    public final Complex sqrt() {
        return Complex.sqrt(this);
    }

    public final void assignSqrt() {
        double rr = Math.sqrt(this.abs());
        double ii = this.arg() / 2.0;
        this.re = rr * Math.cos(ii);
        this.im = rr * Math.sin(ii);
    }

    public final void assignSqrt(Complex u) {
        double rr = Math.sqrt(Complex.abs(u));
        double ii = Complex.arg(u) / 2.0;
        this.re = rr * Math.cos(ii);
        this.im = rr * Math.sin(ii);
    }

    public final void assignSqrt(Field.Complex u) {
        double uRe = u.getRe();
        double uIm = u.getIm();
        double rr = Math.sqrt(Complex.abs(uRe, uIm));
        double ii = Complex.arg(uRe, uIm) / 2.0;
        this.re = rr * Math.cos(ii);
        this.im = rr * Math.sin(ii);
    }

    public static final Complex pow(Field.Complex u, Field.Complex v) {
        Complex w = new Complex(u);
        w.assignPow(v);
        return w;
    }

    public final Complex pow(Field.Complex v) {
        return Complex.pow((Field.Complex)this, v);
    }

    public final void assignPow(Complex v) {
        this.assignPow(this, v);
    }

    public final void assignPow(Field.Complex v) {
        this.assignPow((Field.Complex)this, v);
    }

    public final void assignPow(double x, double y, double u, double v) {
        if (Complex.absSqr(u, v) == 0.0) {
            this.re = 1.0;
            this.im = 0.0;
            return;
        }
        double r = Complex.abs(x, y);
        if (r == 0.0) {
            this.re = 0.0;
            this.im = 0.0;
            return;
        }
        double arg = Complex.arg(x, y);
        double tmpRe = Math.log(r);
        double tmpIm = arg;
        double rr = tmpRe * u - tmpIm * v;
        double ii = tmpRe * v + tmpIm * u;
        r = Math.exp(rr);
        this.re = r * Math.cos(ii);
        this.im = r * Math.sin(ii);
    }

    public final void assignPow(Complex u, Complex v) {
        this.assignPow(u.re, u.im, v.re, v.im);
    }

    public final void assignPow(Field.Complex u, Field.Complex v) {
        this.assignPow(u.getRe(), u.getIm(), v.getRe(), v.getIm());
    }

    public static final Complex pow(Field.Complex u, double r) {
        Complex c = new Complex();
        c.assignPow(u, r);
        return c;
    }

    public final Complex pow(double r) {
        return Complex.pow((Field.Complex)this, r);
    }

    public final void assignPow(double r) {
        this.assignPow(this, r);
    }

    public final void assignPow(double x, double y, double r) {
        double tmpIm;
        double tmpRe;
        double rad = Complex.abs(x, y);
        if (rad == 0.0) {
            tmpRe = Double.NEGATIVE_INFINITY;
            tmpIm = 0.0;
        } else {
            double arg = Complex.arg(x, y);
            tmpRe = Math.log(rad);
            tmpIm = arg;
        }
        double rr = Math.exp(tmpRe *= r);
        this.re = rr * Math.cos(tmpIm *= r);
        this.im = rr * Math.sin(tmpIm);
    }

    public final void assignPow(Complex u, double r) {
        this.assignPow(u.re, u.im, r);
    }

    public final void assignPow(Field.Complex u, double r) {
        this.assignPow(u.getRe(), u.getIm(), r);
    }

    public final void assignPow(double r, Complex u) {
        this.assignPow(r, 0.0, u.re, u.im);
    }

    public final void assignPow(double r, Field.Complex u) {
        this.assignPow(r, 0.0, u.getRe(), u.getIm());
    }

    public final void assignPow(double x, double y, int r) {
        Complex u2n = new Complex(x, y);
        if (r < 0) {
            r = -r;
            u2n.assignInvert();
        }
        this.assign(1.0, 0.0);
        while (r != 0) {
            if ((r & 1) == 1) {
                this.assignTimes(u2n);
            }
            u2n.assignSqr();
            r >>= 1;
        }
    }

    public final void assignPow(Complex u, int r) {
        this.assignPow(u.re, u.im, r);
    }

    public final void assignPow(Field.Complex u, int r) {
        this.assignPow(u.getRe(), u.getIm(), r);
    }

    public static final Complex pow(Field.Complex u, int r) {
        Complex c = new Complex();
        c.assignPow(u, r);
        return c;
    }

    public final Complex pow(int r) {
        Complex c = new Complex();
        c.assignPow(this.re, this.im, r);
        return c;
    }

    public final void assignPow(int r) {
        this.assignPow(this, r);
    }

    public static final Complex sin(Field.Complex u) {
        Complex w = new Complex();
        w.assignSin(u.getRe(), u.getIm());
        return w;
    }

    public final Complex sin() {
        return Complex.sin(this);
    }

    public final void assignSin() {
        this.assignSin(this.re, this.im);
    }

    public final void assignSin(double x, double y) {
        double sinRe = Math.sin(x);
        double cosRe = Math.cos(x);
        double expIm = Math.exp(y);
        this.re = sinRe * (expIm + 1.0 / expIm) / 2.0;
        this.im = cosRe * (expIm - 1.0 / expIm) / 2.0;
    }

    public final void assignSin(Complex u) {
        this.assignSin(u.re, u.im);
    }

    public final void assignSin(Field.Complex u) {
        this.assignSin(u.getRe(), u.getIm());
    }

    public static final Complex cos(Field.Complex u) {
        Complex w = new Complex();
        w.assignCos(u.getRe(), u.getIm());
        return w;
    }

    public final Complex cos() {
        return Complex.cos(this);
    }

    public final void assignCos() {
        this.assignCos(this.re, this.im);
    }

    public final void assignCos(double x, double y) {
        double cosRe = Math.cos(x);
        double sinRe = Math.sin(x);
        double expIm = Math.exp(y);
        this.re = cosRe * (expIm + 1.0 / expIm) / 2.0;
        this.im = -sinRe * (expIm - 1.0 / expIm) / 2.0;
    }

    public final void assignCos(Complex u) {
        this.assignCos(u.re, u.im);
    }

    public final void assignCos(Field.Complex u) {
        this.assignCos(u.getRe(), u.getIm());
    }

    public static final Complex tan(Field.Complex u) {
        Complex w = new Complex();
        w.assignTan(u.getRe(), u.getIm());
        return w;
    }

    public final Complex tan() {
        return Complex.tan(this);
    }

    public final void assignTan() {
        this.assignTan(this.re, this.im);
    }

    public final void assignTan(double x, double y) {
        double cosRe = Math.cos(x);
        double sinRe = Math.sin(x);
        double expIm = Math.exp(y);
        double reCos = cosRe * (expIm + 1.0 / expIm) / 2.0;
        double imCos = -sinRe * (expIm - 1.0 / expIm) / 2.0;
        this.re = sinRe * (expIm + 1.0 / expIm) / 2.0;
        this.im = cosRe * (expIm - 1.0 / expIm) / 2.0;
        this.assignDivide(reCos, imCos);
    }

    public final void assignTan(Complex u) {
        this.assignTan(u.re, u.im);
    }

    public final void assignTan(Field.Complex u) {
        this.assignTan(u.getRe(), u.getIm());
    }

    public static final Complex sinh(Field.Complex u) {
        Complex w = new Complex();
        w.assignSinh(u.getRe(), u.getIm());
        return w;
    }

    public final Complex sinh() {
        return Complex.sinh(this);
    }

    public final void assignSinh() {
        this.assignSinh(this.re, this.im);
    }

    public final void assignSinh(double x, double y) {
        double sinIm = Math.sin(y);
        double cosIm = Math.cos(y);
        double expRe = Math.exp(x);
        this.re = cosIm * (expRe - 1.0 / expRe) / 2.0;
        this.im = sinIm * (expRe + 1.0 / expRe) / 2.0;
    }

    public final void assignSinh(Complex u) {
        this.assignSinh(u.re, u.im);
    }

    public final void assignSinh(Field.Complex u) {
        this.assignSinh(u.getRe(), u.getIm());
    }

    public static final Complex cosh(Field.Complex u) {
        Complex w = new Complex();
        w.assignCosh(u.getRe(), u.getIm());
        return w;
    }

    public final Complex cosh() {
        return Complex.cosh(this);
    }

    public final void assignCosh() {
        this.assignCosh(this.re, this.im);
    }

    public final void assignCosh(double x, double y) {
        double sinIm = Math.sin(y);
        double cosIm = Math.cos(y);
        double expRe = Math.exp(x);
        this.re = cosIm * (expRe + 1.0 / expRe) / 2.0;
        this.im = sinIm * (expRe - 1.0 / expRe) / 2.0;
    }

    public final void assignCosh(Complex u) {
        this.assignCosh(u.re, u.im);
    }

    public final void assignCosh(Field.Complex u) {
        this.assignCosh(u.getRe(), u.getIm());
    }

    public static final Complex fromPolar(double r, double f) {
        Complex w = new Complex();
        w.re = r * Math.cos(f);
        w.im = r * Math.sin(f);
        return w;
    }

    public final void assignFromPolar(double r, double f) {
        this.re = r * Math.cos(f);
        this.im = r * Math.sin(f);
    }

    public final void assignCrossRatio(double aRe, double aIm, double bRe, double bIm, double cRe, double cIm, double dRe, double dIm) {
        this.assignDivide(cRe - bRe, cIm - bIm, bRe - aRe, bIm - aIm);
        this.assignTimes(aRe - dRe, aIm - dIm);
        this.assignDivide(dRe - cRe, dIm - cIm);
    }

    public static final Complex crossRatio(Field.Complex a, Field.Complex b, Field.Complex c, Field.Complex d) {
        Complex cr = new Complex();
        cr.assignCrossRatio(a, b, c, d);
        return cr;
    }

    public final void assignCrossRatio(Complex a, Complex b, Complex c, Complex d) {
        this.assignCrossRatio(a.re, a.im, b.re, b.im, c.re, c.im, d.re, d.im);
    }

    public final void assignCrossRatio(Field.Complex a, Field.Complex b, Field.Complex c, Field.Complex d) {
        this.assignCrossRatio(a.getRe(), a.getIm(), b.getRe(), b.getIm(), c.getRe(), c.getIm(), d.getRe(), d.getIm());
    }

    public final void assignRandom() {
        this.re = Math.random();
        this.im = Math.random();
    }

    public static final double dot(Complex u, Complex v) {
        return u.re * v.re + u.im * v.im;
    }

    public final double dot(Complex v) {
        return this.re * v.re + this.im * v.im;
    }

    public final double dot(Field.Complex v) {
        return this.re * v.getRe() + this.im * v.getIm();
    }

    public static final double det(Complex u, Complex v) {
        return u.re * v.im - u.im * v.re;
    }

    public final double det(Complex v) {
        return this.re * v.im - this.im * v.re;
    }

    public final double det(Field.Complex v) {
        return this.re * v.getIm() - this.im * v.getRe();
    }

    public static final double distSqr(Complex u, Complex v) {
        double subRe = u.re - v.re;
        double subIm = u.im - v.im;
        return subRe * subRe + subIm * subIm;
    }

    public final double distSqr(Complex v) {
        double subRe = this.re - v.re;
        double subIm = this.im - v.im;
        return subRe * subRe + subIm * subIm;
    }

    public final double distSqr(Field.Complex v) {
        double subRe = this.re - v.getRe();
        double subIm = this.im - v.getIm();
        return subRe * subRe + subIm * subIm;
    }

    public static final double dist(Complex u, Complex v) {
        return Math.sqrt(Complex.distSqr(u, v));
    }

    public final double dist(Complex v) {
        return Math.sqrt(this.distSqr(v));
    }

    public final double dist(Field.Complex v) {
        return Math.sqrt(this.distSqr(v));
    }

    public static final double abs(Complex u) {
        return u.abs();
    }

    public final double abs() {
        return Math.sqrt(this.re * this.re + this.im * this.im);
    }

    public static final double absSqr(Complex u) {
        return u.re * u.re + u.im * u.im;
    }

    public final double absSqr() {
        return this.re * this.re + this.im * this.im;
    }

    public static final double arg(Complex u) {
        return Complex.arg(u.re, u.im);
    }

    public final double arg() {
        return Complex.arg(this.re, this.im);
    }

    public final boolean equals(Field.Complex c, double eps) {
        return Math.abs(this.re - c.getRe()) < eps && Math.abs(this.im - c.getIm()) < eps;
    }

    @Override
    public final boolean equals(Field.Complex c) {
        return this == c ? true : this.equals(c.getRe(), c.getIm());
    }

    public final boolean equals(Complex c) {
        return this == c ? true : this.equals(c.re, c.im);
    }

    public final boolean equals(double x, double y, double eps) {
        return Math.abs(this.re - x) < eps && Math.abs(this.im - y) < eps;
    }

    public final boolean equals(double x, double y) {
        return Math.abs(this.re - x) < 1.0E-14 && Math.abs(this.im - y) < 1.0E-14;
    }

    public final boolean equals(Complex c, double eps) {
        return Math.abs(this.re - c.re) < eps && Math.abs(this.im - c.im) < eps;
    }

    public static final boolean arraysCoincide(Complex[] c1, Complex[] c2, double eps) {
        if (c1 == null && c2 == null) {
            return true;
        }
        if (c1 == null && c2 != null || c2 == null && c1 != null || c2.length != c1.length) {
            return false;
        }
        int l = c1.length;
        for (int i = 0; i < l; ++i) {
            if (c1[i].equals(c2[i], eps)) continue;
            return false;
        }
        return true;
    }

    public static final boolean arraysCoincide(Complex[] c1, Complex[] c2) {
        return Complex.arraysCoincide(c1, c2, 1.0E-14);
    }

    public static final boolean setsCoincide(Complex[] c1, Complex[] c2) {
        return Complex.setsCoincide(c1, c2, 1.0E-14);
    }

    public static final boolean setsCoincide(Complex[] c1, Complex[] c2, double eps) {
        if (c1 == null && c2 == null) {
            return true;
        }
        if (c1 == null && c2 != null || c2 == null && c1 != null || c2.length != c1.length) {
            return false;
        }
        int l = c1.length;
        LinkedList<Complex> liste = new LinkedList<Complex>();
        for (int i = 0; i < l; ++i) {
            liste.add(c2[i]);
        }
        block1: for (int i = 0; i < l; ++i) {
            ListIterator it = liste.listIterator(0);
            while (it.hasNext()) {
                if (c1[i].equals((Complex)it.next(), eps)) {
                    it.remove();
                    continue block1;
                }
                if (it.hasNext()) continue;
                return false;
            }
        }
        return liste.size() == 0;
    }

    public static final void arraycopy(Field.Complex[] s, int is, Complex[] d, int id, int size) {
        if (is + size > s.length || id + size > d.length) {
            throw new IndexOutOfBoundsException();
        }
        if (s == d && id == is) {
            return;
        }
        if (id <= is) {
            int i = 0;
            while (i < size) {
                if (s[is] == null) {
                    d[id] = null;
                } else if (d[id] != null) {
                    d[id].assign(s[is]);
                } else {
                    d[id] = new Complex(s[is]);
                }
                ++i;
                ++is;
                ++id;
            }
        } else {
            is += size - 1;
            id += size - 1;
            int i = 0;
            while (i < size) {
                if (s[is] == null) {
                    d[id] = null;
                } else if (d[id] != null) {
                    d[id].assign(s[is]);
                } else {
                    d[id] = new Complex(s[is]);
                }
                ++i;
                --is;
                --id;
            }
        }
    }

    public static final Complex[] copy(Field.Complex[] s) {
        Complex[] d = new Complex[s.length];
        Complex.arraycopy(s, 0, d, 0, s.length);
        return d;
    }

    public static Complex[] createArray(int length) {
        Complex[] array = new Complex[length];
        for (int i = 0; i < length; ++i) {
            array[i] = new Complex();
        }
        return array;
    }

    public static interface FunctionOnComplex {
        public static final FunctionOnComplex ID = new FunctionOnComplex(){

            @Override
            public void eval(Complex z, Complex result) {
                result.assign(z);
            }
        };
        public static final FunctionOnComplex ZERO = new FunctionOnComplex(){

            @Override
            public void eval(Complex z, Complex result) {
                result.assign(0.0, 0.0);
            }
        };

        public void eval(Complex var1, Complex var2);
    }
}

