/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.mfc.field;

import de.jtem.mfc.field.Complex;
import de.jtem.mfc.vector.Real3;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.ListIterator;

public class Quaternion
implements Serializable,
Cloneable {
    static final double EPS = 1.0E-14;
    static final double EPSSQR = 1.0E-28;
    private static final long serialVersionUID = 1L;
    public static final Quaternion ZERO = new Quaternion(0.0, 0.0, 0.0, 0.0);
    public static final Quaternion ONE = new Quaternion(1.0, 0.0, 0.0, 0.0);
    public static final Quaternion I = new Quaternion(0.0, 1.0, 0.0, 0.0);
    public static final Quaternion J = new Quaternion(0.0, 0.0, 1.0, 0.0);
    public static final Quaternion K = new Quaternion(0.0, 0.0, 0.0, 1.0);
    public static final Quaternion NEG_ONE = new Quaternion(-1.0, 0.0, 0.0, 0.0);
    public static final Quaternion NEG_I = new Quaternion(0.0, -1.0, 0.0, 0.0);
    public static final Quaternion NEG_J = new Quaternion(0.0, 0.0, -1.0, 0.0);
    public static final Quaternion NEG_K = new Quaternion(0.0, 0.0, 0.0, -1.0);
    public double re;
    public double x;
    public double y;
    public double z;

    public Quaternion() {
    }

    public Quaternion(double re) {
        this.re = re;
    }

    public Quaternion(Real3 im) {
        this.x = im.x;
        this.y = im.y;
        this.z = im.z;
    }

    public Quaternion(Complex u, Complex v) {
        this.re = u.re;
        this.x = u.im;
        this.y = v.re;
        this.z = -v.im;
    }

    public Quaternion(double re, double x, double y, double z) {
        this.re = re;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Quaternion(double re, Real3 im) {
        this.re = re;
        this.x = im.x;
        this.y = im.y;
        this.z = im.z;
    }

    public Quaternion(Quaternion q) {
        this.assign(q);
    }

    public final double getRe() {
        return this.re;
    }

    public final Real3 getIm() {
        return new Real3(this.x, this.y, this.z);
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public final double getZ() {
        return this.z;
    }

    public final void setRe(double re) {
        this.re = re;
    }

    public final void setIm(Real3 im) {
        this.x = im.x;
        this.y = im.y;
        this.z = im.z;
    }

    public final void setX(double x) {
        this.x = x;
    }

    public final void setY(double y) {
        this.y = y;
    }

    public final void setZ(double z) {
        this.z = z;
    }

    public final Quaternion set(double aR) {
        this.re = aR;
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
        return this;
    }

    public final void assign(double re) {
        this.re = re;
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
    }

    public final Quaternion set(Complex u, Complex v) {
        this.re = u.re;
        this.x = u.im;
        this.y = v.re;
        this.z = -v.im;
        return this;
    }

    public final void assign(Real3 im) {
        this.re = 0.0;
        this.x = im.x;
        this.y = im.y;
        this.z = im.z;
    }

    public final void assign(Complex u, Complex v) {
        this.re = u.re;
        this.x = u.im;
        this.y = v.re;
        this.z = -v.im;
    }

    public final Quaternion set(double aR, double aI, double aJ, double aK) {
        this.re = aR;
        this.x = aI;
        this.y = aJ;
        this.z = aK;
        return this;
    }

    public final void assign(double re, double x, double y, double z) {
        this.re = re;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public final Quaternion set(Quaternion q) {
        this.re = q.re;
        this.x = q.x;
        this.y = q.y;
        this.z = q.z;
        return this;
    }

    public final Quaternion assign(Quaternion q) {
        this.re = q.re;
        this.x = q.x;
        this.y = q.y;
        this.z = q.z;
        return this;
    }

    public final Quaternion copy() {
        return new Quaternion(this.re, this.x, this.y, this.z);
    }

    public final Object clone() {
        return this.copy();
    }

    public final boolean isInfinite() {
        return Double.isInfinite(this.re) || Double.isInfinite(this.x) || Double.isInfinite(this.y) || Double.isInfinite(this.z);
    }

    public final boolean isNaN() {
        return Double.isNaN(this.re) || Double.isNaN(this.x) || Double.isNaN(this.y) || Double.isNaN(this.z);
    }

    public final Quaternion plus(Quaternion q) {
        return new Quaternion(this.re + q.re, this.x + q.x, this.y + q.y, this.z + q.z);
    }

    public final Quaternion plus(Real3 im) {
        return new Quaternion(this.re, this.x + im.x, this.y + im.y, this.z + im.z);
    }

    public final Quaternion plus(double re) {
        return new Quaternion(this.re + re, this.x, this.y, this.z);
    }

    public final Quaternion setPlus(Quaternion q) {
        this.re += q.re;
        this.x += q.x;
        this.y += q.y;
        this.z += q.z;
        return this;
    }

    public final void assignPlus(Quaternion q) {
        this.re += q.re;
        this.x += q.x;
        this.y += q.y;
        this.z += q.z;
    }

    public final void assignPlus(Real3 im) {
        this.x += im.x;
        this.y += im.y;
        this.z += im.z;
    }

    public final void assignPlus(double re) {
        this.re += re;
    }

    public final Quaternion setPlus(Quaternion q, Quaternion qq) {
        this.re = q.re + qq.re;
        this.x = q.x + qq.x;
        this.y = q.y + qq.y;
        this.z = q.z + qq.z;
        return this;
    }

    public final void assignPlus(Quaternion q, Quaternion qq) {
        this.re = q.re + qq.re;
        this.x = q.x + qq.x;
        this.y = q.y + qq.y;
        this.z = q.z + qq.z;
    }

    public final Quaternion setPlus(Quaternion q, double aR) {
        this.re = q.re + aR;
        this.x = q.x;
        this.y = q.y;
        this.z = q.z;
        return this;
    }

    public final void assignPlus(Quaternion q, double aR) {
        this.re = q.re + aR;
        this.x = q.x;
        this.y = q.y;
        this.z = q.z;
    }

    public final Quaternion minus(Quaternion q) {
        return new Quaternion(this.re - q.re, this.x - q.x, this.y - q.y, this.z - q.z);
    }

    public final Quaternion minus(double aR) {
        return new Quaternion(this.re - aR, this.x, this.y, this.z);
    }

    public final Quaternion setMinus(Quaternion q) {
        this.re -= q.re;
        this.x -= q.x;
        this.y -= q.y;
        this.z -= q.z;
        return this;
    }

    public final void assignMinus(Quaternion q) {
        this.re -= q.re;
        this.x -= q.x;
        this.y -= q.y;
        this.z -= q.z;
    }

    public final Quaternion setMinus(double aR) {
        this.re -= aR;
        return this;
    }

    public final void assignMinus(double aR) {
        this.re -= aR;
    }

    public final Quaternion setMinus(Quaternion q, Quaternion qq) {
        this.re = q.re - qq.re;
        this.x = q.x - qq.x;
        this.y = q.y - qq.y;
        this.z = q.z - qq.z;
        return this;
    }

    public final void assignMinus(Quaternion q, Quaternion qq) {
        this.re = q.re - qq.re;
        this.x = q.x - qq.x;
        this.y = q.y - qq.y;
        this.z = q.z - qq.z;
    }

    public final Quaternion setMinus(Quaternion q, double aR) {
        this.re = q.re - aR;
        this.x = q.x;
        this.y = q.y;
        this.z = q.z;
        return this;
    }

    public final void assignMinus(Quaternion q, double aR) {
        this.re = q.re - aR;
        this.x = q.x;
        this.y = q.y;
        this.z = q.z;
    }

    public final Quaternion times(Quaternion q) {
        return new Quaternion(this.re * q.re - this.x * q.x - this.y * q.y - this.z * q.z, this.re * q.x + this.x * q.re + this.y * q.z - this.z * q.y, this.re * q.y - this.x * q.z + this.y * q.re + this.z * q.x, this.re * q.z + this.x * q.y - this.y * q.x + this.z * q.re);
    }

    public final Quaternion times(Real3 im) {
        return new Quaternion(-this.x * im.x - this.y * im.y - this.z * im.z, this.re * im.x + this.y * im.z - this.z * im.y, this.re * im.y - this.x * im.z + this.z * im.x, this.re * im.z + this.x * im.y - this.y * im.x);
    }

    public final Quaternion times(double re) {
        return new Quaternion(this.re * re, this.x * re, this.y * re, this.z * re);
    }

    public final Quaternion setTimes(Quaternion q) {
        double rr = this.re;
        double ii = this.x;
        double jj = this.y;
        double kk = this.z;
        if (q == this) {
            this.re = rr * rr - ii * ii - jj * jj - kk * kk;
            this.x = rr * ii + ii * rr + jj * kk - kk * jj;
            this.y = rr * jj - ii * kk + jj * rr + kk * ii;
            this.z = rr * kk + ii * jj - jj * ii + kk * rr;
        } else {
            this.re = rr * q.re - ii * q.x - jj * q.y - kk * q.z;
            this.x = rr * q.x + ii * q.re + jj * q.z - kk * q.y;
            this.y = rr * q.y - ii * q.z + jj * q.re + kk * q.x;
            this.z = rr * q.z + ii * q.y - jj * q.x + kk * q.re;
        }
        return this;
    }

    public final void assignTimes(Quaternion q) {
        double rr = this.re;
        double ii = this.x;
        double jj = this.y;
        double kk = this.z;
        if (q == this) {
            this.re = rr * rr - ii * ii - jj * jj - kk * kk;
            this.x = rr * ii + ii * rr + jj * kk - kk * jj;
            this.y = rr * jj - ii * kk + jj * rr + kk * ii;
            this.z = rr * kk + ii * jj - jj * ii + kk * rr;
        } else {
            this.re = rr * q.re - ii * q.x - jj * q.y - kk * q.z;
            this.x = rr * q.x + ii * q.re + jj * q.z - kk * q.y;
            this.y = rr * q.y - ii * q.z + jj * q.re + kk * q.x;
            this.z = rr * q.z + ii * q.y - jj * q.x + kk * q.re;
        }
    }

    public final void assignTimes(Real3 im) {
        double rr = this.re;
        double ii = this.x;
        double jj = this.y;
        double kk = this.z;
        this.re = -ii * im.x - jj * im.y - kk * im.z;
        this.x = rr * im.x + jj * im.z - kk * im.y;
        this.y = rr * im.y - ii * im.z + kk * im.x;
        this.z = rr * im.z + ii * im.y - jj * im.x;
    }

    public final Quaternion setTimes(double aR) {
        this.re *= aR;
        this.x *= aR;
        this.y *= aR;
        this.z *= aR;
        return this;
    }

    public final void assignTimes(double aR) {
        this.re *= aR;
        this.x *= aR;
        this.y *= aR;
        this.z *= aR;
    }

    public final Quaternion setTimes(Quaternion q, Quaternion qq) {
        if (q == this || qq == this) {
            double rr = q.re * qq.re - q.x * qq.x - q.y * qq.y - q.z * qq.z;
            double ii = q.re * qq.x + q.x * qq.re + q.y * qq.z - q.z * qq.y;
            double jj = q.re * qq.y - q.x * qq.z + q.y * qq.re + q.z * qq.x;
            this.z = q.re * qq.z + q.x * qq.y - q.y * qq.x + q.z * qq.re;
            this.re = rr;
            this.x = ii;
            this.y = jj;
        } else {
            this.re = q.re * qq.re - q.x * qq.x - q.y * qq.y - q.z * qq.z;
            this.x = q.re * qq.x + q.x * qq.re + q.y * qq.z - q.z * qq.y;
            this.y = q.re * qq.y - q.x * qq.z + q.y * qq.re + q.z * qq.x;
            this.z = q.re * qq.z + q.x * qq.y - q.y * qq.x + q.z * qq.re;
        }
        return this;
    }

    public final void assignTimes(Quaternion a, Quaternion b) {
        if (a == this || b == this) {
            double rr = a.re * b.re - a.x * b.x - a.y * b.y - a.z * b.z;
            double ii = a.re * b.x + a.x * b.re + a.y * b.z - a.z * b.y;
            double jj = a.re * b.y - a.x * b.z + a.y * b.re + a.z * b.x;
            this.z = a.re * b.z + a.x * b.y - a.y * b.x + a.z * b.re;
            this.re = rr;
            this.x = ii;
            this.y = jj;
        } else {
            this.re = a.re * b.re - a.x * b.x - a.y * b.y - a.z * b.z;
            this.x = a.re * b.x + a.x * b.re + a.y * b.z - a.z * b.y;
            this.y = a.re * b.y - a.x * b.z + a.y * b.re + a.z * b.x;
            this.z = a.re * b.z + a.x * b.y - a.y * b.x + a.z * b.re;
        }
    }

    public final void assignTimes(Quaternion a, Real3 b) {
        if (a == this) {
            double rr = -a.x * b.x - a.y * b.y - a.z * b.z;
            double ii = a.re * b.x + a.y * b.z - a.z * b.y;
            double jj = a.re * b.y + a.z * b.x;
            this.z = a.re * b.z + a.x * b.y - a.y * b.x;
            this.re = rr;
            this.x = ii;
            this.y = jj;
        } else {
            this.re = -a.x * b.x - a.y * b.y - a.z * b.z;
            this.x = a.re * b.x + a.y * b.z - a.z * b.y;
            this.y = a.re * b.y - a.x * b.z + a.z * b.x;
            this.z = a.re * b.z + a.x * b.y - a.y * b.x;
        }
    }

    public final void assignTimes(Real3 a, Quaternion b) {
        if (b == this) {
            double rr = -a.x * b.x - a.y * b.y - a.z * b.z;
            double ii = a.x * b.re + a.y * b.z - a.z * b.y;
            double jj = -a.x * b.z + a.y * b.re + a.z * b.x;
            this.z = a.x * b.y - a.y * b.x + a.z * b.re;
            this.re = rr;
            this.x = ii;
            this.y = jj;
        } else {
            this.re = -a.x * b.x - a.y * b.y - a.z * b.z;
            this.x = a.x * b.re + a.y * b.z - a.z * b.y;
            this.y = -a.x * b.z + a.y * b.re + a.z * b.x;
            this.z = a.x * b.y - a.y * b.x + a.z * b.re;
        }
    }

    public final Quaternion setTimes(Quaternion q, double aR) {
        this.re = q.re * aR;
        this.x = q.x * aR;
        this.y = q.y * aR;
        this.z = q.z * aR;
        return this;
    }

    public final void assignTimes(Quaternion q, double re) {
        this.re = q.re * re;
        this.x = q.x * re;
        this.y = q.y * re;
        this.z = q.z * re;
    }

    public final double lengthSqr() {
        return this.re * this.re + this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public static final double lengthSqr(Quaternion q) {
        return q.re * q.re + q.x * q.x + q.y * q.y + q.z * q.z;
    }

    public final double length() {
        return Math.sqrt(this.lengthSqr());
    }

    public static final double length(Quaternion q) {
        return Math.sqrt(Quaternion.lengthSqr(q));
    }

    public final double absSqr() {
        return this.re * this.re + this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public static final double absSqr(Quaternion q) {
        return q.re * q.re + q.x * q.x + q.y * q.y + q.z * q.z;
    }

    public final double abs() {
        return Math.sqrt(this.absSqr());
    }

    public static final double abs(Quaternion q) {
        return Math.sqrt(Quaternion.absSqr(q));
    }

    public final Quaternion invert() {
        double l = this.lengthSqr();
        if (l == 0.0) {
            return new Quaternion(Double.POSITIVE_INFINITY, 0.0, 0.0, 0.0);
        }
        return new Quaternion(this.re / l, -this.x / l, -this.y / l, -this.z / l);
    }

    public static final Quaternion invert(Quaternion q) {
        double l = Quaternion.lengthSqr(q);
        if (l == 0.0) {
            return new Quaternion(Double.POSITIVE_INFINITY, 0.0, 0.0, 0.0);
        }
        return new Quaternion(q.re / l, -q.x / l, -q.y / l, -q.z / l);
    }

    public final Quaternion setInvert() {
        double l = this.lengthSqr();
        if (l == 0.0) {
            this.re = Double.POSITIVE_INFINITY;
            this.x = 0.0;
            this.y = 0.0;
            this.z = 0.0;
        } else {
            this.re /= l;
            this.x = -this.x / l;
            this.y = -this.y / l;
            this.z = -this.z / l;
        }
        return this;
    }

    public final void assignInvert() {
        double l = this.lengthSqr();
        if (l == 0.0) {
            this.re = Double.POSITIVE_INFINITY;
            this.x = 0.0;
            this.y = 0.0;
            this.z = 0.0;
        } else {
            this.re /= l;
            this.x = -this.x / l;
            this.y = -this.y / l;
            this.z = -this.z / l;
        }
    }

    public final Quaternion setInvert(Quaternion q) {
        double l = Quaternion.lengthSqr(q);
        if (l == 0.0) {
            this.re = Double.POSITIVE_INFINITY;
            this.x = 0.0;
            this.y = 0.0;
            this.z = 0.0;
        } else {
            this.re = q.re / l;
            this.x = -q.x / l;
            this.y = -q.y / l;
            this.z = -q.z / l;
        }
        return this;
    }

    public final void assignInvert(Quaternion q) {
        double l = Quaternion.lengthSqr(q);
        if (l == 0.0) {
            this.re = Double.POSITIVE_INFINITY;
            this.x = 0.0;
            this.y = 0.0;
            this.z = 0.0;
        } else {
            this.re = q.re / l;
            this.x = -q.x / l;
            this.y = -q.y / l;
            this.z = -q.z / l;
        }
    }

    public final Quaternion divide(Quaternion q) {
        double kTmp;
        double jTmp;
        double iTmp;
        double rTmp;
        double l = Quaternion.lengthSqr(q);
        if (l == 0.0) {
            return new Quaternion(this.re / l, this.x / l, this.y / l, this.z / l);
        }
        if (l == 0.0) {
            rTmp = Double.POSITIVE_INFINITY;
            iTmp = 0.0;
            jTmp = 0.0;
            kTmp = 0.0;
        } else {
            rTmp = q.re / l;
            iTmp = -q.x / l;
            jTmp = -q.y / l;
            kTmp = -q.z / l;
        }
        return new Quaternion(this.re * rTmp - this.x * iTmp - this.y * jTmp - this.z * kTmp, this.re * iTmp + this.x * rTmp + this.y * kTmp - this.z * jTmp, this.re * jTmp - this.x * kTmp + this.y * rTmp + this.z * iTmp, this.re * kTmp + this.x * jTmp - this.y * iTmp + this.z * rTmp);
    }

    public final Quaternion divide(double aR) {
        return new Quaternion(this.re / aR, this.x / aR, this.y / aR, this.z / aR);
    }

    public final Quaternion setDivide(Quaternion q) {
        this.assignDivide(q);
        return this;
    }

    public final void assignDivide(Quaternion q) {
        double kTmp;
        double jTmp;
        double iTmp;
        double rTmp;
        double l = Quaternion.lengthSqr(q);
        if (l == 0.0) {
            this.re /= l;
            this.y /= l;
            this.x /= l;
            this.z /= l;
            rTmp = Double.POSITIVE_INFINITY;
            iTmp = 0.0;
            jTmp = 0.0;
            kTmp = 0.0;
        } else {
            rTmp = q.re / l;
            iTmp = -q.x / l;
            jTmp = -q.y / l;
            kTmp = -q.z / l;
        }
        this.assignTimes(new Quaternion(rTmp, iTmp, jTmp, kTmp));
    }

    public final Quaternion setDivide(double aR) {
        this.re /= aR;
        this.x /= aR;
        this.y /= aR;
        this.z /= aR;
        return this;
    }

    public final void assignDivide(double aR) {
        this.re /= aR;
        this.x /= aR;
        this.y /= aR;
        this.z /= aR;
    }

    public final Quaternion setDivide(Quaternion q, Quaternion qq) {
        this.assignDivide(q, qq);
        return this;
    }

    public final void assignDivide(Quaternion q, Quaternion qq) {
        double kTmp;
        double jTmp;
        double iTmp;
        double rTmp;
        double l = Quaternion.lengthSqr(qq);
        if (l == 0.0) {
            this.re = q.re / l;
            this.x = q.x / l;
            this.y = q.y / l;
            this.z = q.z / l;
            rTmp = Double.POSITIVE_INFINITY;
            iTmp = 0.0;
            jTmp = 0.0;
            kTmp = 0.0;
        } else {
            rTmp = qq.re / l;
            iTmp = -qq.x / l;
            jTmp = -qq.y / l;
            kTmp = -qq.z / l;
        }
        this.assignTimes(q, new Quaternion(rTmp, iTmp, jTmp, kTmp));
    }

    public final Quaternion setDivide(Quaternion q, double aR) {
        this.re = q.re / aR;
        this.x = q.x / aR;
        this.y = q.y / aR;
        this.z = q.z / aR;
        return this;
    }

    public final void assignDivide(Quaternion q, double aR) {
        this.re = q.re / aR;
        this.x = q.x / aR;
        this.y = q.y / aR;
        this.z = q.z / aR;
    }

    public final Quaternion conjugate() {
        return new Quaternion(this.re, -this.x, -this.y, -this.z);
    }

    public static final Quaternion conjugate(Quaternion q) {
        return new Quaternion(q.re, -q.x, -q.y, -q.z);
    }

    public final Quaternion setConjugate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        return this;
    }

    public final void assignConjugate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
    }

    public final Quaternion setConjugate(Quaternion q) {
        this.re = q.re;
        this.x = -q.x;
        this.y = -q.y;
        this.z = -q.z;
        return this;
    }

    public final void assignConjugate(Quaternion q) {
        this.re = q.re;
        this.x = -q.x;
        this.y = -q.y;
        this.z = -q.z;
    }

    public final Quaternion bar() {
        return new Quaternion(this.re, -this.x, -this.y, -this.z);
    }

    public static final Quaternion bar(Quaternion q) {
        return new Quaternion(q.re, -q.x, -q.y, -q.z);
    }

    public final Quaternion setBar() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        return this;
    }

    public final void assignBar() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
    }

    public final Quaternion setBar(Quaternion q) {
        this.re = q.re;
        this.x = -q.x;
        this.y = -q.y;
        this.z = -q.z;
        return this;
    }

    public final void assignBar(Quaternion q) {
        this.re = q.re;
        this.x = -q.x;
        this.y = -q.y;
        this.z = -q.z;
    }

    public final Quaternion neg() {
        return new Quaternion(-this.re, -this.x, -this.y, -this.z);
    }

    public static final Quaternion neg(Quaternion q) {
        return new Quaternion(-q.re, -q.x, -q.y, -q.z);
    }

    public final Quaternion setNeg() {
        this.re = -this.re;
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        return this;
    }

    public final void assignNeg() {
        this.re = -this.re;
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
    }

    public final Quaternion setNeg(Quaternion q) {
        this.re = -q.re;
        this.x = -q.x;
        this.y = -q.y;
        this.z = -q.z;
        return this;
    }

    public final void assignNeg(Quaternion q) {
        this.re = -q.re;
        this.x = -q.x;
        this.y = -q.y;
        this.z = -q.z;
    }

    public final Quaternion norm() {
        double l = this.length();
        if (l == 0.0) {
            l = 1.0;
        }
        return new Quaternion(this.re / l, this.x / l, this.y / l, this.z / l);
    }

    public static final Quaternion norm(Quaternion q) {
        double l = Quaternion.length(q);
        if (l == 0.0) {
            l = 1.0;
        }
        return new Quaternion(q.re / l, q.x / l, q.y / l, q.z / l);
    }

    public final Quaternion setNorm() {
        double l = this.length();
        if (l == 0.0) {
            l = 1.0;
        }
        this.re /= l;
        this.x /= l;
        this.y /= l;
        this.z /= l;
        return this;
    }

    public final void assignNorm() {
        double l = this.length();
        if (l == 0.0) {
            l = 1.0;
        }
        this.re /= l;
        this.x /= l;
        this.y /= l;
        this.z /= l;
    }

    public final Quaternion setNorm(Quaternion q) {
        double l = Quaternion.length(q);
        if (l == 0.0) {
            l = 1.0;
        }
        this.re = q.re / l;
        this.x = q.x / l;
        this.y = q.y / l;
        this.z = q.z / l;
        return this;
    }

    public final void assignNorm(Quaternion q) {
        double l = Quaternion.length(q);
        if (l == 0.0) {
            l = 1.0;
        }
        this.re = q.re / l;
        this.x = q.x / l;
        this.y = q.y / l;
        this.z = q.z / l;
    }

    public static final Quaternion mean(Quaternion p, Quaternion q) {
        return new Quaternion(0.5 * (p.re + q.re), 0.5 * (p.x + q.x), 0.5 * (p.y + q.y), 0.5 * (p.z + q.z));
    }

    public final Quaternion setMean(Quaternion p, Quaternion q) {
        this.re = 0.5 * (p.re + q.re);
        this.x = 0.5 * (p.x + q.x);
        this.y = 0.5 * (p.y + q.y);
        this.z = 0.5 * (p.z + q.z);
        return this;
    }

    public final void assignMean(Quaternion p, Quaternion q) {
        this.re = 0.5 * (p.re + q.re);
        this.x = 0.5 * (p.x + q.x);
        this.y = 0.5 * (p.y + q.y);
        this.z = 0.5 * (p.z + q.z);
    }

    public final double dot(Quaternion p, Quaternion q) {
        return p.re * q.re + p.x * q.x + p.y * q.y * p.z + q.z;
    }

    public final double dot(Quaternion p) {
        return this.re * p.re + this.x * p.x + this.y * p.y * this.z + p.z;
    }

    public static final double r(Quaternion q) {
        return q.re;
    }

    public static final double i(Quaternion q) {
        return q.x;
    }

    public static final double j(Quaternion q) {
        return q.y;
    }

    public static final double k(Quaternion q) {
        return q.z;
    }

    public final String toString() {
        StringBuffer sb = new StringBuffer().append('(').append(this.re);
        if (this.x >= 0.0) {
            sb.append('+');
        }
        sb.append(this.x).append('i');
        if (this.y >= 0.0) {
            sb.append('+');
        }
        sb.append(this.y).append('j');
        if (this.z >= 0.0) {
            sb.append('+');
        }
        return sb.append(this.z).append('k').append(')').toString();
    }

    public final boolean equals(Object o) {
        try {
            Quaternion c = (Quaternion)o;
            return Quaternion.abs(this.minus(c)) < Double.MIN_VALUE;
        }
        catch (ClassCastException ex) {
            return false;
        }
    }

    public final Quaternion setRandom() {
        this.re = Math.random();
        this.x = Math.random();
        this.y = Math.random();
        this.z = Math.random();
        return this;
    }

    public final void assignRandom() {
        this.re = Math.random();
        this.x = Math.random();
        this.y = Math.random();
        this.z = Math.random();
    }

    public final Quaternion set(double[] d, int offset) {
        this.re = d[offset];
        this.x = d[1 + offset];
        this.y = d[2 + offset];
        this.z = d[3 + offset];
        return this;
    }

    public final void assign(double[] d, int offset) {
        this.re = d[offset];
        this.x = d[1 + offset];
        this.y = d[2 + offset];
        this.z = d[3 + offset];
    }

    public final Quaternion get(double[] d, int offset) {
        d[offset] = this.re;
        d[1 + offset] = this.x;
        d[2 + offset] = this.y;
        d[3 + offset] = this.z;
        return this;
    }

    public final Quaternion dual() {
        return Quaternion.dual(this);
    }

    public static final Quaternion dual(Quaternion q) {
        double l = -q.lengthSqr();
        if (l == 0.0) {
            return new Quaternion(Double.POSITIVE_INFINITY, 0.0, 0.0, 0.0);
        }
        return new Quaternion(q.re / l, q.x / l, q.y / l, q.z / l);
    }

    public final Quaternion setDual() {
        this.assignDual();
        return this;
    }

    public final void assignDual() {
        double l = -this.lengthSqr();
        if (l == 0.0) {
            this.re = Double.POSITIVE_INFINITY;
            this.x = 0.0;
            this.y = 0.0;
            this.z = 0.0;
        } else {
            this.re /= l;
            this.x /= l;
            this.y /= l;
            this.z /= l;
        }
    }

    public final Quaternion setDual(Quaternion q) {
        this.assignDual(q);
        return this;
    }

    public final void assignDual(Quaternion q) {
        double l = -q.lengthSqr();
        if (l == 0.0) {
            this.re = Double.POSITIVE_INFINITY;
            this.x = 0.0;
            this.y = 0.0;
            this.z = 0.0;
        } else {
            this.re = q.re / l;
            this.x = q.x / l;
            this.y = q.y / l;
            this.z = q.z / l;
        }
    }

    public static final double distSqr(Quaternion u, Quaternion v) {
        double subR = u.re - v.re;
        double subI = u.x - v.x;
        double subJ = u.y - v.y;
        double subK = u.z - v.z;
        return subR * subR + subI * subI + subJ * subJ + subK * subK;
    }

    public final double distSqr(Quaternion v) {
        double subR = this.re - v.re;
        double subI = this.x - v.x;
        double subJ = this.y - v.y;
        double subK = this.z - v.z;
        return subR * subR + subI * subI + subJ * subJ + subK * subK;
    }

    public static final double dist(Quaternion u, Quaternion v) {
        return Math.sqrt(Quaternion.distSqr(u, v));
    }

    public final double dist(Quaternion v) {
        return Math.sqrt(this.distSqr(v));
    }

    public final boolean equals(Quaternion c) {
        return this == c ? true : this.equals(c.re, c.x, c.y, c.z);
    }

    public final boolean equals(double re, double x, double y, double z, double eps) {
        return Math.abs(this.re - re) < eps && Math.abs(this.x - x) < eps && Math.abs(this.y - y) < eps && Math.abs(this.z - z) < eps;
    }

    public final boolean equals(double re, double x, double y, double z) {
        return this.equals(re, x, y, z, 1.0E-14);
    }

    public final boolean equals(Quaternion q, double eps) {
        return this.equals(q.re, q.x, q.y, q.z);
    }

    public static final boolean arraysCoincide(Complex[] c1, Complex[] c2, double eps) {
        if (c1 == null && c2 == null) {
            return true;
        }
        if (c1 == null && c2 != null || c2 == null && c1 != null || c2.length != c1.length) {
            return false;
        }
        int l = c1.length;
        for (int i = 0; i < l; ++i) {
            if (c1[i].equals(c2[i], eps)) continue;
            return false;
        }
        return true;
    }

    public static final boolean arraysCoincide(Complex[] c1, Complex[] c2) {
        return Complex.arraysCoincide(c1, c2, 1.0E-14);
    }

    public static final boolean setsCoincide(Quaternion[] c1, Quaternion[] c2) {
        return Quaternion.setsCoincide(c1, c2, 1.0E-14);
    }

    public static final boolean setsCoincide(Quaternion[] c1, Quaternion[] c2, double eps) {
        if (c1 == null && c2 == null) {
            return true;
        }
        if (c1 == null && c2 != null || c2 == null && c1 != null || c2.length != c1.length) {
            return false;
        }
        int l = c1.length;
        LinkedList<Quaternion> liste = new LinkedList<Quaternion>();
        for (int i = 0; i < l; ++i) {
            liste.add(c2[i]);
        }
        block1: for (int i = 0; i < l; ++i) {
            ListIterator it = liste.listIterator(0);
            while (it.hasNext()) {
                if (c1[i].equals((Quaternion)it.next(), eps)) {
                    it.remove();
                    continue block1;
                }
                if (it.hasNext()) continue;
                return false;
            }
        }
        return liste.size() == 0;
    }

    public static final void arraycopy(Quaternion[] s, int is, Quaternion[] d, int id, int size) {
        if (is + size > s.length || id + size > d.length) {
            throw new IndexOutOfBoundsException();
        }
        if (s == d && id == is) {
            return;
        }
        if (id <= is) {
            int i = 0;
            while (i < size) {
                if (s[is] == null) {
                    d[id] = null;
                } else if (d[id] != null) {
                    d[id].assign(s[is]);
                } else {
                    d[id] = new Quaternion(s[is]);
                }
                ++i;
                ++is;
                ++id;
            }
        } else {
            is += size - 1;
            id += size - 1;
            int i = 0;
            while (i < size) {
                if (s[is] == null) {
                    d[id] = null;
                } else if (d[id] != null) {
                    d[id].assign(s[is]);
                } else {
                    d[id] = new Quaternion(s[is]);
                }
                ++i;
                --is;
                --id;
            }
        }
    }

    public static final Quaternion[] copy(Quaternion[] s) {
        Quaternion[] d = new Quaternion[s.length];
        Quaternion.arraycopy(s, 0, d, 0, s.length);
        return d;
    }
}

