/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.mfc.field;

import de.jtem.mfc.field.DoubleBoundedRangeModel;
import de.jtem.mfc.field.MinMaxPanel;
import de.jtem.mfc.field.Quaternion;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class QuaternionEditorPanel
extends JPanel {
    public static final String QUATERNION_PROPERTY = "quaternion";
    MinMaxPanel rScrol;
    MinMaxPanel iScrol;
    MinMaxPanel jScrol;
    MinMaxPanel kScrol;
    Quaternion value = new Quaternion();
    boolean changing;

    public QuaternionEditorPanel() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets.top = 10;
        this.rScrol = new MinMaxPanel("r");
        this.add((Component)this.rScrol, gbc);
        this.rScrol.getModel().addChangeListener(new QuaternionChangeListener(0));
        gbc.insets.top = 0;
        this.iScrol = new MinMaxPanel("i");
        this.add((Component)this.iScrol, gbc);
        this.iScrol.getModel().addChangeListener(new QuaternionChangeListener(1));
        this.jScrol = new MinMaxPanel("j");
        this.add((Component)this.jScrol, gbc);
        this.jScrol.getModel().addChangeListener(new QuaternionChangeListener(2));
        gbc.insets.bottom = 10;
        this.kScrol = new MinMaxPanel("k");
        this.add((Component)this.kScrol, gbc);
        this.kScrol.getModel().addChangeListener(new QuaternionChangeListener(3));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setQuaternion(Quaternion quat) {
        if (!this.value.equals(quat)) {
            try {
                this.changing = true;
                this.value.assign(quat);
                this.rScrol.setValue(this.value.getRe());
                this.iScrol.setValue(this.value.getX());
                this.jScrol.setValue(this.value.getY());
                this.kScrol.setValue(this.value.getZ());
                this.firePropertyChange(QUATERNION_PROPERTY, null, null);
            }
            finally {
                this.changing = false;
            }
        }
    }

    public Quaternion getQuaternion() {
        return new Quaternion(this.value);
    }

    public void getQuaternion(Quaternion target) {
        target.assign(this.value);
    }

    private class QuaternionChangeListener
    implements ChangeListener {
        final int index;
        final double[] quaternion = new double[4];

        QuaternionChangeListener(int i) {
            this.index = i;
        }

        @Override
        public void stateChanged(ChangeEvent ev) {
            if (QuaternionEditorPanel.this.changing) {
                return;
            }
            DoubleBoundedRangeModel src = (DoubleBoundedRangeModel)ev.getSource();
            QuaternionEditorPanel.this.value.get(this.quaternion, 0);
            this.quaternion[this.index] = src.getDoubleValue();
            QuaternionEditorPanel.this.value.assign(this.quaternion, 0);
            QuaternionEditorPanel.this.firePropertyChange(QuaternionEditorPanel.QUATERNION_PROPERTY, null, null);
        }
    }
}

