/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.mfc.geometry;

import de.jtem.mfc.field.Complex;
import de.jtem.mfc.geometry.ComplexProjective1;
import de.jtem.mfc.group.Moebius;
import de.jtem.mfc.matrix.Complex2By2;
import de.jtem.mfc.matrix.HermitianComplex2By2;
import de.jtem.mfc.vector.Real3;
import java.io.Serializable;

public class HermitianCircle
extends HermitianComplex2By2
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private static final Real3 dummyReal3 = new Real3();
    private static final Complex dummyComplexA = new Complex();
    private static final Complex dummyComplexB = new Complex();
    private static final Moebius dummyMoebius = new Moebius();
    private static final Complex2By2 dummyComplex2By2 = new Complex2By2();

    public HermitianCircle() {
        super(1.0, 0.0, 0.0, -1.0);
    }

    public HermitianCircle(HermitianCircle c) {
        super(c);
    }

    @Override
    public void setARe(double v) throws IllegalArgumentException {
        if (!(v * this.dRe - this.bRe * this.bRe - this.bIm * this.bIm <= 0.0)) {
            throw new IllegalArgumentException("Determinant would become positive. ");
        }
        super.setARe(v);
    }

    @Override
    public void setB(Complex b) throws IllegalArgumentException {
        if (!(this.aRe * this.dRe - b.re * b.re - b.im * b.im <= 0.0)) {
            throw new IllegalArgumentException("Determinant would become positive. ");
        }
        super.setB(b);
    }

    @Override
    public void setC(Complex c) throws IllegalArgumentException {
        if (!(this.aRe * this.dRe - c.re * c.re - c.im * c.im <= 0.0)) {
            throw new IllegalArgumentException("Determinant would become positive. ");
        }
        super.setC(c);
    }

    @Override
    public void setDRe(double v) throws IllegalArgumentException {
        if (!(this.aRe * v - this.bRe * this.bRe - this.bIm * this.bIm <= 0.0)) {
            throw new IllegalArgumentException("Determinant would become positive. ");
        }
        super.setDRe(v);
    }

    public void assignThrough(ComplexProjective1 z1, ComplexProjective1 z2, ComplexProjective1 z3) {
        this.assign(0.0, 0.0, 1.0, 0.0);
        dummyMoebius.assign(z1, z2, z3);
        this.apply(dummyMoebius);
    }

    @Override
    public void assignLorentzVector(double x0, double x1, double x2, double x3) throws IllegalArgumentException {
        super.assignLorentzVector(x0, x1, x2, x3);
        if (this.realDeterminant() > 0.0) {
            throw new IllegalArgumentException("Lorentz vector does not represent a circle. ");
        }
    }

    public boolean equals(HermitianCircle circ) {
        double y;
        double x;
        double yy;
        double xx;
        double y3;
        double y2;
        double y1;
        double x0 = this.lorentzVectorX0();
        double x1 = this.lorentzVectorX1();
        double x2 = this.lorentzVectorX2();
        double x3 = this.lorentzVectorX3();
        double y0 = circ.lorentzVectorX0();
        double xy = x0 * y0 + x1 * (y1 = circ.lorentzVectorX1()) + x2 * (y2 = circ.lorentzVectorX2()) + x3 * (y3 = circ.lorentzVectorX3());
        double h = 1.0 - xy * xy / ((xx = x0 * x0 + x1 * x1 + x2 * x2 + x3 * x3) * (yy = y0 * y0 + y1 * y1 + y2 * y2 + y3 * y3));
        if (h > 1.0E-14) {
            return false;
        }
        if (Math.abs(x1) > Math.abs(x0)) {
            x = x1;
            y = y1;
        } else {
            x = x0;
            y = y0;
        }
        if (Math.abs(x2) > Math.abs(x)) {
            x = x2;
            y = y2;
        }
        if (Math.abs(x3) > Math.abs(x)) {
            x = x3;
            y = y3;
        }
        return x * y > 0.0;
    }

    public void assignSpherical(ComplexProjective1 center, double radius) {
        center.projectTo(dummyReal3);
        double x0 = Math.cos(radius);
        double x1 = HermitianCircle.dummyReal3.x;
        double x2 = HermitianCircle.dummyReal3.y;
        double x3 = HermitianCircle.dummyReal3.z;
        this.assignLorentzVector(x0, x1, x2, x3);
    }

    public double sphericalRadius() {
        double x0 = this.lorentzVectorX0();
        double x1 = this.lorentzVectorX1();
        double x2 = this.lorentzVectorX2();
        double x3 = this.lorentzVectorX3();
        double n = Math.sqrt(x1 * x1 + x2 * x2 + x3 * x3);
        return Math.acos(x0 / n);
    }

    public void sphericalCenter(Real3 center) {
        double x1 = this.lorentzVectorX1();
        double x2 = this.lorentzVectorX2();
        double x3 = this.lorentzVectorX3();
        center.assign(x1, x2, x3);
        center.normalize();
    }

    public void sphericalCenter(ComplexProjective1 center) {
        this.sphericalCenter(dummyReal3);
        dummyReal3.projectTo(center);
    }

    public void assignEuclidean(ComplexProjective1 center, double radius) {
        center.getA(dummyComplexA);
        center.getB(dummyComplexB);
        double newA = dummyComplexB.absSqr();
        double newD = dummyComplexA.absSqr() - newA * radius * radius;
        dummyComplexB.assignConjugate();
        dummyComplexB.assignTimes(dummyComplexA);
        dummyComplexB.assignTimes(-1.0);
        this.assign(newA, dummyComplexB, newD);
        if (radius < 0.0) {
            this.assignTimes(-1.0);
        }
    }

    public void assignEuclidean(double m1, double m2, double r) {
        this.assign(1.0, -m1, -m2, m1 * m1 + m2 * m2 - r * r);
        if (r != 0.0) {
            this.assignDivide(r);
        }
    }

    public double euclideanRadius() {
        return Math.sqrt(-this.realDeterminant()) / this.aRe;
    }

    public void euclideanCenter(Complex center) {
        center.assign(-this.bRe, -this.bIm);
        center.assignDivide(this.aRe);
    }

    public void euclideanCenter(ComplexProjective1 center) {
        this.euclideanCenter(dummyComplexA);
        dummyComplexB.assign(1.0, 0.0);
        center.assign(dummyComplexA, dummyComplexB);
    }

    public void assignHyperbolic(double m1, double m2, double r) {
        double nsq = m1 * m1 + m2 * m2;
        if (nsq >= 1.0) {
            throw new IllegalArgumentException("The point (" + m1 + ", " + m2 + ") does not lie inside the " + "unit circle. ");
        }
        double er = Math.exp(r);
        double s = 0.25 * (er + 1.0 / er - 2.0);
        double ddd = 1.0 / (1.0 - nsq);
        double newA = ddd + s;
        double newD = nsq * ddd - s;
        double newBre = -m1 * ddd;
        double newBim = -m2 * ddd;
        this.assign(newA, newBre, newBim, newD);
    }

    public void assignHyperbolic(Complex z, double r) {
        this.assignHyperbolic(z.re, z.im, r);
    }

    public void assignHyperbolic(ComplexProjective1 z, double r) {
        z.projectTo(dummyComplexA);
        this.assignHyperbolic(dummyComplexA, r);
    }

    public void apply(Moebius m) {
        dummyMoebius.assignInvert(m);
        dummyMoebius.assignAdjoined();
        this.assignAdjoinedWith(dummyMoebius);
    }

    public void apply(Complex2By2 m) {
        dummyComplex2By2.assignInvert(m);
        dummyComplex2By2.assignAdjoined();
        this.assignAdjoinedWith(dummyComplex2By2);
    }
}

