/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.mfc.group;

import de.jtem.mfc.field.Complex;
import de.jtem.mfc.field.ComplexConstant;
import de.jtem.mfc.field.Field;
import de.jtem.mfc.geometry.ComplexProjective1;
import de.jtem.mfc.matrix.AbstractComplex2By2;
import java.io.Serializable;

public class Moebius
extends AbstractComplex2By2
implements Complex.FunctionOnComplex,
Serializable {
    private static final long serialVersionUID = 1L;
    final ComplexProjective1 dummyComplexProjective1 = new ComplexProjective1();

    public Moebius() {
    }

    public Moebius(double ar, double ai, double br, double bi, double cr, double ci, double dr, double di) {
        super.assign(ar, ai, br, bi, cr, ci, dr, di);
    }

    public Moebius(Field.Complex a, Field.Complex b, Field.Complex c, Field.Complex d) {
        super.assign(a.getRe(), a.getIm(), b.getRe(), b.getIm(), c.getRe(), c.getIm(), d.getRe(), d.getIm());
    }

    public Moebius(AbstractComplex2By2 m) {
        super(m);
    }

    public Moebius(double ar, double ai, double br, double bi, double mr, double mi) {
        this.assign(ar, ai, br, bi, mr, mi);
    }

    public Moebius(Field.Complex A, Field.Complex B, Field.Complex m) {
        this.assign(A.getRe(), A.getIm(), B.getRe(), B.getIm(), m.getRe(), m.getIm());
    }

    @Override
    public void assign(double ar, double ai, double br, double bi, double cr, double ci, double dr, double di) {
        super.assign(ar, ai, br, bi, cr, ci, dr, di);
    }

    public void assign(Field.Complex a, Field.Complex b, Field.Complex c, Field.Complex d) {
        super.assign(a.getRe(), a.getIm(), b.getRe(), b.getIm(), c.getRe(), c.getIm(), d.getRe(), d.getIm());
    }

    @Override
    public void assign(AbstractComplex2By2 m) {
        super.assign(m);
    }

    public void assign(Moebius m) {
        super.assign(m);
    }

    public final void assign(double ar, double ai, double br, double bi, double mr, double mi) {
        double abRe = ar * br - ai * bi;
        double abIm = ar * bi + ai * br;
        this.aRe = ar * mr - ai * mi - br;
        this.aIm = ar * mi + ai * mr - bi;
        this.bRe = abRe - (abRe * mr - abIm * mi);
        this.bIm = abIm - (abRe * mi + abIm * mr);
        this.cRe = mr - 1.0;
        this.cIm = mi;
        this.dRe = ar - (br * mr - bi * mi);
        this.dIm = ai - (br * mi + bi * mr);
        try {
            this.assignNormalizeDeterminant();
        }
        catch (ArithmeticException e) {
            System.out.println(this);
            throw e;
        }
    }

    @Override
    public void assignIdentity() {
        super.assignIdentity();
    }

    public final void assign(Field.Complex a, Field.Complex b, Field.Complex m) {
        this.assign(a.getRe(), a.getIm(), b.getRe(), b.getIm(), m.getRe(), m.getIm());
    }

    public void assign(ComplexProjective1 fixPoint1, ComplexProjective1 fixPoint2, double lambdaRe, double lambdaIm) throws IllegalArgumentException {
        if (lambdaRe == 0.0 && lambdaIm == 0.0) {
            throw new IllegalArgumentException("lambda must not be zero. ");
        }
        double lambdaAbsSq = lambdaRe * lambdaRe + lambdaIm * lambdaIm;
        double lambdaInvRe = lambdaRe / lambdaAbsSq;
        double lambdaInvIm = -lambdaIm / lambdaAbsSq;
        super.assignByEigenvectors(lambdaRe, lambdaIm, fixPoint1, lambdaInvRe, lambdaInvIm, fixPoint2);
    }

    public void assignEuclideanLogScaleRotation(ComplexProjective1 center, double logScale, double angle) {
        this.dummyComplexProjective1.aRe = 1.0;
        this.dummyComplexProjective1.aIm = 0.0;
        this.dummyComplexProjective1.bRe = 0.0;
        this.dummyComplexProjective1.bIm = 0.0;
        double halfAngle = 0.5 * angle;
        double scale = Math.exp(0.5 * logScale);
        this.assign(this.dummyComplexProjective1, center, scale * Math.cos(halfAngle), scale * Math.sin(halfAngle));
    }

    public void assignSphericalLogScaleRotation(ComplexProjective1 center, double logScale, double angle) {
        this.dummyComplexProjective1.aRe = -center.bRe;
        this.dummyComplexProjective1.aIm = center.bIm;
        this.dummyComplexProjective1.bRe = center.aRe;
        this.dummyComplexProjective1.bIm = -center.aIm;
        double halfAngle = 0.5 * angle;
        double scale = Math.exp(0.5 * logScale);
        this.assign(this.dummyComplexProjective1, center, scale * Math.cos(halfAngle), scale * Math.sin(halfAngle));
    }

    public final void assign(Complex a, Complex b, Complex c, Complex A, Complex B, Complex C) {
        Complex Alpha = B.minus(C);
        Alpha.assignDivide(B.minus(A));
        Complex Beta = A.times(Alpha);
        Beta.assignNeg();
        ComplexConstant Gamma2 = ComplexConstant.ONE;
        Complex Delta = C.times(-1.0);
        Moebius M = new Moebius((Field.Complex)Alpha, (Field.Complex)Beta, Gamma2, (Field.Complex)Delta);
        Complex alpha = b.minus(c);
        alpha.assignDivide(b.minus(a));
        Complex beta = a.times(alpha);
        beta.assignNeg();
        ComplexConstant gamma = ComplexConstant.ONE;
        Complex delta = c.times(-1.0);
        Moebius m = new Moebius((Field.Complex)alpha, (Field.Complex)beta, gamma, (Field.Complex)delta);
        this.assignInvert(M);
        this.assignTimes(m);
    }

    public final void assign(ComplexProjective1 a, ComplexProjective1 b, ComplexProjective1 c) {
        Complex a1 = a.getA();
        Complex a2 = a.getB();
        Complex b1 = b.getA();
        Complex b2 = b.getB();
        Complex c1 = c.getA();
        Complex c2 = c.getB();
        Complex num = new Complex();
        Complex tmp = new Complex();
        Complex denom = new Complex();
        num.assignTimes(c1, a2);
        tmp.assignTimes(a1, c2);
        num.assignMinus(tmp);
        denom.assignTimes(c1, b2);
        tmp.assignTimes(b1, c2);
        denom.assignMinus(tmp);
        denom.assignDivide(num);
        tmp.assignTimes(denom, a1);
        this.setB(tmp);
        tmp.assignTimes(denom, a2);
        this.setD(tmp);
        denom.assignTimes(b1, a2);
        tmp.assignTimes(b2, a1);
        denom.assignMinus(tmp);
        denom.assignDivide(num);
        tmp.assignTimes(denom, c1);
        this.setA(tmp);
        tmp.assignTimes(denom, c2);
        this.setC(tmp);
        super.assignNormalizeDeterminant();
    }

    public void assignInvert(Moebius m) {
        super.assignInvert(m);
    }

    @Override
    public void assignInvert() {
        super.assignInvert(this);
    }

    public Moebius invert() {
        Moebius result = new Moebius();
        result.assignInvert(this);
        return result;
    }

    @Override
    public void assignAdjoined() {
        super.assignAdjoined();
    }

    public Moebius adjoined() {
        Moebius result = new Moebius();
        result.assignAdjoined(this);
        return result;
    }

    public void assignTimes(Moebius a) {
        super.assignTimes((AbstractComplex2By2)this, a);
    }

    public static void times(Moebius a, Moebius b, Moebius c) {
        AbstractComplex2By2.times((AbstractComplex2By2)a, b, c);
    }

    public void assignTimes(Moebius a, Moebius b) {
        AbstractComplex2By2.times((AbstractComplex2By2)a, b, this);
    }

    public Moebius times(AbstractComplex2By2 a) {
        Moebius result = new Moebius();
        AbstractComplex2By2.times((AbstractComplex2By2)this, a, result);
        return result;
    }

    public void assignDivide(Moebius m) {
        super.assignDivide((AbstractComplex2By2)this, m);
    }

    @Override
    public void assignDivide(Complex c) {
        super.assignDivide((AbstractComplex2By2)this, c);
    }

    @Override
    public void assignDivide(double c) {
        super.assignDivide((AbstractComplex2By2)this, c);
    }

    public void assignDivide(Moebius a, Moebius b) {
        super.assignDivide((AbstractComplex2By2)a, b);
    }

    public Moebius divide(AbstractComplex2By2 a) {
        Moebius result = new Moebius();
        AbstractComplex2By2.divide(this, a, result);
        return result;
    }

    public void applyTo(ComplexProjective1 v, ComplexProjective1 w) {
        AbstractComplex2By2.times((AbstractComplex2By2)this, v, w);
    }

    public void applyTo(ComplexProjective1 v) {
        this.applyTo(v, v);
    }

    public final void applyTo(Complex z, Complex r) {
        double d1r = this.aRe * z.re - this.aIm * z.im + this.bRe;
        double d1i = this.aRe * z.im + this.aIm * z.re + this.bIm;
        double d2r = this.cRe * z.re - this.cIm * z.im + this.dRe;
        double d2i = this.cRe * z.im + this.cIm * z.re + this.dIm;
        double d = d2r * d2r + d2i * d2i;
        r.re = (d1r * d2r + d1i * d2i) / d;
        r.im = (d1i * d2r - d1r * d2i) / d;
    }

    public final void applyTo(Field.Complex z, Complex r) {
        Complex w = new Complex(z);
        this.applyTo(w, r);
    }

    @Override
    public final void eval(Complex z, Complex r) {
        this.applyTo(z, r);
    }

    public final Complex applyTo(Complex z) {
        Complex r = new Complex();
        this.applyTo(z, r);
        return r;
    }

    public final Complex valueAt(Complex z) {
        Complex r = new Complex();
        this.applyTo(z, r);
        return r;
    }

    public final void applyInverseTo(Complex z, Complex r) {
        double d1r = this.dRe * z.re - this.dIm * z.im - this.bRe;
        double d1i = this.dRe * z.im + this.dIm * z.re - this.bIm;
        double d2r = -this.cRe * z.re + this.cIm * z.im + this.aRe;
        double d2i = -this.cRe * z.im - this.cIm * z.re + this.aIm;
        double d = d2r * d2r + d2i * d2i;
        r.re = (d1r * d2r + d1i * d2i) / d;
        r.im = (d1i * d2r - d1r * d2i) / d;
    }

    public final void alt_applyInverseTo(Complex z, Complex r) {
        double d1r = this.dRe * z.getRe() - this.dIm * z.getIm() - this.bRe;
        double d1i = this.dRe * z.getIm() + this.dIm * z.getRe() - this.bIm;
        double d2r = -this.cRe * z.getRe() + this.cIm * z.getIm() + this.aRe;
        double d2i = -this.cRe * z.getIm() - this.cIm * z.getRe() + this.aIm;
        double d = d2r * d2r + d2i * d2i;
        r.re = (d1r * d2r + d1i * d2i) / d;
        r.im = (d1i * d2r - d1r * d2i) / d;
    }

    public final Complex applyInverseTo(Complex z) {
        Complex r = new Complex();
        this.applyInverseTo(z, r);
        return r;
    }

    public final void applyDifferentialTo(Complex z, Complex r) {
        double dr = this.cRe * z.re - this.cIm * z.im + this.dRe;
        double di = this.cRe * z.im + this.cIm * z.re + this.dIm;
        double d = dr * dr + di * di;
        d *= d;
        r.re = (dr * dr - di * di) / d;
        r.im = -2.0 * dr * di / d;
    }

    public final Complex applyDifferentialTo(Complex z) {
        Complex r = new Complex();
        this.applyDifferentialTo(z, r);
        return r;
    }

    public final void applyInverseDifferentialTo(Complex z, Complex r) {
        double dr = -this.cRe * z.re + this.cIm * z.im + this.aRe;
        double di = -this.cRe * z.im - this.cIm * z.re + this.aIm;
        double d = dr * dr + di * di;
        d *= d;
        r.re = (dr * dr - di * di) / d;
        r.im = -2.0 * dr * di / d;
    }

    public final Complex applyInverseDifferentialTo(Complex z) {
        Complex r = new Complex();
        this.applyInverseDifferentialTo(z, r);
        return r;
    }

    public final boolean isElliptic() {
        double detRe = this.aRe * this.dRe - this.aIm * this.dIm - (this.bRe * this.cRe - this.bIm * this.cIm);
        double detIm = this.aRe * this.dIm + this.aIm * this.dRe - (this.bRe * this.cIm + this.bIm * this.cRe);
        double nn = detRe * detRe + detIm * detIm;
        double normTraceRe = ((this.aRe + this.dRe) * detRe + (this.aIm + this.dIm) * detIm) / nn;
        double normTraceIm = ((this.aRe + this.dRe) * detIm - (this.aIm + this.dIm) * detRe) / nn;
        if (Math.abs(normTraceIm) > 1.0E-14) {
            return false;
        }
        return Math.abs(normTraceRe) < 1.99999999999999;
    }

    public final boolean isParabolic() {
        double detRe = this.aRe * this.dRe - this.aIm * this.dIm - (this.bRe * this.cRe - this.bIm * this.cIm);
        double detIm = this.aRe * this.dIm + this.aIm * this.dRe - (this.bRe * this.cIm + this.bIm * this.cRe);
        double nn = detRe * detRe + detIm * detIm;
        double normTraceRe = ((this.aRe + this.dRe) * detRe + (this.aIm + this.dIm) * detIm) / nn;
        double normTraceIm = ((this.aRe + this.dRe) * detIm - (this.aIm + this.dIm) * detRe) / nn;
        if (Math.abs(normTraceIm) > 1.0E-14) {
            return false;
        }
        return Math.abs(Math.abs(normTraceRe) - 2.0) < 1.0E-14;
    }

    public final boolean isHyperbolic() {
        double detRe = this.aRe * this.dRe - this.aIm * this.dIm - (this.bRe * this.cRe - this.bIm * this.cIm);
        double detIm = this.aRe * this.dIm + this.aIm * this.dRe - (this.bRe * this.cIm + this.bIm * this.cRe);
        double nn = detRe * detRe + detIm * detIm;
        double normTraceRe = ((this.aRe + this.dRe) * detRe + (this.aIm + this.dIm) * detIm) / nn;
        double normTraceIm = ((this.aRe + this.dRe) * detIm - (this.aIm + this.dIm) * detRe) / nn;
        if (Math.abs(normTraceIm) > 1.0E-14) {
            return false;
        }
        return Math.abs(normTraceRe) > 2.00000000000001;
    }

    public final boolean isLoxodromic() {
        return Math.abs(this.normSqr() - 1.0) > 1.0E-14;
    }

    public final int getFixPoints(Complex[] fp) {
        double dMinusARe = this.dRe - this.aRe;
        double dMinusAIm = this.dIm - this.aIm;
        if (Math.abs(this.cRe) + Math.abs(this.cIm) < 2.0E-14) {
            if (Math.abs(dMinusARe) + Math.abs(dMinusAIm) < 2.0E-14) {
                if (Math.abs(this.bRe) + Math.abs(this.bIm) < 2.0E-14) {
                    return 0;
                }
                if (fp[0] == null) {
                    fp[0] = new Complex();
                }
                fp[0].assign(Double.POSITIVE_INFINITY, 0.0);
                return 1;
            }
            if (fp[0] == null) {
                fp[0] = new Complex();
            }
            if (Math.abs(this.bRe) + Math.abs(this.bIm) < 2.0E-14) {
                fp[0].assign(0.0);
                if (fp[1] == null) {
                    fp[1] = new Complex();
                }
                fp[1].assign(Double.POSITIVE_INFINITY, 0.0);
                return 1;
            }
            fp[0].assign(this.bRe, this.bIm);
            fp[0].assignDivide(dMinusARe, dMinusAIm);
            return 1;
        }
        if (fp[0] == null) {
            fp[0] = new Complex();
        }
        double disRe = dMinusARe * dMinusARe - dMinusAIm * dMinusAIm + 4.0 * (this.cRe * this.bRe - this.cIm * this.bIm);
        double disIm = dMinusARe * dMinusAIm + dMinusAIm * dMinusARe + 4.0 * (this.cRe * this.bIm + this.cIm * this.bRe);
        if (Math.abs(disRe) + Math.abs(disIm) < 2.0E-14) {
            fp[0].assign(-dMinusARe, -dMinusAIm);
            fp[0].assignDivide(2.0 * this.cRe, 2.0 * this.cIm);
            return 1;
        }
        if (fp[1] == null) {
            fp[1] = new Complex();
        }
        double rr = Math.sqrt(Complex.abs(disRe, disIm));
        double ii = Complex.arg(disRe, disIm) / 2.0;
        double sqrtOfDisRe = rr * Math.cos(ii);
        double sqrtOfDisIm = rr * Math.sin(ii);
        fp[0].assign(-dMinusARe, -dMinusAIm);
        fp[1].assign(-dMinusARe, -dMinusAIm);
        fp[0].assignMinus(sqrtOfDisRe, sqrtOfDisIm);
        fp[1].assignPlus(sqrtOfDisRe, sqrtOfDisIm);
        fp[0].assignDivide(2.0 * this.cRe, 2.0 * this.cIm);
        fp[1].assignDivide(2.0 * this.cRe, 2.0 * this.cIm);
        return 2;
    }

    public final Complex[] getFixPoints() {
        Complex[] tmpFP = new Complex[2];
        int numOfFixPoints = this.getFixPoints(tmpFP);
        if (numOfFixPoints == 0) {
            return null;
        }
        Complex[] fp = new Complex[numOfFixPoints];
        for (int i = 0; i < numOfFixPoints; ++i) {
            fp[i] = tmpFP[i];
        }
        return fp;
    }

    public final double getRadiusOfMappedCircle(Complex centerOfCircle, double radiusOfCircle, Complex centerOfMappedCircle) {
        double radiusOfMappedCircle;
        if (this.cRe == 0.0 && this.cIm == 0.0) {
            double dAbsSqr = this.dRe * this.dRe + this.dIm * this.dIm;
            double tmpARe = (this.aRe * this.dRe + this.aIm * this.dIm) / dAbsSqr;
            double tmpAIm = (-this.aRe * this.dIm + this.aIm * this.dRe) / dAbsSqr;
            double tmpBRe = (this.bRe * this.dRe + this.bIm * this.dIm) / dAbsSqr;
            double tmpBIm = (-this.bRe * this.dIm + this.bIm * this.dRe) / dAbsSqr;
            centerOfMappedCircle.re = centerOfCircle.re * tmpARe - centerOfCircle.im * tmpAIm + tmpBRe;
            centerOfMappedCircle.im = centerOfCircle.re * tmpAIm + centerOfCircle.im * tmpARe + tmpBIm;
            radiusOfMappedCircle = radiusOfCircle * Math.sqrt(tmpARe * tmpARe + tmpAIm * tmpAIm);
        } else {
            centerOfMappedCircle.re = centerOfCircle.re * this.cRe - centerOfCircle.im * this.cIm + this.dRe;
            centerOfMappedCircle.im = centerOfCircle.re * this.cIm + centerOfCircle.im * this.cRe + this.dIm;
            double cAbsSqr = this.cRe * this.cRe + this.cIm * this.cIm;
            double cAbs = Math.sqrt(cAbsSqr);
            radiusOfMappedCircle = radiusOfCircle * cAbs;
            double factor = centerOfMappedCircle.absSqr() - radiusOfMappedCircle * radiusOfMappedCircle;
            centerOfMappedCircle.assignDivide(factor);
            centerOfMappedCircle.assignConjugate();
            radiusOfMappedCircle /= Math.abs(factor);
            double tmpARe = (this.aRe * this.cRe + this.aIm * this.cIm) / cAbsSqr;
            double tmpAIm = (-this.aRe * this.cIm + this.aIm * this.cRe) / cAbsSqr;
            double tmpRe = (centerOfMappedCircle.re * this.cRe + centerOfMappedCircle.im * this.cIm) / cAbsSqr;
            double tmpIm = (-centerOfMappedCircle.re * this.cIm + centerOfMappedCircle.im * this.cRe) / cAbsSqr;
            centerOfMappedCircle.re = tmpARe - tmpRe;
            centerOfMappedCircle.im = tmpAIm - tmpIm;
            radiusOfMappedCircle /= cAbs;
        }
        return radiusOfMappedCircle;
    }
}

