/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.mfc.group;

public class Permutation {
    private static final long serialVersionUID = 1L;
    private int[] s;
    private int[] t;

    private void exchangeST() {
        int[] u = this.s;
        this.s = this.t;
        this.t = u;
    }

    public Permutation() {
        this.assign(new int[0]);
    }

    public Permutation(Permutation p) {
        this.assign(p);
    }

    public Permutation(int[] s) {
        this.assign(s);
    }

    public Permutation(int[][] cycles) {
        this.assign(cycles);
    }

    public Permutation(int len) {
        this.assignIdentity(len);
    }

    public void assignIdentity() {
        de.jtem.numericalMethods.algebra.group.Permutation.identity(this.s);
    }

    public void assignIdentity(int len) {
        this.assign(de.jtem.numericalMethods.algebra.group.Permutation.identity(len));
    }

    public void assignRandom() {
        de.jtem.numericalMethods.algebra.group.Permutation.random(this.s);
    }

    public void assignRandom(int len) {
        this.assign(de.jtem.numericalMethods.algebra.group.Permutation.random(len));
    }

    public int[] getPermutation() {
        int[] result = new int[this.s.length];
        System.arraycopy(this.s, 0, result, 0, this.s.length);
        return result;
    }

    public void setPermutation(int[] newPermutation) {
        this.s = newPermutation;
        if (this.t == null || this.t.length != this.s.length) {
            this.t = new int[this.s.length];
        }
    }

    public Permutation copy() {
        return new Permutation(this);
    }

    public void assign(int[] s) {
        this.setPermutation(s);
    }

    public void assign(Permutation s) {
        this.setPermutation(s.getPermutation());
    }

    public void assign(int[][] cycles) {
        de.jtem.numericalMethods.algebra.group.Permutation.fromCycles(cycles, this.s);
    }

    public int[][] getCycles() {
        return de.jtem.numericalMethods.algebra.group.Permutation.cycles(this.s);
    }

    public void setCycles(int[][] cycles) {
        this.assign(cycles);
    }

    public void previous() {
        this.t = this.s;
        de.jtem.numericalMethods.algebra.group.Permutation.previous(this.t);
        this.assign(this.t);
    }

    public void next() {
        this.t = this.s;
        de.jtem.numericalMethods.algebra.group.Permutation.next(this.t);
        this.assign(this.t);
    }

    public Permutation inverse() {
        de.jtem.numericalMethods.algebra.group.Permutation.inverse(this.s, this.t);
        return new Permutation(this.t);
    }

    public int numTranspos() {
        return de.jtem.numericalMethods.algebra.group.Permutation.numTranspos(this.s, this.t);
    }

    public int numInversions() {
        return de.jtem.numericalMethods.algebra.group.Permutation.numInversions(this.s);
    }

    public int parity() {
        return de.jtem.numericalMethods.algebra.group.Permutation.parity(this.s);
    }

    public int order() {
        return de.jtem.numericalMethods.algebra.group.Permutation.order(this.s, this.t);
    }

    public void assignInvert() {
        de.jtem.numericalMethods.algebra.group.Permutation.inverse(this.s, this.t);
        this.exchangeST();
    }

    public void assignDivide(int[] p) {
        de.jtem.numericalMethods.algebra.group.Permutation.divide(this.s, p, this.t);
        this.exchangeST();
    }

    public void assignDivide(Permutation p) {
        this.assignDivide(p.getPermutation());
    }

    public int applyTo(int i) {
        return de.jtem.numericalMethods.algebra.group.Permutation.applyTo(this.s, i);
    }

    public int applyToFun(int i) {
        return this.s[i];
    }

    public int[] times(int[] p) {
        de.jtem.numericalMethods.algebra.group.Permutation.times(this.s, p, this.t);
        return (int[])this.t.clone();
    }

    public Permutation times(Permutation p) {
        de.jtem.numericalMethods.algebra.group.Permutation.times(this.s, p.getPermutation(), this.t);
        return new Permutation((int[])this.t.clone());
    }

    public void assignTimes(int[] p) {
        de.jtem.numericalMethods.algebra.group.Permutation.times(this.s, p, this.t);
        this.exchangeST();
    }

    public void assignTimes(Permutation p) {
        de.jtem.numericalMethods.algebra.group.Permutation.times(this.s, p.getPermutation(), this.t);
        this.exchangeST();
    }

    public int[] timesFun(int[] p) {
        de.jtem.numericalMethods.algebra.group.Permutation.timesFun(this.s, p, this.t);
        return (int[])this.t.clone();
    }

    public Permutation timesFun(Permutation p) {
        de.jtem.numericalMethods.algebra.group.Permutation.timesFun(this.s, p.getPermutation(), this.t);
        return new Permutation((int[])this.t.clone());
    }

    public void assignTimesFun(int[] p) {
        de.jtem.numericalMethods.algebra.group.Permutation.timesFun(this.s, p, this.t);
        this.exchangeST();
    }

    public void assignTimesFun(Permutation p) {
        de.jtem.numericalMethods.algebra.group.Permutation.timesFun(this.s, p.getPermutation(), this.t);
        this.exchangeST();
    }

    public int[] inversions() {
        de.jtem.numericalMethods.algebra.group.Permutation.inversions(this.s, this.t);
        return (int[])this.t.clone();
    }

    public void fromInversions(int[] inv) {
        de.jtem.numericalMethods.algebra.group.Permutation.fromInversions(inv, this.s);
    }

    public int[][][] youngTableaux() {
        return de.jtem.numericalMethods.algebra.group.Permutation.youngTableaux(this.s);
    }

    public void assignFromYoungTableaux(int[][][] y) {
        this.assign(de.jtem.numericalMethods.algebra.group.Permutation.fromYoungTableaux(y));
    }

    public String cyclesToString() {
        return de.jtem.numericalMethods.algebra.group.Permutation.cyclesToString(this.s);
    }

    public String toString() {
        return de.jtem.numericalMethods.algebra.group.Permutation.toString(this.s);
    }
}

