/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.mfc.matrix;

import de.jtem.mfc.field.Complex;
import de.jtem.mfc.matrix.AbstractComplex2By2;
import de.jtem.mfc.matrix.HermitianComplex2By2;
import de.jtem.mfc.vector.Complex2;
import java.io.Serializable;

public class Complex2By2
extends AbstractComplex2By2
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;

    public Complex2By2() {
    }

    public Complex2By2(double aRe, double aIm, double bRe, double bIm, double cRe, double cIm, double dRe, double dIm) {
        super(aRe, aIm, bRe, bIm, cRe, cIm, dRe, dIm);
    }

    public Complex2By2(Complex a, Complex b, Complex c, Complex d) {
        super(a, b, c, d);
    }

    public Complex2By2(AbstractComplex2By2 m) {
        super(m);
    }

    @Override
    public final void setA(Complex a) {
        super.setA(a);
    }

    @Override
    public final void setB(Complex b) {
        super.setB(b);
    }

    @Override
    public final void setC(Complex c) {
        super.setC(c);
    }

    @Override
    public final void setD(Complex d) {
        super.setD(d);
    }

    public final Complex2By2 copy() {
        return new Complex2By2(this);
    }

    @Override
    public final void assignZero() {
        super.assignZero();
    }

    @Override
    public final void assignIdentity() {
        super.assignIdentity();
    }

    @Override
    public final void assign(double aRe, double aIm, double bRe, double bIm, double cRe, double cIm, double dRe, double dIm) {
        super.assign(aRe, aIm, bRe, bIm, cRe, cIm, dRe, dIm);
    }

    @Override
    public final void assign(Complex a, Complex b, Complex c, Complex d) {
        super.assign(a, b, c, d);
    }

    @Override
    public final void assign(AbstractComplex2By2 s) {
        super.assign(s);
    }

    @Override
    public final void assignTimes(AbstractComplex2By2 a) {
        super.assignTimes((AbstractComplex2By2)this, a);
    }

    @Override
    public final void assignTimes(AbstractComplex2By2 a, AbstractComplex2By2 b) {
        super.assignTimes(a, b);
    }

    public final Complex2By2 times(AbstractComplex2By2 a) {
        Complex2By2 result = new Complex2By2();
        result.assignTimes((AbstractComplex2By2)this, a);
        return result;
    }

    @Override
    public final void assignTimes(double r) {
        this.assignTimes((AbstractComplex2By2)this, r);
    }

    @Override
    public final void assignTimes(AbstractComplex2By2 m, double r) {
        super.assignTimes(m, r);
    }

    public final Complex2By2 times(double r) {
        Complex2By2 result = new Complex2By2();
        result.assignTimes((AbstractComplex2By2)this, r);
        return result;
    }

    @Override
    public final void assignTimes(double x, double y) {
        this.assignTimes(this, x, y);
    }

    @Override
    public final void assignTimes(AbstractComplex2By2 m, double x, double y) {
        super.assignTimes(m, x, y);
    }

    public final Complex2By2 times(double x, double y) {
        Complex2By2 result = new Complex2By2();
        result.assignTimes(this, x, y);
        return result;
    }

    @Override
    public final void assignTimes(Complex z) {
        this.assignTimes(this, z.re, z.im);
    }

    @Override
    public final void assignTimes(AbstractComplex2By2 m, Complex z) {
        this.assignTimes(m, z.re, z.im);
    }

    public final Complex2By2 times(Complex z) {
        Complex2By2 result = new Complex2By2();
        result.assignTimes(this, z.re, z.im);
        return result;
    }

    @Override
    public final void assignDivide(AbstractComplex2By2 m) {
        this.assignDivide((AbstractComplex2By2)this, m);
    }

    @Override
    public final void assignDivide(AbstractComplex2By2 a, AbstractComplex2By2 b) {
        super.assignDivide(a, b);
    }

    public final Complex2By2 divide(AbstractComplex2By2 a) {
        Complex2By2 result = new Complex2By2();
        result.assignDivide((AbstractComplex2By2)this, a);
        return result;
    }

    @Override
    public final void assignDivide(double r) {
        this.assignDivide((AbstractComplex2By2)this, r);
    }

    @Override
    public final void assignDivide(AbstractComplex2By2 m, double r) {
        super.assignDivide(m, r);
    }

    public final Complex2By2 divide(double r) {
        Complex2By2 result = new Complex2By2();
        result.assignDivide((AbstractComplex2By2)this, r);
        return result;
    }

    @Override
    public final void assignDivide(double x, double y) {
        this.assignDivide(this, x, y);
    }

    @Override
    public final void assignDivide(AbstractComplex2By2 m, double x, double y) {
        super.assignDivide(m, x, y);
    }

    public final Complex2By2 divide(double x, double y) {
        Complex2By2 result = new Complex2By2();
        result.assignDivide(this, x, y);
        return result;
    }

    @Override
    public final void assignDivide(Complex z) {
        this.assignDivide(this, z.re, z.im);
    }

    @Override
    public final void assignDivide(AbstractComplex2By2 m, Complex z) {
        super.assignDivide(m, z);
    }

    public final Complex2By2 divide(Complex z) {
        Complex2By2 result = new Complex2By2();
        result.assignDivide((AbstractComplex2By2)this, z);
        return result;
    }

    public final Complex2By2 plus(AbstractComplex2By2 a) {
        Complex2By2 result = new Complex2By2();
        result.assignPlus((AbstractComplex2By2)this, a);
        return result;
    }

    @Override
    public final void assignPlus(AbstractComplex2By2 a) {
        this.assignPlus((AbstractComplex2By2)this, a);
    }

    @Override
    public final void assignPlus(AbstractComplex2By2 a, AbstractComplex2By2 b) {
        super.assignPlus(a, b);
    }

    public final Complex2By2 plus(double x) {
        Complex2By2 result = new Complex2By2();
        result.assignPlus((AbstractComplex2By2)this, x);
        return result;
    }

    @Override
    public final void assignPlus(double x) {
        super.assignPlus(x);
    }

    @Override
    public final void assignPlus(AbstractComplex2By2 m, double x) {
        super.assignPlus(m, x);
    }

    public final Complex2By2 plus(double x, double y) {
        Complex2By2 result = new Complex2By2();
        result.assignPlus(this, x, y);
        return result;
    }

    @Override
    public final void assignPlus(double x, double y) {
        super.assignPlus(x, y);
    }

    @Override
    public final void assignPlus(AbstractComplex2By2 m, double x, double y) {
        super.assignPlus(m, x, y);
    }

    public final Complex2By2 plus(Complex z) {
        Complex2By2 result = new Complex2By2();
        result.assignPlus((AbstractComplex2By2)this, z);
        return result;
    }

    @Override
    public final void assignPlus(Complex z) {
        super.assignPlus(z);
    }

    @Override
    public final void assignPlus(AbstractComplex2By2 m, Complex z) {
        super.assignPlus(m, z);
    }

    public final Complex2By2 minus(AbstractComplex2By2 a) {
        Complex2By2 result = new Complex2By2();
        result.assignMinus((AbstractComplex2By2)this, a);
        return result;
    }

    @Override
    public final void assignMinus(AbstractComplex2By2 a) {
        super.assignMinus(a);
    }

    @Override
    public final void assignMinus(AbstractComplex2By2 a, AbstractComplex2By2 b) {
        super.assignMinus(a, b);
    }

    public final Complex2By2 minus(double x) {
        Complex2By2 result = new Complex2By2();
        result.assignMinus((AbstractComplex2By2)this, x);
        return result;
    }

    @Override
    public final void assignMinus(double x) {
        super.assignMinus(x);
    }

    @Override
    public final void assignMinus(AbstractComplex2By2 m, double x) {
        super.assignMinus(m, x);
    }

    public final Complex2By2 minus(double x, double y) {
        Complex2By2 result = new Complex2By2();
        result.assignMinus(this, x, y);
        return result;
    }

    @Override
    public final void assignMinus(double x, double y) {
        super.assignMinus(x, y);
    }

    @Override
    public final void assignMinus(AbstractComplex2By2 m, double x, double y) {
        super.assignMinus(m, x, y);
    }

    public final Complex2By2 minus(Complex z) {
        Complex2By2 result = new Complex2By2();
        result.assignMinus((AbstractComplex2By2)this, z);
        return result;
    }

    @Override
    public final void assignMinus(Complex z) {
        super.assignMinus(z);
    }

    @Override
    public final void assignMinus(AbstractComplex2By2 m, Complex z) {
        super.assignMinus(m, z);
    }

    public final Complex2By2 neg() {
        Complex2By2 result = new Complex2By2();
        result.assignNeg(this);
        return result;
    }

    @Override
    public final void assignNeg(AbstractComplex2By2 a) {
        super.assignNeg(a);
    }

    @Override
    public final void assignNeg() {
        super.assignNeg(this);
    }

    public final Complex2By2 conjugate() {
        Complex2By2 result = new Complex2By2();
        result.assignConjugate(this);
        return result;
    }

    @Override
    public final void assignConjugate(AbstractComplex2By2 a) {
        super.assignConjugate();
    }

    @Override
    public final void assignConjugate() {
        super.assignConjugate(this);
    }

    public final Complex2By2 transpose() {
        Complex2By2 result = new Complex2By2();
        result.assignTranspose(this);
        return result;
    }

    @Override
    public final void assignTranspose(AbstractComplex2By2 a) {
        super.assignTranspose();
    }

    @Override
    public final void assignTranspose() {
        super.assignTranspose(this);
    }

    public final Complex2By2 star() {
        Complex2By2 result = new Complex2By2();
        result.assignStar(this);
        return result;
    }

    @Override
    public final void assignStar(AbstractComplex2By2 a) {
        super.assignStar(a);
    }

    @Override
    public final void assignStar() {
        super.assignStar(this);
    }

    @Override
    public final void assignAdjugate(AbstractComplex2By2 a) {
        super.assignAdjugate(a);
    }

    @Override
    public final void assignAdjugate() {
        this.assignAdjugate(this);
    }

    public final Complex2By2 adjugate() {
        Complex2By2 result = new Complex2By2();
        result.assignAdjugate(this);
        return result;
    }

    @Override
    public final void assignAdjoined(AbstractComplex2By2 a) {
        super.assignAdjoined(a);
    }

    @Override
    public final void assignAdjoined() {
        this.assignAdjoined(this);
    }

    public final Complex2By2 adjoined() {
        Complex2By2 result = new Complex2By2();
        result.assignAdjoined(this);
        return result;
    }

    @Override
    public void assignAdjoinedWith(AbstractComplex2By2 t) {
        super.assignAdjoinedWith(t);
    }

    @Override
    public final void assignInvert(AbstractComplex2By2 m) {
        super.assignInvert(m);
    }

    @Override
    public final void assignInvert() {
        this.assignInvert(this);
    }

    public final Complex2By2 invert() {
        Complex2By2 result = new Complex2By2();
        result.assignInvert(this);
        return result;
    }

    public final Complex2By2 normalizeDeterminant() {
        Complex2By2 result = new Complex2By2();
        result.assignNormalizeDeterminant(this);
        return result;
    }

    @Override
    public final void assignNormalizeDeterminant(AbstractComplex2By2 m) {
        super.assignNormalizeDeterminant(m);
    }

    @Override
    public final void assignNormalizeDeterminant() {
        this.assignNormalizeDeterminant(this);
    }

    @Override
    public final void assignByColumn(Complex2 column1, Complex2 column2) {
        super.assignByColumn(column1, column2);
    }

    @Override
    public final void assignByEigenvectors(double eigenvalue1Re, double eigenvalue1Im, Complex2 eigenvector1, double eigenvalue2Re, double eigenvalue2Im, Complex2 eigenvector2) {
        super.assignByEigenvectors(eigenvalue1Re, eigenvalue1Im, eigenvector1, eigenvalue2Re, eigenvalue2Im, eigenvector2);
    }

    @Override
    public final void assignByEigenvectors(Complex eigenvalue1, Complex2 eigenvector1, Complex eigenvalue2, Complex2 eigenvector2) {
        super.assignByEigenvectors(eigenvalue1, eigenvector1, eigenvalue2, eigenvector2);
    }

    public void assignAsEigenvectorMatrixOf(HermitianComplex2By2 m) {
        double absOfB = Math.sqrt(m.bRe * m.bRe + m.bIm * m.bIm);
        double cosOfPsi = m.bRe / absOfB;
        double sinOfPsi = -m.bIm / absOfB;
        double t = -absOfB / (m.aRe - m.dRe);
        double l = t * t / (4.0 * t * t + 1.0);
        System.out.println("t=" + t);
        System.out.println("l=" + l);
        double cc = 0.5 + Math.sqrt(0.25 - l);
        double cosOfPhi = Math.sqrt(cc);
        double sinOfPhi = Math.sqrt(1.0 - cc);
        this.assign(cosOfPhi, 0.0, sinOfPhi * -cosOfPsi, sinOfPhi * sinOfPsi, sinOfPhi * cosOfPsi, sinOfPhi * sinOfPsi, cosOfPhi, 0.0);
    }
}

