/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.mfc.matrix;

import de.jtem.mfc.field.Complex;
import de.jtem.mfc.field.Field;
import de.jtem.mfc.matrix.AbstractComplex2By2;
import de.jtem.mfc.matrix.Complex2By2;
import de.jtem.mfc.polynomial.ComplexPolynomial;
import java.io.Serializable;

public class ComplexPolynomial2By2
implements Serializable {
    private static final long serialVersionUID = 1L;
    static final double EPS = 1.0E-14;
    public ComplexPolynomial a;
    public ComplexPolynomial b;
    public ComplexPolynomial c;
    public ComplexPolynomial d;
    static ComplexPolynomial p11 = new ComplexPolynomial();
    static ComplexPolynomial p12 = new ComplexPolynomial();
    static ComplexPolynomial p21 = new ComplexPolynomial();
    static ComplexPolynomial p22 = new ComplexPolynomial();
    static ComplexPolynomial q11 = new ComplexPolynomial();
    static ComplexPolynomial q12 = new ComplexPolynomial();
    static ComplexPolynomial q21 = new ComplexPolynomial();
    static ComplexPolynomial q22 = new ComplexPolynomial();
    private static final Complex evalResult = new Complex();
    private static final Complex evalDerivativeResult = new Complex();

    public ComplexPolynomial2By2() {
        this.a = new ComplexPolynomial();
        this.b = new ComplexPolynomial();
        this.c = new ComplexPolynomial();
        this.d = new ComplexPolynomial();
    }

    public ComplexPolynomial2By2(ComplexPolynomial2By2 p) {
        this(p.a, p.b, p.c, p.d);
    }

    public ComplexPolynomial2By2(ComplexPolynomial a, ComplexPolynomial b, ComplexPolynomial c, ComplexPolynomial d) {
        this.a = new ComplexPolynomial(a);
        this.b = new ComplexPolynomial(b);
        this.c = new ComplexPolynomial(c);
        this.d = new ComplexPolynomial(d);
    }

    public ComplexPolynomial getA() {
        return this.a;
    }

    public void setA(ComplexPolynomial p) {
        this.a = p;
    }

    public ComplexPolynomial getB() {
        return this.b;
    }

    public void setB(ComplexPolynomial p) {
        this.b = p;
    }

    public ComplexPolynomial getC() {
        return this.c;
    }

    public void setC(ComplexPolynomial p) {
        this.c = p;
    }

    public ComplexPolynomial getD() {
        return this.d;
    }

    public void setD(ComplexPolynomial p) {
        this.d = p;
    }

    public void eval(Complex z, AbstractComplex2By2 m) {
        this.a.eval(z, evalResult);
        m.setA(evalResult);
        this.b.eval(z, evalResult);
        m.setB(evalResult);
        this.c.eval(z, evalResult);
        m.setC(evalResult);
        this.d.eval(z, evalResult);
        m.setD(evalResult);
    }

    public Complex2By2 eval(Complex z) {
        Complex2By2 m = new Complex2By2();
        this.eval(z, m);
        return m;
    }

    public void evalDerivative(Complex z, int n, AbstractComplex2By2 m) {
        this.a.evalDerivative(z, n, evalDerivativeResult);
        m.setA(evalDerivativeResult);
        this.b.evalDerivative(z, n, evalDerivativeResult);
        m.setB(evalDerivativeResult);
        this.c.evalDerivative(z, n, evalDerivativeResult);
        m.setC(evalDerivativeResult);
        this.d.evalDerivative(z, n, evalDerivativeResult);
        m.setD(evalDerivativeResult);
    }

    public Complex2By2 evalDerivative(Complex z, int n) {
        Complex2By2 m = new Complex2By2();
        this.evalDerivative(z, n, m);
        return m;
    }

    public void assign(ComplexPolynomial2By2 p) {
        this.a.assign(p.a);
        this.b.assign(p.b);
        this.c.assign(p.c);
        this.d.assign(p.d);
    }

    public static ComplexPolynomial2By2 constant(double aRe, double aIm, double bRe, double bIm, double cRe, double cIm, double dRe, double dIm) {
        ComplexPolynomial2By2 result = new ComplexPolynomial2By2();
        result.getA().setCoefficient(0, aRe, aIm);
        result.getB().setCoefficient(0, bRe, bIm);
        result.getC().setCoefficient(0, cRe, cIm);
        result.getD().setCoefficient(0, dRe, dIm);
        return result;
    }

    public static ComplexPolynomial2By2 constant(Complex a, Complex b, Complex c, Complex d) {
        return ComplexPolynomial2By2.constant(a.re, a.im, b.re, b.im, c.re, c.im, d.re, d.im);
    }

    public static ComplexPolynomial2By2 constant(Field.Complex a, Field.Complex b, Field.Complex c, Field.Complex d) {
        return ComplexPolynomial2By2.constant(a.getRe(), a.getIm(), b.getRe(), b.getIm(), c.getRe(), c.getIm(), d.getRe(), d.getIm());
    }

    public static ComplexPolynomial2By2 identity() {
        return ComplexPolynomial2By2.constant(1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
    }

    public void assignIdentity() {
        this.a.assignMonomial(0, 1.0, 0.0);
        this.b.assignMonomial(0, 0.0, 0.0);
        this.c.assignMonomial(0, 0.0, 0.0);
        this.d.assignMonomial(0, 1.0, 0.0);
    }

    public void assignConstant(Field.Complex a, Field.Complex b, Field.Complex c, Field.Complex d) {
        this.a.assignMonomial(0, a);
        this.b.assignMonomial(0, b);
        this.c.assignMonomial(0, c);
        this.d.assignMonomial(0, d);
    }

    public void assignTimes(ComplexPolynomial2By2 l, ComplexPolynomial2By2 m) {
        p11.assignTimes(l.a, m.a);
        q11.assignTimes(l.b, m.c);
        p12.assignTimes(l.a, m.b);
        q12.assignTimes(l.b, m.d);
        p21.assignTimes(l.c, m.a);
        q21.assignTimes(l.d, m.c);
        p22.assignTimes(l.c, m.b);
        q22.assignTimes(l.d, m.d);
        this.a.assignPlus(p11, q11);
        this.b.assignPlus(p12, q12);
        this.c.assignPlus(p21, q21);
        this.d.assignPlus(p22, q22);
    }

    public void assignTimes(ComplexPolynomial2By2 m) {
        this.assignTimes(this, m);
    }

    public ComplexPolynomial2By2 times(ComplexPolynomial2By2 m) {
        ComplexPolynomial2By2 result = new ComplexPolynomial2By2();
        result.assignTimes(this, m);
        return result;
    }

    public void assignPlus(ComplexPolynomial2By2 l, ComplexPolynomial2By2 m) {
        this.a.assignPlus(l.a, m.a);
        this.b.assignPlus(l.b, m.b);
        this.c.assignPlus(l.c, m.c);
        this.d.assignPlus(l.d, m.d);
    }

    public void assignPlus(ComplexPolynomial2By2 m) {
        this.assignPlus(this, m);
    }

    public ComplexPolynomial2By2 plus(ComplexPolynomial2By2 m) {
        ComplexPolynomial2By2 result = new ComplexPolynomial2By2();
        result.assignPlus(this, m);
        return result;
    }

    public ComplexPolynomial2By2 neg() {
        ComplexPolynomial2By2 result = new ComplexPolynomial2By2();
        result.setA(this.a.neg());
        result.setB(this.b.neg());
        result.setC(this.c.neg());
        result.setD(this.d.neg());
        return result;
    }

    public ComplexPolynomial2By2 minus(ComplexPolynomial2By2 q) {
        ComplexPolynomial2By2 result = new ComplexPolynomial2By2();
        result.assignMinus(this, q);
        return result;
    }

    public void assignMinus(ComplexPolynomial2By2 q) {
        this.assignMinus(this, q);
    }

    public void assignMinus(ComplexPolynomial2By2 p, ComplexPolynomial2By2 q) {
        this.a.assignMinus(p.a, q.a);
        this.b.assignMinus(p.b, q.b);
        this.c.assignMinus(p.c, q.c);
        this.d.assignMinus(p.d, q.d);
    }

    public void getDeterminant(ComplexPolynomial p) {
        p.assignMinus(this.a.times(this.d), this.b.times(this.c));
    }

    public ComplexPolynomial getDeterminant() {
        ComplexPolynomial result = new ComplexPolynomial();
        this.getDeterminant(result);
        return result;
    }

    public void getTrace(ComplexPolynomial p) {
        p.assignPlus(this.a, this.d);
    }

    public ComplexPolynomial getTrace() {
        ComplexPolynomial result = new ComplexPolynomial();
        this.getTrace(result);
        return result;
    }

    public int getDegree() {
        int deg = this.a.getDegree();
        int newDeg = this.b.getDegree();
        if (newDeg > deg) {
            deg = newDeg;
        }
        if ((newDeg = this.c.getDegree()) > deg) {
            deg = newDeg;
        }
        if ((newDeg = this.d.getDegree()) > deg) {
            deg = newDeg;
        }
        return deg;
    }

    public void setDegree(int deg) {
        this.a.setDegree(deg);
        this.b.setDegree(deg);
        this.c.setDegree(deg);
        this.d.setDegree(deg);
    }

    public void truncate(int deg) {
        this.a.truncate(deg);
        this.b.truncate(deg);
        this.c.truncate(deg);
        this.d.truncate(deg);
    }

    public void truncate(double eps) {
        this.a.truncate(eps);
        this.b.truncate(eps);
        this.c.truncate(eps);
        this.d.truncate(eps);
    }

    public void truncate() {
        this.truncate(1.0E-14);
    }

    public Complex[] getPointsOfPeriod(int n) {
        ComplexPolynomial t = this.getTrace();
        t.assignTimes(t);
        ComplexPolynomial det = this.getDeterminant();
        int deg = Math.max(t.getDegree(), det.getDegree());
        Complex[] pts = new Complex[deg * (n / 2 + 1)];
        for (int k = 0; k <= n / 2; ++k) {
            double c = Math.cos(Math.PI * (double)k / (double)n);
            double c2 = c * c;
            Complex[] roots = t.minus(det.times(4.0 * c2)).getRoots();
            for (int j = 0; j < deg; ++j) {
                pts[k * deg + j] = roots[j];
            }
        }
        return pts;
    }

    public void assignDerivative(ComplexPolynomial2By2 p, int n) {
        this.a.assignDerivative(p.a, n);
        this.b.assignDerivative(p.b, n);
        this.c.assignDerivative(p.c, n);
        this.d.assignDerivative(p.d, n);
    }

    public void assignDerivative(int n) {
        this.assignDerivative(this, n);
    }

    public ComplexPolynomial2By2 derivative(int n) {
        ComplexPolynomial2By2 result = new ComplexPolynomial2By2(this.a.derivative(n), this.b.derivative(n), this.c.derivative(n), this.d.derivative(n));
        return result;
    }

    public void assignDerivative(ComplexPolynomial2By2 p) {
        this.assignDerivative(p, 1);
    }

    public void assignDerivative() {
        this.assignDerivative(this, 1);
    }

    public ComplexPolynomial2By2 derivative() {
        return this.derivative(1);
    }

    public void assignRandom() {
        this.a.assignRandom();
        this.b.assignRandom();
        this.c.assignRandom();
        this.d.assignRandom();
    }

    public boolean equals(ComplexPolynomial2By2 p) {
        return this.equals(p, 1.0E-14);
    }

    public boolean equals(ComplexPolynomial2By2 p, double eps) {
        return this.a.equals(p.a) && this.b.equals(p.b) && this.c.equals(p.c) && this.d.equals(p.d);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        try {
            return this.equals((ComplexPolynomial2By2)o);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(300);
        sb.append("a = " + this.a + "\n");
        sb.append("b = " + this.b + "\n");
        sb.append("c = " + this.c + "\n");
        sb.append("d = " + this.d + "\n");
        return sb.toString();
    }
}

