/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.mfc.set;

import de.jtem.mfc.set.DiscretizedInterval;
import de.jtem.mfc.set.Interval;
import java.util.NoSuchElementException;

public class DiscretizedIntervalIterator
extends DiscretizedInterval {
    public static final long serialVersionUID = 1L;
    final double[] value;
    final double[] delta;
    final int[] index;
    final int maxLinearIndex;
    int linearIndex = 0;
    boolean first = true;

    public DiscretizedIntervalIterator(Interval interval, int[] discr) {
        this(interval.min, interval.max, discr);
    }

    public DiscretizedIntervalIterator(Interval interval, int discr) {
        this(interval.min, interval.max, DiscretizedIntervalIterator.constant(discr, interval.getDim()));
    }

    public DiscretizedIntervalIterator(int[] discr) {
        this(DiscretizedIntervalIterator.constant(1.0, discr.length), discr);
    }

    public DiscretizedIntervalIterator() {
        this(1, 1);
    }

    public DiscretizedIntervalIterator(int dim, int discr) {
        this(DiscretizedIntervalIterator.constant(1.0, dim), DiscretizedIntervalIterator.constant(discr, dim));
    }

    public DiscretizedIntervalIterator(double[] max, int[] discr) {
        this(new double[max.length], max, discr);
    }

    public DiscretizedIntervalIterator(double[] min, double[] max, int[] discr) {
        super(min, max, discr);
        this.value = (double[])min.clone();
        this.index = new int[this.dim];
        this.delta = new double[this.dim];
        for (int i = 0; i < this.dim; ++i) {
            this.delta[i] = (max[i] - min[i]) / (double)discr[i];
        }
        this.maxLinearIndex = this.numOfVertices - 1;
    }

    public double[] getValue() {
        return this.value;
    }

    public int[] getIndex() {
        return this.index;
    }

    public int getLinearIndex() {
        return this.linearIndex;
    }

    public boolean hasNext() {
        return this.linearIndex < this.maxLinearIndex;
    }

    public void restartIteration() {
        this.first = true;
        this.linearIndex = 0;
    }

    public Object next() {
        if (this.linearIndex >= this.maxLinearIndex) {
            throw new NoSuchElementException();
        }
        if (!this.first) {
            this.iterate();
        } else {
            this.first = false;
        }
        return this.value.clone();
    }

    public void iterate() {
        if (this.linearIndex >= this.maxLinearIndex) {
            throw new NoSuchElementException();
        }
        ++this.linearIndex;
        this.first = false;
        for (int i = this.dim - 1; i > 0; --i) {
            int n = i;
            this.index[n] = this.index[n] + 1;
            if (this.index[i] < this.discr[i]) {
                int n2 = i;
                this.value[n2] = this.value[n2] + this.delta[i];
                return;
            }
            if (this.index[i] <= this.discr[i]) {
                this.value[i] = this.max[i];
                return;
            }
            this.index[i] = 0;
            this.value[i] = this.min[i];
        }
        this.index[0] = this.index[0] + 1;
        this.value[0] = this.value[0] + this.delta[0];
    }

    public void remove() {
        throw new RuntimeException("UnsupportedOperationException");
    }
}

