/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.mfc.set;

import de.jtem.mfc.set.MultiIndexedSet;
import java.util.NoSuchElementException;

public class MultiIndexIterator
extends MultiIndexedSet {
    public static final long serialVersionUID = 1L;
    final int[] index;
    int linearIndex = 0;
    int maxLinearIndex;
    boolean first = true;

    public MultiIndexIterator(int[] max) {
        this(new int[max.length], max);
    }

    public MultiIndexIterator(int[] min, int[] max) {
        super(min, max);
        this.index = (int[])min.clone();
        this.maxLinearIndex = this.numOfVertices - 1;
    }

    public int[] getIndex() {
        return this.index;
    }

    public int getLinearIndex() {
        return this.linearIndex;
    }

    public boolean hasNext() {
        return this.linearIndex < this.maxLinearIndex;
    }

    public void restartIteration() {
        this.first = true;
        this.linearIndex = 0;
    }

    public Object next() {
        if (this.linearIndex >= this.maxLinearIndex) {
            throw new NoSuchElementException();
        }
        if (!this.first) {
            this.iterate();
        } else {
            this.first = false;
        }
        return this.index.clone();
    }

    public void iterate() {
        if (this.linearIndex >= this.maxLinearIndex) {
            throw new NoSuchElementException();
        }
        ++this.linearIndex;
        this.first = false;
        for (int i = this.dim - 1; i > 0; --i) {
            int n = i;
            this.index[n] = this.index[n] + 1;
            if (this.index[i] <= this.max[i]) {
                return;
            }
            this.index[i] = this.min[i];
        }
        this.index[0] = this.index[0] + 1;
    }

    public void remove() {
        throw new RuntimeException("UnsupportedOperationException");
    }
}

